
## Introducing x0-GPT

![App Screenshot](https://i.imgur.com/ffeIgzW.png)


# What is x0-GPT ?

x0-GPT is an advanced AI-powered tool that enables you to interact seamlessly with any website or document (including PDFs) using natural language. Whether you're looking to extract specific data, automate tasks, or gain insights, x0-GPT makes it possible with ease. Best of all, it's free and accessible to everyone.



## Features

- User friendly interface 
- Realtime updates
- Dynamic routing
- Supports almost all ai
- Chat with websites
- Chat with PDFs
- Chat with CSVs
- Chat with notes


## Tech Stack

This project is by the following tech stack:

- Nextjs 14
- Typescript
- Tailwind CSS
- Supabase
- Upstash 
- Acternity UI
- Shadcn UI


## Environment Variables

To run this project, you will need to rename .env.example file to .env.local and add your keys.

#### SUPABASE ENVS
`NEXT_PUBLIC_SUPABASE_URL= "YOUR-KEYS"`
`NEXT_PUBLIC_SUPABASE_ANON_KEY= "YOUR-KEYS"`
            
#### UPSTASH ENVS
`UPSTASH_REDIS_REST_URL= "YOUR-KEYS"`
`UPSTASH_REDIS_REST_TOKEN= "YOUR-KEYS"`
`QSTASH_TOKEN=  "YOUR-KEYS"`
`UPSTASH_VECTOR_REST_URL= "YOUR-KEYS"`
`UPSTASH_VECTOR_REST_TOKEN= "YOUR-KEYS"`

#### TOGETHER AI (optional)

`OPENAI_API_KEY= "YOUR-KEYS"`


## Installation

Clone the github repo
```bash 
git clone https://github.com/SkidGod4444/x0-GPT
cd x0-GPT
```
Install dependencies with bun.

```bash
  bun add
  bun run dev
```
    
## Production

https://x0-gpt.devwtf.in/


## Contributing

Contributions are always welcome!

Do whatever you feel can improve this app.


## Feedback

If you have any feedback, please reach out to us at connect.saidev@gmail.com

