/* eslint-disable quotes */
import { ComponentFile, PackageDefinition } from '../../components';

const isLazyLoadingModule = (componentPath: string) => componentPath.includes('.dynamic');

const removeDynamicModuleNameEnding = (moduleName: string) =>
  moduleName.replace(/\.?dynamic$/i, '');

/**
 * Generate component builder template
 * @param {(PackageDefinition | ComponentFile)[]} components components to include in component builder
 * @returns generated component builder template
 */
export const getComponentBuilderTemplate = (components: (PackageDefinition | ComponentFile)[]) => {
  const componentFiles = components.filter(
    (component) => (component as ComponentFile).componentName
  ) as ComponentFile[];
  const packages = components.filter(
    (component) => (component as PackageDefinition).components
  ) as PackageDefinition[];

  const hasLazyModules = componentFiles.find((component) => isLazyLoadingModule(component.path));

  return `/* eslint-disable */
// Do not edit this file, it is auto-generated at build time!
// See scripts/generate-component-builder/index.ts to modify the generation of this file.

${hasLazyModules ? "import dynamic from 'next/dynamic';" : ''}
import { ComponentBuilder } from '@sitecore-jss/sitecore-jss-nextjs';

${packages
  .map((pkg) => {
    const list = pkg.components.map((c) => c.moduleName).join(', ');
    return `import { ${list} } from '${pkg.name}';\n`;
  })
  .join('')}
${componentFiles
  .map((component) => {
    if (isLazyLoadingModule(component.path)) {
      const moduleName = removeDynamicModuleNameEnding(component.moduleName);
      return `const ${moduleName} = {
  module: () => import('${component.path}'),
  element: (isEditing?: boolean) => isEditing ? require('${component.path}')?.default : dynamic(${moduleName}.module)
}`;
    }

    return `import * as ${component.moduleName} from '${component.path}';`;
  })
  .join('\n')}

export const components = new Map();
${packages
  .map((p) =>
    p.components.map(
      (component) => `components.set('${component.componentName}', ${component.moduleName});\n`
    )
  )
  .flat()
  .join('')}
${componentFiles
  .map(
    (component) =>
      `components.set('${
        isLazyLoadingModule(component.path)
          ? removeDynamicModuleNameEnding(component.componentName)
          : component.componentName
      }', ${
        isLazyLoadingModule(component.path)
          ? removeDynamicModuleNameEnding(component.moduleName)
          : component.moduleName
      });`
  )
  .join('\n')}

export const componentBuilder = new ComponentBuilder({ components });

export const moduleFactory = componentBuilder.getModuleFactory();
`;
};
