import { CommonFieldTypes, SitecoreIcon, Manifest } from '@sitecore-jss/sitecore-jss-dev-tools';
const packageJson = require('../../../package.json');

const jsonConfig = packageJson as { [key: string]: unknown; config: { [key: string]: unknown } };

/**
 * Adds the Styleguide-FieldUsage-ContentList component to the disconnected manifest.
 * This function is invoked by convention (*.sitecore.ts) when `jss manifest` is run.
 */
export default function StyleguideFieldUsageContentList(manifest: Manifest) {
  manifest.addComponent({
    name: 'StyleguideFieldUsageContentList',
    templateName: '<%- helper.getAppPrefix(appPrefix, appName) %>StyleguideFieldUsageContentList',
    icon: SitecoreIcon.ListStyle_numbered,
    fields: [
      {
        name: 'sharedContentList',
        type: CommonFieldTypes.ContentList,
        // this sets the root path in Sitecore that linked items can be selected from.
        // the path is based on the path the shared items are defined in, under /data/content.
        // Using 'source' is recommended to help content editors find the correct items to refer to,
        // unless they can refer to any item in the whole site.
        source: `dataSource=/sitecore/content/${jsonConfig.config.appName}/Content/Styleguide/ContentListField`,
      },
      { name: 'localContentList', type: CommonFieldTypes.ContentList },
    ],
    // inherit fields from another template (../templates/Styleguide-Explanatory-Component)
    // inheritance adds fields defined on the base template(s) implicitly to this component
    inherits: [
      '<%- helper.getAppPrefix(appPrefix, appName) %>styleguide-explanatory-component-template',
    ],
  });
}
