## Design

The UI has been written in **Javascript** and **React** and styling is done with **SCSS**. We use **eslint** for linting and **prettier** for formatting. These have been set up with a few rules already, and we use **husky** and **lint-staged** to enforce a lint check and code-format on every commit. Scoping the codebase properly is important for keeping it clean and extensible. Hence, the guidelines given below should be followed while contributing to this app.

All react components go inside the **src/components** folder. The components which are reusable in different pages should be placed in the **components/common** folder for easy access, e.g., the buttons or headings which follow the same style but only differ in the text they display can be written here with the text coming in as a prop. Prototyping these reusable components is encouraged and we've set up **storybook.js** to make this easy. The components specific to a page in the app should be placed in the **components/pages** folder. It is always a good idea to split up components into small parts and compose them to make pages. If a page requires more than one component, place all these page-specific components in an appropriately named subfolder in **components/pages**. Components that deal with more than one page like the Routes components, can be placed directly in the **src/components** folder.

**Redux** is used for state management. The general idea followed here is to put the state variables in redux if they are used by more than two components and it isn't clean or logical to pass them using props, e.g. things like exception handling state variables which are used by different components. All the redux specific code goes in **src/store**.

Styles are defined as SCSS files and are imported into the respective React components where they are used. Styling is done exclusively using these SCSS files and directly styling react components is discouraged. This way, there is a clear separation between application logic and styling.

Since a lot of styles are reusable in our app, there is a file called **common.scss** which has many constants and mixins defined. Mixins provide a way to reuse css expressions. The idea followed here is that if a certain style needs to be reused more than once, define a mixin for it in **common.scss** and use it from there. The mixin names must be clear and concise. Try to define mixins only here since it will make it easier for people to check later on and will limit the need to import any file other than **common.scss**.

Other than common.scss, separate style modules are created for each reusable design element and each page of the app to strike a balance between not having too many files while also maintaing a clear separation of scope between the files present.

For styling, the CSS classes should have names which are easily understandable and in the spirit of keeping things simple and maintainable, take care not to use obscure CSS snippets you find somewhere on the web and instead ask doubts on the issue page if you are really stuck somewhere so that we can discuss and find the best solution. Also note that we prefer to **use rem instead of px** for sizing whenever possible, so please keep that in mind.

We've also set up **Sentry** to monitor the status of the website and to quickly tackle new issues.

The backend service is written in **Java** and is hosted on **AWS**. We connect to the backend APIs using **axios** and the code dealing with these services are stored in the **src/services** folder. All the non presentational business logic goes here.

Adding comments to describe parts of code that are hard to understand is encouraged. These comments could also be links to articles or stackoverflow answers that were used to solve any problems that occured.
