# Security Policy
battery-tracker is committed to ensuring the security and privacy of its users. 
This document outlines the security policy for the project, including guidelines, reporting vulnerabilities, and the project's response to security concerns.

## Supported Versions

The following table provides information about the currently supported versions of the battery-tracker project and the associated security updates:

| Version | Supported          |
| ------- | ------------------ |
| 1.0.x   | :white_check_mark: |
| 0.1.x   | :x:                |


## Reporting a Vulnerability

If you discover any security vulnerabilities or potential risks within the battery-tracker project, please report them immediately to our security team. To report a vulnerability, follow these steps:

1. Email us at alitabatabaee20@gmail.com with the subject line "battery-tracker Security Vulnerability."

2. Provide a detailed description of the vulnerability, including the steps to reproduce it, potential impact, and any relevant information.

3. If possible, include any proof-of-concept code, logs, or screenshots that demonstrate the vulnerability.

4. Our security team will acknowledge your report within 48 hours and work with you to understand and validate the issue.

5. We kindly request that you refrain from publicly disclosing the vulnerability until we have had sufficient time to address and remediate the issue.

##Security Response
1. Once a security vulnerability is reported, our security team will review and validate the issue.
2. We will work diligently to develop a fix or mitigation strategy for the vulnerability.
3. The fix or mitigation will be implemented in the latest supported version of the project.
4. A new release containing the security patch will be published as soon as possible.
5. The security vulnerability will be publicly disclosed, along with the details of the fix, to ensure transparency and awareness among users.

## Best Practices
To enhance the security of the CLI Word Guessing Game project, we recommend the following best practices:
- Keep your system and dependencies up to date with the latest security patches.
- Regularly review and audit the project's dependencies for known vulnerabilities.
- Use strong and unique passwords for any associated accounts or services.
- Be cautious when executing third-party scripts or code, as they may pose security risks.
- Verify the integrity of the project's releases by checking digital signatures or hashes when available.

## Conclusion
the battery-tracker project is dedicated to providing a secure and reliable gaming experience. 
By following responsible disclosure practices and collaborating with the security community, we strive to promptly address any security concerns. We appreciate the efforts of researchers and users who contribute to the security of the project.

If you have any further questions or need additional information, please reach out to our security team at alitabatabaee20@gmail.com 😁
