![battery tracker banner](https://github.com/Silent-Watcher/battery-tracker/blob/master/.github/battery-banner.png)

<h1 tabindex="-1" dir="auto">Battery Tracker <a id="user-content--thanks-for-visiting" class="anchor" aria-hidden="true" href="#-thanks-for-visiting"><img src="https://raw.githubusercontent.com/Tarikul-Islam-Anik/Animated-Fluent-Emojis/master/Emojis/Objects/Low%20Battery.png" alt="Low Battery" width="25" height="25" /></a></h1>

Battery Tracker is a web application that allows you to monitor and track the battery level of your device in real-time. It provides useful information such as battery level, charging status, time remaining, and historical data with interactive charts.

<p dir="auto"><a href="https://github.com/sindresorhus/awesome"><img src="https://camo.githubusercontent.com/abb97269de2982c379cbc128bba93ba724d8822bfbe082737772bd4feb59cb54/68747470733a2f2f63646e2e7261776769742e636f6d2f73696e647265736f726875732f617765736f6d652f643733303566333864323966656437386661383536353265336136336531353464643865383832392f6d656469612f62616467652e737667" alt="Awesome" data-canonical-src="https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg" style="max-width: 100%;"></a> <a href="https://github.com/chetanraj/awesome-github-badges"><img src="https://camo.githubusercontent.com/ff817852f0d676a36eaa3108d380e0052e689d9e0bc3eb42818fb21008708420/68747470733a2f2f696d672e736869656c64732e696f2f62616467652f4d616465253230576974682d4c6f76652d6f72616e67652e737667" alt="Made With Love" data-canonical-src="https://img.shields.io/badge/Made%20With-Love-orange.svg" style="max-width: 100%;"></a></p>


[![Star this project](https://img.shields.io/badge/-⭐%20Star%20this%20project-yellow?style=for-the-badge)](https://github.com/Silent-Watcher/cli-word-guessing-game)




## Table of Contents


-   [Features](https://github.com/Silent-Watcher/battery-tracker#features)
-   [preview](https://github.com/Silent-Watcher/battery-tracker#preview)
-   [demo](https://github.com/Silent-Watcher/battery-tracker#demo)
-   [Prerequisites](https://github.com/Silent-Watcher/battery-tracker#Prerequisites)
-   [Installation](https://github.com/Silent-Watcher/battery-tracker#Installation)
-   [usage](https://github.com/Silent-Watcher/battery-tracker#usage)
-   [Configuration](https://github.com/Silent-Watcher/battery-tracker#Configuration)
-   [Acknowledgements](https://github.com/Silent-Watcher/battery-tracker#Acknowledgements)
-   [Contributing](https://github.com/Silent-Watcher/battery-tracker#Contributing)
-   [Contact](https://github.com/Silent-Watcher/battery-tracker#Contact)
-   [License](https://github.com/Silent-Watcher/battery-tracker#License)

## Features

- Real-time monitoring of device battery level.
- Display of charging status (charging, discharging, full).
- Estimated time remaining based on current battery level.
- Historical data visualization with interactive charts.
- Battery level notifications at critical thresholds.
- Responsive design for use on various devices.

## Preview
<img src='https://iili.io/HrsCw41.png'>

## demo
### GitHub pages
https://silent-watcher.github.io/battery-tracker/
<p>
 
[![Open in StackBlitz](https://developer.stackblitz.com/img/open_in_stackblitz.svg)](https://stackblitz.com/github/Silent-Watcher/battery-tracker)

</p>



## Prerequisites
In order to run this project, you will need to have the following installed on your computer:
- nodejs
- yarn | npm

## Installation
To install the application, follow these steps:

1.  Clone the repository to your local machine:

 
```bash
git clone https://github.com/Silent-Watcher/battery-tracker
```

2. Navigate to the project directory in your terminal.

 
```bash
  cd battery-tracker
```
3. Run `yarn` to install the necessary packages.

 
```bash
  yarn
```

## usage

To start the application, run yarn dev. This will start the application on http://localhost:5173.

```bash
yarn dev
```

## Configuration
You can customize the configuration of the Battery Tracker app by modifying the config.js file. Here are the available options:

- refreshInterval: The interval (in milliseconds) at which the battery information is updated.
- criticalThreshold: The battery level at which a notification is triggered for critical battery level.

## Acknowledgements

 - [The build tool and development server.](https://vitejs.dev/)
 - [The package manager used in the project.](https://yarnpkg.com/)

## Contributing
Contributions to this project are welcome. 
If you encounter any issues or have suggestions for improvement, please open an issue on the GitHub repository.

Before contributing, please review the contribution guidelines.

## Contact
For additional information or inquiries, you can reach out to the project maintainer:

- Name: Silent-Watcher
- Email: alitabatabaee20@mail.com

Feel free to contact the maintainer for any questions or feedback regarding the project.

## License

[MIT](https://choosealicense.com/licenses/mit/)

This project is licensed under the MIT License. You are free to modify, distribute, and use the code for personal and commercial purposes. See the LICENSE file for details.

<a target="_blank" rel="noopener noreferrer nofollow" href="https://camo.githubusercontent.com/6038c8f1fd8f60de75477470e5a87210e9256202e01dfba9986446304a0f0254/68747470733a2f2f63617073756c652d72656e6465722e76657263656c2e6170702f6170693f747970653d776176696e6726636f6c6f723d6772616469656e74266865696768743d36302673656374696f6e3d666f6f746572"><img src="https://camo.githubusercontent.com/6038c8f1fd8f60de75477470e5a87210e9256202e01dfba9986446304a0f0254/68747470733a2f2f63617073756c652d72656e6465722e76657263656c2e6170702f6170693f747970653d776176696e6726636f6c6f723d6772616469656e74266865696768743d36302673656374696f6e3d666f6f746572" data-canonical-src="https://capsule-render.vercel.app/api?type=waving&amp;color=gradient&amp;height=60&amp;section=footer" style="max-width: 100%;"></a>
