﻿using LearningASP.Data;
using LearningASP.Models.Domain;
using Microsoft.EntityFrameworkCore;

namespace LearningASP.Repositories
{
    public class SQLRegionRepository : IRegionRepository
    {
        private readonly LearningASPDbContext dbContext;
        public SQLRegionRepository(LearningASPDbContext dbContext) {
            this.dbContext = dbContext;
        }

        public async Task<List<Region>> GetAllAsync()
        {
           return await dbContext.Regions.ToListAsync();
        }

        
        public async Task<Region?> GetByIdAsync(Guid id)
        {
            return await dbContext.Regions.FindAsync(id);
        }

        public async Task<Region> CreateAsync(Region region)
        {
             await dbContext.Regions.AddAsync(region);
             await dbContext.SaveChangesAsync();
             return region;
        }

        public async Task<Region?> UpdateAsync(Guid id ,Region region)
        {
            var existingRegion = await dbContext.Regions.FindAsync(id);

            if (existingRegion == null)
            {
                return null;
            }

            existingRegion.Code = region.Code;
            existingRegion.Name = region.Name;
            existingRegion.RegionImageUrl = region.RegionImageUrl;

            await dbContext.SaveChangesAsync();
            return existingRegion;
        }

        public async Task<Region?> DeleteAsync(Guid id)
        {
            var existingRegion = await dbContext.Regions.FindAsync(id);

            if (existingRegion == null)
            {
                return null;
            }

            dbContext.Regions.Remove(existingRegion);
            await dbContext.SaveChangesAsync();
            return existingRegion;
        }
    }
}
