﻿# Tobira Study Resources
Tobira Study Resources is a website that offers a vast collection of exercises for practicing what is taught in [Tobira: Gateway to Advanced Japanese](https://tobiraweb.9640.jp/). Much like [Genki Study Resources](https://github.com/SethClydesdale/genki-study-resources), this was created to help aid those self-studying with Tobira, and if you've used its predecessor you should feel right at home! Choose one of the links below to begin testing the Japanese you've learned in Tobira!


**Online Version:** https://sethclydesdale.github.io/tobira-study-resources/

**Offline Version:** [download](https://github.com/SethClydesdale/tobira-study-resources/archive/refs/heads/main.zip)

If you're interested in learning Japanese, please see [this guide](https://sethclydesdale.github.io/tobira-study-resources/help/japanese-guide/)!

-----

**Quick Links**
- [Using the Offline Version](#using-the-offline-version)
- [Keyboard Shortcuts](#keyboard-shortcuts)
- [Suggestions, Feedback, Bug Reports](#suggestions-feedback-bug-reports)
- [Resources for Studying Japanese](#resources-for-studying-japanese)
- [Special Thanks](#special-thanks)
- [Donate](#donate)


### Using the Offline Version
If you're using the offline version you'll have to unzip the files. Once you've done that, you can access all the study resources by opening any of the **index.html** files in the browser of your choice. It should have the same experience as the online version, however, whenever new exercises/lessons are added they will not be available; you'll have to download the latest version of the repository to get them.

**If icons are broken:** If you use Firefox and icons appear broken, then please see [this topic](https://sethclydesdale.github.io/tobira-study-resources/help/broken-icons/) to resolve the issue.

**If settings will not save:** If your settings will not save, such as furigana preference or dark mode, please see [this topic](https://sethclydesdale.github.io/tobira-study-resources/help/stuck-loading/) for resolving the issue.


### Keyboard Shortcuts
Tobira Study Resources supports a few keyboard shortcuts which you can use to make things easier. If you've used Genki Study Resources, you should already be familiar with these shortcuts. These shortcuts are typically used via <kbd>CTRL</kbd>+<kbd>ALT</kbd>+<kbd>KEY</kbd> for Windows and <kbd>CMD</kbd>+<kbd>SHIFT</kbd>+<kbd>KEY</kbd> for Mac.

#### Global
Shortcuts that can be used anywhere.

| Shortcut | Description |
| -------- | ----------- |
| <kbd>CTRL</kbd>+<kbd>ALT</kbd>+<kbd>D</kbd> | Toggle Dark Mode on/off |
| <kbd>CTRL</kbd>+<kbd>ALT</kbd>+<kbd>M</kbd> | Open Settings Manager |

#### Exercises
Shortcuts that can only be used in exercises.

| Shortcut | Description |
| -------- | ----------- |
| <kbd>CTRL</kbd>+<kbd>ALT</kbd>+<kbd>LEFT</kbd> | Navigate to the previous exercise in the lesson |
| <kbd>CTRL</kbd>+<kbd>ALT</kbd>+<kbd>RIGHT</kbd> | Navigate to the next exercise in the lesson |
| <kbd>CTRL</kbd>+<kbd>ALT</kbd>+<kbd>R</kbd> | Navigate to a random exercise |
| <kbd>CTRL</kbd>+<kbd>ALT</kbd>+<kbd>E</kbd> | Open/Close the Exercise List |
| <kbd>CTRL</kbd>+<kbd>ALT</kbd>+<kbd>Q</kbd> | Open/Close the Quick Dictionary |
| <kbd>CTRL</kbd>+<kbd>ALT</kbd>+<kbd>F</kbd> | Toggle Furigana on/off |
| <kbd>CTRL</kbd>+<kbd>ALT</kbd>+<kbd>C</kbd> | Check answers (for written exercises) |

##### Multiple Choice
The following shortcuts can only be used in multiple choice exercises to quickly select an answer.

| Shortcut | Description |
| -------- | ----------- |
| <kbd>ALT</kbd>+<kbd>A</kbd> | Selects option A |
| <kbd>ALT</kbd>+<kbd>B</kbd> | Selects option B |
| <kbd>ALT</kbd>+<kbd>C</kbd> | Selects option C |
| <kbd>ALT</kbd>+<kbd>D</kbd> | Selects option D |


### Suggestions, Feedback, Bug Reports
If you have any suggestions, feedback, questions, or bugs to report, feel free to [open a new issue](https://github.com/SethClydesdale/tobira-study-resources/issues) in this repository. For alternative contact methods and detailed reporting information, please see the [report page](https://sethclydesdale.github.io/tobira-study-resources/report/) for Tobira Study Resources.


### Resources for Studying Japanese

##### Tools
- [Anki - SRS Flashcard App](https://apps.ankiweb.net/) (great for memorizing vocab)
- [Jisho - Online Japanese Dictionary](http://jisho.org/) (extremely useful for looking up words, kanji, etc.)
- [Jotoba - Japanese Dictionary website](https://jotoba.de/) (another very useful dictionary with search suggestions, pitch accent support and many other helpful features for learning Japanese)
- [Capture2Text](http://capture2text.sourceforge.net/) (very useful for copying and looking up kanji in games, images, etc.)
- [Yomichan](https://foosoft.net/projects/yomichan/) (for quickly looking up words while reading, or for using the search page in tandem with Capture2Text)
- [KanjiTomo](https://www.kanjitomo.net/) (useful for reading manga, LNs, etc.)
- [Useful Tools List](https://sethclydesdale.github.io/tobira-study-resources/help/japanese-guide/#tools) (more in-depth list of tools for Japanese study)

##### Websites
- [Tobira Official Website](https://tobiraweb.9640.jp/)
- [Tobira Grammar Index](https://sethclydesdale.github.io/tobira-study-resources/lessons/appendix/grammar-index/) (for intermediate to advanced grammar explanations)
- [Dictionary of Japanese Grammar](https://core6000.neocities.org/dojg/) (godsend for quickly looking up grammar points)
- [Itazuraneko's Grammar Master Reference](https://kenrick95.github.io/itazuraneko/grammar/masterreference) (another great resource for looking up grammar points)
- [Imabi](http://www.imabi.net/) (very useful for more advanced learning/explanations)
- [/r/LearnJapanese Wiki](https://www.reddit.com/r/LearnJapanese/wiki/index) (additional resources, guides, etc.)


### Special Thanks
Tobira Study Resources was made possible thanks to...
- [Kurosio](https://www.9640.jp/), Mayumi Oka, Michio Tsutsui, Junko Kondo, Shoko Emori, Yoshiro Hanai, and Satoru Ishikawa for Tobira: Gateway to Advanced Japanese.
- [Jen](https://twitter.com/SethC1995/status/1405616116739751945) for gifting me the Tobira textbook.
- [Patrick Roberts](https://github.com/patrickroberts) for [his help with an algorithm](https://stackoverflow.com/a/59337819/12502093) that helped make mixed kana/kanji answers possible in written quizzes.
- [Dominik Klein](https://github.com/asdfjkl) for [his help with adding new recognition patterns](https://github.com/asdfjkl/kanjicanvas/issues/1) for stroke order exercises.
- [Jisho.org](https://jisho.org/) and [modron82](https://www.reddit.com/r/LearnJapanese/comments/awr5vw/downloading_stroke_order_image/ehriio7/?utm_source=reddit&utm_medium=web2x&context=3) for the stroke order images.
- Everyone who helped support or contribute to this project, whether it was on GitHub or outside of it.

The following resources were used in this project. I couldn't have done it without them, so check them out!
- [Font-Awesome](https://github.com/FortAwesome/Font-Awesome) for the awesome icons.
- [dragula](https://github.com/bevacqua/dragula) for the simple drag and drop.
- [easytimer.js](https://github.com/albert-gonzalez/easytimer.js) for the super easy timer.
- [Kanji Canvas](https://github.com/asdfjkl/kanjicanvas) for the stroke order exercises.

### Donate
If you found this project helpful and would like to donate, please see the [Donate page](https://sethclydesdale.github.io/tobira-study-resources/donate/) for ways to support my work.
