// Dictionary for Genki Volumes I & II
// Definitions not present in Genki are supplemented (and sometimes extended) with definitions from jisho.org

// # DEFINITION SYNTAX #
// preferred if definitions are kept to one line and are in alphabetical order (see the dictionary key for hiragana order)
/*{
   ja : 'JAPANESE_DEFINITION|FURIGANA(OPTIONAL)', // | should be omitted if no furigana
   en : 'ENGLISH_DEFINITION',
    v : 'VERB_TYPE(OPTIONAL)', // can be omitted if no verb type
    l : 'LESSON'
}*/

// # EMPTY DEFINITION #
// empty definition used when filling in definitions en masse
// { ja : '|', en : '', v : '', l : '会L読L-II' },
// OR: (since there's usually more nouns/adjs than verbs, and doesn't take long to write v : '',)
// { ja : '|', en : '', l : '会L読L-II' },

Genki.jisho = {
  
  'あ' : [
    { ja : '愛|あい', en : 'love; affection; care', l : 'ワークブック読L1' },
    { ja : '相変わらず|あいかわらず', en : 'as usual', l : '読L22-II' },
    { ja : '挨拶|あいさつ', en : 'greeting; greetings; salutation; polite set phrase used when meeting or parting', l : '会G' },
    { ja : '愛す|あいす', en : 'to love', v : 'u', l : '読L14-II' },
    { ja : '合図|あいず', en : 'signal', l : '読L18-漢字表' },
    { ja : 'アイスクリーム', en : 'ice cream', l : '会L3' },
    { ja : 'アイスティー', en : 'iced tea; ice tea', l : '読L2-I' },
    { ja : '間|あいだ', en : 'between', l : '会L4' },
    { ja : '～間に|～あいだに', en : 'while...', l : '会L21' },
    { ja : '相手|あいて', en : 'partner', l : '会L22' },
    { ja : 'アイロンをかける', en : 'to iron (clothes)', v : 'ru', l : '会L16' },
    { ja : '会う|あう', en : 'to meet; to see (a person)', v : 'u', l : '会L4' },
    { ja : 'アウトドア', en : 'outdoor activities', l : '読L11-II' },
    { ja : '青|あお', en : 'blue color', l : '読L12-漢字表' },
    { ja : '青い|あおい', en : 'blue', l : '会L9, 会L9(e)' },
    { ja : '青信号|あおしんごう', en : 'green light', l : '読L12-漢字表' },
    { ja : '青空|あおぞら', en : 'blue sky', l : '読L12-漢字表' },
    { ja : '赤|あか', en : 'red color', l : '読L12-漢字表' },
    { ja : '赤い|あかい', en : 'red', l : '会L9, 会L9(e)' },
    { ja : '赤字|あかじ', en : 'deficit', l : '読L17-漢字表' },
    { ja : '赤ちゃん|あかちゃん', en : 'baby', l : '会L21' },
    { ja : '明るい|あかるい', en : 'bright; cheerful', l : '会L18, 読L11-II' },
    { ja : '秋|あき', en : 'fall', l : '会L10' },
    { ja : '秋学期|あきがっき', en : 'fall semester', l : '読L19-漢字表' },
    { ja : 'あきらめる', en : 'to give up', v : 'ru', l : '会L14' },
    { ja : '開く|あく', en : '(something) opens', v : 'u', l : '会L18' },
    { ja : '空く|あく', en : 'to be vacant; to become less crowded', v : 'u', l : '読L13-漢字表' },
    { ja : '悪魔|あくま', en : 'devil', l : '読L13-漢字表' },
    { ja : '開ける|あける', en : 'to open (something)', v : 'ru', l : '会L6' },
    { ja : 'あげる', en : 'to give (to others)', v : 'ru', l : '会L14' },
    { ja : '朝|あさ', en : 'morning', l : '会L3' },
    { ja : '朝ご飯|あさごはん', en : 'breakfast', l : '会L3' },
    { ja : '明後日|あさって', en : 'the day after tomorrow', l : '会L4(e), 会L8' },
    { ja : '朝寝坊する|あさねぼうする', en : 'to oversleep', v : 'irr', l : '会L16' },
    { ja : '足|あし', en : 'leg; foot', l : '会L7(e), 会L12' },
    { ja : '味|あじ', en : 'taste', l : '読L15-漢字表' },
    { ja : '鯵|あじ', en : 'horse mackerel; Spanish mackerel', l : '会L18(c)' },
    { ja : 'アジア研究|アジアけんきゅう', en : 'Asian studies', l : '会L1' },
    { ja : '明日|あした', en : 'tomorrow', l : '会L3, 会L4(e)' },
    { ja : 'あそこ', en : 'over there', l : '会L2' },
    { ja : '遊ぶ|あそぶ', en : 'to play; to spend time pleasantly', v : 'u', l : '会L6' },
    { ja : '暖かい|あたたかい', en : 'warm', l : '会L10' },
    { ja : '頭|あたま', en : 'head', l : '会L7(e)' },
    { ja : '頭がいい|あたまがいい', en : 'bright; smart; clever', l : '会L7' },
    { ja : '頭が悪い|あたまがわるい', en : 'slow; weak-headed; dumb', l : 'ワークブックL13' },
    { ja : '新しい|あたらしい', en : 'new', l : '会L5' },
    { ja : '当たる|あたる', en : 'to hit', v : 'u', l : '読L14-漢字表' },
    { ja : 'あちら', en : 'that way (place)', l : '会L20' },
    { ja : '熱い|あつい', en : 'hot (thing)', l : '会L5' },
    { ja : '暑い|あつい', en : 'hot (weather)', l : '会L5' },
    { ja : '集める|あつめる', en : 'to collect', v : 'ru', l : '会L16' },
    { ja : '後|あと', en : 'after (e.g. an event); the rest', l : '読L8-II, 会L11, 会L18' },
    { ja : '後で|あとで', en : 'later on', l : '会L6' },
    { ja : 'アドバイス', en : 'advice', l : '読L14-II' },
    { ja : 'アナウンス', en : 'announcement', l : '読L13-III' },
    { ja : '穴子|あなご', en : 'saltwater eel', l : '会L18(c)' },
    { ja : 'あなた', en : 'you', l : '会L4' },
    { ja : '兄|あに', en : '(my) older brother', l : '会L14' },
    { ja : 'アニメ', en : 'animation', l : '会L20' },
    { ja : '姉|あね', en : '(my) older sister', l : '会L7' },
    { ja : 'あの', en : 'that...(over there); um...', l : '会L1, 会L2' },
    { ja : 'アパート', en : 'apartment', l : '会L7' },
    { ja : '危ない|あぶない', en : 'dangerous', l : '会L17' },
    { ja : 'アプリ', en : 'app; application', l : '会L13' },
    { ja : 'アフリカ', en : 'Africa', l : 'ワークブックL13' },
    { ja : 'アボカド', en : 'avocado', l : '会L8(e)' },
    { ja : '甘い|あまい', en : 'sweet', l : '会L12' },
    { ja : '天の川|あまのがわ', en : 'the Milky Way', l : '読L12-II' },
    { ja : 'あまり', en : 'not much (with neg. sentence)', l : '会L3' },
    { ja : '編む|あむ', en : 'to knit', v : 'u', l : '会L13' },
    { ja : 'アムステルダム', en : 'Amsterdam (The Netherlands)', l : '読L2-I' },
    { ja : '雨|あめ', en : 'rain', l : '会L8' },
    { ja : '雨が降る|あめがふる', en : 'it rains', v : 'u', l : '会L8' },
    { ja : '雨がやむ|あめがやむ', en : 'the rain stops', v : 'u', l : '会L23' },
    { ja : 'アメリカ', en : 'U.S.A.; America', l : '会L1, 会L2' },
    { ja : '謝る|あやまる', en : 'to apologize', v : 'u', l : '会L18' },
    { ja : 'アラーム', en : 'alarm', l : 'ワークブックL21' },
    { ja : '洗う|あらう', en : 'to wash', v : 'u', l : '会L8' },
    { ja : '表す|あらわす', en : 'to express; to show', v : 'u', l : '読L23-II' },
    { ja : 'ありがとう', en : 'Thank you.', l : '会G' },
    { ja : 'ありがとうございます', en : 'Thank you. (polite)', l : '会G' },
    { ja : 'アリゾナ', en : 'Arizona', l : '会L1' },
    { ja : 'ある', en : 'there is...', v : 'u', l : '会L4' },
    { ja : '有る|ある', en : 'to exist', v : 'u', l : '読L11-漢字表' },
    { ja : 'ある～', en : 'one...', l : '読L12-II' },
    { ja : '歩いて|あるいて', en : 'on foot', l : '会L10' },
    { ja : '歩く|あるく', en : 'to walk', v : 'u', l : '会L12' },
    { ja : 'アルゼンチン', en : 'Argentina', l : '読L2-I' },
    { ja : 'アルバイト', en : 'part-time job', l : '会L4' },
    { ja : 'アルバム', en : 'album', l : '読L17-II' },
    { ja : 'あれ', en : 'that one (over there)', l : '会L2' },
    { ja : 'アレルギー', en : 'allergy', l : '会L8(e)' },
    { ja : '案|あん', en : 'idea; proposal', l : '読L22-漢字表' },
    { ja : '暗記する|あんきする', en : 'to memorize', v : 'irr', l : '読L22-漢字表' },
    { ja : 'アンケート', en : 'questionnaire', l : '読L8-II' },
    { ja : '暗証番号|あんしょうばんごう', en : 'personal identification number', l : '会L13(e)' },
    { ja : '安心|あんしん（な）', en : 'relief', l : '読L13-漢字表' },
    { ja : '安全|あんぜん（な）', en : 'safe', l : '会L21' },
    { ja : '案内所|あんないじょ', en : 'information desk', l : '読L22-漢字表' },
    { ja : '案内する|あんないする', en : 'to guide; to show (someone) around', v : 'irr', l : '読L9-II, 会L16' },
    { ja : 'あんなに', en : 'so; such', l : '読L20-II' }
  ],
  
  'い' : [
    { ja : 'いい', en : 'good', l : '会L3' },
    { ja : 'いいえ', en : 'No.; Not at all.', l : '会G' },
    { ja : 'いい子|いいこ', en : 'good child', l : '会L9' },
    { ja : 'いいこと', en : 'good deed', l : '読L10-II' },
    { ja : '医院|いいん', en : 'clinic', l : '読L14-漢字表' },
    { ja : '言う|いう', en : 'to say', v : 'u', l : '会L8' },
    { ja : '家|いえ', en : 'house; home', l : '会L3' },
    { ja : '烏賊|いか', en : 'cuttlefish; squid', l : '会L18(c)' },
    { ja : '～以下|～いか', en : '...or less', l : '読L16-漢字表' },
    { ja : '～以外|～いがい', en : 'other than...', l : '読L16-II' },
    { ja : 'いかが', en : 'how (polite exp. of どう)', l : '読L19-II' },
    { ja : '医学|いがく', en : 'medical science', l : '読L14-漢字表' },
    { ja : '怒り|いかり', en : 'anger; rage', l : '読L23-漢字表' },
    { ja : '～行き|～いき', en : 'bound for...', l : '会L10(e)' },
    { ja : 'イギリス', en : 'Britain', l : '会L1, 会L2' },
    { ja : '行く|いく', en : 'to go', v : 'u', l : '会L3' },
    { ja : 'いくら', en : 'how much', l : '会L2' },
    { ja : 'イクラ', en : 'salmon roe', l : '会L18(c)' },
    { ja : '池|いけ', en : 'pond', l : 'ワークブック読L1' },
    { ja : '生け花|いけばな', en : 'ikebana; Japanese art of flower arrangement', l : '読L19-漢字表' },
    { ja : '意見|いけん', en : 'opinion', l : '読L5-漢字表' },
    { ja : 'いじめる', en : 'to bully', v : 'ru', l : '会L21' },
    { ja : '医者|いしゃ', en : 'doctor', l : '会L1, 会L10' },
    { ja : '移住する|いじゅうする', en : 'to immigrate', v : 'irr', l : '読L10-漢字表' },
    { ja : '～以上|～いじょう', en : '...or more', l : '読L18-II' },
    { ja : '意地悪|いじわる（な）', en : 'mean-spirited', l : '会L9' },
    { ja : '椅子|いす', en : 'chair; stool', l : '会L2(e), 会L4' },
    { ja : '以前|いぜん', en : 'before; formerly', l : '読L16-漢字表' },
    { ja : '忙しい|いそがしい', en : 'busy (people/days)', l : '会L5' },
    { ja : '急ぐ|いそぐ', en : 'to hurry', v : 'u', l : '会L6' },
    { ja : '痛い|いたい', en : 'hurt; painful', l : '会L12' },
    { ja : '致す|いたす', en : 'extra-modest exp. for する', v : 'u', l : '会L20' },
    { ja : 'いただきます', en : 'Thank you for the meal. (before eating)', l : '会G' },
    { ja : '頂く|いただく', en : 'extra-modest exp. for たべる and のむ; humble exp. for もらう', v : 'u', l : '会L20' },
    { ja : '痛み止め|いたみどめ', en : 'painkiller', l : '読L20-漢字表' },
    { ja : 'イタリア', en : 'Italy', l : '読L6-III' },
    { ja : '一|いち', en : 'one', l : '読L3-漢字表' },
    { ja : '一月|いちがつ', en : 'January', l : '会L4(e)' },
    { ja : '苺|いちご', en : 'strawberry', l : '読L1-I' },
    { ja : '一号車|いちごうしゃ', en : 'Car No. 1', l : '会L19(e)' },
    { ja : '一行目|いちぎょうめ', en : 'first line', l : '読L5-漢字表' },
    { ja : '一時|いちじ', en : "one o'clock", l : '会L1, 会L1(e)' },
    { ja : '一時間|いちじかん', en : 'one hour', l : '会L4' },
    { ja : '一度|いちど', en : 'once', l : '読L12-漢字表' },
    { ja : '一日|いちにち', en : 'one day', l : '会L13' },
    { ja : '一日中|いちにちじゅう', en : 'all day long', l : '会L15' },
    { ja : '一年中|いちねんじゅう', en : 'all year', l : '読L15-II' },
    { ja : '一年生|いちねんせい', en : 'first-year student', l : '会L1' },
    { ja : '一年に一度|いちねんにいちど', en : 'once a year', l : '読L12-II' },
    { ja : '市場|いちば', en : 'market', l : '読L11-漢字表' },
    { ja : '一番|いちばん', en : 'the first; best; most', l : '会L10' },
    { ja : '一番後ろ|いちばんうしろ', en : 'last car; tail end', l : '会L10(e)' },
    { ja : '一番前|いちばんまえ', en : 'first car; front end', l : '会L10(e)' },
    { ja : '一枚|いちまい', en : 'one sheet', l : '読L20-漢字表' },
    { ja : '一万|いちまん', en : 'ten thousand', l : '読L3-漢字表' },
    { ja : '一浪|いちろう', en : 'a person who failed entrance exams once', l : '会L22(c)' },
    { ja : 'いつ', en : 'when', l : '会L3' },
    { ja : '五日|いつか', en : 'the fifth day of a month; five days', l : '会L4(e), 会L13' },
    { ja : '一回|いっかい', en : 'one time', l : '読L22-漢字表' },
    { ja : '一か月|いっかげつ', en : 'one month', l : '読L4-漢字表' },
    { ja : '厳島神社|いつくしまじんじゃ', en : 'Itsukushima Shrine', l : '会L21(c)' },
    { ja : '一歳|いっさい', en : 'one year old', l : '会L1(e)' },
    { ja : '一週間|いっしゅうかん', en : 'one week', l : '読L9-漢字表' },
    { ja : '一生懸命|いっしょうけんめい', en : 'very hard', l : '読L21-II' },
    { ja : '一生に一度|いっしょうにいちど', en : 'once in a lifetime', l : '読L13-II' },
    { ja : '一緒に|いっしょに', en : 'together', l : '会L5' },
    { ja : '一足|いっそく', en : 'one pair of shoes', l : '読L15-漢字表' },
    { ja : '五つ|いつつ', en : 'five', l : '会L9' },
    { ja : '一対|いっつい', en : 'a pair', l : '読L20-漢字表' },
    { ja : 'いってきます', en : "I'll go and come back.", l : '会G' },
    { ja : 'いってらっしゃい', en : 'Please go and come back.', l : '会G' },
    { ja : '一泊二食付|いっぱくにしょくつき', en : 'one night with two meals', l : '会L15(e)' },
    { ja : '一分|いっぷん', en : 'one minute', l : '会L1(e)' },
    { ja : '一歩|いっぽ', en : 'one step', l : '読L17-漢字表' },
    { ja : '一方|いっぽう', en : 'on the other hand', l : '読L23-II' },
    { ja : 'いつも', en : 'always', l : '読L6-III, 会L8' },
    { ja : '～以内|～いない', en : 'within...', l : '読L16-漢字表' },
    { ja : 'いなか', en : 'countryside', l : '読L20-II' },
    { ja : 'いなくなる', en : 'to disappear; (someone) is gone', v : 'u', l : '会L23' },
    { ja : '犬|いぬ', en : 'dog', l : '会L4' },
    { ja : '違反|いはん', en : 'violation', l : '読L23-漢字表' },
    { ja : '違法|いほう', en : 'illegal', l : '読L23-漢字表' },
    { ja : '今|いま', en : 'now', l : '会L1' },
    { ja : '今すぐ|いますぐ', en : 'right away', l : '会L18' },
    { ja : '意味|いみ', en : 'meaning', l : '会L11(e), 会L12' },
    { ja : '妹|いもうと', en : 'younger sister', l : '会L1, 会L7' },
    { ja : 'いや', en : 'no', l : '会L23' },
    { ja : 'いらっしゃいます', en : '(someone honorable) is present/home', l : '会L13' },
    { ja : 'いらっしゃいませ', en : 'Welcome (to our store).', l : '会L2' },
    { ja : 'いらっしゃる', en : 'honorific exp. for いく, くる, and いる', v : 'u', l : '会L19' },
    { ja : '入口|いりぐち', en : 'entrance', l : '会L10(e)' },
    { ja : 'いる', en : '(a person) is in...; stays at...', v : 'ru', l : '会L4' },
    { ja : '要る|いる', en : 'to need', v : 'u', l : '会L8' },
    { ja : 'いれる', en : 'to make tea, coffee, etc.', v : 'ru', l : '会L17' },
    { ja : '入れる|いれる', en : 'to put (something) in', v : 'ru', l : '会L16' },
    { ja : '色|いろ', en : 'color', l : '会L9' },
    { ja : '色々|いろいろ（な）', en : 'various; different kinds of', l : '読L9-II, 会L13' },
    { ja : 'いろいろな所|いろいろなところ', en : 'various places', l : '読L11-漢字表' },
    { ja : '飲酒運転|いんしゅうんてん', en : 'drunken driving', l : '読L5-漢字表' },
    { ja : 'インタビュー', en : 'interview', l : 'ワークブックL8' },
    { ja : 'インド', en : 'India', l : '読L2-I' },
    { ja : 'インドネシア', en : 'Indonesia', l : '読L2-I' },
    { ja : 'インターネット', en : 'Internet', l : '会L15' },
    { ja : 'インフルエンザ', en : 'influenza; flu', l : '会L12' }
  ],
  
  'う' : [
    { ja : 'ううん', en : 'uh-uh; no', l : '会L8' },
    { ja : '上|うえ', en : 'above; on', l : '会L4' },
    { ja : 'ウィーン', en : 'Vienna', l : '読L5-II' },
    { ja : 'ウエア', en : 'wear; clothing; dress', l : 'ワークブック読L2' },
    { ja : 'ウエイター', en : 'waiter', l : '会L13' },
    { ja : '魚市場|うおいちば', en : 'fish market', l : '読L15-漢字表' },
    { ja : '伺う|うかがう', en : 'to humbly visit; to humbly ask', v : 'u', l : '会L20' },
    { ja : '雨期|うき', en : 'rainy season', l : '読L9-漢字表' },
    { ja : '受付|うけつけ', en : 'reception desk', l : '会L22' },
    { ja : '受ける|うける', en : 'to take (an examination, interview, etc.)', v : 'ru', l : '読L19-III, 会L23' },
    { ja : '動く|うごく', en : 'to move', v : 'u', l : '読L16-漢字表' },
    { ja : '牛|うし', en : 'cow', l : '読L12-II' },
    { ja : '後ろ|うしろ', en : 'back', l : '会L4' },
    { ja : '右折|うせつ', en : 'right turn', l : '読L6-漢字表' },
    { ja : 'うそをつく', en : 'to tell a lie', v : 'u', l : '会L11' },
    { ja : '歌|うた', en : 'song', l : '会L7' },
    { ja : '歌う|うたう', en : 'to sing', v : 'u', l : '会L7' },
    { ja : 'うち', en : 'home; house; my place', l : '会L3' },
    { ja : '内側|うちがわ', en : 'inside', l : '読L22-漢字表' },
    { ja : '宇宙人|うちゅうじん', en : 'space alien', l : '会L20' },
    { ja : '宇宙飛行士|うちゅうひこうし', en : 'astronaut', l : '会L11' },
    { ja : '写す|うつす', en : 'to copy', v : 'u', l : '読L16-II' },
    { ja : '映る|うつる', en : 'to be reflected', v : 'u', l : '読L11-漢字表' },
    { ja : 'うどん', en : 'udon; thick Japanese wheat noodles', l : 'ワークブックL2' },
    { ja : '鰻|うなぎ', en : 'freshwater eel', l : '会L18(c)' },
    { ja : '海胆|うに', en : 'sea urchin', l : '会L18(c)' },
    { ja : '馬|うま', en : 'horse', l : 'ワークブックL13' },
    { ja : 'うまく', en : 'well; successfully; skillfully', l : '読L22-II' },
    { ja : 'うまくいく', en : 'to go well', v : 'u', l : '読L22-II' },
    { ja : '生まれる|うまれる', en : 'to be born', v : 'ru', l : '読L15-II, 会L17' },
    { ja : '海|うみ', en : 'sea', l : '会L5' },
    { ja : '梅干し|うめぼし', en : 'umeboshi; pickled plums', l : '読L13-II' },
    { ja : '占い|うらない', en : 'fortunetelling', l : '読L21-II' },
    { ja : 'うらやましい', en : 'envious; jealous', l : '会L17' },
    { ja : 'うらやましがる', en : '(somebody is) envious', l : '読L22-II' },
    { ja : '売る|うる', en : 'to sell', v : 'u', l : '読L10-II, 会L15' },
    { ja : 'うるさい', en : 'noisy; annoying', l : '会L22' },
    { ja : 'うれしい', en : 'glad', l : '会L13' },
    { ja : '売れる|うれる', en : 'to be sold', v : 'ru', l : '読L20-II' },
    { ja : 'うん', en : 'uh-huh; yes', l : '会L8' },
    { ja : '運がいい|うんがいい', en : 'lucky', l : '読L16-漢字表' },
    { ja : '運転|うんてん', en : 'driving', l : '読L16-漢字表' },
    { ja : '運転する|うんてんする', en : 'to drive', v : 'irr', l : '会L8' },
    { ja : '運動|うんどう', en : 'exercise', l : '読L16-漢字表' },
    { ja : '運動する|うんどうする', en : 'to do physical exercises', v : 'irr', l : '会L9' },
    { ja : '運命|うんめい', en : 'fate', l : '読L16-漢字表' }
  ],
  
  'え' : [
    { ja : '絵|え', en : 'painting; picture; drawing', l : '会L15' },
    { ja : 'エアコン', en : 'air conditioner', l : '会L18' },
    { ja : '映画|えいが', en : 'movie', l : '会L3' },
    { ja : '英会話|えいかいわ', en : 'English conversation', l : '会L22' },
    { ja : '映画館|えいがかん', en : 'movie theater', l : '会L15' },
    { ja : '影響を受ける|えいきょうをうける', en : 'to be affected', v : 'ru', l : '読L17-II' },
    { ja : '英語|えいご', en : 'English language', l : '会L1' },
    { ja : '英国|えいこく', en : 'United Kingdom', l : '読L14-漢字表' },
    { ja : '英雄|えいゆう', en : 'hero', l : '読L14-漢字表' },
    { ja : 'ええ', en : 'yes', l : '会L1' },
    { ja : 'ええと', en : 'well...; let me see...', l : '会L16' },
    { ja : '笑顔|えがお', en : 'smile', l : '読L20-漢字表' },
    { ja : '駅|えき', en : 'station', l : '読L6-I, 会L10' },
    { ja : '駅員|えきいん', en : 'station attendant', l : '会L16' },
    { ja : '駅前|えきまえ', en : 'vicinity; in front of the station', l : '読L22-漢字表' },
    { ja : 'エクアドル', en : 'Ecuador', l : '読L2-I' },
    { ja : 'えさ', en : 'feed', l : '読L20-II' },
    { ja : 'エジプト', en : 'Egypt', l : '読L2-I' },
    { ja : '江戸|えど', en : 'former name of Tokyo', l : '読L20-II' },
    { ja : '江戸時代|えどじだい', en : 'Edo period', l : '読L20-II' },
    { ja : '海老|えび', en : 'prawn; shrimp; lobster; crayfish', l : '会L8' },
    { ja : '海老フライ|えびフライ', en : 'deep-fried prawns/shrimp', l : '会L8(c)' },
    { ja : '絵馬|えま', en : 'Ema (Shinto); wooden prayer/wish plaque', l : '会L21(c)' },
    { ja : '選ぶ|えらぶ', en : 'to choose; to select', v : 'u', l : '会L17' },
    { ja : 'Lサイズ|エルサイズ', en : 'L size; large size', l : '会L5' },
    { ja : 'エレベーター', en : 'elevator; lift', l : 'ワークブック読L4' },
    { ja : '円|えん', en : 'yen; circle', l : '会L2, 読L3-漢字表' },
    { ja : '円高|えんだか', en : 'strong yen', l : '読L3-漢字表' },
    { ja : '鉛筆|えんぴつ', en : 'pencil', l : '会L2, 会L2(e)' },
    { ja : '遠慮する|えんりょする', en : 'to hold back for the time being; to refrain from', v : 'irr', l : '会L19' }
  ],
  
  'お' : [
    { ja : 'お預け入れ|おあずけいれ', en : 'deposit', l : '会L13(e)' },
    { ja : '老い|おい', en : 'old; old age; old person', l : '会L10' },
    { ja : 'おいしい', en : 'delicious', l : '会L2' },
    { ja : 'お祈りする|おいのりする', en : 'to pray', v : 'irr', l : '会L17' },
    { ja : '王子|おうじ', en : 'prince', l : 'ワークブックL19' },
    { ja : '王族|おうぞく', en : 'member of royalty', l : '読L14-漢字表' },
    { ja : '横断する|おうだんする', en : 'to traverse', v : 'irr', l : '読L23-漢字表' },
    { ja : '往復|おうふく', en : 'round trip', l : '会L10(e)' },
    { ja : '多い|おおい', en : 'many; there are many...', l : '会L12' },
    { ja : '大きい|おおきい', en : 'big; large; great', l : '会L5' },
    { ja : '大きさ|おおきさ', en : 'size', l : '会L16' },
    { ja : '多くの～|おおくの～', en : 'many...', l : '読L21-II' },
    { ja : '大阪|おおさか', en : 'Osaka', l : 'ワークブックL7' },
    { ja : '大阪着|おおさかちゃく', en : 'arriving at Osaka', l : '読L13-漢字表' },
    { ja : 'オーケー', en : 'OK; okay', l : 'ワークブック読L2' },
    { ja : 'オーストラリア', en : 'Australia', l : '会L1, 会L11' },
    { ja : '大昔|おおむかし', en : 'ancient times', l : '読L12-漢字表' },
    { ja : '大文字|おおもじ', en : 'uppercase letters', l : '読L17-漢字表' },
    { ja : '大家さん|おおやさん', en : 'landlord; landlady', l : '会L14' },
    { ja : '丘|おか', en : 'hill; height; rising ground', l : 'ワークブック読L1' },
    { ja : 'お母さん|おかあさん', en : 'mother', l : '会L1, 会L2' },
    { ja : 'お返し|おかえし', en : 'return (as a token of gratitude)', l : '会L14' },
    { ja : 'おかえり（なさい）', en : 'Welcome home.', l : '会G' },
    { ja : 'おかげで', en : 'thanks to...', l : '会L18' },
    { ja : 'お菓子|おかし', en : 'snack; sweets', l : '会L11' },
    { ja : 'おかず', en : 'side dish', l : '会L8(c)' },
    { ja : 'お金|おかね', en : 'money', l : '会L6' },
    { ja : 'お金持ち|おかねもち', en : 'rich person', l : '会L10' },
    { ja : 'おから', en : 'Okara (food); soy pulp; tofu dregs', l : 'ワークブックL20' },
    { ja : '沖縄|おきなわ', en : 'Okinawa', l : '読L4-II' },
    { ja : 'お客さん|おきゃくさん', en : 'guest; visitor; client; customer', l : '会L17' },
    { ja : 'お客様|おきゃくさま', en : 'dear customer', l : '読L19-漢字表' },
    { ja : '起きる|おきる', en : 'to get up', v : 'ru', l : '会L3' },
    { ja : '置く|おく', en : 'to put; to lay; to place', v : 'u', l : '会L21' },
    { ja : '奥様|おくさま', en : '(your/his) wife (polite)', l : '会L19' },
    { ja : '奥さん|おくさん', en : '(your/his) wife', l : '会L14' },
    { ja : '屋上|おくじょう', en : 'rooftop', l : '読L4-漢字表' },
    { ja : '屋内|おくない', en : 'indoor', l : '読L16-漢字表' },
    { ja : '送る|おくる', en : 'to send; to walk/drive (someone)', v : 'u', l : '会L14, 会L19' },
    { ja : '遅れる|おくれる', en : 'to be late', v : 'ru', l : '会L19' },
    { ja : 'お子さん|おこさん', en : '(you/their) child (polite)', l : '会L19' },
    { ja : '起こす|おこす', en : 'to wake (someone) up', v : 'u', l : '会L16' },
    { ja : 'お好み焼き|おこのみやき', en : 'okonomikayki; savory pancake containing meat or seafood and vegetables', l : '会L8(c)' },
    { ja : '怒る|おこる', en : 'to get angry', v : 'u', l : '読L12-II, 会L19' },
    { ja : '起こる|おこる', en : 'to occur; to happen', v : 'u', l : '読L21-II' },
    { ja : 'おごる', en : 'to treat (someone) to a meal', v : 'u', l : '会L16' },
    { ja : 'お先に失礼します|おさきにしつれいします', en : "See you. (lit. I'm leaving ahead of you.)", l : '会L18' },
    { ja : 'お酒|おさけ', en : 'sake; alcohol', l : '会L3' },
    { ja : 'おじいさん', en : 'grandfather; old man', l : '会L7' },
    { ja : '教える|おしえる', en : 'to teach; to instruct', v : 'ru', l : '会L6' },
    { ja : 'お辞儀|おじぎ', en : 'bow; bowing', l : '会G' },
    { ja : 'おじさん', en : 'uncle; middle-aged man', l : '会L14' },
    { ja : 'おじぞうさん', en : 'guardian deity of children', l : '読L10-II' },
    { ja : 'おしゃれ（な）', en : 'fashionable; stylish', l : '会L14' },
    { ja : 'お正月|おしょうがつ', en : "New Year's", l : '読L10-II, 会L11' },
    { ja : 'お嬢さん|おじょうさん', en : "(someone's daughter) polite", l : '会L22' },
    { ja : 'お尻|おしり', en : 'bottom; buttocks', l : '会L7(e)' },
    { ja : 'お城|おしろ', en : 'castle', l : '読L5-II' },
    { ja : '押す|おす', en : 'to press; to push', v : 'u', l : '会L18' },
    { ja : 'お歳暮|おせいぼ', en : 'year-end gift', l : '読L17-漢字表' },
    { ja : 'お世話になる|おせわになる', en : "to be in someone's care", v : 'u', l : '読L19-II, 会L23' },
    { ja : '遅い|おそい', en : 'slow; late', l : '会L10' },
    { ja : '遅く|おそく', en : '(do something) late', l : '読L4-III, 会L6' },
    { ja : '遅くなる|おそくなる', en : 'to be late', v : 'u', l : '会L8' },
    { ja : 'お大事に|おだいじに', en : 'Get well soon.', l : '会L12' },
    { ja : 'お宅|おたく', en : "(someone's) house/home", l : '会L13' },
    { ja : 'お店|おたな', en : "merchant\'s home", l : '読L14-II' },
    { ja : 'オタワ', en : 'Ottawa (Canada)', l : '読L2-I' },
    { ja : '落ち込む|おちこむ', en : 'to get depressed', v : 'u', l : '会L16' },
    { ja : 'お茶|おちゃ', en : 'green tea', l : '会L3' },
    { ja : '落ちる|おちる', en : '(something) drops', v : 'ru', l : '会L18' },
    { ja : 'お使い|おつかい', en : 'errand', l : '読L12-漢字表' },
    { ja : 'お疲れ様（でした）|おつかれさま（でした）', en : 'You must be tired after working so hard. (ritualistic exp.)', l : '会L18' },
    { ja : 'おっしゃる', en : 'honorific exp. for いう', v : 'u', l : '会L19' },
    { ja : 'お手洗い|おてあらい', en : 'restroom', l : '会L12' },
    { ja : 'お寺|おてら', en : 'temple', l : '会L4' },
    { ja : '音|おと', en : 'sound', l : '会L20' },
    { ja : 'お父さん|おとうさん', en : 'father', l : '会L1, 会L2' },
    { ja : '弟|おとうと', en : 'younger brother', l : '会L1, 会L17' },
    { ja : '男|おとこ', en : 'man', l : '読L11-II, 会L17' },
    { ja : '男の子|おとこのこ', en : 'boy', l : '会L11' },
    { ja : '男の人|おとこのひと', en : 'man', l : '会L7' },
    { ja : '落とされる|おとされる', en : 'to be dropped', l : '読L15-II' },
    { ja : '落とす|おとす', en : 'to drop (something)', v : 'u', l : '会L18' },
    { ja : 'おととい', en : 'the day before yesterday', l : '会L4(e), 会L19' },
    { ja : 'おととし', en : 'the year before last', l : '会L4(e)' },
    { ja : '大人|おとな', en : 'adult', l : '読L12-II, 会L13' },
    { ja : '踊る|おどる', en : 'to dance', v : 'u', l : '会L9' },
    { ja : 'おなか', en : 'stomach', l : '会L7(e), 会L12' },
    { ja : 'おなかがすく', en : 'to become hungry', v : 'u', l : '会L11' },
    { ja : 'おなかをこわす', en : 'to have a stomachache', v : 'u', l : '会L23' },
    { ja : '同じ|おなじ', en : 'same', l : '読L13-III, 会L14' },
    { ja : '同じような|おなじような', en : 'similar', l : '読L23-II' },
    { ja : 'お兄さん|おにいさん', en : 'older brother', l : '会L1, 会L7' },
    { ja : 'おにぎり', en : 'rice ball', l : '会L20' },
    { ja : 'お姉さん|おねえさん', en : 'older sister', l : '会L1, 会L7' },
    { ja : 'おねがいします', en : '...,please.', l : '会L2' },
    { ja : 'お願いする|おねがいする', en : 'to request help; to pray for help', v : 'irr', l : '会L22' },
    { ja : 'おばあさん', en : 'grandmother; old woman', l : '会L7' },
    { ja : 'お化け|おばけ', en : 'goblin; ghost', l : '読L23-漢字表' },
    { ja : 'おばさん', en : 'aunt; middle-aged woman', l : '会L14' },
    { ja : 'おはよう', en : 'Good morning.', l : '会G' },
    { ja : 'おはようございます', en : 'Good morning. (polite)', l : '会G' },
    { ja : 'お引き出し|おひきだし', en : 'withdrawal', l : '会L13(e)' },
    { ja : 'お振込|おふりこみ', en : 'bank transfer', l : '会L13(e)' },
    { ja : 'お風呂|おふろ', en : 'bath', l : '会L6' },
    { ja : 'お風呂に入る|おふろにはいる', en : 'to take a bath', v : 'u', l : '会L6' },
    { ja : 'オペラ歌手|オペラかしゅ', en : 'opera singer', l : 'ワークブックL22' },
    { ja : 'お返事|おへんじ', en : 'reply', l : '読L11-II' },
    { ja : 'お弁当|おべんとう', en : 'boxed lunch', l : '会L9' },
    { ja : '覚える|おぼえる', en : 'to memorize', v : 'ru', l : '会L9' },
    { ja : 'お祭り|おまつり', en : 'festival', l : '会L11' },
    { ja : 'お守り|おまもり', en : 'charm (against evils); amulet', l : '読L21-II' },
    { ja : 'おまんじゅう', en : 'sweet bun', l : '読L4-III' },
    { ja : '御神籤|おみくじ', en : 'fortune slip', l : '会L21(c)' },
    { ja : 'お土産|おみやげ', en : 'souvenir', l : '会L4' },
    { ja : 'おめでとうございます', en : 'Congratulations!', l : '会L17' },
    { ja : '重い|おもい', en : 'heavy; serious (illness)', l : '会L20' },
    { ja : '思い出す|おもいだす', en : 'to recall', v : 'u', l : '読L19-II' },
    { ja : '思い出|おもいで', en : 'memory', l : '会L23' },
    { ja : '思う|おもう', en : 'to think', v : 'u', l : '会L8' },
    { ja : '面白い|おもしろい', en : 'interesting; funny', l : '会L5' },
    { ja : 'おもち', en : 'rice cake', l : '読L10-II' },
    { ja : 'おもちゃ', en : 'toy', l : '会L11' },
    { ja : '表|おもて', en : 'the front', l : '読L17-漢字表' },
    { ja : '主に|おもに', en : 'mainly', l : '読L17-II' },
    { ja : '親|おや', en : 'parent', l : '会L16' },
    { ja : 'おや?', en : 'Oh!', l : '会L20' },
    { ja : 'おやすみ（なさい）', en : 'Good night.', l : '会G' },
    { ja : 'お休みになる|おやすみになる', en : 'honorific exp. for ねる', v : 'u', l : '会L19' },
    { ja : 'お湯|おゆ', en : 'hot water', l : '会L17' },
    { ja : 'お湯が沸く|おゆがわく', en : 'water boils', v : 'u', l : '会L18' },
    { ja : 'お湯を沸かす|おゆをわかす', en : 'to boil water', v : 'u', l : '会L17' },
    { ja : '泳ぐ|およぐ', en : 'to swim', v : 'u', l : '会L5' },
    { ja : '折り紙|おりがみ', en : 'origami', l : '読L11-漢字表' },
    { ja : '降りる|おりる', en : 'to get off', v : 'ru', l : '会L6' },
    { ja : 'おる', en : 'extra-modest exp. for いる', v : 'u', l : '会L20' },
    { ja : 'お礼|おれい', en : 'exp. of gratitude', l : '会L19' },
    { ja : 'オランダ', en : 'Holland; The Netherlands', l : '読L2-I' },
    { ja : 'オレンジ', en : 'orange (fruit, color)', l : '読L2-I' },
    { ja : 'オレンジジュース', en : 'orange juice', l : '読L2-I' },
    { ja : '下ろす|おろす', en : 'to withdraw (money)', v : 'u', l : '会L15' },
    { ja : '終わり|おわり', en : 'end', l : '読L18-漢字表' },
    { ja : '終わる|おわる', en : 'to come to an end; (something) ends', v : 'u', l : '会L9' },
    { ja : '音楽|おんがく', en : 'music', l : '会L3' },
    { ja : '音声学|おんせいがく', en : 'phonetics', l : '読L20-漢字表' },
    { ja : '温泉|おんせん', en : 'spa; hot spring', l : '会L11' },
    { ja : '温度|おんど', en : 'temperature', l : '読L12-漢字表' },
    { ja : '女|おんな', en : 'woman', l : '読L11-II, 会L17' },
    { ja : '女の子|おんなのこ', en : 'girl', l : '会L11' },
    { ja : '女の人|おんなのひと', en : 'woman', l : '会L7' }
  ],
  
  'か' : [
    { ja : '蚊|か', en : 'mosquito', l : '会L21' },
    { ja : '～か～', en : 'or', l : '会L10' },
    { ja : '～が', en : '...,but', l : '読L5-II, 会L7' },
    { ja : 'カーテン', en : 'curtain', l : '会L2(e), 会L18' },
    { ja : 'カード', en : 'card', l : 'ワークブックL23' },
    { ja : 'ガイド', en : 'guide; tour guide', l : 'ワークブックL20' },
    { ja : '～階|～かい', en : '...th floor', l : '会L20' },
    { ja : '～回|～かい', en : '...times', l : '会L13' },
    { ja : '会員|かいいん', en : 'member', l : '読L8-漢字表' },
    { ja : '海外|かいがい', en : 'overseas', l : '読L6-漢字表' },
    { ja : '海外旅行|かいがいりょこう', en : 'trip to a foreign country', l : '会L23' },
    { ja : '海岸|かいがん', en : 'coast', l : '読L13-漢字表' },
    { ja : '会議|かいぎ', en : 'business meeting; conference', l : '会L21' },
    { ja : '外国|がいこく', en : 'foreign country', l : '会L11' },
    { ja : '外国語|がいこくご', en : 'foreign language', l : '会L13' },
    { ja : '外国人|がいこくじん', en : 'foreigner', l : '会L15' },
    { ja : '改札|かいさつ', en : 'gate', l : '会L10(e)' },
    { ja : '開始|かいし', en : 'start', l : '読L16-漢字表' },
    { ja : '会社|かいしゃ', en : 'company', l : '会L7' },
    { ja : '会社員|かいしゃいん', en : 'office worker', l : '会L1, 会L8' },
    { ja : '回数券|かいすうけん', en : 'coupons', l : '会L10(e)' },
    { ja : '回送電車|かいそうでんしゃ', en : 'out-of-service train', l : '読L21-漢字表' },
    { ja : '回送バス|かいそうバス', en : 'out-of-service bus', l : '読L22-漢字表' },
    { ja : '階段|かいだん', en : 'stairs', l : '会L10(e)' },
    { ja : '開店|かいてん', en : 'opening of a store', l : '読L16-漢字表' },
    { ja : '回転ずし|かいてんずし', en : 'rotating sushi', l : '読L15-漢字表' },
    { ja : '回答|かいとう', en : 'reply; answer', l : '読L23-漢字表' },
    { ja : '買い物|かいもの', en : 'shopping', l : '会L4' },
    { ja : 'カイロ', en : 'Cairo (Egypt)', l : '読L2-I' },
    { ja : '会話|かいわ', en : 'conversation', l : '読L9-漢字表' },
    { ja : '買う|かう', en : 'to buy', v : 'u', l : '会L4' },
    { ja : '飼う|かう', en : 'to own (a pet)', v : 'u', l : '会L11' },
    { ja : '返す|かえす', en : 'to return (a thing)', v : 'u', l : '会L6' },
    { ja : '帰ってくる|かえってくる', en : 'to come back home', v : 'irr', l : '読L22-II' },
    { ja : '帰り|かえり', en : 'return', l : '読L7-漢字表' },
    { ja : '換える|かえる', en : 'to change', v : 'ru', l : '会L23' },
    { ja : '変える|かえる', en : 'to change (something)', v : 'ru', l : '読L23-漢字表' },
    { ja : '帰る|かえる', en : 'to go back; to return', v : 'u', l : '会L3' },
    { ja : '顔|かお', en : 'face', l : '会L7(e), 会L10' },
    { ja : '顔色|かおいろ', en : 'complexion', l : '読L23-漢字表' },
    { ja : '顔が青い|かおがあおい', en : 'to look pale', l : '会L9(e)' },
    { ja : '顔文字|かおもじ', en : 'emoticon; smiley; kaomoji', l : '読L23-II' },
    { ja : '～顔をする|～かおをする', en : 'to look...(facial exp.)', v : 'irr', l : '会L23' },
    { ja : '画家|がか', en : 'painter', l : '読L11-漢字表' },
    { ja : '科学|かがく', en : 'science', l : '会L1' },
    { ja : '化学|かがく', en : 'chemistry', l : '読L23-漢字表' },
    { ja : '係の者|かかりのもの', en : 'our person in charge', l : '会L20' },
    { ja : 'かかる', en : 'to take (amount of time/money)', v : 'u', l : '会L10' },
    { ja : 'かぎ', en : 'lock; key', l : '会L17' },
    { ja : '書留|かきとめ', en : 'registered mail', l : '会L5(e)' },
    { ja : 'かぎをかける', en : 'to lock', v : 'ru', l : '会L17' },
    { ja : '描く|かく', en : 'to draw; to paint', v : 'u', l : '会L15' },
    { ja : '書く|かく', en : 'to write', v : 'u', l : '会L4' },
    { ja : '家具|かぐ', en : 'furniture', l : '会L15' },
    { ja : '学外|がくがい', en : 'outside the school; extramural', l : '読L6-I' },
    { ja : '学者|がくしゃ', en : 'scholar', l : '読L14-漢字表' },
    { ja : '学生|がくせい', en : 'student', l : '会L1' },
    { ja : '学費|がくひ', en : 'tuition; school expenses', l : 'ワークブックL10' },
    { ja : '学部|がくぶ', en : 'department; faculty', l : '読L6-漢字表' },
    { ja : '学割|がくわり', en : 'student discount', l : '会L10(e)' },
    { ja : '～か月|～かげつ', en : 'for...months', l : '会L10' },
    { ja : 'かける', en : 'to sit down', v : 'ru', l : '会L19' },
    { ja : 'かける（めがねを）', en : 'to put on (glasses)', v : 'ru', l : '会L7' },
    { ja : '過去|かこ', en : 'the past', l : '読L14-漢字表' },
    { ja : 'かさ', en : 'bamboo hat', l : '読L10-II' },
    { ja : '傘|かさ', en : 'umbrella', l : '会L2' },
    { ja : '重ねる|かさねる', en : 'to pile up', v : 'ru', l : '読L21-漢字表' },
    { ja : '火山|かざん', en : 'volcano', l : '読L4-漢字表' },
    { ja : '菓子|かし', en : 'snacks; sweets', l : '会L11' },
    { ja : '歌詞|かし', en : 'lyrics', l : '読L11-漢字表' },
    { ja : '火事|かじ', en : 'fire (disaster)', l : '会L17' },
    { ja : '家事|かじ', en : 'household matters; housework', l : '会L22' },
    { ja : '賢い|かしこい', en : 'wise; clever; smart', l : '読L20-II' },
    { ja : 'かしこまりました', en : 'Certainly.', l : '会L20' },
    { ja : '貸し出し|かしだし', en : 'lending', l : '読L18-漢字表' },
    { ja : '歌手|かしゅ', en : 'singer', l : '会L11' },
    { ja : '果汁|かじゅう', en : 'fruit juice', l : '読L23-漢字表' },
    { ja : '貸す|かす', en : 'to lend; to rent', v : 'u', l : '会L13' },
    { ja : 'カスタマーサービス', en : 'customer service', l : 'ワークブックL18' },
    { ja : '風邪|かぜ', en : 'cold', l : '会L12' },
    { ja : '風|かぜ', en : 'wind', l : '会L22' },
    { ja : '火星|かせい', en : 'Mars', l : '読L4-漢字表' },
    { ja : '風が吹く|かぜがふく', en : 'the wind blows', v : 'u', l : '会L22' },
    { ja : '風邪をひく|かぜをひく', en : 'to catch a cold', v : 'u', l : '会L12' },
    { ja : '数える|かぞえる', en : 'to count', v : 'ru', l : '読L17-II' },
    { ja : '家族|かぞく', en : 'family', l : '会L7' },
    { ja : 'ガソリン', en : 'gasoline', l : '会L21' },
    { ja : '肩|かた', en : 'shoulder', l : '会L7(e)' },
    { ja : 'かたい言い方|かたいいいかた', en : 'bookish exp.', l : '会L11(e)' },
    { ja : '片仮名|かたかな／カタカナ', en : 'katakana; angular Japanese syllabary used primarily for loanwords', l : '会L11(e)' },
    { ja : '片付ける|かたづける', en : 'to tidy up', v : 'ru', l : '会L18' },
    { ja : '片手|かたて', en : 'one hand', l : 'ワークブック読L1' },
    { ja : '片道|かたみち', en : 'one way', l : '会L10(e)' },
    { ja : '勝つ|かつ', en : 'to win', v : 'u', l : '会L22' },
    { ja : 'がっかりする', en : 'to be disappointed', v : 'irr', l : '読L20-II, 会L23' },
    { ja : '楽器|がっき', en : 'musical instrument', l : '会L13' },
    { ja : '活気|かっき', en : 'liveliness', l : '読L17-漢字表' },
    { ja : 'かっこ', en : 'parenthesis', l : '会L11(e)' },
    { ja : 'かっこいい', en : 'attractive; good-looking; stylish; cool', l : '会L5' },
    { ja : 'かっこ悪い|かっこわるい', en : 'unattractive; ugly; unstylish; uncool', l : 'ワークブックL22' },
    { ja : '学校|がっこう', en : 'school', l : '会L3' },
    { ja : 'カット', en : 'cut', l : '会L17(e)' },
    { ja : 'カップラーメン', en : 'cup noodles; cup ramen', l : 'ワークブックL18' },
    { ja : '活動|かつどう', en : 'activities', l : '読L17-II' },
    { ja : '活発|かっぱつ（な）', en : 'active', l : '読L17-漢字表' },
    { ja : '活用|かつよう', en : 'conjugation', l : '読L17-漢字表' },
    { ja : '家庭教師|かていきょうし', en : 'tutor', l : '読L18-III' },
    { ja : '角|かど', en : 'corner', l : '会L6(e), 会L20' },
    { ja : '華道|かどう', en : 'flower arrangement', l : '会L9(c)' },
    { ja : '～かな（あ）', en : 'I wonder...(casual)', l : '会L17' },
    { ja : '家内|かない', en : 'my wife', l : '読L9-漢字表' },
    { ja : 'かなう', en : 'to be realized', v : 'u', l : '読L12-II' },
    { ja : '悲しい|かなしい', en : 'sad', l : '読L10-II, 会L13' },
    { ja : '悲しむ|かなしむ', en : 'to grieve', v : 'u', l : '読L23-漢字表' },
    { ja : 'カナダ', en : 'Canada', l : '読L2-I' },
    { ja : 'カヌー', en : 'canoe', l : 'ワークブック読L2' },
    { ja : '金|かね', en : 'money', l : '会L6' },
    { ja : '金持ち|かねもち', en : 'rich person', l : '会L10' },
    { ja : '彼女|かのじょ', en : 'she; her; girlfriend', l : '読L11-II, 会L12' },
    { ja : '鞄|かばん', en : 'bag', l : '会L2, 会L2(e)' },
    { ja : 'カフェ', en : 'cafe; coffeehouse', l : '読L5-II' },
    { ja : '歌舞伎|かぶき', en : 'Kabuki; traditional Japanese theatrical art', l : '会L9' },
    { ja : 'かぶせる', en : "to put (a hat) on a person's head", v : 'ru', l : '読L10-II' },
    { ja : 'かぶる', en : 'to put on (a hat)', v : 'u', l : '会L7' },
    { ja : '花粉症|かふんしょう', en : 'hay fever', l : '読L19-漢字表' },
    { ja : '我慢する|がまんする', en : 'to be tolerant/patient', v : 'irr', l : '会L23' },
    { ja : '髪|かみ', en : 'hair', l : '会L7, 会L7(e)' },
    { ja : '紙|かみ', en : 'paper', l : '会L17' },
    { ja : '髪形|かみがた', en : 'hair style', l : '会L17(e)' },
    { ja : '神様|かみさま', en : 'God', l : '読L12-II, 会L22' },
    { ja : '紙皿|かみざら', en : 'paper plate', l : '読L20-漢字表' },
    { ja : '髪をとかす|かみをとかす', en : "to comb one's hair", v : 'u', l : '会L17' },
    { ja : 'ガム', en : 'gum', l : 'ワークブックL2' },
    { ja : 'かめ', en : 'turtle', l : '読L13-II' },
    { ja : 'カメラ', en : 'camera', l : '会L8' },
    { ja : '通う|かよう', en : 'to commute to', v : 'u', l : '読L22-II' },
    { ja : '火曜日|かようび', en : 'Tuesday', l : '会L4, 会L4(e)' },
    { ja : '～から', en : 'because...; from...', l : '会L6, 読L7-II, 会L9' },
    { ja : '辛い|からい', en : 'hot and spicy; salty', l : '会L13' },
    { ja : 'カラオケ', en : 'karaoke', l : '会L8' },
    { ja : '体|からだ', en : 'body', l : '読L13-II, 会L23' },
    { ja : '体にいい|からだにいい', en : 'good for health', l : '読L13-II' },
    { ja : '体に気をつける|からだにきをつける', en : 'to take care of oneself', v : 'ru', l : '読L7-II' },
    { ja : '空手|からて', en : 'karate', l : '会L13' },
    { ja : '借りる|かりる', en : 'to borrow; to rent; to hire', v : 'ru', l : '会L6' },
    { ja : '刈る|かる', en : 'to crop', v : 'u', l : '会L17(e)' },
    { ja : '軽い|かるい', en : 'light', l : '会L20' },
    { ja : '彼|かれ', en : 'he; him; boyfriend', l : '会L12' },
    { ja : 'カレー', en : 'curry', l : '会L13' },
    { ja : 'カレーライス', en : 'rice and curry; curry rice', l : '会L8(c)' },
    { ja : '彼ら|かれら', en : 'they', l : '読L14-漢字表' },
    { ja : '川|かわ', en : 'river', l : '会L11' },
    { ja : 'かわいい', en : 'cute', l : '会L7' },
    { ja : 'かわいそう（な）', en : 'pitiful; feel sorry for; poor thing', l : '読L12-II' },
    { ja : '川口市|かわぐちし', en : 'Kawaguchi City', l : '読L11-漢字表' },
    { ja : '代わりに|かわりに', en : 'instead', l : '読L22-II' },
    { ja : '眼科医／目医者|がんかい／めいしゃ', en : 'ophthalmologist', l : '会L12(e)' },
    { ja : '考え|かんがえ', en : 'idea', l : '読L16-漢字表' },
    { ja : '考える|かんがえる', en : 'to think (about); to consider', v : 'ru', l : '読L13-III, 会L18' },
    { ja : '環境|かんきょう', en : 'environment', l : '会L21' },
    { ja : '観光する|かんこうする', en : 'to do sightseeing', v : 'irr', l : '会L15' },
    { ja : '韓国|かんこく', en : 'Korea', l : '会L1, 会L2' },
    { ja : '看護師|かんごし', en : 'nurse', l : '会L1, 会L11' },
    { ja : '関西|かんさい', en : 'Kansai area', l : '読L6-漢字表' },
    { ja : '漢字|かんじ', en : 'kanji; Chinese character', l : '会L6' },
    { ja : '元日|がんじつ', en : 'the first day of the year', l : '読L5-漢字表' },
    { ja : '感謝|かんしゃ', en : 'gratitude', l : '読L23-漢字表' },
    { ja : '感情|かんじょう', en : 'feeling; emotion', l : '読L23-II' },
    { ja : '感じる|かんじる', en : 'to feel', v : 'ru', l : '読L23-漢字表' },
    { ja : '完成する|かんせいする', en : 'to be completed', v : 'irr', l : '読L17-II' },
    { ja : '感想|かんそう', en : 'impression', l : '読L23-漢字表' },
    { ja : '簡単|かんたん（な）', en : 'easy; simple', l : '会L10' },
    { ja : '簡単に|かんたんに', en : 'easily', l : '読L23-II' },
    { ja : '関東|かんとう', en : 'Kanto area', l : '読L6-漢字表' },
    { ja : '感動する|かんどうする', en : 'to be moved/touched (by...)', v : 'irr', l : '会L13' },
    { ja : 'カンニングする', en : 'to cheat in an exam', l : '会L23' },
    { ja : '乾杯|かんぱい', en : 'Cheers! (a toast)', l : '会L8' },
    { ja : '頑張る|がんばる', en : "to do one's best; to try hard", v : 'u', l : '会L13' },
    { ja : 'がんぺき', en : 'cliff', l : '読L1-I' },
    { ja : '漢方薬|かんぽうやく', en : 'Chinese herbal medicine', l : '読L19-漢字表' },
    { ja : '巻末|かんまつ', en : 'end of book; appendix', l : '巻末' },
    { ja : '漢和辞典|かんわじてん', en : 'Kanji dictionary', l : '読L19-漢字表' }
  ],
  
  'き' : [
    { ja : '木|き', en : 'tree', l : '会L22' },
    { ja : '黄色い|きいろい', en : 'yellow', l : '会L9(e)' },
    { ja : 'キウイ', en : 'kiwi fruit', l : 'ワークブック読L2' },
    { ja : '消える|きえる', en : '(something) goes off', v : 'ru', l : '会L18' },
    { ja : '気温|きおん', en : 'temperature (weather)', l : '会L12' },
    { ja : '着替える|きがえる', en : 'to change clothes', v :'ru', l : '会L21' },
    { ja : '気が付く|きがつく', en : 'to notice', v : 'u', l : '会L21' },
    { ja : '聞く|きく', en : 'to hear; to listen; to ask', v : 'u', l : '会L3, 会L5' },
    { ja : '聞こえる|きこえる', en : 'to be audible', v : 'ru', l : '会L20' },
    { ja : '帰国|きこく', en : "returning to one's country", l : '読L7-漢字表' },
    { ja : '記事|きじ', en : 'an article; news', l : '読L22-漢字表' },
    { ja : '擬声語|ぎせいご', en : 'onomatopoeia', l : '読L20-漢字表' },
    { ja : '季節|きせつ', en : 'season', l : '会L10' },
    { ja : '気絶する|きぜつする', en : 'to faint', v : 'irr', l : '読L20-漢字表' },
    { ja : '北|きた', en : 'north', l : '会L6(e)' },
    { ja : 'ギター', en : 'guitar', l : '会L9' },
    { ja : '期待する|きたいする', en : 'to expect', v : 'irr', l : '読L22-漢字表' },
    { ja : '帰宅|きたく', en : 'returning home', l : '読L7-漢字表' },
    { ja : '北口|きたぐち', en : 'north exit', l : '読L6-漢字表' },
    { ja : '汚い|きたない', en : 'dirty', l : '会L16' },
    { ja : '北山長|きたやまちょう', en : 'Kitayama town', l : '読L10-漢字表' },
    { ja : '貴重品|きちょうひん', en : 'valuables', l : '読L21-漢字表' },
    { ja : '喫煙ルーム|きつえんルーム', en : 'smoking room', l : '会L15(e)' },
    { ja : '喫茶店|きっさてん', en : 'cafe', l : '会L12' },
    { ja : '切手|きって', en : 'postal stamps', l : '会L5, 会L5(e)' },
    { ja : '切符|きっぷ', en : 'ticket', l : '会L5' },
    { ja : '切符売り場|きっぷうりば', en : 'ticket vending area', l : '会L10(e)' },
    { ja : '喜怒哀楽|きどあいらく', en : 'human emotions', l : '読L23-漢字表' },
    { ja : '気に入る|きにいる', en : 'to find something agreeable; to be fond of', v : 'u', l : '会L23' },
    { ja : '気にする|きにする', en : 'to worry', v : 'irr', l : '読L21-II' },
    { ja : '記入する|きにゅうする', en : 'to fill in', v : 'irr', l : '読L22-漢字表' },
    { ja : '昨日|きのう', en : 'yesterday', l : '会L4, 会L4(e)' },
    { ja : '厳しい|きびしい', en : 'strict', l : '会L13' },
    { ja : '気分が悪い|きぶんがわるい', en : 'to feel sick', l : '読L13-II, 会L18' },
    { ja : '期末試験|きまつしけん', en : 'final examination', l : '会L16' },
    { ja : '決まる|きまる', en : 'to be decided', v : 'u', l : '会L19' },
    { ja : '決める|きめる', en : 'to decide', v : 'ru', l : '会L10' },
    { ja : '気持ち|きもち', en : 'feeling', l : '読L23-II' },
    { ja : '着物|きもの', en : 'kimono; Japanese tradition dress', l : '読L9-II, 会L13' },
    { ja : 'キャッシュカード', en : 'bank card', l : '会L13(e)' },
    { ja : 'キャップ', en : 'cap (headwear); cap (of a bottle, pen, etc.)', l : 'ワークブック読L2' },
    { ja : 'キャベツ', en : 'cabbage', l : '会L8(e)' },
    { ja : 'キャラ', en : '(fictional) character; personality', l : 'ワークブックL20' },
    { ja : 'キャンベラ', en : 'Canberra (Australia)', l : '読L2-I' },
    { ja : 'キャンプ', en : 'camp', l : '会L11' },
    { ja : '九|きゅう', en : 'nine', l : '読L3-漢字表' },
    { ja : '休講|きゅうこう', en : 'class cancellation', l : '会L23' },
    { ja : '急行|きゅうこう', en : 'express', l : '会L10(e)' },
    { ja : '九歳|きゅうさい', en : 'nine years old', l : '会L1(e)' },
    { ja : '休日|きゅうじつ', en : 'holiday', l : '読L8-漢字表' },
    { ja : '九十年代|きゅうじゅうねんだい', en : 'the nineties', l : '読L14-漢字表' },
    { ja : '急に|きゅうに', en : 'suddenly', l : '読L14-II' },
    { ja : '牛丼|ぎゅうどん', en : 'beef rice bowl; rice covered with beef and vegetables', l : '会L8(c)' },
    { ja : '牛肉|ぎゅうにく', en : 'beef', l : '読L12-漢字表' },
    { ja : '牛乳|ぎゅうにゅう', en : 'milk', l : '会L10' },
    { ja : '急病|きゅうびょう', en : 'sudden illness', l : '読L11-漢字表' },
    { ja : '九分|きゅうふん', en : 'nine minutes', l : '会L1(e)' },
    { ja : 'きゅうり', en : 'cucumber', l : '会L8(e)' },
    { ja : '給料|きゅうりょう', en : 'salary', l : '会L17' },
    { ja : '今日|きょう', en : 'today', l : '会L3, 会L4(e)' },
    { ja : '教会|きょうかい', en : 'church', l : '読L7-漢字表' },
    { ja : '教科書|きょうかしょ', en : 'textbook', l : '会L6' },
    { ja : '餃子|ぎょうざ', en : 'gyoza; pot sticker; dumplings', l : '会L8(c)' },
    { ja : '教室|きょうしつ', en : 'classroom', l : '読L16-II' },
    { ja : '教授|きょうじゅ', en : 'professor', l : '読L18-漢字表' },
    { ja : '今日中に|きょうじゅうに', en : 'by the end of today', l : '会L16' },
    { ja : '兄弟|きょうだい', en : 'siblings; brothers and sisters; brothers', l : '会L7' },
    { ja : '強調する|きょうちょうする', en : 'to emphasize', v : 'irr', l : '読L23-漢字表' },
    { ja : '京都|きょうと', en : 'Kyoto', l : '読L7-漢字表' },
    { ja : '興味|きょうみ', en : 'interest', l : '読L15-漢字表' },
    { ja : '興味がある|きょうみがある', en : 'to be interested (in)', v : 'u', l : '会L12' },
    { ja : '～行目|～ぎょうめ', en : 'line number...', l : '会L11(e)' },
    { ja : '協力|きょうりょく', en : 'cooperation', l : '読L18-漢字表' },
    { ja : '強力|きょうりょく（な）', en : 'powerful', l : '読L11-漢字表' },
    { ja : '去年|きょねん', en : 'last year', l : '会L4(e), 会L9' },
    { ja : '清水寺|きよみずでら', en : 'Kiyomizu-dera', l : '会L21(c)' },
    { ja : '距離|きょり', en : 'distance; range', l : '読L1-I' },
    { ja : '嫌い|きらい（な）', en : 'disgusted with; to dislike', l : '会L5' },
    { ja : 'キリスト教|キリストきょう', en : 'Christianity', l : '読L16-漢字表' },
    { ja : '起立する|きりつする', en : 'to stand up', v : 'irr', l : '読L12-漢字表' },
    { ja : '切る|きる', en : 'to cut', v : 'u', l : '会L8, 会L17(e)' },
    { ja : '着る|きる', en : 'to wear; to put on (clothes above your waist)', v : 'ru', l : '会L7' },
    { ja : 'きれい（な）', en : 'beautiful; clean', l : '会L5' },
    { ja : '～キロ', en : '...kilometers; ...kilograms', l : '会L13' },
    { ja : '究める|きわめる', en : 'to investigate thoroughly', v : 'ru', l : '読L19-漢字表' },
    { ja : '気をつけて|きをつけて', en : 'take care; be careful; watch out', l : 'ワークブック読L1' },
    { ja : '気をつける|きをつける', en : 'to be cautious/careful', v : 'ru', l : '会L15' },
    { ja : '金色|きんいろ', en : 'gold', l : '会L9(e)' },
    { ja : '銀色|ぎんいろ', en : 'silver', l : '会L9(e)' },
    { ja : '禁煙車|きんえんしゃ', en : 'nonsmoking car', l : '会L10(e)' },
    { ja : '禁煙ルーム|きんえんルーム', en : 'nonsmoking room', l : '会L15(e)' },
    { ja : '金額|きんがく', en : 'amount', l : '会L13(e)' },
    { ja : '金魚|きんぎょ', en : 'goldfish', l : '読L15-漢字表' },
    { ja : '銀行|ぎんこう', en : 'bank', l : '会L2' },
    { ja : '禁止する|きんしする', en : 'to prohibit', v : 'irr', l : '読L20-漢字表' },
    { ja : '近所|きんじょ', en : 'neighborhood', l : '読L11-II' },
    { ja : '銀世界|ぎんせかい', en : 'land covered with snow', l : '読L22-漢字表' },
    { ja : '緊張する|きんちょうする', en : 'to get nervous', v : 'irr', l : '会L12' },
    { ja : '筋肉|きんにく', en : 'muscle', l : '読L13-漢字表' },
    { ja : '金髪|きんぱつ', en : 'blonde hair', l : '会L9(e)' },
    { ja : '勤勉|きんべん（な）', en : 'diligent', l : '読L11-漢字表' },
    { ja : '銀メダル|ぎんメダル', en : 'silver medal', l : '読L22-漢字表' },
    { ja : '金曜日|きんようび', en : 'Friday', l : '会L4, 会L4(e)' }
  ],
  
  'く' : [
    { ja : 'クアラルンプール', en : 'Kuala Lumpur (Malaysia)', l : '読L2-I' },
    { ja : '空気|くうき', en : 'air', l : '会L8' },
    { ja : '空港|くうこう', en : 'airport', l : '読L13-III, 会L20' },
    { ja : '九月|くがつ', en : 'September', l : '会L4(e)' },
    { ja : '九時|くじ', en : "nine o'clock", l : '会L1(e)' },
    { ja : 'くじら', en : 'whale', l : '読L15-II' },
    { ja : '薬|くすり', en : 'medicine', l : '会L9' },
    { ja : '薬を飲む|くすりをのむ', en : 'to take medicine', v : 'u', l : '会L9' },
    { ja : 'くだけた言い方|くだけたいいかた', en : 'colloquial exp.', l : '会L11(e)' },
    { ja : '下さい|ください', en : 'please give/do...', l : '会L2, 読L4-漢字表' },
    { ja : '下さる|くださる', en : 'honorific exp. for くれる', v : 'u', l : '会L19' },
    { ja : '果物|くだもの', en : 'fruit', l : '読L23-漢字表' },
    { ja : '口|くち', en : 'mouth', l : '会L7, 会L7(e)' },
    { ja : '靴|くつ', en : 'shoes', l : '会L2' },
    { ja : '靴下|くつした', en : 'socks', l : '会L23' },
    { ja : 'クッキー', en : 'cookie', l : 'ワークブックL18' },
    { ja : 'クッション', en : 'cushion', l : '会L18' },
    { ja : '国|くに', en : 'country; place of origin', l : '会L7' },
    { ja : '配る|くばる', en : 'to distribute', v : 'u', l : '読L21-漢字表' },
    { ja : '首|くび', en : 'neck', l : '会L7(e)' },
    { ja : '雲|くも', en : 'cloud', l : '読L17-II' },
    { ja : '曇り|くもり', en : 'cloudy weather', l : '会L12' },
    { ja : '暗い|くらい', en : 'dark', l : '会L18' },
    { ja : '～ぐらい', en : 'amount (approximate measurement)', l : '会L4' },
    { ja : 'クラシック', en : 'classic; classical music', l : '読L5-II' },
    { ja : 'クラス', en : 'class', l : '会L4' },
    { ja : 'グラス', en : 'tumbler; glass', l : '会L14' },
    { ja : 'クラブ', en : 'club; night club', l : '会L15' },
    { ja : '比べる|くらべる', en : 'to compare', v : 'ru', l : '読L23-II' },
    { ja : 'グリーン', en : 'green', l : '会L9(e)' },
    { ja : 'クリスマス', en : 'Christmas', l : '会L14' },
    { ja : '来る|くる', en : 'to come', v : 'irr', l : '会L3' },
    { ja : '車|くるま', en : 'car', l : '会L7' },
    { ja : '車いす|くるまいす', en : 'wheel chair', l : '読L8-漢字表' },
    { ja : 'グレー', en : 'gray', l : '会L9(e)' },
    { ja : 'グレープ', en : 'grape', l : '読L17-II' },
    { ja : 'グレープフルーツ', en : 'grapefruit', l : '読L17-II' },
    { ja : 'クレジットカード', en : 'credit card', l : '会L10, 会L13(e)' },
    { ja : 'くれる', en : 'to give (me)', v : 'ru', l : '会L14' },
    { ja : '黒い|くろい', en : 'black', l : '会L9, 会L9(e)' },
    { ja : '～君|～くん', en : 'Mr./Ms....(casual)', l : '会L14' }
  ],
  
  'け' : [
    { ja : '経営学|けいえいがく', en : 'management studies', l : '読L21-漢字表' },
    { ja : '計画|けいかく', en : 'plan', l : '読L11-漢字表' },
    { ja : '計画を立てる|けいかくをたてる', en : 'to make a plan', v : 'ru', l : '会L22' },
    { ja : '経験|けいけん', en : 'experience', l : '読L13-II, 会L15' },
    { ja : '敬語|けいご', en : 'honorific language', l : '会L19' },
    { ja : '経済|けいざい', en : 'economics; economy', l : '会L1, 会L2' },
    { ja : '警察|けいさつ', en : 'police; police station', l : '会L21' },
    { ja : '警察官|けいさつかん', en : 'police officer', l : '会L11' },
    { ja : '携帯|けいたい', en : 'cell phone; mobile phone', l : '会L18' },
    { ja : '芸術|げいじゅつ', en : 'art', l : '読L17-II' },
    { ja : 'ケーキ', en : 'cake', l : '会L10' },
    { ja : 'ゲーム', en : 'game', l : '会L7' },
    { ja : 'けが', en : 'injury', l : '会L12(e)' },
    { ja : '外科医|げかい', en : 'surgeon', l : '会L12(e)' },
    { ja : '今朝|けさ', en : 'this morning', l : '会L8' },
    { ja : '景色|けしき', en : 'scenery', l : '読L15-II' },
    { ja : '消しゴム|けしゴム', en : 'eraser', l : '会L2(e)' },
    { ja : '下宿|げしゅく', en : 'boarding house', l : '読L18-漢字表' },
    { ja : '化粧|けしょう', en : 'makeup', l : '読L23-漢字表' },
    { ja : '化粧する|けしょうする', en : 'to put makeup on', v : 'irr', l : '会L17' },
    { ja : '化粧品|けしょうひん', en : 'cosmetics; toilet articles', l : '会L14' },
    { ja : '消す|けす', en : 'to turn off; to erase', v : 'u', l : '会L14' },
    { ja : 'げた', en : 'wooden clogs', l : '会L20' },
    { ja : 'ケチ|けち（な）', en : 'stingy; cheap', l : '会14' },
    { ja : '結果|けっか', en : 'result', l : '読L23-II' },
    { ja : '結構です|けっこうです', en : "That would be fine.; That wouldn't be necessary.", l : '会L6' },
    { ja : '結婚式|けっこんしき', en : 'wedding', l : '会L15' },
    { ja : '結婚する|けっこんする', en : 'to get married', v : 'irr', l : '会L7' },
    { ja : '月末|げつまつ', en : 'end of the month', l : '読L22-漢字表' },
    { ja : '月曜日|げつようび', en : 'Monday', l : '会L4, 会L4(e)' },
    { ja : '結論|けつろん', en : 'conclusion', l : '読L17-漢字表' },
    { ja : '～けど', en : '...,but; ...,so', l : '会L15' },
    { ja : 'ける', en : 'to kick', v : 'u', l : '会L21' },
    { ja : '原因|げんいん', en : 'cause; origin; source', l : 'ワークブックL18' },
    { ja : '限界|げんかい', en : 'limit', l : '読L16-漢字表' },
    { ja : 'けんかする', en : 'to have a fight; to quarrel', v : 'irr', l : '会L11' },
    { ja : '元気|げんき（な）', en : 'healthy; energetic', l : '会L5' },
    { ja : '元気がない|げんきがない', en : "don't look well", l : '会L12' },
    { ja : '元気でね|げんきでね', en : 'Take care of yourself.', l : '会L23' },
    { ja : '研究|けんきゅう', en : 'research', l : '会L16' },
    { ja : '研究室|けんきゅうしつ', en : "professor's office", l : '読L16-漢字表' },
    { ja : '研究者|けんきゅうしゃ', en : 'researcher', l : '読L19-漢字表' },
    { ja : '健康|けんこう', en : 'health', l : '会L23' },
    { ja : '建国|けんこく', en : 'founding a nation', l : '読L15-漢字表' },
    { ja : '言語学|げんごがく', en : 'linguistics', l : '読L8-漢字表' },
    { ja : '剣道|けんどう', en : 'kendo; Japanese fencing; way of the sword', l : '会L9(c)' },
    { ja : '検査|けんさ', en : 'inspection', l : '読L23-漢字表' },
    { ja : '研修|けんしゅう', en : 'training', l : '読L19-漢字表' },
    { ja : '現代的|げんだいてき', en : 'modern', l : '読L18-漢字表' },
    { ja : '原爆|げんばく', en : 'atomic bomb', l : '読L15-II' },
    { ja : '見物|けんぶつ', en : 'sightseeing', l : '読L5-漢字表' }
  ],
  
  'こ' : [
    { ja : '～個|～こ', en : 'counter for smaller items', l : '会L14, 会L14(e)' },
    { ja : '～後|～ご', en : 'in...time; after...', l : '会L10' },
    { ja : '～語|～ご', en : '...language', l : '会L1' },
    { ja : '鯉|こい', en : 'carp', l : 'ワークブック読L1' },
    { ja : '子犬|こいぬ', en : 'puppy', l : '読L21-漢字表' },
    { ja : 'コインランドリー', en : 'laundromat; coin laundry', l : 'ワークブックL6' },
    { ja : '好意|こうい', en : 'good will', l : '読L11-漢字表' },
    { ja : '幸運|こううん', en : 'good fortune', l : '読L21-漢字表' },
    { ja : '公園|こうえん', en : 'park', l : '会L4' },
    { ja : '効果|こうか', en : 'effect', l : '読L23-漢字表' },
    { ja : '公会堂|こうかいどう', en : 'public hall', l : '読L18-漢字表' },
    { ja : '工学|こうがく', en : 'engineering', l : '読L19-漢字表' },
    { ja : '交換する|こうかんする', en : 'to exchange', v : 'irr', l : '会L20' },
    { ja : '好奇心|こうきしん', en : 'curiosity', l : '読L20-漢字表' },
    { ja : '航空便|こうくうびん', en : 'airmail', l : '会L5(e)' },
    { ja : '合計|ごうけい', en : 'sum', l : '読L21-漢字表' },
    { ja : '高校|こうこう', en : 'high school', l : '会L1' },
    { ja : '高校生|こうこうせい', en : 'high school student', l : '会L1' },
    { ja : '考古学|こうこがく', en : 'archeology', l : '読L16-漢字表' },
    { ja : '広告|こうこく', en : 'advertisement', l : '会L13' },
    { ja : '口座|こうざ', en : 'account', l : '会L13(e)' },
    { ja : '子牛|こうし', en : 'calf; veal', l : '読L12-漢字表' },
    { ja : '工事|こうじ', en : 'construction', l : '読L19-漢字表' },
    { ja : '工場|こうじょう', en : 'factory', l : '会L21' },
    { ja : '強情|ごうじょう（な）', en : 'obstinate', l : '読L11-漢字表' },
    { ja : '抗生物質|こうせいぶっしつ', en : 'antibiotic', l : '会L12(e)' },
    { ja : '紅茶|こうちゃ', en : 'black tea', l : '会L13' },
    { ja : '強盗|ごうとう', en : 'robbery', l : '読L11-漢字表' },
    { ja : '後輩|こうはい', en : 'junior member of a group', l : '会L22' },
    { ja : '交番|こうばん', en : 'police box', l : '読L22-漢字表' },
    { ja : '幸福|こうふく（な）', en : 'happiness; well-being; joy', l : '読L21-漢字表' },
    { ja : '好物|こうぶつ', en : 'favorite food', l : '読L11-漢字表' },
    { ja : '神戸港|こうべこう', en : 'Kobe Port', l : '読L13-漢字表' },
    { ja : '神戸市|こうべし', en : 'Kobe City', l : '読L12-漢字表' },
    { ja : '紅葉|こうよう', en : 'red leaves; autumn tints', l : '読L15-II' },
    { ja : '声|こえ', en : 'voice', l : '読L10-II' },
    { ja : 'コーク', en : 'cork; coke; Coca-Cola', l : 'ワークブック読L2' },
    { ja : 'コーヒー', en : 'coffee', l : '会L3' },
    { ja : 'コーラ', en : 'cola', l : 'ワークブックL2' },
    { ja : '五|ご', en : 'five', l : '読L3-漢字表' },
    { ja : 'ゴールド', en : 'gold', l : '会L9(e)' },
    { ja : '五月|ごがつ', en : 'May', l : '会L4(e)' },
    { ja : '国際|こくさい', en : 'international', l : '読L19-III' },
    { ja : '国際関係|こくさいかんけい', en : 'international relations', l : '会L1' },
    { ja : '国際電話|こくさいでんわ', en : 'international call', l : '会L23' },
    { ja : '国内|こくない', en : 'domestic', l : '読L22-漢字表' },
    { ja : '黒板|こくばん', en : 'blackboard', l : '会L2(e), 会L8' },
    { ja : '国立大学|こくりつだいがく', en : 'national university', l : '読L10-漢字表' },
    { ja : '国連|こくれん', en : 'United Nations', l : '読L12-漢字表' },
    { ja : 'ここ', en : 'here', l : '会L2' },
    { ja : '午後|ごご', en : 'P.M.', l : '会L1' },
    { ja : 'ココア', en : 'cocoa; hot chocolate', l : 'ワークブック読L2' },
    { ja : '九日|ここのか', en : 'the ninth day of a month; nine days', l : '会L4(e), 会L13' },
    { ja : '九つ|ここのつ', en : 'nine', l : '会L9' },
    { ja : '心|こころ', en : 'mind; heart', l : '読L20-II' },
    { ja : '心残り|こころのこり', en : 'regret', l : '読L22-漢字表' },
    { ja : '試みる|こころみる', en : 'to try', v : 'ru', l : '読L18-漢字表' },
    { ja : '五歳|ごさい', en : 'five years old', l : '会L1(e)' },
    { ja : 'ござる', en : 'extra-modest exp. for ある', v : 'u', l : '会L20' },
    { ja : '五時|ごじ', en : "five o'clock", l : '会L1(e)' },
    { ja : 'ご主人|ごしゅじん', en : '(your/her) husband', l : '会L14' },
    { ja : '午前|ごぜん', en : 'A.M.', l : '会L1' },
    { ja : '午前中|ごぜんちゅう', en : 'in the morning', l : '読L9-II' },
    { ja : '古代|こだい', en : 'ancient times', l : '読L9-漢字表' },
    { ja : '答え|こたえ', en : 'answer', l : '会L11(e), 読L23-II' },
    { ja : '答える|こたえる', en : 'to answer', v : 'ru', l : '読L8-II, 会L23' },
    { ja : 'ごちそう', en : 'excellent food', l : '読L9-II' },
    { ja : 'ごちそうさま（でした）', en : 'Thank you for the meal. (after eating)', l : '会G' },
    { ja : 'ごちそうする', en : 'to treat/invite (someone) to a meal', v : 'irr', l : '会L19' },
    { ja : 'こちら', en : 'this way (polite); this person (polite)', l : '会L11, 会L18' },
    { ja : '国歌|こっか', en : 'national anthem', l : '読L11-漢字表' },
    { ja : '国会|こっかい', en : 'the Diet', l : '読L6-漢字表' },
    { ja : '小包|こづつみ', en : 'parcel', l : '会L5(e)' },
    { ja : '事|こと', en : 'things; matters', l : '読L11-II, 会L21' },
    { ja : '今年|ことし', en : 'this year', l : '会L4(e), 会L10' },
    { ja : '言葉|ことば', en : 'language; word(s)', l : '会L13' },
    { ja : '子供|こども', en : 'child', l : '会L4' },
    { ja : '子供の時|こどものとき', en : "in one's childhood", l : '読L3-漢字表' },
    { ja : '子供用|こどもよう', en : 'for children', l : '読L22-漢字表' },
    { ja : 'コネ', en : 'connection; pull', l : 'ワークブック読L2' },
    { ja : 'この', en : 'this...', l : '会L2' },
    { ja : 'この間|このあいだ', en : 'the other day', l : '会L16' },
    { ja : 'このぐらい', en : 'about this much', l : '会L16' },
    { ja : 'このごろ', en : 'these days', l : '会L10' },
    { ja : '木の葉|このは', en : 'leaf; foliage', l : 'ワークブック読L1' },
    { ja : 'この人|このひと', en : 'this person', l : '読L4-漢字表' },
    { ja : '好み|このみ', en : 'liking; taste', l : '読L11-漢字表' },
    { ja : 'このように', en : 'like this; this way', l : '読L23-II' },
    { ja : 'ご飯|ごはん', en : 'rice; meal', l : '会L4' },
    { ja : 'コピーを取る|コピーをとる', en : 'to make a photocopy', v : 'u', l : '会L22' },
    { ja : '五分|ごふん', en : 'five minutes', l : '会L1(e)' },
    { ja : '困る|こまる', en : 'to have difficulty', v : 'u', l : '会L16' },
    { ja : 'ごみ', en : 'garbage', l : '会L16' },
    { ja : '込む|こむ', en : 'to get crowded', v : 'u', l : '読L13-III, 会L17' },
    { ja : '混む|こむ', en : 'to get crowded', v : 'u', l : '読L15-II' },
    { ja : 'ごめん', en : "I'm sorry. (casual)", l : '会L16' },
    { ja : 'ごめんなさい', en : "I'm sorry.", l : '会L4' },
    { ja : 'ご覧になる|ごらんになる', en : 'honorific exp. for みる', v : 'u', l : '会L19' },
    { ja : 'ゴルフ', en : 'golf', l : '会L13' },
    { ja : 'これ', en : 'this one', l : '会L2' },
    { ja : 'これから', en : 'from now on', l : '読L11-II, 会L16' },
    { ja : 'ころ', en : 'time of...; when...', l : '会L21' },
    { ja : '～ごろ', en : 'at about...', l : '会L3' },
    { ja : 'ごろごろする', en : 'to chill out at home; to stay home and do nothing', l : '会L10' },
    { ja : '転ぶ|ころぶ', en : 'to fall down', v : 'u', l : '会L18' },
    { ja : '怖い|こわい', en : 'scary; frightening', l : '会L5' },
    { ja : '壊す|こわす', en : 'to break (something)', v : 'u', l : '会L18' },
    { ja : '壊れる|こわれる', en : '(something) breaks', v : 'ru', l : '会L18' },
    { ja : '今学期|こんがっき', en : 'this semester', l : '会L11' },
    { ja : '今月|こんげつ', en : 'this month', l : '会L4(e), 会L8' },
    { ja : 'コンサート', en : 'concert', l : '会L9' },
    { ja : '今週|こんしゅう', en : 'this week', l : '会L4(e), 会L6' },
    { ja : 'コンタクト', en : 'contact lenses', l : '会L17' },
    { ja : '込んでいる|こんでいる', en : 'to be crowded', l : '読L13-III' },
    { ja : '混んでいる|こんでいる', en : 'to be crowded', l : '読L15-II' },
    { ja : '今度|こんど', en : 'this time; next time; near future', l : '会L9' },
    { ja : 'こんな～', en : '...like this; this kind of...', l : '会L14' },
    { ja : 'こんなふう', en : 'like this', l : '会L22' },
    { ja : 'こんにちは', en : 'Good afternoon.', l : '会G' },
    { ja : '今晩|こんばん', en : 'tonight', l : '会L3' },
    { ja : 'こんばんは', en : 'Good evening.', l : '会G' },
    { ja : 'コンビニ', en : 'convenience store', l : '会L7' },
    { ja : 'コンピューター', en : 'computer', l : '会L1, 会L2' },
    { ja : '今夜|こんや', en : 'tonight', l : '読L10-漢字表' },
    { ja : '婚約者|こんやくしゃ', en : 'fiancée', l : '読L17-漢字表' }
  ],
  
  'さ' : [
    { ja : 'さあ', en : 'come; well; I am not sure,...', l : '会L20' },
    { ja : 'サークル', en : 'club activity', l : '会L7' },
    { ja : 'サービス業|サービスぎょう', en : 'service industry', l : '読L18-漢字表' },
    { ja : 'サーフィン', en : 'surfing', l : '会L5' },
    { ja : 'サーモン', en : 'salmon', l : '会L18(c)' },
    { ja : '～歳|～さい', en : '...years old', l : '会L1, 会L1(e)' },
    { ja : '最悪|さいあく', en : 'the worst', l : '読L20-II' },
    { ja : '再起動|さいきどう', en : 'reboot; restart', l : '読L12-漢字表' },
    { ja : '最近|さいきん', en : 'recently', l : '会L15' },
    { ja : '最高|さいこう', en : 'the best', l : '読L7-漢字表' },
    { ja : '最後に|さいごに', en : 'finally; lastly', l : '読L8-II, 会L23' },
    { ja : '最後の～|さいごの～', en : 'last...', l : '読L23-II' },
    { ja : '最新|さいしん', en : 'the latest', l : '読L20-漢字表' },
    { ja : '最終～|さいしゅう～', en : 'the last...', l : '読L18-漢字表' },
    { ja : '最終回|さいしゅうかい', en : 'last inning; last episode', l : '読L22-漢字表' },
    { ja : '最初|さいしょ', en : 'first', l : '読L21-漢字表' },
    { ja : '最初の～|さいしょの～', en : 'first...', l : '読L23-II' },
    { ja : '賽銭|さいせん', en : 'monetary offering; offertory', l : '会L21(c)' },
    { ja : '最低|さいてい', en : 'the lowest; the worst', l : '会L17' },
    { ja : '財布|さいふ', en : 'wallet', l : '会L2' },
    { ja : '幸い|さいわい', en : 'fortunately', l : '読L21-漢字表' },
    { ja : '探す|さがす', en : 'to search; to look for', v : 'u', l : '会L15' },
    { ja : '魚|さかな', en : 'fish', l : '会L2' },
    { ja : '魚屋|さかなや', en : 'fish shop', l : '読L16-漢字表' },
    { ja : '先に|さきに', en : 'ahead', l : '読L6-漢字表' },
    { ja : '咲く|さく', en : 'to bloom', v : 'u', l : '会L18' },
    { ja : '作者|さくしゃ', en : 'author', l : '読L8-漢字表' },
    { ja : '作品|さくひん', en : 'artistic piece', l : '読L17-II' },
    { ja : '作文|さくぶん', en : 'essay; composition', l : '会L9' },
    { ja : '桜|さくら', en : 'cherry tree; cherry blossom', l : '読L19-II' },
    { ja : '酒|さけ', en : 'sake; alcohol', l : '会L3' },
    { ja : '差し上げる|さしあげる', en : 'humble exp. for あげる', v : 'ru', l : '会L20' },
    { ja : '刺身|さしみ', en : 'raw fish', l : 'ワークブックL12' },
    { ja : '刺す|さす', en : 'to bite', v : 'u', l : '会L21' },
    { ja : '授かる|さずかる', en : 'to be given; to be awarded', v : 'u', l : '読L18-漢字表' },
    { ja : '左折|させつ', en : 'left turn', l : '読L6-漢字表' },
    { ja : '誘う|さそう', en : 'to invite', v : 'u', l : '会L15' },
    { ja : '座談会|ざだんかい', en : 'round-table discussion', l : '読L13-III' },
    { ja : '～冊|～さつ', en : 'counter for bound volumes', l : '会L14, 会L14(e)' },
    { ja : '作家|さっか', en : 'writer', l : '会L11' },
    { ja : 'サッカー', en : 'soccer', l : '会L10' },
    { ja : '雑誌|ざっし', en : 'magazine', l : '会L3' },
    { ja : '砂糖|さとう', en : 'sugar', l : '会L16' },
    { ja : '茶道|さどう', en : 'tea ceremony; Way of Tea', l : '会L9(c)' },
    { ja : '寂しい|さびしい', en : 'lonely', l : '会L9' },
    { ja : '座布団|ざぶとん', en : 'cushion (flat one used when sitting or kneeling)', l : '読L1-I' },
    { ja : '差別|さべつ', en : 'discrimination', l : '読L12-漢字表' },
    { ja : 'サボる', en : 'to cut (classes)', v : 'u', l : '会L11' },
    { ja : '～様|～さま', en : 'Mr./Ms....', l : '読L5-II' },
    { ja : '寒い|さむい', en : 'cold (weather)', l : '会L5' },
    { ja : '左右|さゆう', en : 'right and left', l : '読L6-漢字表' },
    { ja : 'さようなら', en : 'Good-bye.', l : '会G' },
    { ja : '皿|さら', en : 'plate; dish', l : '会L14' },
    { ja : '再来月|さらいげつ', en : 'the month after next', l : '会L4(e)' },
    { ja : '再来週|さらいしゅう', en : 'the week after next', l : '会L4(e)' },
    { ja : '再来年|さらいねん', en : 'the year after next', l : '会L4(e)' },
    { ja : 'サラダ', en : 'salad', l : '読L2-I' },
    { ja : 'サラリーマン', en : 'salaryman; company employee', l : '会L17' },
    { ja : '猿|さる', en : 'monkey', l : '会L22' },
    { ja : '去る|さる', en : 'to leave', v : 'u', l : '読L14-漢字表' },
    { ja : '触る|さわる', en : 'to touch', v : 'u', l : '会L21' },
    { ja : '三|さん', en : 'three', l : '読L3-漢字表' },
    { ja : '～さん', en : 'Mr./Ms....', l : '会L1' },
    { ja : '参加する|さんかする', en : 'to participate', v : 'irr', l : '会L15' },
    { ja : '三月|さんがつ', en : 'March', l : '会L4(e)' },
    { ja : '残業|ざんぎょう', en : 'overtime work', l : '読L8-II, 会L17' },
    { ja : '産業|さんぎょう', en : 'industry', l : '読L18-漢字表' },
    { ja : 'サンキュー', en : 'thank you', l : '読L14-II' },
    { ja : '参考|さんこう', en : 'reference', l : '読L16-漢字表' },
    { ja : '三歳|さんさい', en : 'three years old', l : '会L1(e)' },
    { ja : '三時|さんじ', en : "three o'clock", l : '会L1(e)' },
    { ja : '三時半|さんじはん', en : 'half past three', l : '読L4-漢字表' },
    { ja : '三十分|さんじ(ゅ)っぷん', en : 'thirty minutes', l : '会L1(e)' },
    { ja : '三十度|さんじゅうど', en : 'thirty degrees', l : '読L12-漢字表' },
    { ja : '三世|さんせい', en : 'the third generation', l : '読L16-漢字表' },
    { ja : '賛成する|さんせいする', en : 'to agree', v : 'irr', l : '会L22' },
    { ja : '三千|さんぜん', en : 'three thousand', l : '読L3-漢字表' },
    { ja : '残高|ざんだか', en : 'account balance', l : '読L22-漢字表' },
    { ja : '残高照会|ざんだかしょうかい', en : 'balance inquiry', l : '会L13(e)' },
    { ja : 'サンドイッチ', en : 'sandwich', l : '読L2-I' },
    { ja : '残念|ざんねん', en : 'regrettable', l : '読L22-漢字表' },
    { ja : '残念ですね|ざんねんですね', en : "That's too bad.", l : '会L8' },
    { ja : '三年生|さんねんせい', en : 'third-year student', l : '読L3-漢字表' },
    { ja : '三百|さんびゃく', en : 'three hundred', l : '読L3-漢字表' },
    { ja : '産婦人科医|さんふじんかい', en : 'obstetrician and gynecologist', l : '会L12(e)' },
    { ja : '三分|さんぷん', en : 'three minutes', l : '会L1(e)' },
    { ja : '散歩する|さんぽする', en : 'to take a walk', v : 'irr', l : '会L9' },
    { ja : '三両|さんりょう', en : 'three ryoo', l : '読L20-漢字表' }
  ],
  
  'し' : [
    { ja : '詩|し', en : 'poem', l : '読L17-II' },
    { ja : '死|し', en : 'death', l : '読L15-漢字表' },
    { ja : '字|じ', en : 'letter; character', l : '会L20' },
    { ja : '～時|～じ', en : "o'clock", l : '会L1' },
    { ja : '試合|しあい', en : 'match; game', l : '会L12' },
    { ja : '幸せ|しあわせ（な）', en : 'happiness; good fortune; luck', l : '読L10-II, 会L13' },
    { ja : '寺院|じいん', en : 'sacred building', l : '読L15-漢字表' },
    { ja : 'シーザー', en : 'Caesar', l : 'ワークブック読L2' },
    { ja : 'シーディー', en : 'CD', l : '会L6' },
    { ja : 'ジーンズ', en : 'jeans', l : '会L2' },
    { ja : 'シェークスピア', en : 'Shakespeare', l : 'ワークブック読L2' },
    { ja : 'シェパード', en : 'shepherd', l : 'ワークブック読L2' },
    { ja : 'シェフ', en : 'chef', l : '読L6-III' },
    { ja : '鹿|しか', en : 'deer', l : '読L15-II' },
    { ja : '歯科医|しかい', en : 'dentist', l : '会L12(e)' },
    { ja : '視界|しかい', en : 'visibility', l : '読L16-漢字表' },
    { ja : '司会|しかい', en : 'chairman; host; master of ceremonies', l : 'ワークブックL19' },
    { ja : '次回|じかい', en : 'next time', l : '読L8-漢字表' },
    { ja : '仕返し|しかえし', en : 'revenge', l : '読L8-漢字表' },
    { ja : 'しかし', en : 'however', l : '読L17-II' },
    { ja : 'しかたがない', en : 'cannot be helped', l : '読L22-II' },
    { ja : '四月|しがつ', en : 'April', l : '会L4(e)' },
    { ja : '時間|じかん', en : 'time', l : '会L14' },
    { ja : '～時間|～じかん', en : '...hours', l : '会L4' },
    { ja : '時間通り|じかんとおり', en : 'on time', l : '読L13-III' },
    { ja : '時給|じきゅう', en : 'hourly wage', l : '読L18-II' },
    { ja : '試験|しけん', en : 'exam', l : '会L9' },
    { ja : '仕事|しごと', en : 'job; work; occupation', l : '会L1, 会L8' },
    { ja : '死者|ししゃ', en : 'the dead', l : '読L15-漢字表' },
    { ja : '辞書|じしょ', en : 'dictionary', l : '会L2, 会L2(e)' },
    { ja : '次女|じじょ', en : 'second daughter', l : '読L8-漢字表' },
    { ja : '地震|じしん', en : 'earthquake', l : '会L15' },
    { ja : '自信|じしん', en : 'confidence', l : '読L21-漢字表' },
    { ja : '静岡|しずおか', en : 'Shizuoka (city)', l : 'ワークブックL19' },
    { ja : '静か|しずか（な）', en : 'quiet', l : '会L5' },
    { ja : '自然|しぜん', en : 'nature', l : '読L15-II' },
    { ja : 'じぞう', en : 'guardian deity of children', l : '読L10-II' },
    { ja : '下|した', en : 'under', l : '会L4' },
    { ja : '時代|じだい', en : 'age; era', l : '読L14-II' },
    { ja : '親しい|したしい', en : 'close; intimate', l : '読L18-III' },
    { ja : '七|(しち/なな)', en : 'seven', l : '読L3-漢字表' },
    { ja : '七月|しちがつ', en : 'July', l : '会L4(e)' },
    { ja : '七時|しちじ', en : "seven o'clock", l : '会L1(e)' },
    { ja : '質屋|しちや', en : 'pawn shop', l : '読L19-漢字表' },
    { ja : 'シチュー', en : 'stew', l : 'ワークブック読L2' },
    { ja : '市長|しちょう', en : 'mayor', l : '読L11-漢字表' },
    { ja : '質がいい|しつがいい', en : 'good quality', l : '読L19-漢字表' },
    { ja : '実験|じっけん', en : 'experiment', l : '読L18-漢字表' },
    { ja : '十歳|じ(ゅ)っさい', en : 'ten years old', l : '会L1(e)' },
    { ja : '知っています|しっています', en : 'I know', l : '会L7' },
    { ja : '実は|じつは', en : 'as a matter of fact,...', l : '会L13' },
    { ja : '失敗する|しっぱいする', en : 'to fail; to be unsuccessful', v : 'irr', l : '会L22' },
    { ja : '十分|じ(ゅ)っぷん', en : 'ten minutes', l : '会L1(e)' },
    { ja : '質問|しつもん', en : 'question', l : '会L11(e), 読L19-III' },
    { ja : '失礼しました|しつれいしました', en : "I'm very sorry.", l : '会L20' },
    { ja : '失礼します|しつれいします', en : 'Excuse me.; Sorry to interrupt you.', l : '会L16' },
    { ja : '指定席|していせき', en : 'reserved seat', l : '会L10(e)' },
    { ja : '私鉄|してつ', en : 'private railroad', l : '読L5-漢字表' },
    { ja : '支店|してん', en : 'branch office', l : '会L20' },
    { ja : '自転車|じてんしゃ', en : 'bicycle', l : '会L2' },
    { ja : '自動|じどう', en : 'automatic', l : '読L13-III' },
    { ja : '自動車|じどうしゃ', en : 'automobile', l : '読L10-漢字表' },
    { ja : '自動販売機|じどうはんばいき', en : 'vending machine', l : '読L10-漢字表' },
    { ja : 'シドニー', en : 'Sidney; Sydney (Australia)', l : '会L1' },
    { ja : '品物|しなもの', en : 'merchandise article', l : '読L17-漢字表' },
    { ja : '死ぬ|しぬ', en : 'to die', v : 'u', l : '会L6' },
    { ja : '始発|しはつ', en : 'first train', l : '読L16-漢字表' },
    { ja : '次発|じはつ', en : 'departing second', l : '会L10(e)' },
    { ja : '支払い|しはらい', en : 'payment', l : '読L20-漢字表' },
    { ja : '耳鼻科医|じびかい', en : 'otorhinolaryngologist; ENT doctor', l : '会L12(e)' },
    { ja : '自分|じぶん', en : 'oneself', l : '読L10-II, 会L17' },
    { ja : '自分で|じぶんで', en : '(do something) by oneself', l : '会L16' },
    { ja : '島|しま', en : 'island', l : '読L15-II' },
    { ja : '姉妹|しまい', en : 'sisters', l : '読L19-漢字表' },
    { ja : '姉妹校|しまいこう', en : 'sister school', l : '読L21-漢字表' },
    { ja : '姉妹都市|しまいとし', en : 'sister city', l : '読L19-漢字表' },
    { ja : '閉まる|しまる', en : '(something) closes', v : 'u', l : '会L18' },
    { ja : '市民病院|しみんびょういん', en : 'municipal hospital', l : '会L6' },
    { ja : '氏名|しめい', en : 'full name', l : '読L9-漢字表' },
    { ja : '締め切り|しめきり', en : 'deadline', l : '会L11(e), 会L15' },
    { ja : '閉める|しめる', en : 'to close (something)', v : 'ru', l : '会L6' },
    { ja : '地元|じもと', en : 'local', l : '読L5-漢字表' },
    { ja : 'じゃあ', en : 'then...; if that is the case,...', l : '会L2' },
    { ja : 'ジャズ', en : 'jazz (music)', l : '会L5' },
    { ja : 'ジャーナリスト', en : 'journalist', l : '会L11' },
    { ja : '社会|しゃかい', en : 'society', l : '会L23' },
    { ja : '社会的|しゃかいてき', en : 'social', l : '読L18-漢字表' },
    { ja : 'じゃがいも', en : 'potato', l : '会L8(e)' },
    { ja : '市役所|しやくしょ', en : 'city hall', l : '読L11-漢字表' },
    { ja : '借地|しゃくち', en : 'rented land', l : '読L15-漢字表' },
    { ja : '借家|しゃくや', en : 'rented house', l : '読L15-漢字表' },
    { ja : 'ジャケット', en : 'jacket', l : '会L15' },
    { ja : '写真|しゃしん', en : 'picture; photograph', l : '会L4' },
    { ja : '写生|しゃせい', en : 'sketch', l : '読L17-漢字表' },
    { ja : '社長|しゃちょう', en : 'president of a company', l : '会L11' },
    { ja : 'シャツ', en : 'shirt', l : '会L10' },
    { ja : '借金|しゃっきん', en : 'debt', l : '読L15-漢字表' },
    { ja : 'しゃべる', en : 'to chat', v : 'u', l : '会L15' },
    { ja : 'シャワー', en : 'shower', l : '会L6' },
    { ja : 'シャワーを浴びる|シャワーをあびる', en : 'to take a shower', v : 'ru', l : '会L6' },
    { ja : 'シャンプー', en : 'shampoo', l : '会L17(e), 会L18' },
    { ja : '自由|じゆう', en : 'freedom', l : '会L22' },
    { ja : '十一月|じゅういちがつ', en : 'November', l : '会L4(e)' },
    { ja : '十一時|じゅういちじ', en : "eleven o'clock", l : '会L1(e)' },
    { ja : '十一日|じゅういちにち', en : 'the eleventh day of a month', l : '会L4(e)' },
    { ja : '十一歳|じゅういっさい', en : 'eleven years old', l : '会L1(e)' },
    { ja : '十一分|じゅういっぷん', en : 'eleven minutes', l : '会L1(e)' },
    { ja : '十月|じゅうがつ', en : 'October', l : '会L4(e)' },
    { ja : '就活|しゅうかつ', en : 'job hunting; abbr. of 就職活動', l : '会L22(c)' },
    { ja : '習慣|しゅうかん', en : 'habit; custom', l : '会L15' },
    { ja : '～週間|～しゅうかん', en : 'for...weeks', l : '会L10' },
    { ja : '十九分|じゅうきゅうふん', en : 'nineteen minutes', l : '会L1(e)' },
    { ja : '十五分|じゅうごふん', en : 'fifteen minutes', l : '会L1(e)' },
    { ja : '十三分|じゅうさんぷん', en : 'thirteen minutes', l : '会L1(e)' },
    { ja : '十時|じゅうじ', en : "ten o'clock", l : '会L1(e)' },
    { ja : '住所|じゅうしょ', en : 'address', l : '読L10-漢字表' },
    { ja : '就職活動|しゅうしょくかつどう', en : 'job hunting', l : '会L22(c)' },
    { ja : '就職する|しゅうしょくする', en : 'to get a full-time job (at...)', v : 'irr', l : '会L17' },
    { ja : '習字|しゅうじ', en : 'calligraphy', l : '読L17-漢字表' },
    { ja : '囚人|しゅうじん', en : 'prisoner', l : '読L1-I' },
    { ja : 'ジュース', en : 'juice', l : '会L12' },
    { ja : '自由席|じゆうせき', en : 'general administration seat', l : '会L10(e)' },
    { ja : '十代|じゅうだい', en : "in one's teens", l : '読L14-漢字表' },
    { ja : '集中する|しゅうちゅうする', en : 'to concentrate', v : 'irr', l : '読L17-漢字表' },
    { ja : '銃で撃たれる|じゅうでうたれる', en : 'to be shot', l : '読L17-II' },
    { ja : '終点|しゅうてん', en : 'last stop', l : '読L18-漢字表' },
    { ja : '終電|しゅうでん', en : 'last train', l : '会L10(e), 会L21' },
    { ja : '柔道|じゅうどう', en : 'judo', l : '読L10-漢字表' },
    { ja : '十七分|じゅうななふん', en : 'seventeen minutes', l : '会L1(e)' },
    { ja : '収入|しゅうにゅう', en : 'income', l : '読L18-II' },
    { ja : '自由に|じゆうに', en : 'freely', l : '会L22' },
    { ja : '十二月|じゅうにがつ', en : 'December', l : '会L4(e)' },
    { ja : '十二時|じゅうにじ', en : "twelve o'clock", l : '会L1(e)' },
    { ja : '十二分|じゅうにふん', en : 'twelve minutes', l : '会L1(e)' },
    { ja : '十八分|じゅうは(ちふ/っぷ)ん', en : 'eighteen minutes', l : '会L1(e)' },
    { ja : '重病|じゅうびょう', en : 'serious illness', l : '読L11-漢字表' },
    { ja : '秋分|しゅうぶん', en : 'autumnal equinox', l : '読L19-漢字表' },
    { ja : '週末|しゅうまつ', en : 'weekend', l : '会L3' },
    { ja : '十万|じゅうまん', en : 'one hundred thousand', l : '読L3-漢字表' },
    { ja : '十四日|じゅうよっか', en : 'the fourteenth day of a month', l : '会L4(e)' },
    { ja : '十四分|じゅうよんぷん', en : 'fourteen minutes', l : '会L1(e)' },
    { ja : '十六分|じゅうろっぷん', en : 'sixteen minutes', l : '会L1(e)' },
    { ja : '守衛|しゅえい', en : 'security guard', l : '読L22-漢字表' },
    { ja : '授業|じゅぎょう', en : 'class', l : '会L11' },
    { ja : '授業中に|じゅぎょうちゅうに', en : 'in class; during the class', l : '会L16' },
    { ja : '授業料|じゅぎょうりょう', en : 'tuition', l : '会L23' },
    { ja : '塾|じゅく', en : 'cram school', l : '読L7-II, 会L22' },
    { ja : '宿題|しゅくだい', en : 'homework', l : '会L5, 会L11(e)' },
    { ja : '宿泊|しゅくはく', en : 'lodging', l : '読L18-漢字表' },
    { ja : '受験|じゅけん', en : 'taking examination', l : '読L18-漢字表' },
    { ja : '主語|しゅご', en : 'subject of a sentence', l : '読L17-漢字表' },
    { ja : '手術|しゅじゅつ', en : 'operation', l : '会L12(e)' },
    { ja : '首相|しゅしょう', en : 'prime minister', l : '会L17' },
    { ja : '主人|しゅじん', en : 'owner', l : '読L20-II' },
    { ja : '出身|しゅっしん', en : 'coming from', l : '会L11' },
    { ja : '出席|しゅっせき', en : 'attendance', l : '読L6-漢字表' },
    { ja : '出張|しゅっちょう', en : 'business trip', l : '読L14-II, 会L19' },
    { ja : '出発|しゅっぱつ', en : 'departure', l : '読L17-漢字表' },
    { ja : '主夫|しゅふ', en : 'house-husband; stay-at-home dad', l : '読L17-II' },
    { ja : '主婦|しゅふ', en : 'housewife; homemaker', l : '会L1' },
    { ja : '趣味|しゅみ', en : 'hobby; pastime', l : '読L11-II, 会L20' },
    { ja : '種類|しゅるい', en : 'a kind; a sort', l : '会L19' },
    { ja : '手話|しゅわ', en : 'sign language', l : '読L11-漢字表' },
    { ja : '春夏秋冬|しゅんかしゅうとう', en : 'four seasons; spring, summer, autumn, and winter', l : '読L19-漢字表' },
    { ja : '順番|じゅんばん', en : 'turn; order', l : '読L22-漢字表' },
    { ja : '準備|じゅんび', en : 'preparation', l : '会L21' },
    { ja : '春分|しゅんぶん', en : 'vernal equinox', l : '読L19-漢字表' },
    { ja : '紹介する|しょうかいする', en : 'to introduce', v : 'irr', l : '会L11' },
    { ja : '奨学金|しょうがくきん', en : 'scholarship', l : '会L16' },
    { ja : '小学生|しょうがくせい', en : 'elementary school students', l : '読L16-II' },
    { ja : '正月|しょうがつ', en : "New Year's", l : '読L10-II, 会L11' },
    { ja : '小学校|しょうがっこう', en : 'elementary school', l : '会L23' },
    { ja : '消去する|しょうきょする', en : 'to erase', v : 'irr', l : '読L14-漢字表' },
    { ja : '上京する|じょうきょうする', en : 'to go to the capital', v : 'irr', l : '読L7-漢字表' },
    { ja : 'しょうぎ', en : 'Japanese chess', l : '読L19-II' },
    { ja : '正午|しょうご', en : 'noon', l : '読L9-漢字表' },
    { ja : '乗車|じょうしゃ', en : 'riding a car', l : '読L14-漢字表' },
    { ja : '乗車券|じょうしゃけん', en : '(boarding) ticket', l : '会L10(e)' },
    { ja : '少女|しょうじょ', en : 'girl', l : '読L9-漢字表' },
    { ja : '少々|しょうしょう', en : 'a few seconds; a little', l : '読L9-漢字表, 会L20' },
    { ja : '上手|じょうず（な）', en : 'skillful; good at...', l : '会L8' },
    { ja : '小説|しょうせつ', en : 'novel', l : '会L20' },
    { ja : '小説家|しょうせつか', en : 'novelist', l : '読L22-漢字表' },
    { ja : '招待|しょうたい', en : 'invitation', l : '読L22-漢字表' },
    { ja : '招待する|しょうたいする', en : 'to invite someone (to an event/a place)', v : 'irr', l : '会L19' },
    { ja : '冗談|じょうだん', en : 'joke', l : '読L23-II' },
    { ja : '使用中|しようちゅう', en : '"Occupied"', l : '読L12-漢字表' },
    { ja : '少年|しょうねん', en : 'boy', l : '読L9-漢字表' },
    { ja : '乗馬|じょうば', en : 'horseback riding', l : '読L14-漢字表' },
    { ja : '上品な|じょうひんな', en : 'elegant', l : '読L17-漢字表' },
    { ja : '情報|じょうほう', en : 'information', l : '読L23-漢字表' },
    { ja : '消防士|しょうぼうし', en : 'firefighter', l : '会L11' },
    { ja : 'しょう油|しょうゆ', en : 'soy sauce', l : '会L18' },
    { ja : '将来|しょうらい', en : 'future', l : '会L11' },
    { ja : '初夏|しょか', en : 'early summer', l : '読L15-漢字表' },
    { ja : '職業|しょくぎょう', en : 'occupation', l : '読L18-漢字表' },
    { ja : '食事|しょくじ', en : 'meal', l : '読L21-II' },
    { ja : '食事付|しょくじつき', en : 'with meals', l : '会L15(e)' },
    { ja : '食堂|しょくどう', en : 'cafeteria; dining commons', l : '会L7' },
    { ja : '食費|しょくひ', en : 'food cost', l : '読L18-III' },
    { ja : '女子学生|じょしがくせい', en : 'female student', l : '読L18-II' },
    { ja : '所持品|しょじひん', en : 'belongings', l : '読L10-漢字表' },
    { ja : '女性|じょせい', en : 'woman', l : '読L5-漢字表' },
    { ja : 'ジョギング', en : 'jogging', l : 'ワークブックL23' },
    { ja : 'ショック', en : 'shock (psychological, physical, circulatory, etc.)', l : 'ワークブック読L2' },
    { ja : 'ショッピングモール', en : 'shopping mall', l : '会L17' },
    { ja : '書店|しょてん', en : 'book store', l : '読L14-漢字表' },
    { ja : '書道|しょどう', en : 'calligraphy', l : '読L10-漢字表' },
    { ja : '女優|じょゆう', en : 'actress', l : '会L11' },
    { ja : '書類|しょるい', en : 'document', l : '会L22' },
    { ja : '調べる|しらべる', en : 'to examine; to look into (a matter)', v : 'ru', l : '会L15' },
    { ja : 'しり', en : 'buttocks', l : '会L7(e)' },
    { ja : '知り合い|しりあい', en : 'acquaintance', l : '読L9-漢字表' },
    { ja : '知り合う|しりあう', en : 'to get acquainted with', v : 'u', l : '会L19' },
    { ja : '私立高校|しりつこうこう', en : 'private high school', l : '読L10-漢字表' },
    { ja : '私立大学|しりつだいがく', en : 'private university', l : '読L5-漢字表' },
    { ja : '知りません|しりません', en : 'I do not know', l : '会L7' },
    { ja : '知る|しる', en : 'to know', v : 'u', l : '会L7' },
    { ja : 'シルバー', en : 'silver', l : '会L9(e)' },
    { ja : '城|しろ', en : 'castle', l : '読L5-II' },
    { ja : '白|しろ', en : 'white color', l : '読L9-漢字表' },
    { ja : '白い|しろい', en : 'white', l : '会L9, 会L9(e)' },
    { ja : '白黒|しろくろ', en : 'black and white', l : '会L9(e)' },
    { ja : '白黒写真|しろくろしゃしん', en : 'black and white photograph', l : '読L22-漢字表' },
    { ja : 'じろじろ見る|じろじろみる', en : 'to stare (at)', v : 'ru', l : '会L8' },
    { ja : '～人|～じん', en : '...people', l : '会L1' },
    { ja : '新幹線|しんかんせん', en : 'Bullet Train', l : '会L10' },
    { ja : 'シンガポール', en : 'Singapore', l : '読L2-I' },
    { ja : 'シングル', en : 'single room', l : '会L15(e)' },
    { ja : '神経質|しんけいしつ', en : 'over sensitive', l : '読L21-漢字表' },
    { ja : '信号|しんごう', en : 'traffic light', l : '会L6(e), 会L20' },
    { ja : '人口|じんこう', en : 'population', l : '読L6-漢字表' },
    { ja : '新婚|しんこん', en : 'newlywed', l : '読L17-漢字表' },
    { ja : '審査|しんさ', en : 'screening', l : '読L23-漢字表' },
    { ja : '神社|じんじゃ', en : 'shrine', l : '会L11' },
    { ja : '信じる|しんじる', en : 'to believe', v : 'ru', l : '読L21-II' },
    { ja : '親せき|しんせき', en : 'relatives', l : '会L16' },
    { ja : '新雪|しんせつ', en : 'new snow', l : '読L10-漢字表' },
    { ja : '親切|しんせつ（な）', en : 'kind', l : '会L7' },
    { ja : '新鮮|しんせん（な）', en : 'fresh', l : '読L8-漢字表' },
    { ja : '神道|しんとう', en : 'Shinto religion', l : '読L12-漢字表' },
    { ja : '新年|しんねん', en : 'New Year', l : 'ワークブックL15' },
    { ja : '新年の抱負|しんねんのほうふ', en : "New Year's Resolution", l : 'ワークブックL15' },
    { ja : '心配|しんぱい（な）', en : 'worried about', l : '読L21-II, 会L22' },
    { ja : '心配する|しんぱいする', en : 'to worry', v : 'irr', l : '会L12' },
    { ja : '新聞|しんぶん', en : 'newspaper', l : '会L2' },
    { ja : '進歩|しんぽ', en : 'progress', l : '読L17-漢字表' },
    { ja : '親友|しんゆう', en : 'best friend', l : '読L22-II' },
    { ja : '心理|しんり', en : 'state of mind; mentality; psychology', l : 'ワークブック読L1' },
    { ja : '人類学|じんるいがく', en : 'anthropology', l : '会L1' }
  ],
  
  'す' : [
    { ja : '図|ず', en : 'figure', l : '読L18-漢字表' },
    { ja : '水泳|すいえい', en : 'swimming', l : '読L4-漢字表' },
    { ja : 'すいか', en : 'watermelon', l : '会L8(e)' },
    { ja : '推薦状|すいせんじょう', en : 'letter of recommendation', l : '会L16' },
    { ja : '水族館|すいぞくかん', en : 'aquarium', l : '読L14-漢字表' },
    { ja : 'スイッチ', en : 'switch', l : '会L18' },
    { ja : '水道|すいどう', en : 'water supply', l : '読L4-漢字表' },
    { ja : 'ずいぶん', en : 'very', l : '会L17' },
    { ja : '水曜日|すいようび', en : 'Wednesday', l : '会L4, 会L4(e)' },
    { ja : 'スイス', en : 'Switzerland', l : 'ワークブックL13' },
    { ja : 'スウェーデン', en : 'Sweden', l : '会L1' },
    { ja : 'スーツ', en : 'suit (clothing, playing cards)', l : 'ワークブック読L2' },
    { ja : 'スーツケース', en : 'suitcase', l : '読L13-III' },
    { ja : 'スーパー', en : 'supermarket', l : '会L4' },
    { ja : 'スープ', en : 'soup', l : '会L18' },
    { ja : '数字|すうじ', en : 'numbers; numeral; figure; digit', l : '会L1' },
    { ja : '末|すえ', en : 'the end', l : '読L22-漢字表' },
    { ja : 'スカート', en : 'skirt', l : '会L18' },
    { ja : '好き|すき（な）', en : 'fond of; to like', l : '会L5' },
    { ja : 'すき焼き|すきやき', en : 'sukiyaki; thin slices of beef, cooked with various vegetables in a table-top cast-iron pan', l : 'ワークブックL2' },
    { ja : 'スキー', en : 'ski', l : '会L9' },
    { ja : 'すぐ', en : 'right away', l : '会L6' },
    { ja : '少ない|すくない', en : 'a little; a few', l : '会L17' },
    { ja : 'スクランブル交差点|スクランブルこうさてん', en : 'scramble crossing', l : '読L15-II' },
    { ja : 'スクリーン', en : 'screen', l : 'ワークブックL18' },
    { ja : 'スケジュール', en : 'schedule', l : 'ワークブックL3' },
    { ja : 'すごい', en : 'incredible; awesome', l : '会L13' },
    { ja : 'すごく', en : 'extremely', l : '会L5' },
    { ja : '少し|すこし', en : 'a little', l : '読L7-II, 会L21' },
    { ja : 'すし', en : 'sushi', l : '会L10' },
    { ja : '鈴|すず', en : 'bell', l : '会L21(c)' },
    { ja : '涼しい|すずしい', en : 'cool (weather)', l : '会L10' },
    { ja : '頭痛|ずつう', en : 'headache', l : '読L20-漢字表' },
    { ja : 'ずっと', en : 'for a long time; all the time', l : '会L22' },
    { ja : 'すっぽん', en : 'snapping turtle; terrapin', l : '読L13-II' },
    { ja : '素敵|すてき（な）', en : 'nice', l : '会L12' },
    { ja : '捨てる|すてる', en : 'to throw away', v : 'ru', l : '会L8' },
    { ja : 'ステーキ', en : 'steak', l : '読L2-I' },
    { ja : 'ストックホルム', en : 'Stockholm (Sweden)', l : '会L1, 読L2-I' },
    { ja : 'ストレス', en : 'stress', l : '読L8-II' },
    { ja : 'スニーカー', en : 'sneakers', l : '会L20' },
    { ja : 'スパゲッティ', en : 'spaghetti', l : '読L2-I' },
    { ja : 'スピーチ', en : 'speech', l : '会L21' },
    { ja : 'スプーン', en : 'spoon', l : '会L17' },
    { ja : 'スペイン', en : 'Spain', l : '読L2-I' },
    { ja : '全て|すべて', en : 'all', l : '読L16-漢字表' },
    { ja : 'スポーツ', en : 'sports', l : '会L3' },
    { ja : 'スマホ', en : 'smartphone; smart phone; mobile', l : '会L2' },
    { ja : 'すみません', en : "Excuse me.; I'm sorry.", l : '会G' },
    { ja : '住む|すむ', en : 'to live', v : 'u', l : '会L7' },
    { ja : '相撲|すもう', en : 'sumo wrestling', l : '会L9(c)' },
    { ja : 'スリランカ', en : 'Sri Lanka', l : '会L13' },
    { ja : 'する', en : 'to do; to decide on (an item); to wear small items (necktie, watch, etc.); to cost', v : 'irr', l : '会L3, 会L15, 会L17, 読L20-II' },
    { ja : 'すると', en : '...Then,...', l : '読L16-II' },
    { ja : '座る|すわる', en : 'to sit down', v : 'u', l : '会L6' }
  ],
  
  'せ' : [
    { ja : '正解|せいかい', en : 'correct answer', l : '読L10-漢字表' },
    { ja : '政界|せいかい', en : 'political world', l : '読L16-漢字表' },
    { ja : '性格|せいかく', en : 'personality', l : '会L19' },
    { ja : '生活|せいかつ', en : 'life; living', l : '会L10' },
    { ja : '生活する|せいかつする', en : 'to lead a life', v : 'irr', l : '会L20' },
    { ja : '生活のゆとり|せいかつのゆとり', en : 'extra money to spare for the cost of living', l : '読L18-II' },
    { ja : '生活費|せいかつひ', en : 'the cost of living', l : '読L18-II' },
    { ja : '世紀|せいき', en : 'century', l : '読L1-I' },
    { ja : '税金|ぜいきん', en : 'tax', l : '会L15' },
    { ja : '整形外科医|せいけいげかい', en : 'orthopedic surgeon', l : '会L12(e)' },
    { ja : '政治|せいじ', en : 'politics', l : '会L1, 会L12' },
    { ja : '青春|せいしゅん', en : 'youth', l : '読L19-漢字表' },
    { ja : '成績|せいせき', en : 'grade (on a test, etc.)', l : '会L12' },
    { ja : 'ぜいたくをする', en : 'to indulge in luxury', v : 'irr', l : '読L21-II' },
    { ja : '正答|せいとう', en : 'correct answer', l : '読L23-漢字表' },
    { ja : '青年|せいねん', en : 'youth; young man', l : '読L12-漢字表' },
    { ja : '政府|せいふ', en : 'government', l : '会L21' },
    { ja : '制服|せいふく', en : 'uniform', l : '読L18-漢字表' },
    { ja : '生物学|せいぶつがく', en : 'biology', l : '会L1' },
    { ja : 'セーター', en : 'sweater', l : '会L13' },
    { ja : '声優|せいゆう', en : 'voice actor', l : '読L20-漢字表' },
    { ja : '西洋|せいよう', en : 'the West', l : '読L6-漢字表' },
    { ja : '世界|せかい', en : 'world', l : '会L10' },
    { ja : '世界中|せかいじゅう', en : 'all over the world', l : '読L23-II' },
    { ja : '背が高い|せがたかい', en : 'tall (stature)', l : '会L7' },
    { ja : '背が低い|せがひくい', en : 'short (stature)', l : '会L7' },
    { ja : '席|せき', en : 'seat', l : '読L1-I' },
    { ja : 'せき', en : 'cough', l : '会L12' },
    { ja : 'せきが出る|せきがでる', en : 'to cough', v : 'ru', l : '会L12' },
    { ja : '赤十字|せきじゅうじ', en : 'the Red Cross', l : '読L12-漢字表' },
    { ja : '赤道|せきどう', en : 'the equator', l : '読L12-漢字表' },
    { ja : 'セクシー', en : 'sexy', l : 'ワークブックL7' },
    { ja : '世代|せだい', en : 'generation', l : '読L16-漢字表' },
    { ja : '説教する|せっきょうする', en : 'to preach', v : 'irr', l : '読L22-漢字表' },
    { ja : '絶対に|ぜったいに', en : 'definitely; no matter what', l : '読L20-II, 会L22' },
    { ja : 'セット', en : 'set', l : '会L17(e)' },
    { ja : '絶望|ぜつぼう', en : 'despair', l : '読L20-漢字表' },
    { ja : '説明|せつめい', en : 'explanation', l : '読L11-漢字表' },
    { ja : '説明する|せつめいする', en : 'to explain', v : 'irr', l : '会L16' },
    { ja : '絶滅|ぜつめつ', en : 'extinction', l : '読L20-漢字表' },
    { ja : '背中|せなか', en : 'back (body)', l : '会L7(e)' },
    { ja : '是非|ぜひ', en : 'by all means', l : '会L9' },
    { ja : '狭い|せまい', en : 'narrow; not spacious', l : '会L12' },
    { ja : 'ゼミ', en : 'seminar', l : '会L22(c)' },
    { ja : '世話|せわ', en : 'care', l : '読L16-漢字表' },
    { ja : '世話をする|せわをする', en : 'to take care of', v : 'irr', l : '会L23' },
    { ja : '全員|ぜんいん', en : 'all members', l : '読L23-II' },
    { ja : '千|せん', en : 'thousand', l : '読L3-漢字表' },
    { ja : '千円|せんえん', en : 'one thousand yen', l : '読L3-漢字表' },
    { ja : '洗顔|せんがん', en : "washing one's face", l : '読L23-漢字表' },
    { ja : '1960年代|せんきゅうひゃくろくじゅうねんだい', en : "the nineteen-sixties (1960's)", l : '読L17-II' },
    { ja : '選挙|せんきょ', en : 'election', l : '会L23' },
    { ja : '先月|せんげつ', en : 'last month', l : '会L4(e), 会L9' },
    { ja : '専攻|せんこう', en : 'major', l : '会L1' },
    { ja : '全国|ぜんこく', en : 'whole country', l : '読L16-漢字表' },
    { ja : '先週|せんしゅう', en : 'last week', l : '会L4, 会L4(e)' },
    { ja : '扇子|せんす', en : 'fan', l : '会L20' },
    { ja : '先生|せんせい', en : 'teacher; Professor...', l : '会L1' },
    { ja : '全然|ぜんぜん', en : 'not at all', l : '会L3' },
    { ja : '戦争|せんそう', en : 'war', l : '読L15-II' },
    { ja : '洗濯する|せんたくする', en : 'to do laundry', v : 'irr', l : '会L8' },
    { ja : '禅寺|ぜんでら', en : 'zen temple', l : '読L15-漢字表' },
    { ja : '先輩|せんぱい', en : 'senior member of a group', l : '読L14-II, 会L22' },
    { ja : '先発|せんぱつ', en : 'departing first', l : '会L10(e)' },
    { ja : '全部|ぜんぶ', en : 'all', l : '会L13' }
  ],
  
  'そ' : [
    { ja : '象|ぞう', en : 'elephant', l : '会L13' },
    { ja : 'そうか', en : 'I see. (casual)', l : '会L17' },
    { ja : '送金|そうきん', en : 'sending money', l : '読L21-漢字表' },
    { ja : '相互の|そうごの', en : 'mutual', l : '読L23-漢字表' },
    { ja : '捜査|そうさ', en : 'criminal investigation', l : '読L23-漢字表' },
    { ja : '掃除する|そうじする', en : 'to clean', v : 'irr', l : '会L8' },
    { ja : 'そうそう', en : 'You are right.', l : '会L23' },
    { ja : '相続する|そうぞくする', en : 'to inherit', v : 'irr', l : '読L20-漢字表' },
    { ja : 'そうだ！', en : 'I have an idea!', l : '読L20-II' },
    { ja : '相談|そうだん', en : 'consultation', l : '読L23-漢字表' },
    { ja : '相談する|そうだんする', en : 'to consult', v : 'irr', l : '会L14' },
    { ja : '早朝|そうちょう', en : 'early morning', l : '読L12-漢字表' },
    { ja : 'そうです', en : "That's right.", l : '会L1' },
    { ja : 'そうですか', en : 'I see.; Is that so?', l : '会L1' },
    { ja : 'そうですね', en : "That's right.; Let me see.", l : '会L3' },
    { ja : '送料|そうりょう', en : 'postage', l : '読L21-漢字表' },
    { ja : 'ソウル', en : 'Seoul', l : 'ワークブックL1' },
    { ja : '速達|そくたつ', en : 'special delivery', l : '会L5(e)' },
    { ja : 'そこ', en : 'there', l : '会L2' },
    { ja : '素質|そしつ', en : 'aptitude', l : '読L19-漢字表' },
    { ja : 'そして', en : 'and then', l : '読L9-II, 会L11' },
    { ja : '注ぐ|そそぐ', en : 'to pour', v : 'u', l : '読L15-漢字表' },
    { ja : '育てる|そだてる', en : 'to raise; to bring up', v : 'ru', l : '会L22' },
    { ja : '卒業式|そつぎょうしき', en : 'graduation ceremony', l : '会L15' },
    { ja : '卒業する|そつぎょうする', en : 'to graduate (from...)', v : 'irr', l : '会L15' },
    { ja : 'ソックス', en : 'socks', l : 'ワークブック読L2' },
    { ja : '外|そと', en : 'outside', l : '会L18' },
    { ja : '供える|そなえる', en : 'to offer; to sacrifice', v : 'ru', l : '読L16-漢字表' },
    { ja : 'ソニー', en : 'Sony', l : 'ワークブックL7' },
    { ja : 'その', en : 'that...', l : '会L2' },
    { ja : 'その後|そのご', en : 'after that', l : '読L17-II' },
    { ja : 'そば', en : 'soba; Japanese buckwheat noodle', l : '会L15' },
    { ja : '祖父|そふ', en : 'grandfather', l : '読L7-漢字表' },
    { ja : 'ソファ', en : 'sofa', l : '会L18' },
    { ja : 'ソフト', en : 'software', l : '会L23' },
    { ja : '祖母|そぼ', en : 'grandmother', l : '読L7-漢字表' },
    { ja : 'そめる', en : 'to dye', v : 'ru', l : '会L17(e)' },
    { ja : '空|そら', en : 'sky', l : '読L16-II' },
    { ja : 'そる', en : 'to shave', v : 'u', l : '会L17(e)' },
    { ja : 'それ', en : 'that one', l : '会L2' },
    { ja : 'それから', en : 'and then', l : '会L5' },
    { ja : 'それで', en : 'then; therefore', l : '会L19' },
    { ja : 'それでは', en : 'well then; if that is the case,...', l : '読L19-II, 会L20' },
    { ja : 'それに', en : 'moreover,...', l : '会L17' },
    { ja : 'そろえる', en : 'to make hair even; to trim', v : 'ru', l : '会L17(e)' },
    { ja : 'そろそろ', en : 'it is about time to...', l : '会L23' },
    { ja : 'そんな～', en : 'such...; that kind of...', l : '読L16-II, 会L23' },
    { ja : 'そんなこと(は)ない', en : "I don't think so.", l : '会L22' }
  ],
  
  'た' : [
    { ja : '鯛|たい', en : 'sea bream; snapper', l : '会L18(c)' },
    { ja : 'タイ', en : 'Thailand', l : '読L2-I' },
    { ja : '題|だい', en : 'title', l : '読L18-漢字表' },
    { ja : '～代|～だい', en : 'charge; fee', l : '読L18-III' },
    { ja : '～台|～だい', en : 'counter for equipment', l : '会L14, 会L14(e)' },
    { ja : '第一印象|だいいちいんしょう', en : 'the first impression', l : '読L13-III' },
    { ja : 'ダイエットする', en : 'to go on a diet', v : 'irr', l : '会L11' },
    { ja : '体温計|たいおんけい', en : 'thermometer', l : '会L12(e)' },
    { ja : '第～課|だい～か', en : 'lesson...', l : '会L1' },
    { ja : '大学|だいがく', en : 'college; university', l : '会L1' },
    { ja : '大学院|だいがくいん', en : 'graduate school', l : '会L16' },
    { ja : '大学院生|だいがくいんせい', en : 'graduate student', l : '会L1' },
    { ja : '大学生|だいがくせい', en : 'college student', l : '会L1, 会L8' },
    { ja : '大学生活|だいがくせいかつ', en : 'college/university life', l : '会L22(c)' },
    { ja : '大学入試|だいがくにゅうし', en : 'university entrance examination', l : '会L22(c)' },
    { ja : '大嫌い|だいきらい（な）', en : 'to hate', l : '会L5' },
    { ja : '大工|だいく', en : 'carpenter', l : '読L19-漢字表' },
    { ja : '大国|たいこく', en : 'large country; major nation', l : '読L6-I' },
    { ja : '大使|たいし', en : 'ambassador', l : '読L12-漢字表' },
    { ja : '大使館|たいしかん', en : 'embassy', l : '読L6-漢字表' },
    { ja : '体重|たいじゅう', en : 'body weight', l : '読L13-漢字表' },
    { ja : '大丈夫|だいじょうぶ', en : "It's okay.; Not to worry.; Everything is under control.", l : '会L5' },
    { ja : '大好き|だいすき（な）', en : 'to love; very fond of', l : '会L5' },
    { ja : '大西洋|たいせいよう', en : 'the Atlantic', l : '読L18-漢字表' },
    { ja : '大切|たいせつ（な）', en : 'precious; valuable', l : '会L21' },
    { ja : '大切にする|たいせつにする', en : 'to take good care of', v : 'irr', l : '読L19-II' },
    { ja : '体操|たいそう', en : 'gymnastics; physical exercises', l : '読L13-漢字表' },
    { ja : '大卒|だいそつ', en : 'university graduate', l : '読L19-漢字表' },
    { ja : 'たいてい', en : 'usually', l : '会L3' },
    { ja : '態度|たいど', en : 'attitude', l : '読L12-漢字表' },
    { ja : '大統領|だいとうりょう', en : 'president of a country', l : '会L11' },
    { ja : '台所|だいどころ', en : 'kitchen', l : '読L11-漢字表' },
    { ja : '対比|たいひ', en : 'contrast', l : '読L23-漢字表' },
    { ja : '大ヒット|だいヒット', en : 'big hit', l : '読L17-II' },
    { ja : 'タイプ', en : 'type', l : '読L22-II' },
    { ja : '台風|たいふう', en : 'typhoon', l : '会L16' },
    { ja : 'たいへん', en : 'greatly', l : '読L19-II' },
    { ja : '大変|たいへん（な）', en : 'tough (situation)', l : '読L5-II, 会L6' },
    { ja : 'タイペイ', en : 'Taipei', l : 'ワークブックL1' },
    { ja : 'タイヤ', en : 'tire', l : '会L23' },
    { ja : '絶える|たえる', en : 'to die out', v : 'ru', l : '読L20-漢字表' },
    { ja : 'タオル', en : 'towel', l : '会L18' },
    { ja : '高い|たかい', en : 'expensive; high', l : '会L2' },
    { ja : 'だから', en : 'so; therefore', l : '会L4' },
    { ja : '宝くじ|たからくじ', en : 'lottery', l : '会L17' },
    { ja : '宝くじに当たる|たからくじにあたる', en : 'to win a lottery', v : 'u', l : '会L17' },
    { ja : '抱く|だく', en : "to hold something in one's arm", v : 'u', l : '読L20-II' },
    { ja : 'たくさん', en : 'many; a lot', l : '会L4' },
    { ja : 'タクシー', en : 'taxi', l : '読L13-III' },
    { ja : '宅配便|たくはいびん', en : 'home delivery service', l : '読L21-漢字表' },
    { ja : '竹|たけ', en : 'bamboo', l : '読L15-II' },
    { ja : '～だけ', en : 'just...; only...', l : '会L11' },
    { ja : '蛸|たこ', en : 'octopus', l : '会L18(c)' },
    { ja : 'タコス', en : 'taco', l : 'ワークブック読L2' },
    { ja : '出す|だす', en : 'to take (something) out; to hand in (something)', v : 'u', l : '会L16' },
    { ja : '多数決|たすうけつ', en : 'decision by majority', l : '読L19-漢字表' },
    { ja : '助かる|たすかる', en : 'to be saved; to be helped', v : 'u', l : '会L18' },
    { ja : '助け|たすけ', en : 'assistance; help; aid; support', l : 'ワークブック読L1' },
    { ja : '助ける|たすける', en : 'to help; to rescue', v : 'ru', l : '読L16-II, 会L22' },
    { ja : 'ただ', en : 'free of charge', l : '会L23' },
    { ja : 'ただいま', en : "I'm home.", l : '会G' },
    { ja : '正しい|ただしい', en : 'right', l : '読L10-漢字表' },
    { ja : 'ただの～', en : 'nothing more than...', l : '読L21-II' },
    { ja : '～たち', en : 'makes a noun plural', l : '会L14' },
    { ja : 'たつ', en : '(time) pass', v : 'u', l : '読L19-II' },
    { ja : '立つ|たつ', en : 'to stand up', v : 'u', l : '会L6' },
    { ja : '建つ|たつ', en : 'to be built', v : 'u', l : '読L15-漢字表' },
    { ja : '脱走|だっそう', en : 'escape from a prison', l : '読L15-漢字表' },
    { ja : '縦|たて', en : 'vertical', l : '読L23-II' },
    { ja : '建物|たてもの', en : 'building', l : '読L15-II' },
    { ja : '建てる|たてる', en : 'to build', v : 'ru', l : '読L15-漢字表' },
    { ja : '例えば|たとえば', en : 'for example', l : '会L11(e), 読L16-II, 会L17' },
    { ja : '七夕|たなばた', en : 'Tanabata; Star Festival', l : '読L22-漢字表' },
    { ja : '楽しい|たのしい', en : 'fun', l : '会L5' },
    { ja : '楽しそうに|たのしそうに', en : 'joyfully', l : '読L22-II' },
    { ja : '楽しみ|たのしみ', en : 'pleasure', l : '読L21-II' },
    { ja : '楽しみです|たのしみです', en : 'cannot wait; to look forward to it', l : '会L15' },
    { ja : '楽しみにする|たのしみにする', en : 'to look forward (to)', v : 'irr', l : '読L7-II' },
    { ja : '楽しむ|たのしむ', en : 'to enjoy', v : 'u', l : '読L15-II' },
    { ja : '頼む|たのむ', en : 'to ask (a favor)', v : 'u', l : '会L18' },
    { ja : 'たばこを吸う|たばこをすう', en : 'to smoke', v : 'u', l : '会L6' },
    { ja : 'ダブル', en : 'double room', l : '会L15(e)' },
    { ja : '多分|たぶん', en : 'probably; maybe', l : '会L12' },
    { ja : '食べ物|たべもの', en : 'food', l : '会L5' },
    { ja : '食べる|たべる', en : 'to eat', v : 'ru', l : '会L3' },
    { ja : '卵|たまご', en : 'egg; eggs; spawn; roe', l : '会L8(c)' },
    { ja : 'だます', en : 'to deceive', v : 'u', l : '読L20-II' },
    { ja : 'たまねぎ', en : 'onion', l : '会L8(e)' },
    { ja : 'だめ（な）', en : 'no good', l : '会L13' },
    { ja : 'ためる', en : 'to save money', v : 'ru', l : '会L21' },
    { ja : '足りる|たりる', en : 'to be sufficient; to be enough', v : 'ru', l : '会L17' },
    { ja : '誰|だれ', en : 'who', l : '会L2' },
    { ja : '～(ん)だろう', en : 'short form of ～(ん)でしょう', l : '会L18' },
    { ja : '探究|たんきゅう', en : 'inquiry', l : '読L19-漢字表' },
    { ja : '単語|たんご', en : 'word; vocabulary', l : '会L9' },
    { ja : '団子|だんご', en : 'dumpling', l : '読L1-I' },
    { ja : 'たんざく', en : 'strip of fancy paper', l : '読L12-II' },
    { ja : '男子学生|だんしがくせい', en : 'male student', l : '読L18-II' },
    { ja : '誕生日|たんじょうび', en : 'birthday', l : '会L5' },
    { ja : '男性|だんせい', en : 'man', l : '読L5-漢字表' },
    { ja : '暖冬|だんとう', en : 'warm winter', l : '読L19-漢字表' },
    { ja : '田んぼ|たんぼ', en : 'rice field', l : '読L5-漢字表' },
    { ja : '蒲公英|たんぽぽ', en : 'dandelion', l : '読L1-I' }
  ],
  
  'ち' : [
    { ja : '小さい|ちいさい', en : 'small', l : '会L5' },
    { ja : 'チーズ', en : 'cheese', l : 'ワークブック読L2' },
    { ja : 'チーム', en : 'team', l : '会L23' },
    { ja : 'チェコ', en : 'Czech Republic', l : '読L2-I' },
    { ja : 'チェック', en : 'check', l : 'ワークブック読L2' },
    { ja : 'チェックする', en : 'to check', l : '会L23' },
    { ja : 'チェックアウト(する)', en : 'checking out', v : 'irr', l : '会L15(e)' },
    { ja : 'チェックイン(する)', en : 'checking in', v : 'irr', l : '会L15(e)' },
    { ja : '地下|ちか', en : 'underground', l : '読L15-II' },
    { ja : '近い|ちかい', en : 'close; near', l : '会L13' },
    { ja : '違い|ちがい', en : 'difference', l : '会L17' },
    { ja : '違う|ちがう', en : 'to be different; wrong', v : 'u', l : '読L16-II, 会L23' },
    { ja : '近く|ちかく', en : 'near; nearby', l : '会L4' },
    { ja : '地下室|ちかしつ', en : 'basement', l : '読L16-漢字表' },
    { ja : '地下鉄|ちかてつ', en : 'subway', l : '会L10' },
    { ja : '力仕事|ちからしごと', en : 'physical labor such as construction', l : '読L18-III' },
    { ja : 'ちかん', en : 'sexual offender; groper; pervert', l : '会L21' },
    { ja : '地球|ちきゅう', en : 'earth; globe', l : '読L15-漢字表' },
    { ja : 'チケット', en : 'ticket', l : '会L14' },
    { ja : '遅刻する|ちこくする', en : 'to be late (for an appointment)', v : 'irr', l : '会L11' },
    { ja : '知人|ちじん', en : 'friend; acquaintance', l : '読L9-漢字表' },
    { ja : '地図|ちず', en : 'map', l : '会L15' },
    { ja : '父|ちち', en : '(my) father', l : '会L7' },
    { ja : '父親|ちちおや', en : 'father', l : '読L14-II' },
    { ja : 'チップ', en : 'tip; chip', l : '読L13-III' },
    { ja : '地名|ちめい', en : 'place name', l : '読L9-漢字表' },
    { ja : '茶|ちゃ', en : 'green tea', l : '会L3' },
    { ja : '茶色い|ちゃいろい', en : 'brown', l : '会L9(e)' },
    { ja : '茶店|ちゃみせ', en : 'teahouse', l : '読L20-II' },
    { ja : '～ちゃん', en : '[suffix for names of children]', l : '会L22' },
    { ja : '～中|～ちゅう', en : 'while...', l : '読L19-II' },
    { ja : '注意する|ちゅういする', en : 'to watch out; to give warning', v : 'irr', l : '読L15-II, 会L19' },
    { ja : '中華街|ちゅうかがい', en : 'Chinatown', l : '会L17' },
    { ja : '中学|ちゅうがく', en : 'junior high school (abbreviation)', l : '読L4-漢字表' },
    { ja : '中学生|ちゅうがくせい', en : 'junior high school student', l : '会L19' },
    { ja : '中学校|ちゅうがっこう', en : 'junior high school', l : '読L7-漢字表' },
    { ja : '中近東|ちゅうきんとう', en : 'the Middle and Near East', l : '読L11-漢字表' },
    { ja : '中古|ちゅうこ', en : 'secondhand', l : '読L9-漢字表' },
    { ja : '中国|ちゅうごく', en : 'China', l : '会L1, 会L2' },
    { ja : '中止する|ちゅうしする', en : 'to cancel', v : 'irr', l : '読L20-漢字表' },
    { ja : '注射|ちゅうしゃ', en : 'injection', l : '会L12(e)' },
    { ja : '駐車場|ちゅうしゃじょう', en : 'parking lot', l : '読L8-漢字表' },
    { ja : '昼食|ちゅうしょく', en : 'lunch', l : '読L13-漢字表' },
    { ja : '注文する|ちゅうもんする', en : 'to place an order', v : 'irr', l : '会L18' },
    { ja : '調査|ちょうさ', en : 'survey', l : '読L23-II' },
    { ja : '調子|ちょうし', en : 'condition', l : '読L23-漢字表' },
    { ja : '長女|ちょうじょ', en : 'the eldest daughter', l : '読L5-漢字表' },
    { ja : '朝食|ちょうしょく', en : 'breakfast', l : '読L5-漢字表' },
    { ja : '町長|ちょうちょう', en : 'mayor of a town', l : '読L10-漢字表' },
    { ja : 'ちょうど', en : 'exactly', l : '会L14' },
    { ja : '長男|ちょうなん', en : 'the eldest son', l : '読L10-漢字表' },
    { ja : '貯金|ちょきん', en : 'savings', l : '読L18-II' },
    { ja : '貯金する|ちょきんする', en : 'to deposit money (in a bank)', v : 'irr', l : '読L18-II' },
    { ja : 'チョコレート', en : 'chocolate', l : '会L14' },
    { ja : 'チョコレートパフェ', en : 'chocolate parfait', l : '読L2-I' },
    { ja : 'ちょっと', en : 'a little', l : '会L3' },
    { ja : '地理|ちり', en : 'geography', l : '読L13-漢字表' },
    { ja : '賃貸マンション|ちんたいマンション', en : 'apartment for rent', l : '読L18-漢字表' }
  ],
  
  'つ' : [
    { ja : 'ツアー', en : 'tour', l : '会L10' },
    { ja : '一日|ついたち', en : 'the first day of a month', l : '会L4(e)' },
    { ja : 'ツイン', en : 'twin room', l : '会L15(e)' },
    { ja : '通学|つうがく', en : 'going to school', l : '読L15-漢字表' },
    { ja : '通勤|つうきん', en : 'going to work', l : '読L15-漢字表' },
    { ja : '通帳|つうちょう', en : 'passbook', l : '会L13(e)' },
    { ja : '通帳記入|つうちょうきにゅう', en : 'passbook update', l : '会L13(e)' },
    { ja : '使い果たす|つかいはたす', en : 'to use up', v : 'u', l : '読L23-漢字表' },
    { ja : '使う|つかう', en : 'to use', v : 'u', l : '会L6' },
    { ja : '仕える|つかえる', en : 'to serve; to work under', v : 'u', l : '読L8-漢字表' },
    { ja : '捕まる|つかまる', en : 'to be arrested; to be caught', v : 'u', l : '会L21' },
    { ja : '疲れている|つかれている', en : 'to be tired', l : '読L8-II' },
    { ja : '疲れる|つかれる', en : 'to get tired', v : 'ru', l : '会L11' },
    { ja : '月|つき', en : 'moon', l : '会L20' },
    { ja : '～付|～つき', en : 'with...', l : '会L15(e)' },
    { ja : '次|つぎ', en : 'next', l : '会L6' },
    { ja : '付き合う|つきあう', en : 'to date (someone); to keep company', v : 'u', l : '読L14-II, 会L15' },
    { ja : '次に|つぎに', en : 'secondly', l : '読L8-II' },
    { ja : '次は～|つぎは～', en : 'next (stop),...', l : '会L10(e)' },
    { ja : '着く|つく', en : 'to arrive', v : 'u', l : '読L13-III, 会L15' },
    { ja : 'つく', en : '(something) turns on', v : 'u', l : '会L18' },
    { ja : '机|つくえ', en : 'desk', l : '会L2(e), 会L4' },
    { ja : '作る|つくる', en : 'to make', v : 'u', l : '会L8' },
    { ja : 'つける', en : 'to turn on', v : 'ru', l : '会L6' },
    { ja : '都合が悪い|つごうがわるい', en : 'inconvenient; to have a scheduling conflict', l : '会L12' },
    { ja : '伝える|つたえる', en : 'to convey (message)', v : 'ru', l : '会L20' },
    { ja : '土|つち', en : 'soil', l : '読L4-漢字表' },
    { ja : '続く|つづく', en : 'to continue', v : 'u', l : '読L16-II' },
    { ja : '続ける|つづける', en : 'to continue', v : 'ru', l : '会L21' },
    { ja : '包む|つつむ', en : 'to wrap; to cover', v : 'u', l : '会L21' },
    { ja : '勤める|つとめる', en : 'to work for', v : 'ru', l : '会L7' },
    { ja : '勉める|つとめる', en : 'to try hard', v : 'ru', l : '読L11-漢字表' },
    { ja : 'つまらない', en : 'boring', l : '会L5' },
    { ja : '冷たい|つめたい', en : 'cold (things/people)', l : '会L10' },
    { ja : 'つもり', en : 'intention; plan', l : '会L10' },
    { ja : '梅雨|つゆ', en : 'rainy season (in Japan usually from early June to mid-July); East Asian rainy season', l : '読L9-漢字表' },
    { ja : '強い|つよい', en : 'strong', l : '会L17' },
    { ja : 'つり', en : 'fishing', l : '会L11' },
    { ja : '連れていく|つれていく', en : 'to take (someone) to (a place)', v : 'u', l : '会L16' },
    { ja : '連れて帰る|つれてかえる', en : 'to bring (a person) back', v : 'u', l : '読L12-II' },
    { ja : '連れてくる|つれてくる', en : 'to bring (a person)', v : 'irr', l : '会L6' }
  ],
  
  'て' : [
    { ja : '手|て', en : 'hand; arm', l : '会L7(e), 読L15-II' },
    { ja : '～で', en : 'by (means of transportation); with (a tool)', l : '会L10' },
    { ja : 'Tシャツ', en : 'T-shirt', l : '会L2' },
    { ja : '提案|ていあん', en : 'proposal', l : '読L22-漢字表' },
    { ja : 'ディーブイディー', en : 'DVD', l : '会L7' },
    { ja : '定期券|ていきけん', en : "commuter's pass", l : '会L10(e)' },
    { ja : '提供|ていきょう', en : 'offer', l : '読L16-漢字表' },
    { ja : '定食|ていしょく', en : 'set meal; special (of the day)', l : '会L8(c)' },
    { ja : 'ていねいな言い方|ていねいないいかた', en : 'polite exp.', l : '会L11(e)' },
    { ja : '～ていらっしゃる', en : 'honorific exp. for ～ている', v : 'u', l : '会L19' },
    { ja : 'デート', en : 'date (romantic, not calendar)', l : '会L3' },
    { ja : '～ておる', en : 'extra-modest exp. for ～ている', v : 'u', l : '会L20' },
    { ja : '出かける|でかける', en : 'to go out', v : 'ru', l : '会L5' },
    { ja : '手紙|てがみ', en : 'letter', l : '会L4' },
    { ja : 'できる', en : 'to come into existence; to be made', v : 'ru', l : '会L14' },
    { ja : 'できるだけ', en : 'as much as possible', l : '会L12' },
    { ja : 'できれば', en : 'if possible', l : '会L20' },
    { ja : '出口|でぐち', en : 'exit', l : '会L10(e)' },
    { ja : '～でござる', en : 'extra-modest exp. for です', v : 'u', l : '会L20' },
    { ja : 'デザート', en : 'desert', l : '読L13-III' },
    { ja : '弟子|でし', en : 'apprentice', l : '読L21-漢字表' },
    { ja : '手品|てじな', en : 'magic', l : '読L17-漢字表' },
    { ja : '～でしょう', en : 'probably; ...,right?', l : '会L12' },
    { ja : '手数料|てすうりょう', en : 'commission', l : '会L13(e)' },
    { ja : 'テスト', en : 'test', l : '会L5' },
    { ja : '手伝う|てつだう', en : 'to help', v : 'u', l : '会L6' },
    { ja : '手続き|てつづき', en : 'procedure', l : '読L20-漢字表' },
    { ja : '徹夜する|てつやする', en : 'to stay up all night', v : 'irr', l : '会L22' },
    { ja : 'デッキ', en : 'deck (ship, cassette, etc.)', l : 'ワークブック読L2' },
    { ja : 'テニス', en : 'tennis', l : '会L3' },
    { ja : 'テニス部|テニスぶ', en : 'tennis club', l : '読L16-漢字表' },
    { ja : 'では、お元気で|では、おげんきで', en : 'Take care.', l : '読L5-II' },
    { ja : 'デパート', en : 'department store', l : '会L4' },
    { ja : '手袋|てぶくろ', en : 'gloves', l : '会L10' },
    { ja : 'でも', en : 'but', l : '会L3' },
    { ja : '寺|てら', en : 'temple', l : '会L4' },
    { ja : '出る|でる', en : 'to exit; to appear; to attend', v : 'ru', l : '読L6-I, 会L9' },
    { ja : 'テレビ', en : 'TV', l : '会L3' },
    { ja : 'テレビ局|テレビきょく', en : 'TV station', l : '会L19' },
    { ja : '天|てん', en : 'the heavens; the sky', l : '読L12-II' },
    { ja : '～点|～てん', en : '...points', l : '会L11' },
    { ja : '店員|てんいん', en : 'store clerk', l : '読L8-漢字表' },
    { ja : '天気|てんき', en : 'weather', l : '会L5' },
    { ja : '電気|でんき', en : 'electricity', l : '会L2(e), 会L6' },
    { ja : '電気工学|でんきこうがく', en : 'electric engineering', l : '読L19-III' },
    { ja : '電気代|でんきだい', en : 'charge for electricity ', l : '読L18-III' },
    { ja : '天気予報|てんきよほう', en : 'weather forecast', l : '会L8' },
    { ja : '天国|てんごく', en : 'heaven', l : '読L5-漢字表' },
    { ja : '伝言|でんごん', en : 'message', l : '読L22-II' },
    { ja : '伝言板|でんごんばん', en : 'bulletin board; message board', l : '読L6-II' },
    { ja : '天才|てんさい', en : 'genius', l : '読L5-漢字表' },
    { ja : '電子辞書|でんしじしょ', en : 'electronic dictionary', l : '会L20' },
    { ja : '電子レンジ|でんしレンジ', en : 'microwave oven', l : '読L8-漢字表' },
    { ja : '電車|でんしゃ', en : 'train', l : '会L6' },
    { ja : '天井|てんじょう', en : 'ceiling', l : '読L17-II' },
    { ja : '電池|でんち', en : 'battery', l : '会L15' },
    { ja : '店長|てんちょう', en : 'store manager', l : '読L14-漢字表' },
    { ja : '点滴|てんてき', en : 'intravenous feeding; IV', l : '会L12(e)' },
    { ja : '天皇|てんのう', en : 'Japanese emperor', l : '読L5-漢字表' },
    { ja : '天ぷら|てんぷら', en : 'tempura', l : '会L10' },
    { ja : '展覧会|てんらんかい', en : 'art exhibition', l : '読L17-II' },
    { ja : '電話|でんわ', en : 'telephone', l : '会L1' },
    { ja : '電話する|でんわする', en : 'to call', v : 'irr', l : '会L8' },
    { ja : '電話番号|でんわばんごう', en : 'telephone number', l : '会L1' },
    { ja : '電話をかける|でんわをかける', en : 'to make a phone call', v : 'ru', l : '会L6' }
  ],
  
  'と' : [
    { ja : '戸|と', en : 'door', l : '読L10-II' },
    { ja : '～と', en : 'together with (a person)', l : '会L4' },
    { ja : '～度|～ど', en : '...degrees (temperature)', l : '会L12' },
    { ja : 'ドア', en : 'door', l : '会L2(e)' },
    { ja : 'ドイツ', en : 'Germany', l : '会L20' },
    { ja : 'トイレ', en : 'toilet; restroom', l : '会L2' },
    { ja : '問う|とう', en : 'to question', v : 'u', l : '読L19-漢字表' },
    { ja : '答案|とうあん', en : 'examination paper', l : '読L23-漢字表' },
    { ja : '同化|どうか', en : 'assimilation', l : '読L23-漢字表' },
    { ja : '同級生|どうきゅうせい', en : 'classmate', l : '読L13-漢字表' },
    { ja : '東京|とうきょう', en : 'Tokyo', l : '読L6-漢字表' },
    { ja : '東京駅|とうきょうえき', en : 'Tokyo Station', l : '読L22-漢字表' },
    { ja : '東京スカイツリー|とうきょうスカイツリー', en : 'Tokyo Skytree', l : '会L7' },
    { ja : '道具|どうぐ', en : 'tool', l : '読L16-II' },
    { ja : '同時|どうじ', en : 'same time', l : '読L13-漢字表' },
    { ja : '当時|とうじ', en : 'at that time', l : '読L14-漢字表' },
    { ja : '東寺|とうじ', en : 'Toji temple', l : '読L15-漢字表' },
    { ja : '動詞|どうし', en : 'verb', l : '読L16-漢字表' },
    { ja : 'どうしたらいい', en : 'what should one do', l : '会L14' },
    { ja : 'どうして', en : 'why', l : '会L4' },
    { ja : 'どうしよう', en : 'What should I/we do?', l : '会L18' },
    { ja : '同情する|どうじょうする', en : 'to sympathize', v : 'irr', l : '会L23' },
    { ja : 'トースト', en : 'toast', l : '読L2-I' },
    { ja : 'どうぞ', en : 'Please.; Here it is.', l : '会L2' },
    { ja : 'どうぞよろしくお願いします|どうぞよろしくおねがいします', en : 'Thank you in advance.', l : '読L19-III' },
    { ja : 'どうですか', en : 'How about...?; How is...?', l : '会L3' },
    { ja : '堂々とした|どうどうとした', en : 'dignified; imposing', l : '読L18-漢字表' },
    { ja : '豆腐|とうふ', en : 'tofu', l : 'ワークブックL20' },
    { ja : '動物|どうぶつ', en : 'animal', l : '読L13-漢字表' },
    { ja : '動物園|どうぶつえん', en : 'zoo', l : '会L17' },
    { ja : 'どうも', en : 'Thank you.', l : '会L2' },
    { ja : 'どうやって', en : 'how; by what means', l : '会L10' },
    { ja : '東洋|とうよう', en : 'the East', l : '読L6-漢字表' },
    { ja : '同僚|どうりょう', en : 'colleague; coworker', l : '会L21' },
    { ja : '東南アジア|とうなんアジア', en : 'Southeast Asia', l : '読L6-漢字表' },
    { ja : '東北|とうほく', en : 'Tohoku area', l : '読L6-漢字表' },
    { ja : '十|(とお/じゅう)', en : 'ten', l : '読L3-漢字表, 会L9' },
    { ja : '遠い|とおい', en : 'far (away)', l : '会L21' },
    { ja : '十日|とおか', en : 'the tenth day of a month; ten days', l : '会L4(e), 会L13' },
    { ja : '通る|とおる', en : 'to pass; to go through', v : 'u', l : '読L15-II' },
    { ja : '～とか', en : '...for example', l : '会L22' },
    { ja : '時|とき', en : 'when...; at the time of...', l : '会L4' },
    { ja : '時々|ときどき', en : 'sometimes', l : '会L3' },
    { ja : '研ぐ|とぐ', en : 'to sharpen', v : 'u', l : '読L19-漢字表' },
    { ja : '読者|どくしゃ', en : 'reader', l : '読L14-漢字表' },
    { ja : '特集|とくしゅう', en : '(magazine) feature', l : '読L17-漢字表' },
    { ja : '読書|どくしょ', en : 'reading (books)', l : '読L1-I' },
    { ja : '特色|とくしょく', en : 'characteristic', l : '読L12-漢字表' },
    { ja : '特徴|とくちょう', en : 'feature; trait; characteristic', l : '読L13-漢字表' },
    { ja : '特に|とくに', en : 'especially', l : '読L13-II' },
    { ja : '特別|とくべつ（な）', en : 'special', l : '読L12-漢字表' },
    { ja : '時計|とけい', en : 'watch; clock', l : '会L2' },
    { ja : 'どこ', en : 'where', l : '会L2' },
    { ja : 'どこでも', en : 'anywhere', l : '読L16-II' },
    { ja : '床屋|とこや', en : "barber's", l : '会L10' },
    { ja : '所|ところ', en : 'place', l : '会L8' },
    { ja : 'ところが', en : 'however; on the contrary', l : '読L21-II' },
    { ja : 'ところで', en : 'by the way', l : '会L9' },
    { ja : '年|とし', en : 'year', l : '読L10-II' },
    { ja : '年上|としうえ', en : 'being older; someone older', l : '読L14-II' },
    { ja : '図書館|としょかん', en : 'library', l : '会L2' },
    { ja : 'どちら', en : 'which; where (polite)', l : '会L10, 会L19' },
    { ja : '土地|とち', en : 'land', l : '読L4-漢字表' },
    { ja : '特急|とっきゅう', en : 'super express', l : '会L10(e)' },
    { ja : '突然|とつぜん', en : 'suddenly', l : '読L19-III' },
    { ja : 'どっち', en : 'which', l : '会L10' },
    { ja : 'とても', en : 'very', l : '会L5' },
    { ja : '隣|となり', en : 'next', l : '会L4' },
    { ja : 'とにかく', en : 'anyhow; anyway', l : '会L21' },
    { ja : 'どの', en : 'which...', l : '会L2' },
    { ja : 'どのぐらい', en : 'how much; how long', l : '会L10' },
    { ja : '飛ぶ|とぶ', en : 'to fly', v : 'u', l : '読L16-II' },
    { ja : 'トマト', en : 'tomato', l : '会L8' },
    { ja : '泊まる|とまる', en : 'to stay (at a hotel, etc.)', v : 'u', l : '会L10' },
    { ja : '止まる|とまる', en : 'to stop', v : 'u', l : '読L20-II' },
    { ja : '～と申します|～ともうします', en : 'my name is...', l : '会L13' },
    { ja : '友達／友だち|ともだち', en : 'friend; companion', l : '会L1' },
    { ja : '共働き|ともばたらき', en : 'both husband and wife working', l : '読L12-漢字表' },
    { ja : '土曜日|どようび', en : 'Saturday', l : '会L3; 会L4(e)' },
    { ja : 'ドライブ', en : 'drive', l : '会L11' },
    { ja : '鳥|とり', en : 'bird', l : '読L13-漢字表' },
    { ja : '鶏肉|とりにく', en : 'chicken meat', l : '会L8(e)' },
    { ja : '努力|どりょく', en : 'endeavor', l : '読L18-漢字表' },
    { ja : '取る|とる', en : 'to take (a class); to get (a grade)', v : 'u', l : '読L7-II, 会L11' },
    { ja : '撮る|とる', en : 'to take (a picture)', v : 'u',  l : '会L4' },
    { ja : 'とる', en : 'to take off', v : 'u',  l : '読L10-II' },
    { ja : 'どれ', en : 'which one', l : '会L2' },
    { ja : 'とろ', en : 'fatty cut; fatty tuna', l : '会L18(c)' },
    { ja : 'トレーナー', en : 'sweat shirt', l : '会L14' },
    { ja : 'ドレス', en : 'dress', l : 'ワークブックL7' },
    { ja : 'トロッコ列車|トロッコれっしゃ', en : 'small train usually for tourists', l : '読L15-II' },
    { ja : '泥棒|どろぼう', en : 'thief; burglar', l : '会L21' },
    { ja : 'とんかつ', en : 'pork cutlet', l : '会L2' },
    { ja : 'どんな', en : 'what kind of...', l : '会L5' }
  ],
  
  'な' : [
    { ja : '無い|ない', en : 'nonexistent; there is no...', l : '読L20-漢字表' },
    { ja : '内科医|ないかい', en : 'physician; internal medicine', l : '会L12(e), 読L22-漢字表' },
    { ja : 'ナイロビ', en : 'Nairobi (Kenya)', l : '会L1' },
    { ja : '直す|なおす', en : 'to correct; to fix', v : 'u', l : '会L16' },
    { ja : '中|なか', en : 'inside', l : '会L4' },
    { ja : '長い|ながい', en : 'long', l : '会L7' },
    { ja : '長い間|ながいあいだ', en : 'long time', l : '読L21-II' },
    { ja : '仲がいい|なかがいい', en : 'be on good/close terms; to get along well', l : '会L19' },
    { ja : '長野|ながの', en : 'Nagano', l : '読L17-漢字表' },
    { ja : '泣く|なく', en : 'to cry', v : 'u', l : '読L12-II, 会L13' },
    { ja : 'なくす', en : 'to lose', v : 'u', l : '会L12' },
    { ja : 'なくなる', en : 'to be lost; to disappear', v : 'u', l : '会L23' },
    { ja : '殴る|なぐる', en : 'to strike; to hit; to punch', v : 'u', l : '会L21' },
    { ja : '名古屋|なごや', en : 'Nagoya', l : 'ワークブックL7' },
    { ja : '情け|なさけ', en : 'mercy', l : '読L23-漢字表' },
    { ja : 'なさる', en : 'honorific exp. for する', v : 'u', l : '会L19' },
    { ja : 'なす', en : 'eggplant', l : '会L8(e)' },
    { ja : 'なぜ', en : 'why', l : '会L19' },
    { ja : '夏|なつ', en : 'summer', l : '会L8' },
    { ja : 'なつかしい', en : 'to miss; to long for', l : '読L19-II' },
    { ja : 'ナッツ', en : 'nuts', l : 'ワークブック読L2' },
    { ja : '納豆|なっとう', en : 'natto (fermented soybeans)', l : '会L5' },
    { ja : '夏休み|なつやすみ', en : 'summer vacation', l : '読L15-漢字表' },
    { ja : '～など', en : 'and so forth', l : '読L12-II' },
    { ja : '七歳|ななさい', en : 'seven years old', l : '会L1(e)' },
    { ja : '七つ|ななつ', en : 'seven', l : '会L9' },
    { ja : '七分|ななふん', en : 'seven minutes', l : '会L1(e)' },
    { ja : '何か|なにか', en : 'something', l : '会L8' },
    { ja : '何も|なにも', en : 'not...anything (with neg. verbs)', l : '会L7' },
    { ja : '七日|なのか', en : 'the seventh day of a month; seven days', l : '会L4(e), 会L13' },
    { ja : 'なべ', en : 'pot', l : '読L13-II' },
    { ja : '名前|なまえ', en : 'name', l : '会L1' },
    { ja : '名前を付ける|なまえをつける', en : 'to name', v : 'ru', l : '読L17-II' },
    { ja : '怠け者|なまけもの', en : 'lazy person', l : '会L19' },
    { ja : 'ナマケモノ', en : 'sloth', l : '会L20' },
    { ja : '悩み|なやみ', en : 'worry', l : '読L14-II, 会L19' },
    { ja : '習う|ならう', en : 'to learn', v : 'u', l : '会L11' },
    { ja : 'なる', en : 'to become', v : 'u', l : '会L10' },
    { ja : '慣れる|なれる', en : 'to get used to...', v : 'ru', l : '会L17' },
    { ja : '何|(なん/なに)', en : 'what', l : '会L1' },
    { ja : 'なんだか', en : 'somehow', l : '読L22-II' },
    { ja : 'なんでも', en : 'anything; everything', l : '読L13-II' },
    { ja : '南東|なんとう', en : 'southeast', l : '読L6-漢字表' },
    { ja : '南極|なんきょく', en : 'Antarctica', l : '読L6-漢字表' },
    { ja : '何時|なんじ', en : 'what time', l : '読L8-漢字表' },
    { ja : '何度も|なんども', en : 'many times', l : '読L17-II, 会L22' },
    { ja : '何人|なんにん', en : 'how many people', l : '読L8-漢字表' }
  ],
  
  'に' : [
    { ja : '二|に', en : 'two', l : '読L3-漢字表' },
    { ja : '似合う|にあう', en : 'to look good (on somebody)', v : 'u', l : '会L14' },
    { ja : '二か月前|にかげつまえ', en : 'two months ago', l : '会L4(e)' },
    { ja : '二月|にがつ', en : 'February', l : '会L4(e)' },
    { ja : 'にぎやか（な）', en : 'lively', l : '会L5' },
    { ja : '肉|にく', en : 'meat', l : '会L2' },
    { ja : '肉屋|にくや', en : 'meat shop', l : '読L13-漢字表' },
    { ja : '～に比べて|～にくらべて', en : 'compared with...', l : '会L17' },
    { ja : '逃げる|にげる', en : 'to run away; to escape', v : 'ru', l : '読L22-II' },
    { ja : 'ニコニコする|にこにこする', en : 'to smile', v : 'irr', l : '読L20-II' },
    { ja : '二歳|にさい', en : 'two years old', l : '会L1(e)' },
    { ja : '二三日|にさんにち', en : 'for two to three days', l : '会L12' },
    { ja : '西|にし', en : 'west', l : '会L6(e)' },
    { ja : '二時|にじ', en : "two o'clock", l : '会L1(e)' },
    { ja : '二時間|にじかん', en : 'two hours', l : '読L9-漢字表' },
    { ja : '西口|にしぐち', en : 'west exit', l : '読L6-漢字表' },
    { ja : '二十分|にじ(ゅ)っぷん', en : 'twenty minutes', l : '会L1(e)' },
    { ja : '二時半|にじはん', en : 'half past two', l : '会L1' },
    { ja : '西町|にしまち', en : 'Nishimachi', l : 'ワークブックL8-76' },
    { ja : '二週間前|にしゅうかんまえ', en : 'two weeks ago', l : '会L4(e)' },
    { ja : '二十五歳|にじゅうごさい', en : 'twenty-five years old', l : '読L17-漢字表' },
    { ja : '二週目|にしゅうめ', en : 'second week', l : '読L16-漢字表' },
    { ja : '二十四日|にじゅうよっか', en : 'the twenty-fourth day of a month', l : '会L4(e)' },
    { ja : '二台|にだい', en : 'two vehicles/machines/etc.', l : '読L21-漢字表' },
    { ja : '日曜日|にちようび', en : 'Sunday', l : '会L3, 会L4(e)' },
    { ja : '～について', en : 'about...; concerning...', l : '会L8' },
    { ja : '日記|にっき', en : 'diary', l : '読L9-II, 会L18' },
    { ja : '二年生|にねんせい', en : 'second-year student', l : '読L3-漢字表' },
    { ja : '二番目|にばんめ', en : 'the second', l : '読L18-漢字表' },
    { ja : '二分|にふん', en : 'two minutes', l : '会L1(e)' },
    { ja : '日本|にほん', en : 'Japan', l : '会L1' },
    { ja : '日本海|にほんかい', en : 'the Japan Sea', l : '読L13-漢字表' },
    { ja : '日本語|にほんご', en : 'Japanese language', l : '会L1' },
    { ja : '日本人|にほんじん', en : 'Japanese people', l : '会L1' },
    { ja : '日本対中国|にほんたいちゅうごく', en : 'Japan versus China', l : '読L20-漢字表' },
    { ja : '荷物|にもつ', en : 'baggage', l : '会L6' },
    { ja : 'ニヤニヤする|にやにやする', en : 'to grin', v : 'irr', l : '読L13-II' },
    { ja : '入院する|にゅういんする', en : 'to be hospitalized', v : 'irr', l : '読L21-II' },
    { ja : '入試|にゅうし', en : 'entrance exam', l : '読L18-漢字表' },
    { ja : '入社|にゅうしゃ', en : 'entry to a company', l : '読L7-漢字表' },
    { ja : 'ニュージーランド', en : 'New Zealand', l : '会L13' },
    { ja : 'ニュース', en : 'news', l : '会L17' },
    { ja : 'ニューデリー', en : 'New Delhi (India)', l : '会L1, 読L2-I' },
    { ja : 'ニューヨーク', en : 'New York', l : '会L1, ワークブックL1' },
    { ja : '～によって', en : 'depending on...', l : '読L23-II' },
    { ja : '～によると', en : 'according to...', l : '会L17' },
    { ja : '二浪|にろう', en : 'a person who failed entrance exams twice', l : '会L22(c)' },
    { ja : '庭|にわ', en : 'garden', l : '会L15' },
    { ja : '～人|～にん', en : 'counter for people', l : '会L7' },
    { ja : '人気|にんき', en : 'popularity', l : '読L5-漢字表' },
    { ja : '人気がある|にんきがある', en : 'to be popular', v : 'u', l : '会L9' },
    { ja : '人魚|にんぎょ', en : 'mermaid', l : '読L15-漢字表' },
    { ja : '人間|にんげん', en : 'human being', l : '読L23-II' },
    { ja : '忍者|にんじゃ', en : 'ninja', l : '読L14-漢字表' },
    { ja : 'にんじん', en : 'carrot', l : '会L8(e)' }
  ],
  
  'ぬ' : [
    { ja : 'ぬいぐるみ', en : 'stuffed animal (e.g. teddy bear)', l : '会L14' },
    { ja : '脱ぐ|ぬぐ', en : 'to take off (clothes)', v : 'u', l : '会L17' },
    { ja : '盗む|ぬすむ', en : 'to steal; to rob', v : 'u', l : '会L21' },
    { ja : '布|ぬの', en : 'cloth', l : 'ワークブック読L1' }
  ],
  
  'ね' : [
    { ja : '願い|ねがい', en : 'wish', l : '読L12-II' },
    { ja : 'ネクタイ', en : 'necktie', l : '会L14' },
    { ja : '猫|ねこ', en : 'cat', l : '会L4' },
    { ja : '値段|ねだん', en : 'price', l : '読L20-II' },
    { ja : '熱がある|ねつがある', en : 'to have a fever', v : 'u', l : '会L12' },
    { ja : '熱を測る|ねつをはかる', en : "to check someone's temperature", v : 'u', l : 'ワークブックL12' },
    { ja : '熱心|ねっしん（な）', en : 'enthusiastic', l : '読L20-漢字表' },
    { ja : '眠い|ねむい', en : 'sleepy', l : '会L10' },
    { ja : '寝る|ねる', en : 'to sleep; to go to sleep', v : 'ru', l : '会L3' },
    { ja : '～年|～ねん', en : '...years', l : '会L10' },
    { ja : '～年間|～ねんかん', en : 'for...years', l : '読L14-II' },
    { ja : '～年生|～ねんせい', en : '...year student', l : '会L1' },
    { ja : '粘土|ねんど', en : 'clay', l : '読L4-漢字表' },
    { ja : '年末|ねんまつ', en : 'year-end', l : '読L22-漢字表' }
  ],
  
  'の' : [
    { ja : '～の後|～のあと', en : 'after...', l : '読L9-漢字表' },
    { ja : '能|のう', en : 'Noh theater; masked musical drama', l : '会L9(c)' },
    { ja : 'ノート', en : 'notebook', l : '会L2' },
    { ja : '～の多く|～のおおく', en : 'many of...', l : '読L19-漢字表' },
    { ja : '残す|のこす', en : 'to leave; to preserve', v : 'u', l : '読L15-II' },
    { ja : '～の紹介で|～のしょうかいで', en : 'through the introduction of', l : '読L19-III' },
    { ja : '～ために', en : 'for...; for the sake of...', l : '会L23' },
    { ja : '～のために', en : 'for...', l : '読L19-III' },
    { ja : '～のための', en : 'for the sake of...', l : '読L17-II' },
    { ja : '～ので', en : 'because...', l : '会L12' },
    { ja : 'のど', en : 'throat', l : '会L12' },
    { ja : 'のどが渇く|のどがかわく', en : 'to become thirsty', v : 'u', l : '会L12' },
    { ja : '上る|のぼる', en : 'to go up', v : 'u', l : '読L4-漢字表' },
    { ja : '登る|のぼる', en : 'to climb', v : 'u', l : '会L11' },
    { ja : '～の真上|～のまうえ', en : 'right above...', l : '読L17-漢字表' },
    { ja : '飲み物|のみもの', en : 'drink', l : '会L5' },
    { ja : '飲む|のむ', en : 'to drink', v : 'u', l : '会L3' },
    { ja : '～のようなもの', en : 'something like...', l : '読L16-II' },
    { ja : '海苔|のり', en : 'nori; edible seaweed', l : '読L13-II' },
    { ja : '乗り遅れる|のりおくれる', en : 'to miss (a train, bus, etc.)', v : 'ru', l : '会L16' },
    { ja : '乗り換え|のりかえ', en : 'transfer', l : '会L10(e)' },
    { ja : '乗り物|のりもの', en : 'vehicle', l : '読L14-漢字表' },
    { ja : '乗る|のる', en : 'to ride; to board', v : 'u', l : '会L5' }
  ],
  
  'は' : [
    { ja : '歯|は', en : 'tooth', l : '会L7(e), 会L12' },
    { ja : '場合|ばあい', en : 'case', l : '読L14-II' },
    { ja : 'パーティー', en : 'party', l : '会L8' },
    { ja : 'パートナー', en : 'partner', l : '会L14' },
    { ja : 'ハーブ', en : 'herb', l : 'ワークブック読L2' },
    { ja : 'バーベキュー', en : 'barbecue', l : '会L8' },
    { ja : 'パーマ', en : 'permanent', l : '会L17(e)' },
    { ja : 'ハーモニカ', en : 'harmonica; mouth organ', l : 'ワークブック読L2' },
    { ja : 'パーマをかける', en : "to have one's hair permed", v : 'ru', l : '会L17(e)' },
    { ja : 'はい', en : 'yes', l : '会L1' },
    { ja : '灰色|はいいろ', en : 'gray', l : '会L9(e)' },
    { ja : 'バイオリン', en : 'violin', l : '会L13' },
    { ja : '俳句|はいく', en : 'haiku (Japanese poetry)', l : '読L17-II' },
    { ja : 'バイク', en : 'motorcycle', l : '会L13' },
    { ja : '灰皿|はいざら', en : 'ashtray', l : '読L20-漢字表' },
    { ja : '歯医者|はいしゃ', en : 'dentist', l : '読L14-漢字表' },
    { ja : '配達|はいたつ', en : 'delivery', l : '読L21-漢字表' },
    { ja : '売店|ばいてん', en : 'shop; stand; kiosk', l : '会L10(e)' },
    { ja : 'バイト', en : 'abbreviation of アルバイト', l : '会L21' },
    { ja : '売買|ばいばい', en : 'selling and buying', l : '読L10-漢字表' },
    { ja : 'ハイヒール', en : 'high heels', l : '会L20' },
    { ja : '俳優|はいゆう', en : 'actor; actress', l : '会L11' },
    { ja : '入る|はいる', en : 'to enter', v : 'u', l : '会L6' },
    { ja : '葉書|はがき', en : 'postcard', l : '会L5, 会L5(e)' },
    { ja : 'ばかにする', en : 'to insult; to make a fool of...', v : 'irr', l : '会L21' },
    { ja : '図る|はかる', en : 'to attempt', v : 'u', l : '読L18-漢字表' },
    { ja : '計る|はかる', en : 'to measure', v : 'u', l : '読L21-漢字表' },
    { ja : 'はく', en : 'to put on (items below your waist)', v : 'u', l : '会L7' },
    { ja : '～泊|～はく', en : '...nights', l : '会L15(e)' },
    { ja : '白紙|はくし', en : 'blank sheet', l : '読L9-漢字表' },
    { ja : '爆笑する|ばくしょうする', en : 'to burst into laughter', v : 'irr', l : '読L20-漢字表' },
    { ja : '白鳥|はくちょう', en : 'swan', l : '読L9-漢字表' },
    { ja : '運ぶ|はこぶ', en : 'to carry', v : 'u', l : '会L22' },
    { ja : 'パスタ', en : 'pasta', l : '会L2' },
    { ja : 'はし', en : 'chopsticks', l : '会L8' },
    { ja : 'はしご', en : 'ladders', l : '読L17-II' },
    { ja : '始まる|はじまる', en : '(something) begins', v : 'u', l : '会L9' },
    { ja : '初めて|はじめて', en : 'for the first time', l : '会L12' },
    { ja : '初めは|はじめは', en : 'at first', l : '読L18-III' },
    { ja : 'はじめまして', en : 'How do you do?', l : '会G' },
    { ja : '始める|はじめる', en : 'to begin', v : 'ru', l : '会L8' },
    { ja : '場所|ばしょ', en : 'place', l : '読L16-II, 会L23' },
    { ja : '走る|はしる', en : 'to run; to drive; to rush', v : 'u', l : '読L15-II, 会L22' },
    { ja : '走り書き|はしりがき', en : 'hasty writing', l : '読L15-漢字表' },
    { ja : '場所|ばしょ', en : 'place', l : '読L15-漢字表' },
    { ja : 'バス', en : 'bus', l : '会L5' },
    { ja : '恥ずかしい|はずかしい', en : 'embarrassing; to feel embarrassed', l : '会L18' },
    { ja : '恥ずかしがり屋|はずかしがりや', en : 'shy person', l : '会L19' },
    { ja : 'バスケットボール', en : 'basketball', l : 'ワークブックL3' },
    { ja : 'バス停|バスてい', en : 'bus stop', l : '会L4' },
    { ja : 'パソコン', en : 'personal computer', l : '会L6' },
    { ja : '畑|はたけ', en : 'farm', l : '読L12-II' },
    { ja : '二十歳|はたち', en : 'twenty years old', l : '会L1(e)' },
    { ja : '働く|はたらく', en : 'to work', v : 'u', l : '会L11' },
    { ja : 'はたを織る|はたをおる', en : 'to weave', v : 'u', l : '読L12-II' },
    { ja : '八|はち', en : 'eight', l : '読L3-漢字表' },
    { ja : '八月|はちがつ', en : 'August', l : '会L4(e)' },
    { ja : '八時|はちじ', en : "eight o'clock", l : '会L1(e)' },
    { ja : '八分|は(ちふ/っぷ)ん', en : 'eight minutes', l : '会L1(e)' },
    { ja : '×|ばつ', en : 'wrong', l : '会L11(e)' },
    { ja : '発音|はつおん', en : 'pronunciation', l : '会L11(e)' },
    { ja : '二十日|はつか', en : 'the twentieth day of a month', l : '会L4(e)' },
    { ja : '初恋|はつこい', en : 'first love', l : '読L21-漢字表' },
    { ja : '八歳|はっさい', en : 'eight years old', l : '会L1(e)' },
    { ja : '八千|はっせん', en : 'eight thousand', l : '読L3-漢字表' },
    { ja : '八百|はっぴゃく', en : 'eight hundred', l : '読L3-漢字表' },
    { ja : '発表|はっぴょう', en : 'presentation', l : '会L15' },
    { ja : '発表する|はっぴょうする', en : 'to make public; to publish', v : 'irr', l : '読L17-II' },
    { ja : 'ハッピー', en : 'happy', l : 'ワークブック読L2' },
    { ja : '発明|はつめい', en : 'invention', l : '読L11-漢字表' },
    { ja : '初雪|はつゆき', en : 'first snow', l : '読L21-漢字表' },
    { ja : '花|はな', en : 'flower', l : '会L12' },
    { ja : '鼻|はな', en : 'nose', l : '会L7(e)' },
    { ja : '話|はなし', en : 'chat; talk', l : '会L19' },
    { ja : '話をする|はなしをする', en : 'to have a talk', v : 'irr', l : '読L9-II, 会L19' },
    { ja : '話す|はなす', en : 'to speak; to talk', v : 'u', l : '会L3' },
    { ja : '花火|はなび', en : 'fireworks', l : '読L4-漢字表' },
    { ja : 'バナナ', en : 'banana', l : '会L18' },
    { ja : '花見|はなみ', en : 'flower viewing', l : '読L5-漢字表' },
    { ja : '離れる|はなれる', en : '(something/someone) separates; parts from', v : 'ru', l : '会L23' },
    { ja : '母|はは', en : '(my) mother', l : '会L7' },
    { ja : '母親|ははおや', en : 'mother', l : '読L14-漢字表' },
    { ja : '母の日|ははのひ', en : "Mother's Day", l : '読L4-漢字表' },
    { ja : 'はまち', en : 'hamachi; young Japanese amberjack; yellowtail', l : '会L18(c)' },
    { ja : '早い|はやい', en : 'early', l : '会L3' },
    { ja : '速い|はやい', en : 'fast', l : '会L7' },
    { ja : '早起きする|はやおきする', en : 'to get up early', v : 'irr', l : '読L12-漢字表' },
    { ja : '早く／速く|はやく', en : '(do something) early; fast', l : '会L10' },
    { ja : '払う|はらう', en : 'to pay', v : 'u', l : '会L10' },
    { ja : '払い戻し|はらいもどし', en : 'refund', l : '読L20-漢字表' },
    { ja : 'パリ', en : 'Paris', l : 'ワークブックL1' },
    { ja : 'パリ経由|パリけいゆ', en : 'via Paris', l : '読L21-漢字表' },
    { ja : '春|はる', en : 'spring', l : '会L10' },
    { ja : '貼る|はる', en : 'to post; to stick; to affix', v : 'u', l : '会L21' },
    { ja : '春巻|はるまき', en : 'spring roll', l : '読L19-漢字表' },
    { ja : '晴れ|はれ', en : 'sunny weather', l : '会L12' },
    { ja : '晴れる|はれる', en : 'to become sunny', v : 'ru', l : '会L19' },
    { ja : 'パレス', en : 'palace', l : 'ワークブックL21' },
    { ja : 'バレンタインデー', en : "St. Valentine's Day", l : '会L14' },
    { ja : '半|はん', en : 'half', l : '会L1' },
    { ja : '～番|～ばん', en : 'number...', l : '会L11(e), 会L15' },
    { ja : 'パン', en : 'bread', l : '会L4' },
    { ja : 'パン屋さん|パンやさん', en : 'baker', l : 'ワークブックL22' },
    { ja : '繁栄|はんえい', en : 'prosperity; thriving; flourishing', l : 'ワークブック読L1' },
    { ja : '半額|はんがく', en : 'half price', l : '読L4-漢字表' },
    { ja : 'パンクする', en : '(tire) goes flat', v : 'irr', l : '会L23' },
    { ja : '番組|ばんぐみ', en : 'broadcast program', l : '会L15' },
    { ja : '番犬|ばんけん', en : 'watch dog', l : '読L21-漢字表' },
    { ja : '番号|ばんごう', en : 'number', l : '会L1' },
    { ja : '晩ご飯|ばんごはん', en : 'dinner', l : '会L3' },
    { ja : 'バンコク', en : 'Bangkok (Thailand)', l : '会L1' },
    { ja : 'バンザイをする', en : 'to raise hands and shout "<em>Banzai!</em>"', l : '読L23-II' },
    { ja : '～番線|～ばんせん', en : 'track number...', l : '会L10(e)' },
    { ja : 'パンダ', en : 'panda', l : '会L17' },
    { ja : '反対する|はんたいする', en : 'to oppose; to object to', v : 'irr', l : '会L22' },
    { ja : 'パンツ', en : 'pants; underpants', l : '会L10' },
    { ja : '半年|はんとし', en : 'half a year', l : '読L4-漢字表' },
    { ja : 'バンド', en : 'band', l : '読L11-II' },
    { ja : '犯人|はんにん', en : 'criminal', l : '会L21' },
    { ja : 'ハンバーガー', en : 'hamburger', l : '会L3' },
    { ja : '半分|はんぶん', en : 'half', l : '読L4-漢字表' }
  ],
  
  'ひ' : [
    { ja : '日|ひ', en : 'day', l : '会L16' },
    { ja : '火|ひ', en : 'fire', l : '読L4-漢字表' },
    { ja : 'ピアノ', en : 'piano', l : '会L9' },
    { ja : 'ヒーター', en : 'heater', l : '会L17' },
    { ja : 'ビーチ', en : 'beach', l : 'ワークブックL11' },
    { ja : 'ピーナッツ', en : 'peanuts', l : '会L8(e)' },
    { ja : 'ピーマン', en : 'bell pepper; green pepper', l : 'ワークブックL13' },
    { ja : 'ビール', en : 'beer', l : '会L11' },
    { ja : '比較|ひかく', en : 'comparison', l : '読L23-漢字表' },
    { ja : '東|ひがし', en : 'east', l : '会L6(e)' },
    { ja : '東口|ひがしぐち', en : 'east exit', l : '読L6-漢字表' },
    { ja : '～匹|～ひき', en : 'counter for smaller animals', l : '会L14, 会L14(e)' },
    { ja : 'ビキニ', en : 'bikini (swimwear)', l : 'ワークブック読L2' },
    { ja : '弾く|ひく', en : 'to play (a string instrument or piano)', v : 'u', l : '会L9' },
    { ja : 'ピクニック', en : 'picnic', l : 'ワークブックL6' },
    { ja : 'ひげ', en : 'beard', l : '会L17' },
    { ja : '悲劇|ひげき', en : 'tragedy', l : '読L23-漢字表' },
    { ja : 'ひげをそる', en : "to shave one's beard", v : 'u', l : '会L17' },
    { ja : '飛行機|ひこうき', en : 'airplane', l : '会L5' },
    { ja : 'ピザ', en : 'pizza', l : '読L6-III, 会L9' },
    { ja : '悲惨|ひさん（な）', en : 'miserable', l : '読L23-漢字表' },
    { ja : '久しぶり|ひさしぶり', en : 'it has been a long time', l : '会L11' },
    { ja : 'ビジネス', en : 'business', l : '会L1, 会L2' },
    { ja : '美術館|びじゅつかん', en : 'art museum', l : '会L11' },
    { ja : '左|ひだり', en : 'left', l : '会L4' },
    { ja : '左側|ひだりがわ', en : 'left side', l : '会L6(e)' },
    { ja : '左利き|ひだりきき', en : 'left-handed', l : '読L6-漢字表' },
    { ja : '左手|ひだりて', en : 'left hand', l : '読L6-漢字表' },
    { ja : 'ひっかく', en : 'to scratch', v : 'u', l : '読L20-II' },
    { ja : 'びっくりする', en : 'to be surprised', v : 'irr', l : '読L10-II, 会L21' },
    { ja : '引っ越し|ひっこし', en : 'moving', l : '読L18-III' },
    { ja : '引っ越す|ひっこす', en : 'to move (to another place to live)', v : 'u', l : '会L19' },
    { ja : '必死|ひっし', en : 'desperate', l : '読L15-漢字表' },
    { ja : 'ビデオカメラ', en : 'camcorder', l : '会L14' },
    { ja : 'ビデオチャット ', en : 'video chat', l : 'ワークブックL16' },
    { ja : '人|ひと', en : 'person', l : '会L4' },
    { ja : 'ひどい', en : 'awful', l : '会L21' },
    { ja : '一つ|ひとつ', en : 'one', l : '会L9' },
    { ja : '一つ目|ひとつめ', en : 'first', l : '会L6(e)' },
    { ja : '人々|ひとびと', en : 'people', l : '読L12-II' },
    { ja : '一人|ひとり', en : 'one person', l : '会L7' },
    { ja : '一人暮らし|ひとりぐらし', en : 'living alone', l : '会L22' },
    { ja : '一人旅|ひとりたび', en : 'traveling alone', l : '読L11-漢字表' },
    { ja : '一人で|ひとりで', en : 'alone', l : '会L4' },
    { ja : '皮肉|ひにく', en : 'irony; sarcasm; cynicism; satire', l : 'ワークブック読L1' },
    { ja : '皮膚|ひふ', en : 'skin', l : 'ワークブック読L1' },
    { ja : '皮膚科医|ひふかい', en : 'dermatologist', l : '会L12(e)' },
    { ja : '暇|ひま（な）', en : 'not busy; free time; spare time', l : '会L5' },
    { ja : '秘密|ひみつ', en : 'secret', l : '読L16-II, 会L17' },
    { ja : '百|ひゃく', en : 'hundred', l : '読L3-漢字表' },
    { ja : '百円|ひゃくえん', en : 'one hundred yen', l : '読L3-漢字表' },
    { ja : '百円玉|ひゃくえんだま', en : '100-yen coin', l : '会L13(e)' },
    { ja : '百万|ひゃくまん', en : 'one million', l : '読L3-漢字表' },
    { ja : '冷やす|ひやす', en : 'to cool (from room temperature); to chill', v : 'u', l : '読L1-I' },
    { ja : '比喩|ひゆ', en : 'figure of speech', l : '読L23-漢字表' },
    { ja : '費用|ひよう', en : 'cost', l : '読L22-漢字表' },
    { ja : '美容院|びよういん', en : 'beauty parlor', l : '会L10' },
    { ja : '病院|びょういん', en : 'hospital', l : '会L4' },
    { ja : '病気|びょうき', en : 'illness; sickness', l : '会L9, 会L12(e)' },
    { ja : '表現|ひょうげん', en : 'expression', l : '読L17-漢字表' },
    { ja : '表現ノート|ひょうげんノート', en : 'expression notes', l : '会G' },
    { ja : '表紙|ひょうし', en : 'front cover; cover page', l : '読L11-漢字表' },
    { ja : '標準語|ひょうじゅんご', en : 'standard Japanese', l : '会L11(e)' },
    { ja : '描写する|びょうしゃする', en : 'to describe', v : 'irr', l : '読L17-漢字表' },
    { ja : '表情|ひょうじょう', en : 'facial expression', l : '読L23-II' },
    { ja : '平仮名|ひらがな', en : 'hiragana; cursive Japanese syllabary used primarily for native Japanese words', l : '会L0' },
    { ja : '開く|ひらく', en : 'to open', v : 'u', l : '読L16-漢字表' },
    { ja : 'ピラミッド', en : 'pyramid', l : 'ワークブックL13' },
    { ja : '昼|ひる', en : 'noon; daytime', l : '読L9-II' },
    { ja : '昼ご飯|ひるごはん', en : 'lunch', l : '会L3' },
    { ja : '昼寝|ひるね', en : 'nap', l : '読L13-漢字表' },
    { ja : '昼寝をする|ひるねをする', en : 'to take a nap', v : 'irr', l : '会L21' },
    { ja : '昼休み|ひるやすみ', en : 'lunch break', l : '読L13-漢字表' },
    { ja : '比例|ひれい', en : 'proportion', l : '読L23-漢字表' },
    { ja : '広い|ひろい', en : 'spacious; wide', l : '会L15' },
    { ja : '拾う|ひろう', en : 'to pick up (something)', v : 'u', l : '会L22' },
    { ja : '広島|ひろしま', en : 'Hiroshima', l : '読L15-漢字表' },
    { ja : '広島平和記念公園|ひろしまへいわきねんこうえん', en : 'Hiroshima Peace Memorial Park', l : 'ワークブックL15' },
    { ja : '広場|ひろば', en : 'square; open space', l : '読L15-II' },
    { ja : '便|びん', en : 'flight', l : '会L10' },
    { ja : 'ピンク', en : 'pink', l : '会L9(e)' },
    { ja : '貧乏|びんぼう（な）', en : 'poor', l : '会L22' }
  ],
  
  'ふ' : [
    { ja : 'ファイル', en : 'file; portfolio', l : '会L16' },
    { ja : 'ファッション', en : 'fashion', l : '読L15-II' },
    { ja : '不安|ふあん（な）', en : 'uneasy; worried', l : '読L13-II' },
    { ja : 'ブーツ', en : 'boots', l : '会L17' },
    { ja : 'フィリピン', en : 'Philippines', l : '会L1' },
    { ja : '夫婦|ふうふ', en : 'married couple; husband and wife', l : '会L14' },
    { ja : 'プール', en : 'swimming pool', l : '会L15' },
    { ja : 'ブエノスアイレス', en : 'Buenos Aires (Argentina)', l : '読L2-I' },
    { ja : '部下|ぶか', en : 'subordinate', l : '会L22' },
    { ja : '服|ふく', en : 'clothes', l : '会L12' },
    { ja : '拭く|ふく', en : 'to wipe; to dry', v : 'u', l : 'ワークブックL23' },
    { ja : '復習|ふくしゅう', en : 'review of a lesson', l : '会L22' },
    { ja : '腹痛|ふくつう', en : 'stomachache', l : '読L20-漢字表' },
    { ja : '袋|ふくろ', en : 'sack; plastic/paper bag', l : '会L8(e)' },
    { ja : '不景気|ふけいき', en : 'recession', l : '読L19-漢字表' },
    { ja : '不幸|ふこう', en : 'misfortune', l : '読L21-漢字表' },
    { ja : '不思議|ふしぎ（な）', en : 'mysterious', l : '読L8-漢字表' },
    { ja : '富士山|ふじさん', en : 'Mt. Fuji', l : '読L5-漢字表' },
    { ja : '舞台|ぶたい', en : 'stage', l : '読L21-漢字表' },
    { ja : '二つ|ふたつ', en : 'two', l : '会L9' },
    { ja : '二つ目|ふたつめ', en : 'second', l : '会L6(e)' },
    { ja : '豚肉|ぶたにく', en : 'pork', l : '読L13-漢字表' },
    { ja : '二人|ふたり', en : 'two people', l : '会L7' },
    { ja : '二人ずつ|ふたりずつ', en : 'two people each', l : '会L11(e)' },
    { ja : '部長|ぶちょう', en : 'department manager', l : '会L19' },
    { ja : '普通|ふつう', en : 'local (train)', l : '会L10(e)' },
    { ja : '二日|ふつか', en : 'the second day of a month; two days', l : '会L4(e), 会L13' },
    { ja : '物価|ぶっか', en : '(consumer) prices', l : '会L13' },
    { ja : '仏教|ぶっきょう', en : 'Buddhism', l : '会L21(c)' },
    { ja : '二日間|ふつかかん', en : 'for two days', l : '読L22-II' },
    { ja : '二日酔い|ふつかよい', en : 'hangover', l : '会L12' },
    { ja : '太っています|ふとっています', en : 'to be on the heavy side', l : '会L7' },
    { ja : '太る|ふとる', en : 'to gain weight', v : 'u', l : '会L7' },
    { ja : 'ぶどう', en : 'grapes', l : '会L8(e)' },
    { ja : '船便|ふなびん', en : 'surface mail', l : '会L5(e)' },
    { ja : '船|ふね', en : 'ship; boat', l : '会L10' },
    { ja : '不便|ふべん（な）', en : 'inconvenient', l : '読L21-II' },
    { ja : '父母|ふぼ', en : 'father and mother', l : '読L7-漢字表' },
    { ja : '踏む|ふむ', en : 'to step on', v : 'u', l : '会L21' },
    { ja : '冬|ふゆ', en : 'winter', l : '会L8' },
    { ja : '冬休み|ふゆやすみ', en : 'winter vacation', l : '読L19-漢字表' },
    { ja : 'フライドポテト', en : 'french fries', l : '読L2-I' },
    { ja : 'ブラジル', en : 'Brazil', l : '読L2-I' },
    { ja : 'フランス', en : 'France', l : 'ワークブックL2' },
    { ja : 'プリン', en : 'pudding (esp. custard)', l : '読L13-III' },
    { ja : 'ふる', en : 'to turn down (somebody); to reject; to jilt', v : 'u', l : '会L21' },
    { ja : '古い|ふるい', en : 'old (thing)', l : '会L5' },
    { ja : 'フルーツ', en : 'fruit', l : '読L17-II' },
    { ja : '無礼|ぶれい（な）', en : 'rude', l : '読L20-漢字表' },
    { ja : 'プレゼント', en : 'present', l : '会L12' },
    { ja : '風呂|ふろ', en : 'bath', l : '会L6' },
    { ja : 'ブロー', en : 'blow-dry', l : '会L17(e)' },
    { ja : 'プロジェクト', en : 'project', l : '会L22' },
    { ja : '風呂に入る|ふろにはいる', en : 'to take a bath', v : 'u', l : '会L6' },
    { ja : 'プロポーズする', en : 'to propose marriage', v : 'irr', l : '会L14' },
    { ja : 'フロント', en : 'receptionist; front desk', l : '会L15(e)' },
    { ja : '文|ぶん', en : 'sentence; text; writings', l : '読L13-II' },
    { ja : '文化|ぶんか', en : 'culture', l : '読L11-II, 会L19' },
    { ja : '文学|ぶんがく', en : 'literature', l : '会L1, 読L7-II' },
    { ja : '分割払い|ぶんかつばらい', en : 'payment in installments', l : '読L20-漢字表' },
    { ja : '文法|ぶんぽう', en : 'grammar', l : '会L11(e), 会L13' },
    { ja : '文明|ぶんめい', en : 'civilization', l : '読L11-漢字表' },
    { ja : '分野|ぶんや', en : 'field; realm', l : '読L17-II' },
    { ja : '文楽|ぶんらく', en : 'Japanese puppet theater; bunraku', l : '会L9(c)' }
  ],
  
  'へ' : [
    { ja : '平日|へいじつ', en : 'weekday', l : '読L11-II' },
    { ja : '平和|へいわ', en : 'peace', l : '読L15-II' },
    { ja : '平和記念資料館|へいわきねんしりょうかん', en : 'Peace Memorial Museum', l : '読L15-II' },
    { ja : 'ページ', en : 'page', l : '会L6' },
    { ja : '～ページ', en : 'page number...', l : '会L11(e)' },
    { ja : '臍|へそ', en : 'navel; belly button', l : 'ワークブック読L1' },
    { ja : '下手|へた（な）', en : 'clumsy; poor at...', l : '会L8' },
    { ja : '別荘|べっそう', en : 'villa; vacation home', l : '会L23' },
    { ja : 'ペット', en : 'pet', l : '会L15' },
    { ja : '別に|べつに', en : 'nothing in particular', l : '会L7' },
    { ja : '別々に|べつべつに', en : 'separately', l : '読L12-漢字表' },
    { ja : 'ベトナム', en : 'Vietnam', l : '読L2-I' },
    { ja : '部屋|へや', en : 'room', l : '会L5' },
    { ja : 'ぺらぺら（な）', en : 'fluent', l : '会L22' },
    { ja : 'ペン', en : 'pen', l : '会L2, 会L2(e)' },
    { ja : '変|へん（な）', en : 'strange; unusual', l : '会L22' },
    { ja : '変化|へんか', en : 'change', l : '読L23-漢字表' },
    { ja : '勉強する|べんきょうする', en : 'to study', v : 'irr', l : '会L3' },
    { ja : '弁護士|べんごし', en : 'lawyer', l : '会L1, 会L13' },
    { ja : '返事|へんじ', en : 'reply', l : '読L11-II' },
    { ja : '変人|へんじん', en : 'eccentric person', l : '読L23-漢字表' },
    { ja : '弁当|べんとう', en : 'boxed lunch', l : '会L9' },
    { ja : '返品する|へんぴんする', en : 'to return (merchandise)', v : 'irr', l : '会L20' },
    { ja : '便利|べんり（な）', en : 'convenient', l : '会L7' }
  ],
  
  'ほ' : [
    { ja : '方言|ほうげん', en : 'dialect', l : '会L11(e)' },
    { ja : '帽子|ぼうし', en : 'hat; cap', l : '会L2' },
    { ja : '放送|ほうそう', en : 'broadcast', l : '読L21-漢字表' },
    { ja : '放っておく|ほうっておく', en : 'to leave (someone/something) alone; to neglect', v : 'u', l : '会L22' },
    { ja : '忘年会|ぼうねんかい', en : 'year-end party', l : '読L22-漢字表' },
    { ja : '抱負|ほうふ', en : 'aspiration; ambition; plan; hopes', l : 'ワークブックL15' },
    { ja : '方法|ほうほう', en : 'method', l : '読L16-漢字表' },
    { ja : '～方面|～ほうめん', en : 'serving...areas', l : '会L10(e)' },
    { ja : '訪問|ほうもん', en : 'visit', l : '読L19-漢字表' },
    { ja : 'ほうれん草|ほうれんそう', en : 'spinach', l : 'ワークブックL13' },
    { ja : 'ボーイフレンド', en : 'boyfriend; male friend', l : 'ワークブックL7' },
    { ja : 'ボーナス', en : 'bonus', l : '会L23' },
    { ja : 'ホーム', en : 'platform', l : '読L22-II, 会L10(e)' },
    { ja : 'ホームシック', en : 'homesickness', l : '会L12' },
    { ja : 'ホームステイ', en : 'homestay; living with a local family', l : '会L8' },
    { ja : 'ホームレス', en : 'homeless', l : '読L15-II' },
    { ja : 'ボール', en : 'ball', l : '会L22' },
    { ja : 'ほかに', en : 'anything else', l : '会L11(e)' },
    { ja : 'ほかの', en : 'other', l : '会L16' },
    { ja : '僕|ぼく', en : 'I (used by men)', l : '会L5' },
    { ja : '北西|ほくせい', en : 'northwest', l : '読L6-漢字表' },
    { ja : 'ポケット', en : 'pocket', l : '読L16-II' },
    { ja : '保険|ほけん', en : 'insurance', l : '会L5(e), 会L15' },
    { ja : '保険に入る|ほけんにはいる', en : 'to buy insurance', v : 'u', l : '会L15' },
    { ja : '母語|ぼご', en : 'mother tongue', l : '読L7-漢字表' },
    { ja : 'ボサノバ', en : 'bossa nova', l : 'ワークブック読L2' },
    { ja : '星|ほし', en : 'star; planet', l : 'ワークブック読L1' },
    { ja : '欲しい|ほしい', en : 'to want', l : '会L14' },
    { ja : '募集|ぼしゅう', en : 'recruitment', l : '会L13' },
    { ja : '～募集|～ぼしゅう', en : 'looking for...', l : '読L11-II' },
    { ja : 'ポスター', en : 'poster', l : '会L21' },
    { ja : 'ホストファミリー', en : 'host family', l : '読L9-II, 会L11' },
    { ja : '北海道|ほっかいどう', en : 'Hokkaido', l : '読L6-漢字表' },
    { ja : '北極|ほっきょく', en : 'North Pole', l : '読L6-漢字表' },
    { ja : 'ポップコーン', en : 'popcorn', l : '会L18' },
    { ja : 'ホテル', en : 'hotel', l : '会L4' },
    { ja : '歩道|ほどう', en : 'sidewalk', l : '読L17-漢字表' },
    { ja : 'ほとんど', en : 'almost', l : '読L23-II' },
    { ja : '骨|ほね', en : 'bone', l : 'ワークブック読L1' },
    { ja : '微笑む|ほほえむ', en : 'to smile', v : 'u', l : '読L20-漢字表' },
    { ja : 'ほめる', en : 'to praise; to say nice things', v : 'ru', l : '会L21' },
    { ja : 'ホラー', en : 'horror', l : '読L11-II' },
    { ja : 'ボランティア', en : 'volunteer', l : '読L11-II' },
    { ja : 'ホワイトデー', en : '"White Day" (yet another gift-giving day)', l : '会L14' },
    { ja : '本|ほん', en : 'book', l : '会L2, 会L2(e)' },
    { ja : '～本|～ほん', en : 'counter for long objects', l : '会L14, 会L14(e)' },
    { ja : '盆踊り|ぼんおどり', en : 'Bon dance (Japanese traditional dance)', l : '会L23' },
    { ja : '香港|ほんこん', en : 'Hong Kong', l : '読L13-漢字表' },
    { ja : '本当ですか|ほんとうですか', en : 'Really?', l : '会L6' },
    { ja : '本当に|ほんとうに', en : 'really', l : '読L14-II, 会L18' },
    { ja : '本当は|ほんとうは', en : 'in fact; originally', l : '会L19' },
    { ja : '本音|ほんね', en : 'real intention', l : '読L14-漢字表' },
    { ja : '本屋|ほんや', en : 'bookstore', l : '会L4' },
    { ja : '翻訳する|ほんやくする', en : 'to translate', v : 'irr', l : '会L22' }
  ],
  
  'ま' : [
    { ja : 'マーク', en : 'mark', l : '読L23-II' },
    { ja : 'まあまあ', en : 'okay; so-so', l : '会L11' },
    { ja : '～枚|～まい', en : 'counter for flat objects', l : '会L5, 会L14(e)' },
    { ja : '毎朝|まいあさ', en : 'every morning', l : '会L19' },
    { ja : '毎週|まいしゅう', en : 'every week', l : '会L8' },
    { ja : '枚数|まいすう', en : 'number of flat things', l : '読L20-漢字表' },
    { ja : '毎月|まいつき', en : 'every month', l : '読L18-III' },
    { ja : 'マイナス', en : 'minus', l : '会L12' },
    { ja : '毎日|まいにち', en : 'every day', l : '会L3' },
    { ja : '毎年|まい(ねん/とし)', en : 'every year', l : '読L7-漢字表' },
    { ja : '毎晩|まいばん', en : 'every night', l : '会L3' },
    { ja : '参る|まいる', en : 'extra-modest exp. for いく and くる', v : 'u', l : '会L20' },
    { ja : '前|まえ', en : 'front; before...', l : '会L4, 会L17' },
    { ja : '前売り|まえうり', en : 'advance sale', l : '読L9-漢字表' },
    { ja : '前髪|まえがみ', en : 'forelock; bangs', l : '会L17(e)' },
    { ja : '曲がる|まがる', en : 'to turn (right/left)', v : 'u', l : '会L6(e), 会L20' },
    { ja : 'マクドナルド', en : "McDonald's", l : '会L3' },
    { ja : '鮪|まぐろ', en : 'tuna', l : '会L18(c)' },
    { ja : '負ける|まける', en : 'to lose (a match)', v : 'ru', l : '会L22' },
    { ja : '誠に|まことに', en : 'really (very polite)', l : '会L20' },
    { ja : 'マスコット', en : 'mascot', l : '会L20' },
    { ja : 'まじめ（な）', en : 'serious; sober; diligent', l : '読L12-II, 会L19' },
    { ja : 'まず', en : 'first of all', l : '読L8-II, 会L18' },
    { ja : 'まずい', en : '(food is) terrible', l : '会L23' },
    { ja : 'また', en : 'again; in addition', l : '読L5-II, 読L16-II, 会L20' },
    { ja : 'まだ', en : 'still; not...yet (with neg. verb)', l : '会L8, 会L19' },
    { ja : '待たせる|またせる', en : 'to keep (someone) waiting', v : 'ru', l : '会L20' },
    { ja : '町|まち', en : 'town; city', l : '会L4' },
    { ja : '待合室|まちあいしつ', en : 'waiting room', l : '読L16-漢字表' },
    { ja : '待ち合わせをする|まちあわせをする', en : 'to meet up', v : 'irr', l : '読L15-II' },
    { ja : '間違い|まちがい', en : 'mistake', l : '会L19' },
    { ja : '間違える|まちがえる', en : 'to make a mistake', v : 'ru', l : '会L21' },
    { ja : '待ち遠しい|まちどおしい', en : 'to wait eagerly for...', l : '読L22-II' },
    { ja : '待つ|まつ', en : 'to wait', v : 'u', l : '会L4' },
    { ja : 'まっすぐ', en : 'straight', l : '会L6(e), 読L6-I' },
    { ja : '全く|まったく', en : 'entirely', l : '読L16-漢字表' },
    { ja : '祭り|まつり', en : 'festival', l : '会L11' },
    { ja : '～まで', en : 'until (a time); to (a place); as far as', l : '会L5' },
    { ja : '～までに', en : 'by (time/date)', l : '読L12-II, 会L18' },
    { ja : '窓|まど', en : 'window', l : '会L2(e), 会L6' },
    { ja : '的|まと', en : 'target', l : '読L18-漢字表' },
    { ja : '窓口|まどぐち', en : 'counter', l : '会L5(e)' },
    { ja : '纏め|まとめ', en : 'settlement; conclusion; summary', l : '会L1' },
    { ja : '学ぶ|まなぶ', en : 'to study', v : 'u', l : '読L6-漢字表' },
    { ja : '間に合う|まにあう', en : 'to be in time', v : 'u', l : '会L22' },
    { ja : 'マフラー', en : 'winter scarf', l : '会L14' },
    { ja : 'マヤ', en : 'Maya (ancient Indian tribe in Central America)', l : 'ワークブック読L2' },
    { ja : '眉毛|まゆげ', en : 'eyebrows', l : '会L7(e)' },
    { ja : '真夜中|まよなか', en : 'midnight', l : '読L17-漢字表' },
    { ja : '〇|まる', en : 'correct', l : '会L11(e)' },
    { ja : '円い|まるい', en : 'round', l : '読L3-漢字表' },
    { ja : 'マレーシア', en : 'Malaysia', l : '読L2-I' },
    { ja : '回す|まわす', en : 'to turn', v : 'u', l : '読L22-漢字表' },
    { ja : '満員電車|まんいんでんしゃ', en : 'jam-packed train', l : '読L13-III' },
    { ja : '漫画|まんが', en : 'comic book', l : '会L14' },
    { ja : '漫画家|まんがか', en : 'cartoonist', l : '会L11' },
    { ja : 'まんじゅう', en : 'sweet bun', l : '読L4-III' },
    { ja : 'マンション', en : 'multi-story apartment building; condominium', l : '会L14' },
    { ja : '真ん中|まんなか', en : 'center', l : '読L17-漢字表' }
  ],
  
  'み' : [
    { ja : '見える|みえる', en : 'to be visible', v : 'ru', l : '会L15' },
    { ja : '磨く|みがく', en : 'to brush (teeth); to polish', v : 'u', l : '会L13' },
    { ja : '味方|みかた', en : "person on one's side", l : '読L16-II' },
    { ja : 'みかん', en : 'mandarin orange', l : '会L14' },
    { ja : '右|みぎ', en : 'right', l : '会L4' },
    { ja : '右側|みぎがわ', en : 'right side', l : '会L6(e)' },
    { ja : '右手|みぎて', en : 'right hand', l : '読L6-漢字表' },
    { ja : '未婚|みこん', en : 'unmarried', l : '読L17-漢字表' },
    { ja : '短い|みじかい', en : 'short (length)', l : '会L7' },
    { ja : '水|みず', en : 'water', l : '会L3' },
    { ja : '水色|みずいろ', en : 'light blue', l : '会L9(e)' },
    { ja : '湖|みずうみ', en : 'lake', l : '会L11' },
    { ja : '水着|みずぎ', en : 'bathing suit', l : '読L4-漢字表' },
    { ja : '水不足|みずぶそく', en : 'lack of water; water shortage', l : '読L15-漢字表' },
    { ja : '店|みせ', en : 'shop; store', l : '読L4-III, 会L13' },
    { ja : '見せる|みせる', en : 'to show', v : 'ru', l : '会L16' },
    { ja : '味噌|みそ', en : 'soybean paste', l : '読L15-漢字表' },
    { ja : '味噌汁|みそしる', en : 'miso soup', l : '会L8(c)' },
    { ja : '～みたいなＸ', en : 'X such as...', l : '会L20' },
    { ja : '道|みち', en : 'way; road; directions', l : '会L16' },
    { ja : '道に迷う|みちにまよう', en : "to become lost; to lose one's way", v : 'u', l : '会L16' },
    { ja : '三日|みっか', en : 'the third day of a month; three days', l : '会L4(e), 会L13' },
    { ja : '見つかる|みつかる', en : 'to be found', v : 'u', l : '会L16' },
    { ja : '見つける|みつける', en : 'to find', v : 'ru', l : '読L12-II, 会L21' },
    { ja : '三つ|みっつ', en : 'three', l : '会L9' },
    { ja : '緑|みどり', en : 'green', l : '会L9(e), 読L15-II' },
    { ja : '皆様|みなさま', en : 'everyone (polite exp. of みなさん)', l : '読L19-II' },
    { ja : '皆さん|みなさん', en : 'everyone; all of you', l : '読L6-III, 会L14' },
    { ja : '港|みなと', en : 'port', l : '読L13-漢字表' },
    { ja : '南|みなみ', en : 'south', l : '会L6(e), 読L15-II' },
    { ja : '南口|みなみぐち', en : 'south exit', l : '読L6-漢字表' },
    { ja : 'ミニ', en : 'mini; miniskirt', l : 'ワークブック読L2' },
    { ja : '身ぶり|みぶり', en : 'gesture', l : '読L20-II' },
    { ja : '～未満|～みまん', en : 'less than...', l : '読L18-II' },
    { ja : '耳|みみ', en : 'ear', l : '会L7(e)' },
    { ja : '土産|みやげ', en : 'souvenir', l : '会L4' },
    { ja : 'ミュージカル', en : 'musical', l : 'ワークブックL11' },
    { ja : '名字|みょうじ', en : 'family name', l : '読L17-漢字表' },
    { ja : '未来|みらい', en : 'future', l : '読L16-II' },
    { ja : '見る|みる', en : 'to see; to look at; to watch', v : 'ru', l : '会L3' },
    { ja : 'ミルク', en : 'milk', l : '会L2' },
    { ja : '民族|みんぞく', en : 'race; ethnic group', l : '読L14-漢字表' },
    { ja : 'みんな', en : 'all', l : '読L7-II, 会L9' },
    { ja : 'みんなで', en : 'all (of the people) together', l : '会L8' }
  ],
  
  'む' : [
    { ja : '六日|むいか', en : 'the sixth day of a month; six days', l : '会L4(e), 会L13' },
    { ja : 'ムード', en : 'mood', l : 'ワークブック読L2' },
    { ja : '迎えに行く|むかえにいく', en : 'to go to pick up', v : 'u', l : '会L16' },
    { ja : '迎えに来る|むかえにくる', en : 'to come to pick up', v : 'irr', l : '会L16' },
    { ja : '昔|むかし', en : 'old days; past', l : '読L15-II, 会L21' },
    { ja : '昔話|むかしばなし', en : 'old tale', l : '読L12-漢字表' },
    { ja : '昔々|むかしむかし', en : 'once upon a time', l : '読L10-II' },
    { ja : '向こう|むこう', en : 'the other side; over there', l : '読L12-II' },
    { ja : '虫|むし', en : 'insect', l : '会L18' },
    { ja : '虫めがね|むしめがね', en : 'magnifying glass', l : '読L17-II' },
    { ja : '難しい|むずかしい', en : 'difficult', l : '会L5' },
    { ja : '結ぶ|むすぶ', en : 'to tie a knot', v : 'u', l : '読L17-漢字表' },
    { ja : '娘|むすめ', en : 'daughter', l : '読L12-II' },
    { ja : '無駄遣い|むだづかい', en : 'waste (money)', l : '会L22' },
    { ja : '無駄|むだ（な）', en : 'wasteful', l : '読L20-漢字表' },
    { ja : '六つ|むっつ', en : 'six', l : '会L9' },
    { ja : '胸|むね', en : 'chest; breast', l : '会L7(e)' },
    { ja : '紫|むらさき', en : 'purple', l : '会L9(e)' },
    { ja : '無理|むり（な）', en : 'impossible', l : '読L20-II' },
    { ja : '無料|むりょう', en : 'free (of charge); gratuitous', l : '読L20-漢字表' }
  ],
  
  'め' : [
    { ja : '目|め', en : 'eye', l : '会L7, 会L7(e)' },
    { ja : '～目|～め', en : '-th', l : '会L15' },
    { ja : '～名|～めい', en : '...person(s)', l : '会L15(e)' },
    { ja : '～名様|～めいさま', en : 'party of...people', l : '会L19' },
    { ja : '名刺|めいし', en : 'name card', l : '読L9-漢字表' },
    { ja : '迷信|めいしん', en : 'superstition', l : '読L21-II' },
    { ja : 'メール', en : 'e-mail', l : '会L4' },
    { ja : '目上の人|めうえのひと', en : "one's superiors", l : '読L18-漢字表' },
    { ja : '眼鏡|めがね', en : 'glasses', l : '会L7' },
    { ja : 'メキシコ', en : 'Mexico', l : '読L5-II' },
    { ja : '目薬|めぐすり', en : 'eye drops', l : '読L18-漢字表' },
    { ja : '目覚まし時計|めざましどけい', en : 'alarm clock', l : '会L16' },
    { ja : '召し上がる|めしあがる', en : 'honorific exp. for たべる and のむ', v : 'u', l : '会L19' },
    { ja : 'めずらしい', en : 'rare', l : '読L13-II' },
    { ja : 'めちゃくちゃ（な）', en : 'messy; disorganized', l : '会L21' },
    { ja : 'めったに～ない', en : 'seldom', l : '読L21-II' },
    { ja : 'メッセージ', en : 'message', l : '読L11-II' },
    { ja : '目を覚ます|めをさます', en : 'to wake up', l : 'ワークブック読L1' },
    { ja : 'メニュー', en : 'menu', l : '会L2' },
    { ja : 'メモ', en : 'memo; note; memorandum', l : 'ワークブック読L2' },
    { ja : '免許|めんきょ', en : 'license', l : '会L22' },
    { ja : '面接|めんせつ', en : 'interview', l : '会L23' },
    { ja : 'メンバー', en : 'member; participant; attendee', l : '読L17-II' }
  ],
  
  'も' : [
    { ja : 'もう', en : 'already', l : '会L9' },
    { ja : 'もう一度|もういちど', en : 'one more time', l : '会L15' },
    { ja : '申し込み|もうしこみ', en : 'application', l : '読L19-III' },
    { ja : '申し訳ありません|もうしわけありません', en : 'You have my apologies.', l : '読L19-III, 会L20' },
    { ja : '申す|もうす', en : 'extra-modest exp. for いう', v : 'u', l : '会L20' },
    { ja : 'もうすぐ', en : 'very soon; in a few moments/days', l : '会L12' },
    { ja : 'もう少し|もうすこし', en : 'a little more', l : '会L22' },
    { ja : '盲導犬|もうどうけん', en : 'seeing-eye dog', l : '読L21-漢字表' },
    { ja : 'もう～ない', en : 'not any longer', l : '読L13-II' },
    { ja : '目次|もくじ', en : 'table of contents', l : '読L8-漢字表' },
    { ja : '目的|もくてき', en : 'object; purpose', l : '読L18-II' },
    { ja : '木曜日|もくようび', en : 'Thursday', l : '会L4, 会L4(e)' },
    { ja : '文字|もじ', en : 'letter; character', l : '読L17-II' },
    { ja : 'もし～たら', en : 'if...', l : '読L19-III' },
    { ja : 'もしもし', en : 'Hello? (used on the phone)', l : '会L7' },
    { ja : 'モスクワ', en : 'Moscow (Russia)', l : 'ワークブックL12' },
    { ja : 'もち', en : 'rice cake', l : '読L10-II' },
    { ja : '持ち主|もちぬし', en : 'owner', l : '読L17-漢字表' },
    { ja : 'もちろん', en : 'of course', l : '会L7' },
    { ja : '持つ|もつ', en : 'to carry; to hold', v : 'u', l : '会L6' },
    { ja : '持っていく|もっていく', en : 'to take (a thing)', v : 'u', l : '会L8' },
    { ja : '持ってくる|もってくる', en : 'to bring (a thing)', v : 'irr', l : '会L6' },
    { ja : 'もっと', en : 'more', l : '会L11' },
    { ja : 'モットー', en : 'motto', l : 'ワークブックL23' },
    { ja : '最も|もっとも', en : 'most', l : '読L20-漢字表' },
    { ja : '持てる|もてる', en : 'to be popular (in terms of romantic interest)', v : 'ru', l : '会L19' },
    { ja : '戻ってくる|もどってくる', en : '(something/someone) comes back', v : 'irr', l : '会L23' },
    { ja : '戻る|もどる', en : 'to return; to come/go back', v : 'u', l : '読L16-II, 会L20' },
    { ja : '物|もの', en : 'thing (concrete object)', l : '会L12' },
    { ja : 'ものすごく', en : 'extremely', l : '会L23' },
    { ja : 'もみあげ', en : 'sideburns', l : '会L17(e)' },
    { ja : 'もも', en : 'peach', l : '会L8(e)' },
    { ja : '靄|もや', en : 'fog; mist; haze', l : 'ワークブック読L1' },
    { ja : 'もらう', en : 'to get (from somebody)', v : 'u', l : '会L9' },
    { ja : '文句|もんく', en : 'complaint', l : '会L21' },
    { ja : '文句を言う|もんくをいう', en : 'to complain', v : 'u', l : '会L21' },
    { ja : 'モンゴル', en : 'Mongolia', l : 'ワークブックL13' },
    { ja : '問題|もんだい', en : 'problem; question', l : '読L18-漢字表' }
  ],
  
  'や' : [
    { ja : '～屋|～や', en : '...shop', l : '会L20' },
    { ja : '焼き魚|やきざかな', en : 'grilled fish; broiled fish', l : '会L8(c)' },
    { ja : '焼き鳥|やきとり', en : 'grilled chicken', l : '読L13-漢字表' },
    { ja : '野球|やきゅう', en : 'baseball', l : '会L10' },
    { ja : '野球選手|やきゅうせんしゅ', en : 'baseball player', l : '会L11' },
    { ja : '焼く|やく', en : 'to bake; to burn; to grill', v : 'u', l : '会L21' },
    { ja : 'やくざ', en : 'yakuza; gangster', l : '会L13' },
    { ja : '訳す|やくす', en : 'to translate', v : 'u', l : '会L16' },
    { ja : '約束|やくそく', en : 'promise; appointment', l : '会L13' },
    { ja : '約束を守る|やくそくをまもる', en : 'to keep a promise', v : 'u', l : '会L13' },
    { ja : '厄年|やくどし', en : 'unlucky year; critical year', l : '読L21-II' },
    { ja : '野菜|やさい', en : 'vegetable', l : '会L2' },
    { ja : 'やさしい', en : 'easy (problem); kind (person)', l : '会L5' },
    { ja : '安い|やすい', en : 'inexpensive; cheap (thing)', l : '会L5' },
    { ja : '休み|やすみ', en : 'holiday; day off; absence', l : '会L5' },
    { ja : '休む|やすむ', en : 'to be absent (from); to rest', v : 'u', l : '会L6' },
    { ja : 'やせています', en : 'to be thin', l : '会L7' },
    { ja : 'やせる', en : 'to lose weight', v : 'ru', l : '会L7' },
    { ja : '家賃|やちん', en : 'rent', l : '会L18' },
    { ja : 'やった！', en : 'I did it!', l : '読L20-II' },
    { ja : '八つ|やっつ', en : 'eight', l : '会L9' },
    { ja : 'やっぱり', en : 'after all; as I thought', l : '読L13-II, 会L17' },
    { ja : '宿|やど', en : 'inn', l : '読L18-漢字表' },
    { ja : '山|やま', en : 'mountain', l : '読L5-II, 会L11' },
    { ja : '山道|やまみち', en : 'mountain road', l : '読L10-II' },
    { ja : 'やめる', en : 'to quit', v  : 'ru', l : '会L11' },
    { ja : 'やる', en : 'to do; to perform; to give (to pets, plants, siblings, etc.)', v : 'u', l : '会L5, 会L21' }
  ],
  
  'ゆ' : [
    { ja : '夕方|ゆうがた', en : 'evening', l : '会L18' },
    { ja : '夕刊|ゆうかん', en : 'evening newspaper', l : '読L22-漢字表' },
    { ja : '勇気|ゆうき', en : 'courage', l : '読L22-II' },
    { ja : 'ユーザー', en : 'user', l : 'ワークブック読L2' },
    { ja : '友情|ゆうじょう', en : 'friendship', l : '読L9-漢字表' },
    { ja : '優勝する|ゆうしょうする', en : 'to win a championship', v : 'irr', l : '会L23' },
    { ja : '夕食|ゆうしょく', en : 'dinner', l : '会L23' },
    { ja : '友人|ゆうじん', en : 'friend', l : '読L19-III' },
    { ja : '有能|ゆうのう（な）', en : 'talented', l : '読L11-漢字表' },
    { ja : '夕日|ゆうひ', en : 'setting sun', l : '読L22-漢字表' },
    { ja : '郵便局|ゆうびんきょく', en : 'post office', l : '会L2' },
    { ja : '有名|ゆうめい（な）', en : 'famous', l : '会L8' },
    { ja : '有名人|ゆうめいじん', en : 'celebrity', l : '会L10' },
    { ja : '有料|ゆうりょう', en : 'toll; fee', l : '読L11-漢字表' },
    { ja : '雪|ゆき', en : 'snow', l : '読L10-II, 会L12' },
    { ja : '雪だるま|ゆきだるま', en : 'snowman', l : '読L10-漢字表' },
    { ja : '輸出|ゆしゅつ', en : 'export', l : '読L6-漢字表' },
    { ja : 'ゆっくり', en : 'slowly; leisurely; unhurriedly', l : '会L6' },
    { ja : '輸入|ゆにゅう', en : 'import', l : '読L7-漢字表' },
    { ja : '指|ゆび', en : 'finger', l : '会L7(e)' },
    { ja : '指輪|ゆびわ', en : 'ring', l : '会L14' },
    { ja : '夢|ゆめ', en : 'dream', l : '会L11' }
  ],
  
  'よ' : [
    { ja : '夜明け|よあけ', en : 'dawn', l : '読L10-漢字表' },
    { ja : '用意する|よういする', en : 'to prepare', l : '読L15-漢字表' },
    { ja : '八日|ようか', en : 'the eighth day of a month; eight days', l : '会L4(e), 会L13' },
    { ja : 'ようこそ', en : 'Welcome.', l : '会L19' },
    { ja : '用事|ようじ', en : 'business to take care of', l : '会L12' },
    { ja : '洋食|ようしょく', en : 'Western food', l : '読L18-漢字表' },
    { ja : '様子|ようす', en : 'manner', l : '読L19-漢字表' },
    { ja : '腰痛|ようつう', en : 'lower back pain', l : '読L20-漢字表' },
    { ja : '曜日|ようび', en : 'day of the week', l : '読L4-漢字表' },
    { ja : '洋服|ようふく', en : 'Western clothes', l : '読L18-II' },
    { ja : 'ヨーグルト', en : 'yogurt', l : '会L8(c)' },
    { ja : 'ヨーロッパ', en : 'Europe', l : '会L22' },
    { ja : 'よかったら', en : 'if you like', l : '会L7' },
    { ja : 'ヨガ', en : 'yoga', l : 'ワークブックL3' },
    { ja : '預金|よきん', en : 'savings', l : '会L13(e)' },
    { ja : 'よく', en : 'often; much; well', l : '会L3, 会L14' },
    { ja : '横|よこ', en : 'side; horizontal', l : '読L23-II' },
    { ja : '横書き|よこがき', en : 'horizontal writing', l : '読L23-漢字表' },
    { ja : '汚す|よごす', en : 'to make dirty', v : 'u', l : '会L18' },
    { ja : '横綱|よこづな', en : 'grand champion of sumo', l : '読L23-漢字表' },
    { ja : '横浜|よこはま', en : 'Yokohama (city)', l : 'ワークブックL4' },
    { ja : '汚れる|よごれる', en : 'to become dirty', v : 'ru', l : '会L18' },
    { ja : '四時|よじ', en : "four o'clock", l : '会L1(e)' },
    { ja : '予習|よしゅう', en : 'preparation of lessons', l : '会L22' },
    { ja : '四日|よっか', en : 'the fourth day of a month; four days', l : '会L4(e), 会L13' },
    { ja : '四つ|よっつ', en : 'four', l : '会L9' },
    { ja : 'ヨット', en : 'yacht; sailboat', l : 'ワークブック読L2' },
    { ja : '予定|よてい', en : 'schedule; plan', l : '会L15' },
    { ja : '夜中|よなか', en : 'midnight', l : '読L10-漢字表' },
    { ja : '四年生|よねんせい', en : 'fourth-year student', l : '読L3-漢字表' },
    { ja : '世の中|よのなか', en : 'the society', l : '読L16-漢字表' },
    { ja : '予備校|よびこう', en : 'prep school', l : '会L22(c)' },
    { ja : '呼ぶ|よぶ', en : "to call (one's name); to invite", v : 'u', l : '会L19' },
    { ja : '読み方|よみかた', en : 'way of reading', l : '読L16-漢字表' },
    { ja : '読み物|よみもの', en : 'reading matter; reading material', l : '読L8-漢字表' },
    { ja : '読む|よむ', en : 'to read', v : 'u', l : '会L3' },
    { ja : '予約|よやく', en : 'reservation', l : '会L10' },
    { ja : '予約する|よやくする', en : 'to reserve', v : 'irr', l : '会L15' },
    { ja : '夜|よる', en : 'night', l : '読L5-II, 会L6' },
    { ja : '寄る|よる', en : 'to stop by', v : 'u', l : '会L19' },
    { ja : 'よろしかったら', en : 'if it is okay (polite)', l : '会L20' },
    { ja : 'よろしくお伝えください|よろしくおつたえください', en : 'Please give my best regards (to...)', l : '会L19' },
    { ja : 'よろしくお願いします|よろしくおねがいします', en : 'Nice to meet you.', l : '会G' },
    { ja : '弱い|よわい', en : 'weak', l : '読L16-II' },
    { ja : '四|よん', en : 'four', l : '読L3-漢字表' },
    { ja : '四歳|よんさい', en : 'four years old', l : '会L1(e)' },
    { ja : '四分|よんぷん', en : 'four minutes', l : '会L1(e)' }
  ],
  
  'ら' : [
    { ja : 'ラーメン', en : 'ramen', l : 'ワークブック読L2' },
    { ja : '来学期|らいがっき', en : 'next semester', l : '会L10' },
    { ja : '来月|らいげつ', en : 'next month', l : '会L4(e), 会L8' },
    { ja : '来週|らいしゅう', en : 'next week', l : '会L4(e), 会L6' },
    { ja : '来日|らいにち', en : 'arrival in Japan; visit to Japan', l : '読L9-漢字表' },
    { ja : '来年|らいねん', en : 'next year', l : '会L4(e), 会L6' },
    { ja : 'ライト', en : 'light', l : 'ワークブックL18' },
    { ja : 'ライブ', en : 'live (concert, short, etc.); live performance', l : 'ワークブックL6' },
    { ja : 'ライブのチケット', en : 'concert ticket', l : 'ワークブックL6' },
    { ja : '楽|らく（な）', en : 'easy; comfortable', l : '会L22' },
    { ja : '落語|らくご', en : 'comic monologue', l : '読L20-II' },
    { ja : '落語家|らくごか', en : 'comic storyteller', l : '読L20-II' },
    { ja : 'ラジオ', en : 'radio', l : '会L14' },
    { ja : 'ラッシュ', en : 'the rush hour', l : '読L13-III' }
  ],
  
  'り' : [
    { ja : 'リオデジャネイロ', en : 'Rio de Janeiro (Brazil)', l : '会L1' },
    { ja : '離婚|りこん', en : 'divorce', l : '読L17-漢字表' },
    { ja : '離婚する|りこんする', en : 'to get a divorce', v : 'irr', l : '会L17' },
    { ja : '力士|りきし', en : 'sumo wrestler', l : '読L18-漢字表' },
    { ja : '理想|りそう', en : 'ideal', l : '会L23' },
    { ja : '理由|りゆう', en : 'reason', l : '読L13-漢字表' },
    { ja : '留学する|りゅうがくする', en : 'to study abroad', v : 'irr', l : '会L11' },
    { ja : '留学生|りゅうがくせい', en : 'international student', l : '会L1' },
    { ja : '両|りょう', en : 'a unit of currency used in the Edo period', l : '読L20-II' },
    { ja : '寮|りょう', en : 'dormitory', l : '読L9-II, 会L17' },
    { ja : '了解|りょうかい', en : 'comprehension; understanding; OK; roger', l : 'ワークブックL6' },
    { ja : '両替|りょうがえ', en : 'exchange', l : '読L20-漢字表' },
    { ja : '料金|りょうきん', en : 'charge', l : '読L4-漢字表' },
    { ja : '両親|りょうしん', en : 'parents', l : '会L14' },
    { ja : '両手|りょうて', en : 'both hands', l : '読L20-漢字表' },
    { ja : '両方|りょうほう', en : 'both; both sides', l : '読L16-漢字表' },
    { ja : '料理|りょうり', en : 'cooking', l : '読L6-III' },
    { ja : '料理する|りょうりする', en : 'to cook', v : 'irr', l : '会L8' },
    { ja : '旅館|りょかん', en : 'Japanese inn', l : '会L15' },
    { ja : '旅行|りょこう', en : 'travel', l : '会L5' },
    { ja : '旅行会社|りょこうがいしゃ', en : 'travel agency', l : '会L17' },
    { ja : '旅行する|りょこうする', en : 'to travel', v : 'irr', l : '会L10' },
    { ja : '旅券|りょけん', en : 'passport', l : '読L11-漢字表' },
    { ja : '履歴書|りれきしょ', en : 'resume; résumé', l : '会L14' },
    { ja : '理論|りろん', en : 'theory', l : 'ワークブック読L1' },
    { ja : 'りんご', en : 'apple', l : '会L10' }
  ],
  
  'る' : [
    { ja : 'ルームメート／ルームメイト', en : 'roommate', l : '会L11' },
    { ja : 'ルーレット', en : 'roulette', l : 'ワークブック読L2' },
    { ja : '留守|るす', en : 'absence; not at home', l : '会L21' },
    { ja : '留守番|るすばん', en : "looking after a house during someone's absence", l : '会L23' },
    { ja : '留守番電話|るすばんでんわ', en : 'answering machine', l : '会L18' },
    { ja : 'ルワンダ', en : 'Rwanda', l : '読L2-I' }
  ],
  
  'れ' : [
    { ja : '例|れい', en : 'example', l : '会L11(e)' },
    { ja : '冷蔵庫|れいぞうこ', en : 'refrigerator', l : '会L18' },
    { ja : '歴史|れきし', en : 'history', l : '会L1, 会L2' },
    { ja : 'レシピ', en : 'recipe', l : 'ワークブックL20' },
    { ja : 'レストラン', en : 'restaurant', l : '会L4' },
    { ja : 'レポート', en : '(term) paper', l : '会L13' },
    { ja : 'レモン', en : 'lemon', l : '読L2-I' },
    { ja : 'レモンティー', en : 'lemon tea', l : '読L2-I' },
    { ja : '連休|れんきゅう', en : 'consecutive holidays', l : '読L12-漢字表' },
    { ja : '練習|れんしゅう', en : 'practice; exercise', l : '会L11(e)' },
    { ja : '練習する|れんしゅうする', en : 'to practice', v : 'irr', l : '会L10' },
    { ja : '連続ドラマ|れんぞくドラマ', en : 'serial TV drama', l : '読L20-漢字表' },
    { ja : 'レントゲン', en : 'X-ray', l : '会L12(e)' },
    { ja : '連絡する|れんらくする', en : 'to contact', v : 'irr', l : '会L21' }
  ],
  
  'ろ' : [
    { ja : 'ろうそく', en : 'candle', l : '会L18' },
    { ja : '労働|ろうどう', en : 'labor', l : '読L12-漢字表' },
    { ja : '六|ろく', en : 'six', l : '読L3-漢字表' },
    { ja : '六月|ろくがつ', en : 'June', l : '会L4(e)' },
    { ja : '六歳|ろくさい', en : 'six years old', l : '会L1(e)' },
    { ja : '六時|ろくじ', en : "six o'clock", l : '会L1(e)' },
    { ja : 'ロシア', en : 'Russia', l : 'ワークブックL10' },
    { ja : '六甲山|ろっこうさん', en : 'Mt. Rokko', l : 'ワークブックL17' },
    { ja : '六百|ろっぴゃく', en : 'six hundred', l : '読L3-漢字表' },
    { ja : '六分|ろっぷん', en : 'six minutes', l : '会L1(e)' },
    { ja : 'ロック', en : 'lock; rock (music)', l : '読L17-II' },
    { ja : 'ロックバンド', en : 'rock band', l : '読L17-II' },
    { ja : 'ロボット', en : 'robot', l : '読L16-II' },
    { ja : 'ロンドン', en : 'London', l : 'ワークブックL1' }
  ],
  
  'わ' : [
    { ja : 'ワイン', en : 'wine', l : '読L6-III' },
    { ja : '若い|わかい', en : 'young', l : '会L9' },
    { ja : '沸かす|わかす', en : 'to boil; to heat; to excite', v : 'u', l : '会L18' },
    { ja : '分かる|わかる', en : 'to understand', v : 'u', l : '会L4' },
    { ja : '若者|わかもの', en : 'young people', l : '読L14-漢字表' },
    { ja : '別れる|わかれる', en : 'to break up; to separate', v : 'ru', l : '会L12' },
    { ja : '若々しい|わかわかしい', en : 'youthful', l : '読L21-漢字表' },
    { ja : '分け目|わけめ', en : 'dividing line; parting (of the hair); partition; crisis', l : '会L17(e)' },
    { ja : '分ける|わける', en : 'to divide', v : 'ru', l : '読L6-漢字表' },
    { ja : '和紙|わし', en : 'Japanese paper', l : '読L11-漢字表' },
    { ja : 'ワシントンＤＣ', en : 'Washington, DC (U.S. capital)', l : '読L2-I' },
    { ja : '忘れ物|わすれもの', en : 'lost article; something forgotten', l : '読L22-漢字表' },
    { ja : '忘れる|わすれる', en : 'to forget; to leave behind', v : 'ru', l : '会L6' },
    { ja : '話題|わだい', en : 'topic of conversation', l : '読L18-漢字表' },
    { ja : '私|わたし', en : 'I; I (formal: わたくし)', l : '会L1, 会L13' },
    { ja : '私たち|わたしたち', en : 'we', l : '読L12-II, 会L14' },
    { ja : '渡す|わたす', en : 'to give; to hand', v : 'u', l : '読L20-II' },
    { ja : '渡る|わたる', en : 'to cross', v : 'u', l : '会L6(e)' },
    { ja : 'ワックス', en : 'wax (for polishing)', l : 'ワークブック読L2' },
    { ja : '和風|わふう', en : 'Japanese style', l : '読L21-漢字表' },
    { ja : '和服|わふく', en : 'Japanese clothes', l : '読L18-漢字表' },
    { ja : '笑う|わらう', en : 'to laugh; to smile', v : 'u', l : '会L16' },
    { ja : '割引券|わりびきけん', en : 'discount coupon', l : '会L15' },
    { ja : '悪い|わるい', en : 'bad', l : '会L12' },
    { ja : '悪口を言う|わるぐちをいう', en : "to talk behind someone's back", v : 'u', l : '会L23' },
    { ja : 'ワンルームマンション', en : 'one-room apartment; a studio', l : '読L18-III' }
  ]
  
};
