﻿# Genki Study Resources
Genki Study Resources is a website that offers a vast collection of exercises for practicing what is taught in [Genki: An Integrated Course in Elementary Japanese](http://genki.japantimes.co.jp/index_en). It was mainly created to help aid with self-study, as such, you can use it online or offline depending on your needs. Choose one of the links below to begin testing the Japanese you've learned in Genki!


**Online Version:** [2nd Edition](https://sethclydesdale.github.io/genki-study-resources/) | [3rd Edition](https://sethclydesdale.github.io/genki-study-resources/lessons-3rd/)

**Offline Version:** [download](https://github.com/SethClydesdale/genki-study-resources/archive/master.zip)

If you're interested in learning Japanese, please see [this guide](https://sethclydesdale.github.io/genki-study-resources/help/japanese-guide/)!

-----

**Quick Links**
- [Using the Offline Version](#using-the-offline-version)
- [Keyboard Shortcuts](#keyboard-shortcuts)
- [Suggestions, Feedback, Bug Reports](#suggestions-feedback-bug-reports)
- [Resources for Studying Japanese](#resources-for-studying-japanese)
- [Special Thanks](#special-thanks)
- [Donate](#donate)


### Using the Offline Version
If you're using the offline version you'll have to unzip the files. Once you've done that, you can access all the study resources by opening any of the [**index.html**](https://i62.servimg.com/u/f62/18/21/41/30/captur11.png) files in the browser of your choice. It should have the same experience as the online version, however, whenever new exercises/lessons are added they will not be available; you'll have to download the latest version of the repository to get them.

**If icons are broken:** If you use Firefox and icons appear broken, then please see [this topic](https://sethclydesdale.github.io/genki-study-resources/help/broken-icons/) to resolve the issue.

**If settings will not save:** If your settings will not save, such as furigana preference or dark mode, please see [this topic](https://sethclydesdale.github.io/genki-study-resources/help/stuck-loading/) for resolving the issue.


### Keyboard Shortcuts
Genki Study Resources supports a few keyboard shortcuts which you can use to make things easier. These shortcuts are typically used via <kbd>CTRL</kbd>+<kbd>ALT</kbd>+<kbd>KEY</kbd> for Windows and <kbd>CMD</kbd>+<kbd>SHIFT</kbd>+<kbd>KEY</kbd> for Mac.

#### Global
Shortcuts that can be used anywhere.

| Shortcut | Description |
| -------- | ----------- |
| <kbd>CTRL</kbd>+<kbd>ALT</kbd>+<kbd>D</kbd> | Toggle Dark Mode on/off |
| <kbd>CTRL</kbd>+<kbd>ALT</kbd>+<kbd>M</kbd> | Open Settings Manager |

#### Exercises
Shortcuts that can only be used in exercises.

| Shortcut | Description |
| -------- | ----------- |
| <kbd>CTRL</kbd>+<kbd>ALT</kbd>+<kbd>LEFT</kbd> | Navigate to the previous exercise in the lesson |
| <kbd>CTRL</kbd>+<kbd>ALT</kbd>+<kbd>RIGHT</kbd> | Navigate to the next exercise in the lesson |
| <kbd>CTRL</kbd>+<kbd>ALT</kbd>+<kbd>R</kbd> | Navigate to a random exercise |
| <kbd>CTRL</kbd>+<kbd>ALT</kbd>+<kbd>E</kbd> | Open/Close the Exercise List |
| <kbd>CTRL</kbd>+<kbd>ALT</kbd>+<kbd>Q</kbd> | Open/Close the Quick Dictionary |
| <kbd>CTRL</kbd>+<kbd>ALT</kbd>+<kbd>F</kbd> | Toggle Furigana on/off |
| <kbd>CTRL</kbd>+<kbd>ALT</kbd>+<kbd>C</kbd> | Check answers (for written exercises) |

##### Multiple Choice
The following shortcuts can only be used in multiple choice exercises to quickly select an answer.

| Shortcut | Description |
| -------- | ----------- |
| <kbd>ALT</kbd>+<kbd>A</kbd> | Selects option A |
| <kbd>ALT</kbd>+<kbd>B</kbd> | Selects option B |
| <kbd>ALT</kbd>+<kbd>C</kbd> | Selects option C |
| <kbd>ALT</kbd>+<kbd>D</kbd> | Selects option D |


### Suggestions, Feedback, Bug Reports
If you have any suggestions, feedback, questions, or bugs to report, feel free to [open a new discussion](https://github.com/SethClydesdale/genki-study-resources/discussions) in this repository. For alternative contact methods and detailed reporting information, please see the [report page](https://sethclydesdale.github.io/genki-study-resources/report/) for Genki Study Resources.


### Resources for Studying Japanese

##### Tools
- [Anki - SRS Flashcard App](https://apps.ankiweb.net/) (great for memorizing vocab; you can find decks for Genki [here](https://sethclydesdale.github.io/genki-study-resources/help/anki-decks/))
- [Jisho - Online Japanese Dictionary](http://jisho.org/) (extremely useful for looking up words, kanji, etc.)
- [Jotoba - Japanese Dictionary website](https://jotoba.de/) (another very useful dictionary with search suggestions, pitch accent support and many other helpful features for learning Japanese)
- [Capture2Text](http://capture2text.sourceforge.net/) (very useful for copying and looking up kanji in games, images, etc.)
- [Yomichan](https://foosoft.net/projects/yomichan/) (for quickly looking up words while reading, or for using the search page in tandem with Capture2Text)
- [KanjiTomo](https://www.kanjitomo.net/) (useful for reading manga, LNs, etc.)
- [Genki xlsx Vocab Lists](https://github.com/SethClydesdale/genki-study-resources/tree/master/resources/tools/wordlist_E-J) (these are based on the vocab in Genki/on the site -- useful for printing out/using as a quick reference)
- [Useful Tools List](https://sethclydesdale.github.io/genki-study-resources/help/japanese-guide/#tools) (more in-depth list of tools for Japanese study)

##### Websites
- [Genki Self-study Room](https://genki3.japantimes.co.jp/en/student/) | [Genki Online](https://genki3.japantimes.co.jp/) (official Genki sites/resources)
- [Tobira Grammar Index](https://sethclydesdale.github.io/tobira-study-resources/lessons/appendix/grammar-index/) (for intermediate to advanced grammar explanations)
- [Dictionary of Japanese Grammar](https://core6000.neocities.org/dojg/) (godsend for quickly looking up grammar points)
- [Itazuraneko's Grammar Master Reference](https://kenrick95.github.io/itazuraneko/grammar/masterreference) (another great resource for looking up grammar points)
- [Tae Kim's Guide to Learning Japanese](http://www.guidetojapanese.org/learn/) (good for supplementary learning/explanations)
- [Imabi](http://www.imabi.net/) (very useful for more advanced learning/explanations)
- [/r/LearnJapanese Wiki](https://www.reddit.com/r/LearnJapanese/wiki/index) (additional resources, guides, etc.)


### Special Thanks
Genki Study Resources was made possible thanks to...
- [The Japan Times](https://bookclub.japantimes.co.jp/en/), Eri Banno, Yoko Ikeda, Yutaka Ohno, Chikako Shinagawa, and Kyoko Tokashiki for Genki: An Integrated Course in Elementary Japanese.
- Noriko Udagawa and Reiko Maruyama for some Illustrations that were used.
- [DavidBurela](https://github.com/DavidBurela) for gifting me the 3rd Edition textbook and workbook of Genki I.
- [Maarten Jacobs](https://github.com/maartenJacobs) for gifting me the 3rd Edition textbook and workbook of Genki II.
- **Everyone** who donated, as I was able to purchase the Answer Key for the 3rd Edition thanks to your support.
- [Patrick Roberts](https://github.com/patrickroberts) for [his help with an algorithm](https://stackoverflow.com/a/59337819/12502093) that helped make mixed kana/kanji answers possible in written quizzes.
- [Dominik Klein](https://github.com/asdfjkl) for [his help with adding new recognition patterns](https://github.com/asdfjkl/kanjicanvas/issues/1) for the stroke order exercises.
- [Ronserruya](https://github.com/Ronserruya) for the [Anki Decks and Deck Maker script](https://github.com/SethClydesdale/genki-study-resources/pull/89).
- [Zakkaruu](https://github.com/Zakkaruu) for the [Kanji Anki Decks](https://github.com/SethClydesdale/genki-study-resources/issues/192).
- [RealFakeAccount](https://github.com/RealFakeAccount) for the [xlsx wordlist generator](https://github.com/SethClydesdale/genki-study-resources/pull/109).
- [sasagami358](http://sasagami358.blog.fc2.com/blog-entry-593.html) for the hiragana and katakana stroke order charts.
- Everyone who helped support or contribute to this project, whether it was on GitHub or outside of it.

The following resources were used in this project. I couldn't have done it without them, so check them out!
- [Font-Awesome](https://github.com/FortAwesome/Font-Awesome) for the awesome icons.
- [dragula](https://github.com/bevacqua/dragula) for the simple drag and drop.
- [easytimer.js](https://github.com/albert-gonzalez/easytimer.js) for the super easy timer.
- [Kanji Canvas](https://github.com/asdfjkl/kanjicanvas) for the stroke order exercises.
- [Noto CJK](https://www.google.com/get/noto/help/cjk/) and [Sawarabi Gothic](https://fonts.google.com/specimen/Sawarabi+Gothic) for the fonts used in the Hiragana/Katakana stroke order exercises.
- [Genanki](https://github.com/kerrickstaley/genanki) for the simple package to create Anki decks

### Donate
If you found this project helpful and would like to donate, please see the [Donate page](https://sethclydesdale.github.io/genki-study-resources/donate/) for ways to support my work.
