//Copyright (c) ServiceStack, Inc. All Rights Reserved.
//License: https://raw.github.com/ServiceStack/ServiceStack/master/license.txt

using ServiceStack.Caching;
using ServiceStack.Redis.Internal;
using System;
using System.Threading;
using System.Threading.Tasks;

namespace ServiceStack.Redis;

public partial class RedisManagerPool
    : IRedisClientsManagerAsync
{
    ValueTask<ICacheClientAsync> IRedisClientsManagerAsync.GetCacheClientAsync(CancellationToken token)
        => new RedisClientManagerCacheClient(this).AsValueTaskResult<ICacheClientAsync>();

    ValueTask<IRedisClientAsync> IRedisClientsManagerAsync.GetClientAsync(CancellationToken token)
        => GetClient(true).AsValueTaskResult<IRedisClientAsync>();

    ValueTask<ICacheClientAsync> IRedisClientsManagerAsync.GetReadOnlyCacheClientAsync(CancellationToken token)
        => new RedisClientManagerCacheClient(this) { ReadOnly = true }.AsValueTaskResult<ICacheClientAsync>();

    ValueTask<IRedisClientAsync> IRedisClientsManagerAsync.GetReadOnlyClientAsync(CancellationToken token)
        => GetClient(true).AsValueTaskResult<IRedisClientAsync>();

    ValueTask IAsyncDisposable.DisposeAsync()
    {
        Dispose();
        return default;
    }
}