---
title: About this Blazor App
---

## .NET 8 Blazor App Templates

ServiceStack's new .NET 8 Blazor templates enhances the default ASP.NET Blazor App templates with several modern, high-productivity features, including:

 - [Tailwind CSS](https://tailwindcss.com) - Style your Blazor Apps with the modern popular utility-first CSS framework for creating beautiful, maintainable responsive UIs with DarkMode support
 - [ServiceStack.Blazor Components](https://blazor-gallery.jamstacks.net) - Rapidly develop beautiful Blazor Apps integrated with Rich high-productivity UI Tailwind Components like [AutoQueryGrid](https://blazor-gallery.servicestack.net/gallery/autoquerygrid) and [AutoForms](https://blazor-gallery.servicestack.net/gallery/autoform)
 - [ASP .NET Identity Auth](https://learn.microsoft.com/en-us/aspnet/core/blazor/security/) - Use the same ASP .NET Identity Auth used in ASP.NET's .NET 8 Blazor Apps, with all Identity Pages upgraded with beautiful Tailwind CSS styling
 - [Entity Framework](https://learn.microsoft.com/ef/) & [OrmLite](https://docs.servicestack.net/ormlite/) - Choose the Best ORM to build each App feature, with a unified solution that sees [OrmLite's Code-First DB Migrations](https://docs.servicestack.net/ormlite/db-migrations) run both EF and OrmLite migrations, inc. Seed Data with a single command at Development or Deployment
 - [AutoQuery](https://docs.servicestack.net/autoquery/) - Rapidly developing data-driven APIs, UIs and CRUD Apps
 - [Auto Admin Pages](https://www.youtube.com/watch?v=tt0ytzVVjEY) - Quickly develop your back-office CRUD Admin UIs to manage your App's Database tables at [/admin](/admin)
 - [Markdown](https://docs.servicestack.net/razor-press/syntax) - Maintain SEO-friendly documentation and content-rich pages like this one with just Markdown, beautifully styled with [@tailwindcss/typography](https://tailwindcss.com/docs/typography-plugin)
 - [Built-in UIs](https://servicestack.net/auto-ui) - Use ServiceStack's Auto UIs to [Explore your APIs](https://docs.servicestack.net/api-explorer) at [/ui](/ui/) 
   or Query your [App's Database Tables](https://docs.servicestack.net/admin-ui-database) at [/admin-ui/database](/admin-ui/database) 
 - [Universal API Components](https://youtu.be/66DgLHExC9E) - Effortlessly create reusable, maximally performant universal Blazor API Components that works in Blazor Server and Web Assembly Interactivity modes
 - [Built-in Docker Deployments](/deploy) - Use the built-in GitHub Actions to effortlessly deploy .NET 8 containerized Blazor Apps with Docker and GitHub Registry via SSH to any Linux Server