# Contributing

:sparkles: We are very glad to see you in this section! :sparkles:

Before you go ahead you should know that your contributions will be published under
the terms of the [`GPL-3.0` license](LICENSE).

Have you just found a spelling error or a grammatical one? Need to fix indentation?
Send us a pull request! :sparkles:

You have discovered something cool, but don't know exactly if it suits the
list or it doesn't have a pretrained model or even source code? :+1: Submit a pull request to the [inbox](inbox.md)!
We'll consider your addition, wait for the code and add to the main list for you! :smiley:

:boom: If you know something pretty cool, it suits the awesome list, works for you and seems to be useful 
for the community please add it to the [main readme](READREADME_BASE.md) or the corresponding json file and then 
rerun the [read me generator](generate.py). 

In this case please ensure your pull request adheres to the following guidelines:

- Use one commit per addition (several commits per PR are OK).
- Add everything to the bottom of the relevant category.
- If required introduce new categories or improve the existing categorization.
- Break down long lines, check your spelling, capitalization, and punctuation.
- Provide a useful titles and comments for your Pull Request (not `Changed readme.md`).

Sometimes we will ask you to edit your Pull Request before it is included.
This is normally due to spelling errors or because your PR didn't match
these guidelines.

[Here][change-pr] is a write up on how to change a Pull Request and
the different ways you can do that.

:+1: Thank you for your suggestions!

[change-pr]: https://github.com/RichardLitt/knowledge/blob/master/github/amending-a-commit-guide.md
