class Light:
    """
    Рассчёт освещенности на карте
    """

    def __init__(self, dim):
        """
        Создаем поле заданного размера:
        :type dim: Tuple[int, int]
            - width, height = dim[0], dim[1]
        """
        self.dim = dim
        # n-мерный масив нулей
        self.grid = [[0 for i in range(dim[0])]
                     for _ in range(dim[1])]
        self.lights = []
        self.obstacles = []

    def set_dim(self, dim):
        self.dim = dim
        self.grid = [[0 for i in range(dim[0])]
                     for _ in range(dim[1])]

    def set_lights(self, lights):
        """
        устанавливает массив источников света с заданными координатами
        и просчитывает освещение
        """
        self.lights = lights
        self.generate_lights()

    def set_obstacles(self, obstacles):
        """
        устанавливает препятствия аналогичным образом
        """
        self.obstacles = obstacles
        self.generate_lights()

    def generate_lights(self):
        return self.grid.copy()


class System:
    def __init__(self):
        self.map = self.grid = [[0 for i in range(30)]
                                for _ in range(20)]
        self.map[5][7] = 1  # Источники света
        self.map[5][2] = -1  # Стены

    def get_lightening(self, light_mapper):
        self.lightmap = light_mapper.lighten(self.map)


class MappingAdapter(Light):
    def __init__(self, adaptee):
        self.adaptee = adaptee

    def _get_lights_and_obstacles(self, grid):
        lights = []
        obstacles = []
        for i, row in enumerate(grid):
            for j, elem in enumerate(row):
                if elem == 1:
                    lights += [(j, i)]
                if elem == -1:
                    obstacles += [(j, i)]
        return lights, obstacles

    def lighten(self, grid):
        dim = (len(grid[0]), len(grid))
        self.adaptee.set_dim(dim)
        lights, obstacles = self._get_lights_and_obstacles(grid)
        self.adaptee.set_lights(lights)
        self.adaptee.set_obstacles(obstacles)
        return self.adaptee.generate_lights()


if __name__ == '__main__':
    system = System()
    lights = Light((0, 0))
    adapter = MappingAdapter(lights)
    system.get_lightening(adapter)
