# Создание иерархий классов

Вам предлагается программа — заставка, в которой по экрану «летает» кривая. При нажатии на экране мышкой — к кривой добавляется новая «опорная» точка. Сглаживание ломаной из опорный точек происходит при помощи специально написанного алгоритма.

В этой работе, Вам предстоит провести рефакторинг предложенной программы, переместив максимум функционала в соответствующие классы. В процессе рефакторинга, Вам придётся создать класс двумерных векторов, который можно будет использовать и в других Ваших программах.

- Несмотря на то, что некоторые (требуемые по заданию) функции не используются:
  - длина векторов,
  - деление вектора на число,
  - скалярное умножение
  - и пр.
- или же могут быть использованы только один раз:
  - получение пары целых чисел для рисования кривых,
- их реализация необходима для получения более полезного результата.

В то же время, **для решения дополнительных задач** Вам может потребоваться **пополнить классы методами**, не указанными в задании.

Для получения положительной оценки необходимо:

1. Реализовать все требуемые классы;
2. Все классы должны быть самостоятельными и полноценными;
3. Полученный код должен корректно исполняться и сохранить все возможности предоставленного;

Для получения максимальной оценки необходимо реализовать дополнительные задания. Вариантов их решения много. Вам необходимо предложить свой.

**Реализация окна помощи** *— на Ваше усмотрение*.

### Вам предоставляется следующий код на языке Python
Вам необходимо провести рефакторинг кода:

1. Реализовать класс 2-мерных векторов `Vec2d` — определить основные математические операции: сумма `Vec2d.__add__`, разность `Vec2d.__sub__`, умножение на скаляр и скалярное умножение (`Vec2d.__mul__`); добавить возможность вычислять длину вектора a через `len(a)`;добавить метод `int_pair` для получение пары (`tuple`) целых чисел.
2. Реализовать класс замкнутых ломаных `Polyline`, с возможностями: добавление в ломаную точки (`Vec2d`) c её скоростью; пересчёт координат точек (`set_points`); отрисовка ломаной (`draw_points`),
3. Реализовать класс `Knot` — потомок класса `Polyline` — в котором добавление и пересчёт координат инициируют вызов функции `get_knot` для расчёта точек кривой по добавляемым опорным.
4. Все классы должны быть самостоятельными и не использовать внешние функции.

Дополнительные задачи (для получения "положительной" оценки не обязательны):

1. Реализовать возможность удаления точки из кривой.
2. Реализовать возможность удаления/добавления точек сразу для нескольких кривых.
3. Реализовать возможность ускорения/замедления движения кривых.