# ООП и паттерны проектирования в Python

Moscow Institute of Physics and Technology, Mail.Ru Group & ФРОО
------

Курс возводит слушателя от написания простых конкретных классов к профессиональному конструированию приложения в объектно-ориентированной парадигме. Паттерны проектирования позволяют шагнуть за пределы простого использования синтаксических конструкций языка. Вы научитесь писать красиво и элегантно, будете использовать проверенные временем концепции и создавать масштабируемые программы. Использование паттернов проектирования является признаком профессионализма программиста.
Классические книги по паттернам проектирования описывают их реализацию на C++, C#, Java. У языка Python есть своя специфика из-за которой он отлично подходит для использования паттернов проектирования.


![Created](https://img.shields.io/date/1557933315.svg)
![last commit](https://img.shields.io/github/last-commit/Searge/mipt_oop.svg)
![Lang count](https://img.shields.io/github/languages/count/Searge/mipt_oop.svg)
![Code size](https://img.shields.io/github/languages/code-size/Searge/mipt_oop.svg)
![Repo size](https://img.shields.io/github/repo-size/Searge/mipt_oop.svg)
***

## Контент
1. [PEP 8](https://github.com/Searge/mipt_oop/blob/master/week_1/readme.md#pep-8--общепринятый-стиль-кода-на-языке-python)
2. [Структурное программирование](https://github.com/Searge/mipt_oop/blob/master/week_1/structured_programming.md#понятие-о-структурном-программировании)
3. [Контрактное программирование](https://github.com/Searge/mipt_oop/blob/master/week_1/contracts.md#утверждения-assert)
4. [Разработка через тестирование](https://github.com/Searge/mipt_oop/blob/master/week_1/tdd.md#разработка-через-тестирование)
5. [Использование unittest](https://github.com/Searge/mipt_oop/blob/master/week_1/unittests.md#использование-unittest)
6. [Парадигмы ООП](https://github.com/Searge/mipt_oop/blob/master/week_2/oop_paradigms.md#парадигмы-ооп)
7. [SOLID-принципы](https://github.com/Searge/mipt_oop/blob/master/week_2/SOLID_Principle.md#solid-принципы)
8. [Парадигма наследования](https://github.com/Searge/mipt_oop/blob/master/week_2/Inheritance.md#парадигма-наследования)
9. [Паттерны проектирования](https://github.com/Searge/mipt_oop/blob/master/week_3/patterns.md#паттерны-проектирования)
   1.  [Паттерн Адаптер](https://nbviewer.jupyter.org/github/Searge/mipt_oop/blob/master/week_3/Adapter.ipynb#Паттерн-Адаптер)
   2.  [Паттерн Декоратор](https://nbviewer.jupyter.org/github/Searge/mipt_oop/blob/master/week_3/decorator.ipynb#Паттерн-Декоратор)
   3.  [Паттерн Наблюдатель](https://nbviewer.jupyter.org/github/Searge/mipt_oop/blob/master/week_3/Observer.ipynb)

***
[coursera.org/learn/oop-patterns-python/](https://www.coursera.org/learn/oop-patterns-python/)

***

> #### [Lessons from previous course](https://github.com/Searge/DiveinPython#content)