---
title: Security Policy
weight: 2
no_comments: true
---

## Supported versions

The most recent release of the Scratch Addons browser extension (available at the Chrome Web Store, Add-ons for Firefox, and Microsoft Edge Add-ons) should be secure, and that is the top priority of the Scratch Addons open source project.

Vulnerabilities found on other repositories belonging to the GitHub organization are also considered.

See <https://scratchaddons.com/docs/getting-started/installing/> for a list of browsers supported by the Scratch Addons browser extension. Vulnerabilities that only affect unsupported browsers will also be considered, but will not be triaged as critical.

## Reporting a vulnerability

To report a security vulnerability, either use the [GitHub vulnerability report form](https://github.com/ScratchAddons/ScratchAddons/security/advisories) ("report a vulnerability" button) or contact World_Languages privately by emailing `security@scratchaddons.com` (security [at] scratchaddons [dot] com).

**Do not report vulnerabilities publicly.** A short period of time after the patch is released, the details of the vulnerability will be publicly disclosed on GitHub. The reporter may ask to stay anonymous, otherwise they will be credited for the finding.

If there's no response after 48 hours, please [open a GitHub discussion](https://github.com/ScratchAddons/ScratchAddons/discussions) titled "I've reported a security vulnerability" on the ScratchAddons/ScratchAddons GitHub repository. Do not disclose the details of the vulnerability publicly, only mention that you've reported one recently to the report form or the appropriate email address.

English is the preferred language for vulnerability reports.

## Vulnerabilities disclosed

See our advisories that we have published for vulnerabilities that we have disclosed on [this page](https://github.com/ScratchAddons/ScratchAddons/security/advisories?state=published) (browser extension vulnerabilities only).
