---
title: Website Privacy Policy
toc_title: Website
description: This page informs you of our policies regarding the collection, use, and disclosure of personal data when using the Scratch Addons website and the choices you have associated with that data.
aliases:
  - /docs/privacy/policies/website
  - /privacy/website
no_comments: true
---

> Last updated: 28 May 2021

This page informs you of our policies regarding the collection, use, and disclosure of personal data when using the Scratch Addons website (<https://scratchaddons.com>) and the choices you have associated with that data.

We use your data to provide and improve the website. By using the website, you agree to the collection and use of information in accordance with this policy.

"Website" refers to to the Scratch Addons website (<https://scratchaddons.com>). This is the website you're on right now.

## Summary

- **We do not use cookies.**
  
  Local storage is used to store basic preferences, such as whether dark mode is enabled.

- **We track trends in website traffic, without tracking individual visitors.**
  
  We do not collect any personally identifiable information. You can see the same data we can see on the [public analytics dashboard](https://analytics.scratchaddons.com).

- **You can send feedback anonymously.**
  
  Your IP address isn't stored when sending feedback.

## Cookies and Local Storage

We do not store cookies on your device.  
We might, however, use local storage capabilities to store basic preferences, such as whether dark mode is enabled on this website.

## Analytics

We use a self-hosted Plausible Analytics instance routed through our analytics subdomain to count website visits, downloads, etc. Plausible works without collecting any personal data or personally identifiable information, and without using cookies. You can see the same data we can see on the [public analytics dashboard](https://analytics.scratchaddons.com).

## Feedback

When sending feedback through <https://scratchaddons.com/feedback>, some data included in the request is:

- Text written in the "identifiers" field, if any.
- Text written in "feedback" field.
- The version number for your Scratch Addons instance.
- Your browser's user agent string (which often includes your browser's and operating system's names and version numbers).

Feedback is sent to a public open source [Glitch.com Node.js server instance](https://glitch.com/edit/#!/scratchaddons-feedback) which then redirects the information to a [Discord](https://discord.com) server. We do not log the IP addresses of the users that send feedback. You can verify this by looking at the Glitch server source code linked above.

## Third Parties

When using our website, third party services might be reached, such as:
- [Cloudflare](https://www.cloudflare.com/privacypolicy/) for website hosting
- [GitHub](https://docs.github.com/en/github/site-policy/github-privacy-statement) for website hosting
- [cdn.jsdelivr.net](https://www.jsdelivr.com/terms/privacy-policy-jsdelivr-net) for library CDN
- [Skypack](https://www.skypack.dev/legal/privacy-policy) for library CDN
- [Google services](https://policies.google.com/privacy) such as YouTube and Google Fonts
- [Glitch](https://glitch.com/legal/privacy) for sending feedback

## Links to Other Websites

As part of the website, we may provide links to or compatibility with other websites or apps. We aren't responsible for the content on those sites or how they might use your data. This Privacy Policy is only about our website.

## Contact

If you have any questions, please contact us through our feedback page at <https://scratchaddons.com/feedback> (make sure to fill out the "identifiers" field so that we can reply to your message) or email `worldxlanguages (at) gmail.com`.

## Website Privacy Policy Changelog

- **28 May 2021:** created
