---
title: Extension Privacy Policy
toc_title: Extension
description: This page informs you of our policies regarding the collection, use, and disclosure of personal data when using the Scratch Addons extension and the choices you have associated with that data.
aliases:
  - /docs/privacy/policies/extension
  - /privacy/extension
no_comments: true
---

> Last updated: 26 July 2022

This page informs you of our policies regarding the collection, use, and disclosure of personal data when using the Scratch Addons extension and the choices you have associated with that data.

We use your data to provide and improve the service. By using the service, you agree to the collection and use of information in accordance with this policy.

"Extension" refers to our browser extension, which you can download from the [Chrome Web Store](https://chrome.google.com/webstore/detail/fbeffbjdlemaoicjdapfpikkikjoneco), [Add-ons for Firefox](https://addons.mozilla.org/firefox/addon/scratch-messaging-extension/) or [Microsoft Edge Add-ons](https://microsoftedge.microsoft.com/addons/detail/scratch-addons/iliepgjnemckemgnledoipfiilhajdjj).

"The Scratch website" refers to <https://scratch.mit.edu> and all of its subdomains, such as <https://api.scratch.mit.edu> and <https://clouddata.scratch.mit.edu>.  

## Summary

- **We do not track extension usage at all.**
  
  We don't know how many users have enabled the pause button or turned on light mode.

- **We never send Scratch account information or extension settings outside of your browser.**

  Extension settings only leave your device if you've enabled Chrome/Firefox/Edge Sync.

- **By default, the extension only interacts with the Scratch website and this website.**

  You need to opt-in to features if they require external services.

## Temporarily-Stored Information 

We store some data on your device temporarily. This information is generated while the extension is running and cannot be recovered after your browser is restarted. 

This data can only be accessed by the Scratch Addons extension on your device.

Temporarily-stored information might include:

- Your Scratch account's username and user ID.
- Values of the `scratchcsrftoken` and `scratchlanguage` cookies.
- Value of your Scratch authentication token "X-Token".
- Your most recent Scratch messages.

## Permanently-Stored Information

We store some data locally on your device permanently. This information is still available even if your browser is restarted. 

This data can only be accessed by the Scratch Addons extension on your browser.

Permanently-stored information might include:

- Addon settings (what addons are enabled and their settings).
- Extension settings (such as theme preference).
- Whether the Scratch Addons update notification was shown.
- Whether the extension was muted through the context menu.

The extension by itself does not send any of this information outside of your device. 

However, if you enable Chrome Sync, Firefox Sync, Edge Sync, or any other compatible browser data synchronization feature, this information might be sent to that service by your browser.

## Third Parties

By default, Scratch Addons only reaches 2 services automatically:
1. The Scratch website (for example, to get your unread message count).
2. This website (for example, <https://scratchaddons.com/welcome> opening as a new tab after you've installed the extension).

Some extension features that are disabled by default might require other external services to function. In those cases, the description of the addon will mention the name and/or URL of the service. 

## Scratch Website

The Scratch website might be able to know you are using Scratch Addons. It might also be able to read or deduce some of your addon settings (for example, the Scratch website could know you've enabled "website dark mode" if it detects the background color is black).

## Websites Other than Scratch

If you use a Chromium-based browser such as Chrome, any websites you visit might be able to know whether Scratch Addons is installed in your browser. In the future, with the launch of new extension platform updates that let us limit what origins can access extension files, we expect this to change. This does not affect Firefox.

## Other Software

In case you use other extensions in your browser that can interact with the Scratch website, similarly to Scratch Addons, these extensions might be able to know everything that the Scratch website itself could potentially know.

Any malware running in your device could also potentially read any data stored by the Scratch Addons extension.

## Contact

If you have any questions, please contact us through our feedback page at <https://scratchaddons.com/feedback> (make sure to fill out the "identifiers" field so that we can reply to your message) or email `worldxlanguages (at) gmail.com`.

## Extension Privacy Policy Changelog

- **26 July 2022:** reference Microsoft Edge browser ([diff](https://github.com/ScratchAddons/website-v2/commit/610c656bd30fd394bd6dbff98bfad677ce99e7f0))
- **28 May 2021:** created
