---
title: Joining the Localization Team
description: Thanks for being interested on volunteering to translate Scratch Addons to other languages! Scratch Addons is a non-profit open source project where volunteer web developers maintain the extension and create its addons.
aliases:
  - /docs/localization/how-to-join-the-localization-team
  - /translate
---

{{< admonition info >}}
If you found a **translation mistake/error** in Scratch Addons, please [send feedback](/feedback) about it.
{{< /admonition >}}

Thanks for the interest to help with translating Scratch Addons to other languages! Scratch Addons is available in more than 15 languages thanks to the help of volunteers around the world.

Please read this page carefully to continue.

## Requirements to join as a translator

* You must be **FLUENT IN THE ENGLISH LANGUAGE**.
* For example, you're fluent in English if you can use the Scratch Addons settings page in English, or if you understand griffpatch's videos. If you struggle to understand sentences without a translator, you're not fluent.
* You must be **a NATIVE SPEAKER** of the language you want to translate to.
* You must have an email address, which you should ideally check at least once a week.
* You must own an account on [scratch.mit.edu](https://scratch.mit.edu).

{{< admonition info >}}
**These languages do NOT accept new translators:** Italian, Spanish.<!-- This list of languages is also found below. Remember to update both. -->
{{< /admonition >}}

If you're not a native speaker but consider yourself fluent enough, you may also request to join. Keep in mind taking some language classes does not make you fluent. If you wouldn't change your smartphone's system language to it, you're not fluent enough!

We only support languages that Scratch itself supports. We also fully support RTL languages, such as Arabic and Hebrew.

## Content available for translation

### Scratch Addons browser extension

- **General Translation.** These are ~150 text strings which are used by the extension. Users can only see these translations for their language if 90% of general strings were translated.

- **Addons Translation.** These text strings include addon names, descriptions, settings, and other text strings used by addons. Users can only see these translations if the general translation is already available and 80% of addon strings were translated. There are over 1000 addon strings available for translation.

![Screenshot of the Scratch Addons extension in Japanese](/assets/img/docs/transifex-general-vs-addons.png)

### Scratch Addons website

Translators also have the possibility to translate the contents of the Scratch Addons website. For more information about translating the website, see [Translating](https://github.com/ScratchAddons/website-v2/wiki/Translating).

## Supported languages

We support most languages that Scratch itself supports.

<details>
<summary>Click to access the full list supported languages (50+ languages)</summary>
Abkhaz (ab), Afrikaans (af), Amharic (am), Aragonese (an), Arabic (ar), Azerbaijani (az), Belarusian (be), Bulgarian (bg), Bengali (bn), Catalan (ca), Central Kurdish (ckb), Czech (cs), Welsh (cy), Danish (da), German (de), Greek (el), Spanish (es), Estonian (et), Basque (eu), Persian (fa), Finnish (fi), French (fr), Western Frisian (fy), Irish (ga), Gaelic, Scottish (gd), Galician (gl), Hebrew (he), Hindi (hi), Croatian (hr), Haitian (Haitian Creole) (ht), Hungarian (hu), Armenian (hy), Indonesian (id), Icelandic (is), Italian (it), Japanese (ja), Georgian (ka), Kazakh (kk), Khmer (km), Korean (ko), Kurdish (ku), Lithuanian (lt), Latvian (lv), Maori (mi), Mongolian (mn), Norwegian Bokmål (nb), Dutch (nl), Norwegian Nynorsk (nn), Northern Sotho (nso), Odia (or), Polish (pl), Portuguese (Brazil) (pt_BR), Quechua (qu), Rapa Nui (rap), Romanian (ro), Russian (ru), Slovak (sk), Slovenian (sl), Serbian (sr), Swedish (sv), Swahili (sw), Thai (th), Tswana (tn), Turkish (tr), Ukrainian (uk), Uzbek (uz), Vietnamese (vi), Xhosa (xh), Chinese (China) (zh_CN), Chinese (Taiwan) (zh_TW), Zulu (zu).
</details>

We do not support these languages yet: Asturianu (ast), Esperanto (eo), Español Latinoamericano (es_419), Filipino (fil), Hausa (ha), Japanese (Hiragana) (ja-Hira), Occitan (oc), Portuguese (Portugal) (pt_PT). If you're interested on becoming a translator for one of these languages we currently do not support, please send an email to `translation@scratchaddons.com`.

These languages **do not** accept new translator requests: **Italian, Spanish.**<!-- This list of languages is also found above. Remember to update both. -->

## Steps to join as a translator

Please follow the steps below.

### 1. Verify your Scratch account
1. Visit this [Scratch studio](https://scratch.mit.edu/studios/33665222/comments) with your Scratch account.
1. Send a studio comment indicating the language you want to translate to (for example, `Greek`).  
![Screenshot of Scratch](/assets/img/docs/scratch-req-language.png)

**If you don't have a Scratch account**, please send an email to `translation@scratchaddons.com` instead. Do not create a new Scratch account just to fulfill this requirement. New Scratcher accounts will be ignored.

### 2. Create a Transifex account
1. Go to [Transifex open-source Sign up](https://app.transifex.com/signup/open-source/?join_org=scratch-addons&join_project=scratch-addons-extension).  
1. You will be shown Transifex's "Sign up" screen. **DO NOT sign up with Google.**  
1. In the "business email" field, enter your email (it can be Gmail, Outlook, or any other).
1. In the "username" field, we highly recommend you enter your Scratch username, or a slight variation of it.  
For example, if your Scratch username is `john_walker954`, your Transifex username can be exactly the same (`john_walker954`) or `john_walker954_scratch`.
1. In the "password" field, enter a password.
1. Click the "Sign up" button.
1. You'll be asked for your First name and Last name.  
\- In the **First name**, we recommend you enter your Scratch username.  
\- In the **Last name**, we recommend you enter the language you want to translate to (for example, `Greek`).
1. In the "languages you speak" field, select at least one language you're fluent with (for example, English).
1. Click the "Let's get started" button.
1. Continue with the "requesting a language" steps below.

If you already own a Transifex account and don't want to create a new one, please send an email to `translation@scratchaddons.com` indicating your Transifex account's username. Then, continue with the "requesting a language" section below.

### 3. Requesting a language
1. Make sure you're logged in to Transifex. If you just signed up, you are already logged in.
1. Go to [Scratch Addons' Transifex page](https://app.transifex.com/join/?o=scratch-addons&p=scratch-addons-extension&t=opensource).
1. You'll be prompted to choose the language you want to translate to.
1. Choose one of the languages **which are "available to join"**. We do not support languages that are not available to join.  
![Screenshot of Transifex](/assets/img/docs/transifex-req-language.png)
1. Click the "Join Project" button.
1. Wait until your request is accepted.

If you have a Discord account, we encourage you to join our [Development Discord server](https://discord.gg/Ak8sCDQ).

{{< admonition success >}}
**If your request is accepted, you'll receive an email from Transifex. We usually review requests every 96 hours.**
{{< /admonition >}}

{{< admonition error >}}
If your request is denied, you'll receive an email. Decisions are never final. You may send an email to  `translation@scratchaddons.com` indicating your Transifex username and your request will be strongly reconsidered. See below for other contact methods.
{{< /admonition >}}

## Help or contact

If you have any questions about translating, you may choose one of the following options:
- Send an email to `translation@scratchaddons.com`.
- Join our [Development Discord](https://discord.gg/Ak8sCDQ) server.
- [Open a discussion on GitHub](https://github.com/ScratchAddons/ScratchAddons/discussions) (GitHub account required).
- [Send feedback](/feedback) (make sure to specify your Scratch username in the form, we will reply in your profile).

## Credits

- If you get accepted, you may add yourself (or be added) to [the website's credits page](/credits).
- Your translations are licensed under the same license as Scratch Addons (GPL v3.0).
