---
title: What's new in Scratch Addons v1.39
description: Handle asset import conflicts, delete all but one asset, and more.
date: 2024-08-31T18:45:00Z
author: DNin01
---

Plenty of new features have been added in this update to improve your productivity on Scratch!

Let's start with the new addons.

## 📄 Choose what to do with conflicting asset names

When the new [Asset conflict dialog](https://scratch.mit.edu/scratch-addons-extension/settings#addon-asset-conflict-dialog) addon is enabled, upon importing one or more costumes or sounds that have the same name as an existing asset, this addon will ask you if you want to replace it, rename the imported item, or skip the import.

<video src="/assets/img/blog/v1-39-released/import-and-replace.mp4" controls type="video/mp4" autoplay loop></video>

## 🗑️ Delete all but one costume or sound

The new [Delete other costumes or sounds](https://scratch.mit.edu/scratch-addons-extension/settings#addon-delete-others) addon lets you delete all of a sprite's costumes or sounds except for the one you choose when you right-click on a costume or sound.

<video src="/assets/img/blog/v1-39-released/delete-others.mp4" controls type="video/mp4" autoplay loop></video>

## 🔮 See how close you're getting to the reply limit

In studios, each comment can have a maximum of 25 replies. When the new [Remaining reply counter](https://scratch.mit.edu/scratch-addons-extension/settings#addon-remaining-replies) addon is enabled, the number of replies you have left is displayed as a number next to each reply button, on threads that have accumulated more than 15 replies.

![A chain of replies, each comment with a "reply (4 left)" button](/assets/img/blog/v1-39-released/reply-chain.png)

## 🎨 New customizations

Two new addons, [Customizable code editor grid](https://scratch.mit.edu/scratch-addons-extension/settings#addon-workspace-dots) and [Customizable stage monitors](https://scratch.mit.edu/scratch-addons-extension/settings#addon-stage-monitor), have been added to let you customize Scratch even more.

[Customizable block colors](https://scratch.mit.edu/scratch-addons-extension/settings#addon-editor-theme3) has also been updated with new settings to change the color of the insertion marker that highlights where a block you're dragging will be placed.

## ✨ Other improvements, changes, and bug fixes

- [Message count on extension icon](https://scratch.mit.edu/scratch-addons-extension/settings#addon-msg-count-badge) will be automatically disabled if you have not pinned the Scratch Addons extension to your browser toolbar, and for new users, to reduce unnecessary background activity.
- [Forum search](https://scratch.mit.edu/scratch-addons-extension/settings#addon-forum-search) now works again.
- [Project video recorder](https://scratch.mit.edu/scratch-addons-extension/settings#addon-mediarecorder)'s options dialog has been updated and remembers the settings you used for your last recording.
- Fixed the block palette scroll bar when [Two-column category menu](https://scratch.mit.edu/scratch-addons-extension/settings#addon-columns) is enabled.
- Fixed [Data category tweaks](https://scratch.mit.edu/scratch-addons-extension/settings#addon-data-category-tweaks-v2) causing the "Save Now" button to appear even if no changes were made.
- Optimized [Save blocks as image](https://scratch.mit.edu/scratch-addons-extension/settings#addon-blocks2image) to render images faster.
- And much more!

## Feature removals

The following functions have been removed:
- The Profile statistics addon, as well as the [Show exact count](https://scratch.mit.edu/scratch-addons-extension/settings#addon-exact-count) addon's ability to show the exact number of forum posts each user has made have been removed for now due to issues with the service they obtain data from.
- The Local timezone on forums addon has been removed for now because it has been broken for a while.
- The Forums image uploader addon has been removed because the Scratch forums no longer allow images of Scratch assets to be embedded in posts.

Although the above features won't be available anymore, we may reconsider some of them for later releases.
