---
title: What's new in Scratch Addons v1.37
description: Download projects with one click and more!
date: 2024-03-31T00:00:00Z
author: DNin01
---

This update brings in the ability to download projects with one click, plus a couple other new useful features and quality-of-life improvements and some bug fixes!

### Download projects fast

Finding yourself saving a lot of your own or your favorite Scratch projects? The new [Project page download button](https://scratch.mit.edu/scratch-addons-extension/settings#download-button) addon can help. It adds a download button right below the Notes and Credits section of all projects.

![The actions button row on the project page with a Download button added at the end](/assets/img/blog/v1-37-released/projectpage-download-button.png)

This button is functionally identical to the `File` → `Save to your computer` option in the editor, just that you don't have to go into the editor first.

### A smaller backpack button

Another new addon we've made is called [Replace backpack bar with button](https://scratch.mit.edu/scratch-addons-extension/settings#hide-backpack), which changes the backpack drawer at the bottom of the editor to this little button:

<video src="/assets/img/blog/v1-37-released/small-backpack-button.mp4" controls type="video/mp4" autoplay loop></video>

### Improved custom block input insertion

Now, when you have the [Rearrangeable custom block inputs](https://scratch.mit.edu/scratch-addons-extension/settings#reorder-custom-inputs) addon enabled, you can turn on the "Insert new inputs after selected input" setting to make it so that when you add an input or label, it gets inserted to the right of whatever input or label you have selected. It works like this:

<video src="/assets/img/blog/v1-37-released/better-parameters.mp4" controls type="video/mp4" autoplay loop></video>

### An important button gets better

That's right, our new addon, [Larger "Save Now" button](https://scratch.mit.edu/scratch-addons-extension/settings#big-save-button), which is **enabled by default**, just increases the clickable area of the "Save Now" button in the editor, a change that you might not even notice that can subconsciously make a big difference.

### Other changes

As for the smaller stuff, there's a lot:
- [Debugger](https://scratch.mit.edu/scratch-addons-extension/settings#debugger)'s "Threads" tab will now automatically scroll to the active thread while single stepping.
- [Square block inputs](https://scratch.mit.edu/scratch-addons-extension/settings#editor-square-inputs) can now apply to number inputs. Just turn on the setting.
- Fixed an issue where you couldn't reveal the toolbar when you had set it to show when hovering over the top of the screen with [Enhanced full screen](https://scratch.mit.edu/scratch-addons-extension/settings#fullscreen) on Firefox.
- When [Project progress bar](https://scratch.mit.edu/scratch-addons-extension/settings#progress-bar) is enabled and has been set to show the progress bar at the top of the screen, it will no longer block clicks, which made it impossible to reveal the toolbar when you have set it to show when hovering over the top of the screen with [Enhanced full screen](https://scratch.mit.edu/scratch-addons-extension/settings#fullscreen).
- With [Full areas](https://scratch.mit.edu/scratch-addons-extension/settings#full-signature) enabled, the heights of forum signature areas now properly adapt to fit the content.
- Pressing <kbd>Alt</kbd>+<kbd>X</kbd> to pause a project while in the editor no longer removes blocks.
- Opening the sound library while a project is paused no longer resumes the audio.
- And various other improvements and fixes.

### Browser support changes

For those of you using older browsers, starting this release, Scratch Addons will drop support for Chrome versions under 96 and Firefox versions under 109. Why? It's not important. But what is important is that you will need to update your browser to continue using Scratch Addons if you are using a version that we no longer support. For more information, check [this page](https://scratchaddons.com/unsupported-browser/).

If you have anything you want to say, let us know by clicking the "Send Feedback" button in the settings page of Scratch Addons. Enjoy the update!
