---
title: What's new in Scratch Addons v1.36
description: Custom block parameter rearranging, new customization options, and more!
date: 2024-02-19T00:00:00Z
author: DNin01
---

# What's new in Scratch Addons v1.36.0

With this new Scratch Addons update, which will be rolling out soon, we've made some improvements to existing addons to make them even more useful, and a couple new addons too!

### Rearranging parameters in custom blocks

You may have once created a custom block with some parameters, only to realize you want to change their order, but found no such option other than to delete the parameters and re-add them. The new [Rearrangable custom block inputs](https://scratch.mit.edu/scratch-addons-extension/settings#reorder-custom-inputs) addon solves this problem by adding buttons to switch them around.

To switch the places of a parameter or label in a custom block you're editing, click on it and use the `<` and `>` buttons to switch its place with the parameter or label to the left or right.

<video src="/assets/img/blog/v1-36-released/reordering-parameters.mp4" controls type="video/mp4" autoplay loop></video>

### Infinite scrolling expands to search results and the explore page

The [Infinite scrolling](https://scratch.mit.edu/scratch-addons-extension/settings#infinite-scroll) addon now works on the search results and explore pages. That means you don't have to click "Load more" anymore on those pages.

### Semi-hidden toolbar in full screen

When using the [Enhanced full screen](https://scratch.mit.edu/scratch-addons-extension/settings#fullscreen) addon, you only had the option to show the toolbar (the green flag and stop sign) persistently at the top of the screen or to hide it completely. Now, you can set it to show only while your mouse is hovering near the top of the screen, which is a nice in-between.

<video src="/assets/img/blog/v1-36-released/fullscreen-toolbar-on-hover.mp4" controls type="video/mp4" autoplay loop></video>

### New theme options

This update also adds a new addon that provides options for customizing the look of the editor menu bar in a few different ways. You can hide buttons you don't need and change how buttons with icons and text labels look.

We also added a few more customization features:
- A new addon for the editor which makes the input fields on blocks have squared-off corners, resembling how they looked in Scratch 2.0.
- You can now apply custom colors to variable, list, and other reporter monitors on the stage with [Customizable block colors](https://scratch.mit.edu/scratch-addons-extension/settings#editor-theme3).

### Highlights

This update contains some other small but nice enhancements as well:
- A new addon, enabled by default, that makes code dragged and dropped from the backpack drop right next to your mouse pointer, instead of at the top-left corner of the code area.
- [Auto-hiding block palette](https://scratch.mit.edu/scratch-addons-extension/settings#hide-flyout) has a new setting, "open by default", which makes the block palette start out expanded.
- [Arrow key incrementation in editor](https://scratch.mit.edu/scratch-addons-extension/settings#editor-number-arrow-keys) now works on bigger numbers.
- Fixed an issue with [Customizable link style](https://scratch.mit.edu/scratch-addons-extension/settings#colorblind) where the custom link style would take a moment to apply after page load.
- Plenty of other bug fixes!

If you have any feedback, let us know by clicking the "Send Feedback" button in the settings page of Scratch Addons.
