

# TTSAudioNormalizer

TTSAudioNormalizer 是一个专业的 TTS 音频预处理工具，提供全面的音频分析和标准化处理功能。本工具旨在提升 TTS 训练数据质量，确保音频特征的一致性。



## TTS音频标准化处理的必要性

### 一、提升模型训练效果

#### 1. 优化学习过程
- 统一的音量水平让模型更专注于学习语音特征，而不是被音量差异干扰
- 标准化的数据有助于模型更快收敛，减少训练时间
- 降低模型学习错误特征的风险

#### 2. 防止训练异常
- 避免因音量差异过大导致的梯度爆炸或消失
- 减少模型过拟合于音量特征的可能性
- 提高训练过程的稳定性

#### 3. 增强泛化能力
- 帮助模型专注于学习语音的本质特征
- 提升模型在不同场景下的适应能力
- 减少对非关键特征的依赖

### 二、保障音频质量

#### 1. 语音清晰度
- 优化频率响应，突出语音关键频段
- 增强辅音清晰度，提升语音可懂度
- 保持元音自然度，维持声音特色

#### 2. 噪声控制
- 去除背景噪声，提升语音纯净度
- 压缩动态范围，平衡音量水平
- 过滤无用频段，减少干扰因素

### 三、确保数据一致性

#### 1. 技术规格统一
- 统一采样率，保证数据质量
- 规范声道设置，简化处理流程
- 标准化音频格式，提高兼容性

#### 2. 特征提取优化
- 提高特征提取的准确性和可靠性
- 增强不同样本间的可比性
- 保证训练数据的质量一致性

## 理想的音频标准化流程：


## 1. 基础预处理 🎯
- **统一格式**
  - 将不同音频格式统一转换（如 WAV）
  - 确保格式兼容性
- **统一采样率**
  - 标准化采样率（如 22050Hz）
  - 保证数据一致性
- **转换单声道**
  - 将多声道音频转换为单声道
  - 简化后续处理

## 2. 音质优化 🔊
- **去除直流偏置**
  - 消除音频信号的固定偏移
  - 改善音频质量
- **音量标准化**
  - 统一音频音量水平
  - 确保响度一致性
- **频率响应优化**
  - 调整频率特性
  - 优化音频表现

## 3. 噪声处理 🎵
- **去除静音段**
  - 清理无效音频片段
  - 提高数据质量
- **降噪处理**
  - 消除背景噪声
  - 提升音频清晰度
- **动态范围压缩**
  - 平衡音频动态范围
  - 改善整体表现

## 4. 质量检查 ✅
- **质量验证**
  - 检查处理后的音频质量
  - 确保满足训练要求
- **特征验证**
  - 验证音频特征参数
  - 保证特征提取的有效性

---

**处理流程示意：**

`输入音频` ➡️ `基础预处理` ➡️ `音质优化` ➡️ `噪声处理` ➡️ `质量检查` ➡️ `输出音频`

---

**注意事项：**
- 每个步骤都应保存处理日志
- 关键节点进行质量检测
- 保留原始音频备份
- 参数需根据具体应用场景调整

## 主要功能

### 1. 音频分析
- 生成详细的响度统计报告
- 提供音量分布可视化
- 输出参数优化建议
```python
from audio_analyzer import AudioAnalyzer

analyzer = AudioAnalyzer()
results = analyzer.analyze_speaker_directory(
    base_dir="raw_voices",  # 嵌套文件夹，即一个大文件夹下有若干子文件夹（其中有若干音频文件）
    output_dir="analysis_report",
    max_workers=16
)
```
#### Results:
```
发现 49 个说话人目录
处理说话人:   0%|          | 0/49 [00:00<?, ?it/s]

分析说话人: 廉颇

分析音频:   0%|          | 0/118 [00:00<?, ?it/s]
分析音频:  25%|██▌       | 30/118 [00:00<00:00, 289.97it/s]
分析音频:  53%|█████▎    | 62/118 [00:00<00:00, 299.46it/s]
分析音频:  78%|███████▊  | 92/118 [00:00<00:00, 298.95it/s]
                                                           

音频分析报告 说话人: 廉颇:
--------------------------------------------------
分析的音频文件总数: 118

音量统计:

Mean Norm:
  mean: 0.053
  std: 0.010
  min: 0.032
  max: 0.082

RMS Amplitude:
  mean: 0.089
  std: 0.015
  min: 0.057
  max: 0.131

Max Amplitude:
  mean: 0.546
  std: 0.123
  min: 0.293
  max: 0.882
处理说话人:   2%|▏         | 1/49 [00:01<01:03,  1.31s/it]

推荐的target_db值:
1. 保守设置 (保持动态范围): target_db = 0.053
2. 平衡设置 (确保清晰度): target_db = 0.063
3. 安全设置: target_db = -3.000

分析结果已保存到: raw_voices/音频分析报告/廉颇

分析说话人: 小乔

分析音频:   0%|          | 0/201 [00:00<?, ?it/s]
分析音频:  14%|█▍        | 28/201 [00:00<00:00, 268.48it/s]
分析音频:  29%|██▉       | 58/201 [00:00<00:00, 283.83it/s]
分析音频:  43%|████▎     | 87/201 [00:00<00:00, 281.59it/s]
分析音频:  60%|█████▉    | 120/201 [00:00<00:00, 297.76it/s]
分析音频:  75%|███████▍  | 150/201 [00:00<00:00, 294.95it/s]
分析音频:  90%|████████▉ | 180/201 [00:00<00:00, 289.50it/s]
                                                            

音频分析报告 说话人: 小乔:
--------------------------------------------------
分析的音频文件总数: 201

音量统计:

Mean Norm:
  mean: 0.052
  std: 0.019
  min: 0.012
  max: 0.135

RMS Amplitude:
  mean: 0.086
  std: 0.030
  min: 0.024
  max: 0.209

Max Amplitude:
  mean: 0.495
  std: 0.143
  min: 0.163
  max: 0.943
处理说话人:   4%|▍         | 2/49 [00:02<01:09,  1.49s/it]

推荐的target_db值:
1. 保守设置 (保持动态范围): target_db = 0.052
2. 平衡设置 (确保清晰度): target_db = 0.071
3. 安全设置: target_db = -3.000

分析结果已保存到: raw_voices/音频分析报告/小乔

分析说话人: 赵云

分析音频:   0%|          | 0/142 [00:00<?, ?it/s]
分析音频:  20%|█▉        | 28/142 [00:00<00:00, 270.67it/s]
分析音频:  42%|████▏     | 60/142 [00:00<00:00, 294.19it/s]
分析音频:  63%|██████▎   | 90/142 [00:00<00:00, 291.33it/s]
分析音频:  85%|████████▍ | 120/142 [00:00<00:00, 283.42it/s]
                                                            

音频分析报告 说话人: 赵云:
--------------------------------------------------
分析的音频文件总数: 142

音量统计:

Mean Norm:
  mean: 0.050
  std: 0.019
  min: 0.018
  max: 0.124

RMS Amplitude:
  mean: 0.089
  std: 0.031
  min: 0.039
  max: 0.193

Max Amplitude:
  mean: 0.603
  std: 0.182
  min: 0.339
  max: 1.000
处理说话人:   6%|▌         | 3/49 [00:04<01:06,  1.45s/it]

推荐的target_db值:
1. 保守设置 (保持动态范围): target_db = 0.050
2. 平衡设置 (确保清晰度): target_db = 0.070
3. 安全设置: target_db = -3.000

分析结果已保存到: raw_voices/音频分析报告/赵云
...
```
<img width="381" alt="image" src="https://github.com/user-attachments/assets/32beed78-d703-419a-a77c-a6aa232c9adc" />
<img width="933" alt="image" src="https://github.com/user-attachments/assets/7e3a0f6c-007a-409f-bc07-2c6f6a002a6f" />

## **关键指标说明**：


### 1. Mean Norm（平均归一化音量）
- **实际意义**：
  - 反映音频的整体响度水平
  - 表示音频信号的平均绝对振幅
  - 值域范围通常在0-1之间
- **数值含义**：
  - 值越大 = 整体听感越响
  - 值越小 = 整体听感越轻
  - 理想范围通常在0.1-0.3之间
- **应用场景**：
  - 用于评估音频的整体响度是否合适
  - 帮助判断是否需要音量增益

### 2. RMS Amplitude（均方根振幅）
- **实际意义**：
  - 反映音频的有效能量水平
  - 更接近人耳对响度的感知
  - 考虑了时间维度上的能量分布
- **数值含义**：
  - 值越大 = 音频能量越强
  - 值越小 = 音频能量越弱
  - 专业音频通常建议在0.1-0.4之间
- **应用场景**：
  - 评估音频的动态范围
  - 判断音频是否需要压缩或扩展
  - 常用于音频标准化处理

### 3. Max Amplitude（最大振幅）
- **实际意义**：
  - 反映音频中的峰值水平
  - 表示信号的最大瞬时值
  - 用于判断是否存在削波
- **数值含义**：
  - 1.0 = 达到数字音频的最大可能值（可能出现削波）
  - 建议峰值控制在0.9以下
  - 过低（如<0.5）表示音频可能过轻
- **应用场景**：
  - 检测音频是否存在失真
  - 评估音频的动态余量
  - 指导限幅器的设置

### 三者的关系
1. **层次关系**：
   - Max Amplitude > RMS Amplitude > Mean Norm
   - 这是由于它们计算方法的不同

2. **实际应用**：
   - Mean Norm：用于整体音量评估
   - RMS：用于能量水平控制
   - Max Amplitude：用于峰值控制

### 理想值参考
- **专业音频制作参考值**：
  - Mean Norm：0.1-0.3
  - RMS：0.1-0.4
  - Max Amplitude：0.8-0.9

### 使用建议
1. 先检查Max Amplitude避免削波
2. 用RMS确保整体能量适中
3. 参考Mean Norm调整整体音量
4. 三个指标要结合具体应用场景来判断

这些指标共同作用，帮助我们：
- 确保音频质量
- 保持音量一致性
- 避免失真和噪声
- 优化听感体验




### 2. 音频标准化
这个解决方案的主要特点：
- 使用 sox 的 norm 效果对音频进行标准化处理
- 可以处理单个文件或批量处理整个目录
- 默认将音量标准化到 -3dB，可以根据需要调整
- 保持原始音频质量，只调整音量

使用方法很简单，你可以：
- 处理单个文件：直接调用 normalize_audio() 函数
- 处理整个目录：使用 batch_normalize_directory() 函数
这样处理后的音频文件应该会有比较均匀的音量水平，解决声音忽大忽小的问题。如果觉得整体音量还是太小或太大，可以调整 target_db 参数的值。
```python
from tts_audio_normalizer import AudioProcessingParams, TTSAudioNormalizer

# 创建参数对象并自定义参数
params = AudioProcessingParams()
params.noise_reduction_strength = 0.8  # 增加降噪强度
params.target_db = -3  # 设置目标音量

# 处理单个文件
#normalizer.normalize_audio("input.wav", "output.wav", params)

# 批量处理目录
normalizer.batch_normalize_directory(
    input_dir = "./audio_segments",
    output_dir = "./audio_segments_normalized",
    params=params,
    max_workers=4
)
```

## 参数配置指南

### 1. 基础参数
```python
# 基础格式设置
rate: int = 44100            # 采样率
channels: int = 1            # 声道数
output_format: str = 'wav'   # 输出格式
target_db: float = -3.0      # 目标音量
```

### 2. 音质优化参数
```python
# 均衡器设置
equalizer_enabled: bool = True    # 启用均衡
treble_frequency: float = 3000.0  # 高频中心(2-8kHz)
mid_frequency: float = 1000.0     # 中频中心(250Hz-2kHz)
bass_frequency: float = 100.0     # 低频中心(80-250Hz)
```

### 3. 降噪参数
```python
# 噪声处理
subsonic_filter_enabled: bool = True  # 超低频过滤
compression_ratio: float = 2.5        # 压缩比
threshold_db: float = -15.0           # 噪声阈值
```

## 场景优化建议

### 1. 语音类型适配
| 语音类型 | 推荐参数 |
|---------|---------|
| 男声 | bass_gain=2.0, mid_frequency=1200Hz |
| 女声 | treble_gain=1.5, bass_gain=1.5 |
| 儿童声 | mid_gain=1.5, bass_gain=1.0 |

### 2. 压限器配置
| 压缩程度 | 参数组合 |
|---------|---------|
| 温和压缩 | threshold_db=-20, ratio=2, attack=0.3s |
| 中等压缩 | threshold_db=-25, ratio=3, attack=0.2s |
| 强烈压缩 | threshold_db=-30, ratio=4, attack=0.1s |

### 3. 均衡器配置
| 音质目标 | 参数组合 |
|---------|---------|
| 人声增强 | treble=2.0, bass=1.0 |
| 清晰度提升 | treble=3.0, bass=-1.0 |
| 温暖音色 | treble=-1.0, bass=2.0 |

## 使用注意事项

1. **音频特征保护**
- 避免过度处理导致失真
- 保持音素边界清晰度
- 维持语音自然韵律

2. **数据集适配**
- 根据说话人特点调整参数
- 考虑录音环境因素
- 保持处理一致性

3. **质量控制**
- 定期检查处理效果
- 监控异常样本
- 及时调整参数

## 最佳实践流程

1. 先进行音频分析
2. 根据分析报告选择参数
3. 小批量测试处理效果
4. 调整优化参数配置
5. 执行批量标准化处理
6. 验证处理结果质量

通过合理配置和使用本工具，可以显著提升 TTS 训练数据质量，为模型训练提供更好的基础数据支持。
