author: Scott Morgan
summary: Have a question? Check it out here first.
id: faqs
categories: python-programming
environments: Web
status: Published
feedback link: https://github.com/Scott3142/python-programming
analytics account: UA-49751789-4

# FAQs

## Starting out

Welcome to this course on Python Programming. This is a list of some of the most frequently asked questions about coding, programming and software development. If your question is one of these, it has probably been answered many times before, and you should get a good answer below.

**This has been adapted from the FAQs on the [r/learnprogramming](https://www.reddit.com/r/learnprogramming/wiki/faq) subreddit.**

### Where do I start?

If you're interested in learning to code, it's very helpful to start with the right mindset. This [YouTube video](https://www.youtube.com/watch?v=mvK0UzFNw1Q) by Kevin Cheers does a great job of explaining the proper perspective you should have when starting out.

Next, you should keep in mind that there's no universally agreed way of learning to code -- everybody prefers learning in a slightly different way, and you may need to do some experimenting to find an approach that works best for you. Nevertheless, the majority of people seem to learn best using the following approach, which we strongly recommend you try:

1.  Find some small problem or project that you're interested in tackling. You could try building a tool to solve a small problem in your life, or try implementing a program you find interesting from scratch. This project will help motivate you to continue to learn to code and will give you opportunities to practice applying what you're learning.
2.  Do some research to figure out which programming language is most appropriate for your project. (See below for recommendations)
3.  Find and follow a single, high-quality beginner-oriented resource for that language. (Again, see below)
4.  Supplement that resource by googling and asking questions
5.  Eventually complete several non-trivial projects using that language.

Here are some things we recommend you avoid doing:

1.  Don't just simply passively follow along whatever resource you're using. Do the exercises and homework assignments; practice is an absolutely essential part of learning to code.
2.  Avoid needlessly switching back and forth between programming languages; pick one and stick with it. This is because programming is ultimately about problem solving, not about programming languages. Learning to problem-solve is challenging and is a skill you can hone only through practice. Every time you switch languages, you're losing time you could have spent practicing applying what you've learned to improve your problem-solving skills.
3.  Don't stop learning once you've completed a tutorial. Programming is the kind of field where there's always something new to learn.

And finally, remember that learning to code can be a [long](http://norvig.com/21-days.html) and [difficult](https://www.vikingcodeschool.com/posts/why-learning-to-code-is-so-damn-hard) process. If learning to code feels hard, don't get discouraged! That's completely normal -- many people will spend years of their lives learning and practicing before they consider themselves competent enough to look for a job or contribute to a significant project. Fortunately, just getting started is not difficult at all.

### Which programming language should I start with?

There are two common misconceptions that cause people to ask this question. The first is that there actually is a "best" programming language for learning and the second is that the first language you learn will decide what the rest of your programming career looks like.

In reality, there is no best language to start with, and your first language has virtually no lasting effect on your eventual career. Programming languages can look very different on the surface, but the majority of the fundamental concepts will transfer from language to language. Learning a new language will also get easier over time -- it can take a beginner months before they feel comfortable with their first language; an experienced programmer can become familiar with a new language in a matter of days.

All programmers should ideally have experience in multiple types of languages. Once you are comfortable with one language, move on to another language which differs in some fundamental way. As you learn more languages, you will become more equipped to choose the right tool for the task at hand, which is a hallmark of a good programmer. Since programming concepts are what matter most, we recommended that beginners start with one of the mainstream languages from the table below. All these languages enable beginners to start writing simple applications and practice programming without having to use any of the more complex language features.

If you already have a project or goal in mind, you will learn faster if you can apply your skills to the problem you are trying to solve. The table below contains some recommended language choices for common projects:

|I want to learn how to...|Consider using...|
|--- |--- |
|...make iPhone Apps|Swift ([more](https://www.reddit.com/r/learnprogramming/wiki/faq#wiki_how_do_i_get_starting_making_mobile_apps.2Fandroid_apps.2Fios_apps.2Fwindows_phone_apps.3F))|
|...make Android Apps|Java ([more](https://www.reddit.com/r/learnprogramming/wiki/faq#wiki_how_do_i_get_starting_making_mobile_apps.2Fandroid_apps.2Fios_apps.2Fwindows_phone_apps.3F))|
|...build a website|JavaScript, CSS, HTML5 ([more](https://www.reddit.com/r/learnprogramming/wiki/faq#wiki_how_do_i_get_started_making_websites.2Fmaking_webapps.2Fdoing_web_development.3F))|
|...write Windows desktop applications|C#|
|...make 2D/3D games|JavaScript, C#, or C++ ([more](https://www.reddit.com/r/learnprogramming/wiki/faq#wiki_how_can_i_get_started_making_video_games.3F))|
|...program Arduinos/micro-controllers/robots|C|
|...do scientific/mathematical computing or data analysis|Julia, Python, R, or Matlab|
|...do automation and scripting|Many languages (Python, Ruby, Bash, Powershell, AutoHotKey...)|

If you still can't decide, try Python. Python is a good, beginner-friendly language with a huge community and many libraries for doing almost anything you want, ranging from making games to automating things at your home or workplace or doing data analysis to making websites. Try to find a learning resource which focuses on concepts and fundamentals before diving into more complex applications. You can find instructions for starting with any language on the subreddit [r/learnprogramming getting started page](http://www.reddit.com/r/learnprogramming/wiki/gettingstarted).

### Where do I find good learning resources (other than this course)?

*   [Books](http://www.reddit.com/r/learnprogramming/wiki/books)
*   [Online Resources](http://www.reddit.com/r/learnprogramming/wiki/online)
*   [Curated Programming Resources](https://github.com/Michael0x2a/curated-programming-resources/blob/master/resources.md)
*   [InfoCobuild Education](http://www.infocobuild.com/education/audio-video-courses/) - aggregated University courses
*   [OSSU Computer Science](https://github.com/ossu/computer-science) - a full long-term curriculum for CS starting from zero

## How to improve

### How do I move from a beginning to an intermediate level?

A common question we get from many beginners is "now what?". In particular, you might have tried working through some tutorials, books, courseworks, but ultimately have difficulty making the gap from understanding how things like if statements and for loop works to understanding how to actually _apply_ what you've learned to make complex and interesting programs.

Making this jump between intro tutorials to complex code can be difficult, and is a normal part of learning to code. [This article](http://www.vikingcodeschool.com/posts/why-learning-to-code-is-so-damn-hard) describes this phenomenon very well. Many tutorials (in particular, commercialized "learn-to-code" websites like CodeAcademy) tend to hand-hold you through the basics, but stop after that point, leaving many beginners floundering.

However, if you stick with it and work through the confusion, you'll eventually find yourself gradually growing better and better, until one day, without realizing it, you'll find that you've started to become competent.

Here are some suggestions on how to persevere, and what you should be doing next.

*   **Switch from passive learning to active learning**

    Rather just taking courses and classes that (you hope) will teach you what you want to learn, start actively researching for ways to teach yourself. If you have no idea how to make a game, for example, google "how to program a game in X", where "X" is the programming language you want to use. If you run into an error message you don't recognize, try googling it. Want to learn how to do machine learning? Google, and find a textbook, tutorial, or online course that seems good.

    You'll often be able to find tutorials explaining what exactly it is you want to do, or at least articles that give you overviews and clues on how to compose more specific search queries. More broadly, there's no shame in doing research to learn new things -- quite the opposite, in fact. Googling and researching is something all programmers, both beginning and advanced constantly do.

*   **Constantly be practicing**

    Programming is sort of like exercising, in that the main way to improve is through constant practice. Start simple, and try programming a basic game like "rock-paper-scissors" on the command line. Once you finish, try picking a more ambitious project, and work through that. Perhaps try some programming exercises, if you want to mix things up.

    Programming, fundamentally, is really about applied problem-solving, and the best way to learn how to problem-solve is to constantly be solving problems, big and small.

    (See also [FAQ: Where can I find practice exercises and project ideas](https://www.reddit.com/r/learnprogramming/wiki/faq#wiki_where_can_i_find_practice_exercises_and_project_ideas.3F) and [FAQ: I can't come up with any cool new ideas for a project. Am I simply lacking in creativity? How do other programmers become inspired?](https://www.reddit.com/r/learnprogramming/wiki/faq#wiki_i_can.27t_come_up_with_any_cool_new_ideas_for_a_project._am_i_simply_lacking_in_creativity.3F_how_do_other_programmers_become_inspired.3F))

*   **Learn how to decompose problems**

    When you're trying to tackle a large project or problem, it's easy to become discouraged by just how big or intimidating the task seems. Instead of being intimidated, work on breaking the problem up (_decomposing_ the problem) into smaller and smaller subproblems, until each individual subproblem seems manageable and doable.

    For example, let's say you wanted to make a rock-paper-scissors game. Well, if you really break it apart, this consists of several subproblems: how to get input from the user, how to make the computer pick a random option, how to tell who won, and how to repeat the entire thing (if you want to play multiple games).

    If you're not sure how to solve each of _these_ subproblems, try breaking it apart more. For example, if you're not how to tell who's won, you could break it up into more sub-problems: how to tell if you've tied, how to tell if you've won (assuming you picked rock), how to tell if you've won (assuming you picked paper), and how to tell if you've won (assuming you picked scissors).

    If you're absolutely not sure (for example, how do you make the computer pick a random option?), try googling it. In this case, googling "X pick random option" (where X is the programming language you're using) will bring up multiple different methods you could use. Sometimes, you can break a problem up into many pieces before needing to google, and sometimes will need to do so immediately.

    For example, if you're learning Java, want to learn to write games, but have no idea where to start or how to break the problem apart, googling "java game tutorial" would bring up several good results that would both teach you how to write games, and (usually implicitly) how you can break down the process of writing a game into smaller pieces.

    Essentially, you're trying to gain the mindset of an engineer. If a problem is big, don't give up. Keep breaking it up into smaller and smaller pieces, and research things that seem irreducible. Then repeat, continuing the cycle: break down, google, break down, google...

    This, by the way, is a pretty effective strategy for self-teaching! As you practice, you'll get better at seeing how to break down problems, and will expand your pool of knowledge/possible solutions to problems.

    See [FAQ: How can I improve my skill to convert tasks/problems into programs (Algorithmic thinking)?](https://www.reddit.com/r/learnprogramming/wiki/faq#wiki_how_can_i_improve_my_skill_to_convert_tasks.2Fproblems_into_programs_.28algorithmic_thinking.29.3F) for more suggestions.

*   **Learn how to be systematic**

    When coding and debugging your code, never fall into the habit of just "trying" things and hoping they work. Be as systematic and rigorous as possible, and avoid "trial-and-error".

    When writing code, take a moment to pause and plan out in paper a rough plan of attack. Consider sketching some diagrams, or jotting down some pseudocode. If you have to change your plan (which you most likely will), think about why you're making that change, and what your new plan of attack is. (This planning phase is also a good time to practice problem decomposition!)

    When debugging, never be aimless. Try and think like a scientist -- conduct experiments to either try fixing the bug or to narrow down where the bug might be, and record your results. If your hypothesis/attempted change turned out to be wrong, or if something worked when you didn't think it would, stop, pause, and figure out why. Consider tracking your experiments and tests in a notebook, if it helps you stay on-track.

    Bugs happen when your assumptions don't match up to reality. If something feels "off", don't ignore it -- trace that down until you pin down what the issue is/what incorrect assumption you made.

    Don't just "do" random stuff until you get lucky -- be systematic about it.

*   **Don't be discouraged by having to debug or google**

    Something that not all beginners realize is that having to spend more time debugging or googling is perfectly normal, even among professional programmers.

    Debugging (and struggling!) is an essential part of coding. Try to avoid being stressed out or impatient, if possible. Treat it as an interesting hunt or a puzzle!

    Even if you're making no progress on your actual code due to some bug, as long as you're being systematic, you're still practicing your problem-solving skills, albeit in a different way.

    As a result, even if you spend many hours working through a single bug, you should still consider it time-well spent. Debugging is one of the best ways to become good at problem-solving!

    (This is even more true as you grow more experienced. It turns out that the difficulty of bugs you encounter will grow and scale with your level of experience. It isn't uncommon for experienced programmers to have to spend months tracking down just a single bug if it turns out to be particularly nasty.)

*   **Don't be afraid to ask for help**

    And finally, if you're completely stuck and have no idea what to do next, don't feel bad about asking for help!

    Programmers are generally very helpful. Many people are also self-taught, and so understand what it's like to struggle as a beginner and what it's like to be completely stuck.

    As a caveat, make sure you've done your due diligence (tried decomposing the problem, tried debugging, tried googling, etc), and make sure you've come up with a good-quality question. Like any subculture, programmers tend to have certain implicit rules and expectations. One of the key ones is that your question should be well-posed (even if it's basic).

*   **Try taking a more rigorous intro course**

    This bullet point only applies if your only exposure to programming has been really basic "intro-to-programming" courses like CodeCademy. Those sorts of websites are good at giving you a _taste_ of what programming is like, and teaching some of the basics, but may not be helpful if you're trying to progress to an intermediate level.

    As a good rule of thumb, if whatever "intro to programming" course you took did not really challenge you, or did not ask you to work through exercises and mini-projects, you should consider finding a more rigorous one. Constant practice (and struggle!) is an essential part of the learning process.

### Where can I find practice exercises and project ideas?

**Project ideas:**

If you are trying to make a project, here are some lists of ideas you can reference for inspiration:

*   Big lists:
    *   [http://www.dreamincode.net/forums/topic/78802-martyr2s-mega-project-ideas-list/](http://www.dreamincode.net/forums/topic/78802-martyr2s-mega-project-ideas-list/)
    *   [https://github.com/karan/Projects](https://github.com/karan/Projects)
    *   [https://github.com/NirantK/awesome-project-ideas](https://github.com/NirantK/awesome-project-ideas)
    *   [https://github.com/florinpop17/app-ideas](https://github.com/florinpop17/app-ideas) - growing list
*   Project ideas accompanied by tutorials or writeups
    *   [Programming projects for advanced beginners](https://robertheaton.com/2018/12/08/programming-projects-for-advanced-beginners/) (blog series)
    *   [https://github.com/tuvtran/project-based-learning](https://github.com/tuvtran/project-based-learning)
    *   [http://aosabook.org/en/index.html](http://aosabook.org/en/index.html) - Note: read just the first book: "500 lines or less". Complete solutions can be found on [https://github.com/aosabook/500lines](https://github.com/aosabook/500lines)
*   Topic-specific projects:
    *   [http://inventwithpython.com/blog/2012/02/20/i-need-practice-programming-49-ideas-for-game-clones-to-code/](http://inventwithpython.com/blog/2012/02/20/i-need-practice-programming-49-ideas-for-game-clones-to-code/)
*   Other:
    *   [http://nifty.stanford.edu/](http://nifty.stanford.edu/) - Note: this website is really meant more for teachers who are looking for creative assignment ideas for their intro to programming courses, but it can serve as a good source of inspiration for self-learners.

Want to do something challenging? Try re-implementing programs that you use every day. For example, try writing your own...

*   Command line utilities (ls, wget, curl, etc)
*   Text editor
*   IDE
*   Image viewer
*   Office suite (something like Microsoft Office or Libreoffice)
*   Programming language (write an interpreter or compiler)
*   Web browser
*   Database (relational or non-relational)
*   Web server
*   Version control system

**Practice exercises:**

Here are some good sites/resources to start with:

*   On reddit
    *   [/r/dailyprogrammer](/r/dailyprogrammer) - a subreddit with daily programming challenges
*   General exercises:
    *   [Coding step by step](https://www.codestepbystep.com/)
    *   [Leetcode](https://leetcode.com/)
    *   [Codewars](https://www.codewars.com/)
    *   [Hackerrank](https://www.hackerrank.com/)
    *   [CodeAbbey](http://www.codeabbey.com)
    *   [Codingbat.com](http://codingbat.com/)
    *   [Ruby Quiz](http://rubyquiz.com/) - a series of "quizzes" which ask you to write short programs of varying complexity. The canonical solutions are all in Ruby, but the prompts are language-agnostic so you should be able use any other programming language as long as you don't mind not having a definitive solution for reference.
*   Topic-specific exercises:
    *   [Project Euler](http://projecteuler.net/) - Focuses on maths related problems (i.e. number theory, primes, numeral systems) intended to be solved in a programmatic way.
    *   [CodeByMath](http://www.codebymath.com/index.php/welcome/challenges) - Like Project Euler, but with possibly simpler problems
    *   [Rosalind](http://rosalind.info) - has problems with a bioinformatics twist.
*   Competitive programming exercises:
    *   [TopCoder](https://www.topcoder.com/tc?module=ProblemArchive) - Has a collection of algorithmic challenges collected from other contests.
    *   [UVa Online Judge](http://uva.onlinejudge.org/)
    *   [CodeForces](http://codeforces.com)
    *   [Timus](http://acm.timus.ru)
    *   [SPOJ](http://spoj.pl) - similar to UVA, with largest choice of programming languages allowed for solutions
    *   [USACO](http://usaco.org)
    *   [CodeWars](https://www.codewars.com/)
*   Language-specific:
    *   [P-99](http://www.ic.unicamp.br/%7Emeidanis/courses/mc336/2009s2/prolog/problemas/) and [L-99](http://www.ic.unicamp.br/%7Emeidanis/courses/mc336/2006s2/funcional/L-99_Ninety-Nine_Lisp_Problems.html) - A set of 99 basic problems designed to help you become proficient with prolog and lisp respectively.
    *   [4Clojure](http://4clojure.com) - A set of programming exercises specifically geared around Clojure, a Lisp-variant.
*   Other:
    *   [codegolf.stackexchange.com](http://codegolf.stackexchange.com/) - site for posting and discussing programming puzzles
    *   [Build your own X](https://github.com/danistefanovic/build-your-own-x) - aggregation of completed projects and tutorials with commented source code

### How can I improve my skill to convert tasks/problems into programs (Algorithmic thinking)?

This is one of the most commonly asked questions.

The general answer is: **By writing lots of programs.**

However, there is a simple exercise that can help you to build up that skill:

*   Pick an activity that you do every day, like making breakfast or something similar. It should be not too easy, but also not too difficult.
*   Write down the steps that you should do for the activity, but do it _out of memory_ in a different time to when you actually perform the activity. (Write the steps to make breakfast down in the afternoon.)
*   The next time you perform the activity take your notes and try to follow the steps religiously. Try not to deviate from your written down steps and if you have to, note the differences down.
*   Improve your algorithm until you are satisfied.
*   Try this with different activities. The tasks become easier and easier.

As stupid as it may sound, it works. The above has been tried on many students and proven to produce significant improvement.

### I can't come up with any cool new ideas for a project. Am I simply lacking in creativity? How do other programmers become inspired?

For starters, here's a good quote from [Chuck Close](https://en.wikipedia.org/wiki/Chuck_Close) on (not) waiting for inspiration:

> The advice I like to give young artists, or really anybody who'll listen to me, is not to wait around for inspiration. Inspiration is for amateurs; the rest of us just show up and get to work. If you wait around for the clouds to part and a bolt of lightning to strike you in the brain, you are not going to make an awful lot of work. All the best ideas come out of the process; they come out of the work itself. Things occur to you. If you're sitting around trying to dream up a great art idea, you can sit there a long time before anything happens. But if you just get to work, something will occur to you and something else will occur to you and something else that you reject will push you in another direction. Inspiration is absolutely unnecessary and somehow deceptive. You feel like you need this great idea before you can get down to work, and I find that's almost never the case.

You'll rarely get ideas by just sitting around and waiting for a spark of inspiration. Your time will be much more well-spent if you just go ahead and try building something (anything!), even if the idea seems somewhat stupid or already done.

After all, that's what artists and musicians do -- they don't necessarily start by trying to come up with a highly creative drawing or compose their own music. Instead, they draw landscapes or vases, or cover existing songs. Similarly, don't feel obligated when coming up with project ideas. Re-implementing existing programs is a time-honoured tradition -- see how far you can get!

But in any case, here are some other ideas and tricks for coming up with your own projects:

*   **Try reimplementing an existing project.** Much as how beginning musicians start by covering songs other people have written, it might be good to start by re-implementing programs others have made. 2D arcade games are a popular choice, for example -- games like "Pong" or "Space Invaders" are very doable by beginners and will still teach you a lot.
*   **Try connecting programming to another hobby.** Programming is a very useful skill in that you can apply it to a _wide_ variety of fields, even ones completely unrelated to computer science. For example, if you're interested in politics you could try analyzing voting pools and trends, if you're interested in music you could try writing a digital soundboard, if you're interested in sports you could try writing a fantasy football tracker or predictor, if you own a business you could write something to help you keep track of inventory... Having interests beyond computer science is useful here.
*   **Try keeping track of things that irritate you.** If you find anything in your life that you dislike doing or find repetitive, ask yourself if it's something you could automate. To get a sense of what sorts of things computers can automate, see [Automate the Boring Stuff](https://automatetheboringstuff.com/). This guide uses Python, but you can do all of the things it mentions using any programming language. Or, perhaps try googling "home automation tutorial" for more physical solutions.

### Where can I find examples of good code and projects to study?

Before you start, please keep in mind that studying existing code is not necessarily the best way to learn programming. Programming, in the end, is about applied problem solving, and the best way to get better at problem solving is through lots of practice. Just reading existing snippets of code isn't likely to teach you as much. Usually, when people _do_ study code, it's in a targeted and specific way. For example, if a dev was interested in writing a game using some engine, it would be helpful to see the source code for various demos using that engine.

In any case, try checking out the [Showcases](https://github.com/showcases) section on Github. It has a curated list of tons of popular and interesting open-source programs that range from libraries and games to music and open journalism/data analysis, and is a good showcase of what sorts of things people are doing with code. The source code is also publicly viewable, so you can try downloading and tinkering with these projects yourself.

Also see [The Architecture of Open Source Programs](http://aosabook.org/en/index.html), a series of free ebooks that contain more guided walkthroughs on how popular open-source programs are structured. The latest book in the series, "500 lines or less" might be a good starting point since the programs are small enough that you could feasibly tinker with them yourself and use them as a good jumping off point to start your own project.

### How do I learn topics covered by a typical computer science degree?

If you're interested in self-teaching yourself material covered by most standard computer science programs at the university or college level, the following links give a good overview, with links to additional learning sources:

*   [What every computer science major should know - Matt Might](http://matt.might.net/articles/what-cs-majors-should-know/)

    Focuses on giving a high-level overview of different fields, and more importantly, _why_ they're valuable. Also contains some reading recommendations.

*   [Open source computer science degree - Open Source Society](https://github.com/open-source-society/computer-science)

    Gives more of a concrete roadmap, with links to mostly Coursera courses per each topic.

*   [Teach yourself CS](https://teachyourselfcs.com/)

    Similar to the previous resource, except it mixes in recommendations for both books and video lectures. The upper-level recommendations focus mostly on systems (e.g. operating systems, databases...).

*   [A Self-Learning, Modern Computer Science Curriculum](https://functionalcs.github.io/curriculum/)

    This resource is a bit unconventional and recommends a far more mathematical approach to learning computer science, focusing on topics like discrete maths, functional programming, software verification, proofs, type theory, and complexity theory.

Please keep in mind that high-quality computer science degrees tend to be very rigorous and demanding. If you're interested in pursuing this path, it'll likely take you several years and a lot of hard work to acquire a similar level of education via self-teaching.

### How do I start and finish a large project?

First and foremost: **get a full, comprehensive understanding of the problem**.

Often, [**Rubber Duck Debugging**](https://en.wikipedia.org/wiki/Rubber_duck_debugging) helps with this step. Explaining a problem or concept to someone (or something) that has zero knowledge or understanding helps to gain a deeper insight into the problem. By doing so, one has to think a lot more about the problem which will lead to a deeper understanding.

Second: **Don't go straight to the computer!**

Spend considerable time pondering about the problem/task. Create some sketches, drawings, some pseudocode, some plain language hints, whatever may help **on paper** (I'm emphasizing this here because digital tools are distractions from the actual task at hand - use only pencil & paper or a whiteboard.) Analyse the problem thoroughly.

This leads us to the following.

Remember one thing when tackling big projects by yourself:

> Everything in the world is made of smaller parts.

This means that basically whatever big machine, house, skyscraper, car, train, computer, etc. you look at consists of many smaller structures that, combined, make the final product. The smaller structures consist of smaller structures and so on.

The same applies to big programs. They consist of many smaller units that are coupled together to form the whole. Ideally (but often not possible) each smaller unit should work (and be tested) independently from the others.

Start small. Look at the problem you have chosen and try to break it down into smaller parts. Rinse and repeat until you think that you can't break it apart any further.

Once you have reached that point, start programming. Build one small part, test it. Build the next small part, test it, and so on.

Don't look at the final, big picture as this will overwhelm you. Tackle one individual part at a time.

The biggest problem inexperienced programmers face is that mostly they get overwhelmed when they look at a large task. But this problem is not too difficult to overcome:

Don't try to see the final program with all bells and whistles. Focus on a small, manageable part, complete it, and move on. Even the most complex program/system consists of small, simple parts.

**How do I keep up with it?**

Imagine that you are working for a client and the client needs to see and approve your design before you start to code as they might have one or another comment, or they want to make sure that the communication between them and you worked and you understood their requirements.

*   Prepare a detailed description of your project, a so-called "functional design specification"
*   Discuss that functional design specification with your imaginary client (i.e. explain it to some inanimate object, or if you have somebody who can bear it, to them).
*   Refine the functional design specification - go back to the step above - loop until you are satisfied.
*   Prepare a project schedule with a fixed (realistic) deadline
*   Stick to the above (because otherwise the imaginary client would demand late-fees that could get quite expensive)

**Some additional advice:**

*   At first, forget about the code completely and imagine the program completely from the point of view of the user.
*   Write down a list of features you want the software to do.
*   Write down a list of features the software WON'T have. (This will keep you from feature creep with "it'd be cool if it could do this...". Programs getting too big is the main reason folks abandon them after a few weeks.)
*   Write out a few drawings of what screens the user will see and their workflow. These aren't blueprints or to show what they'll look like, it's more for "first the user is at this page, then they can go to this page". Sketching it out helps you not forget any big things.
*   Learn how to use git and get a github account. It's great for backup and also soliciting code reviews. (Ignore anyone's comments that are about code style, 99% of the time that's an unproductive debate.)

* * *

## Common concerns and fears

### Am I too old to code?

No, you can learn to program, and possibly have a career doing so, at any age.

There's a common myth that the only way to be good at programming is if you start learning to code at an early age. This is false -- while there are some people who start learning to code early (and so might have a bit of a head start), most people will start to learn to code when they enter college, or later.

Learning is something you can do at any age -- rather then focusing on others, just focus on yourself, and your personal rate of progress. Try and cultivate a "[growth mindset](http://edglossary.org/growth-mindset/)" rather then a "fixed mindset".

### Is there anything I should learn first?

There are very few prerequisites -- for the most part, you can jump straight into learning to code.

The only real prerequisites are:

*   You know how to type (unless you're using a drag-and-drop language like Scratch)
*   You own a computer
*   You know how to google/search for answers independently

It's also helpful if you know some maths (up to the basic algebra level) and if you know English (because many online resources are in English), but the two aren't required.

All of the above is also more-or-less true if you want to get a formal degree at a university. Most universities and colleges expect incoming students to know nothing about computer science and programming, and will start by teaching you from scratch (though in some cases, you can skip one or two intro courses if you pass a test or demonstrate enough prior skill). If you're in high school or earlier, and want to study computer science at college, then it might be good to start studying ahead of time to get a head start, but you shouldn't feel obligated to do so.

Some colleges may also have more stringent general education or maths prerequisites (most colleges have calculus as a pre-requisite, for example), but this will vary from college to college and is something you should directly investigate and ask the colleges and universities you're interested in attending about. See below for more details.

### Do I have to be good at maths?

Not necessarily - programming and computer science is a wide and broad field, and whether or not you need to be good at maths depends on what discipline you chose to specialize in.

For example, some disciplines of programming do require strong maths skills. 2D and 3D games will make frequent use of vectors, matrices and linear algebra; data mining and machine learning make use of many concepts from statistics; and working out algorithmic complexity is easier if you have a good grasp on algebra and basic calculus.

In general, the more advanced and complex the topic, the more likely it is that you need to have a strong mathematical foundation. If your goal is to be able to work on those types of complex problems, then having a good foundation will be invaluable.

However, just as many aspects of computer science and programming _do not_ require a good understanding of maths. The only things you _really_ need to know are how to add, subtract, multiply, and divide, and maybe a little basic algebra. Many programmers go through their entire career with having to do barely any maths at all.

In particular, many product-facing roles (e.g. web development, mobile development) require very minimal knowledge of maths. In those sub-disciplines, what matters most is your ability to write robust and maintainable code, as well as your ability to figure out how to build things that are valuable to your users.

In any case, if you're not very good at maths, you can definitely learn and improve! After all, you're presumably not very good at programming yet either, but here you are, learning to code. Check out [Khan Academy](http://khanacademy.org) and you can find free lessons starting from basic maths on up.

Do note, however, that the answer is a bit different if you are interested in getting a _degree_ in Computer Science. Many universities or colleges will have specific prerequisites you need to fulfill before you can either enter the major or graduate (calculus classes, etc). And, since Computer Science is, to a certain degree, [applied mathematics](https://www.reddit.com/r/learnprogramming/wiki/faq#wiki_what_is_the_difference_between_computer_science.2C_computer_engineering.2C_software_engineering.2C_programming.2C_and_coding.3F), you will almost certainly end up learning about discrete maths, writing proofs and other similar topics while earning your degree. You do not need to be inherently good at maths in order to learn these topics (or any mathematical topic, really), but having some mathematical maturity certainly wouldn't hurt, and would probably smooth the learning process.

Exactly how mathematically-focused a CS degree will be differs from school to school. Some schools place a heavy emphasis on covering theory, while others de-emphasize both in favour of focusing on application. (And some schools emphasize both). If you want to find out more, you should directly investigate the degree requirements and structure of whatever colleges or universities you are interested in attending. We will not be able to easily predict what direction some given university will skew.

To summarize, you do not necessarily need to be good at maths if you want a successful career as a developer. If you want to be a computer scientist, you will end up learning a fair amount of maths. If you want to work on harder problems/within certain domains, maths can be a helpful tool, depending on the situation.

### I Google a lot or don't know how to complete something before I start. Is that okay?

**YES**. [Here](https://www.reddit.com/r/learnprogramming/comments/4mehpk/is_it_normal_as_a_programmer_to_never_know_how_to/) is a thread which discusses the topic from a variety of angles. There are many more like it.

### Is programming hard?

Programming is like most skills: it's relatively easy to learn the basics and apply them. If you want to learn to bowl - you'll figure out how to put your fingers into the holes, and chuck it in the general direction of the pins. You might even knock a few over, and not find it particularly difficult.

Programming is also like most skills in that it is much more involved to go from a beginner to someone with a degree of skill. To continue the bowling analogy: if you want to become a competition bowler, you're going to have to spend years mastering the skill. The same is true of coding: you're going to need to spend some (that is, a lot of) time trying to figure out why this **stupid** program won't work even when you've checked it **three times**. You're going to need to read books, sit through lessons, and talk to people about it. You're going to learn jargon. You're also going to specialise - learning more about a few small fields really deeply. All of this still uses the basics of programming, but in new ways, and new combinations. Finding solutions to your problems will be hard. Focusing for hours on the same problem will be hard. That's okay, because if you enjoy it, and you're motivated - the hard parts don't feel as hard, and you can get through them.

In summary, programming can be hard. Just like with most things, it takes effort, and that effort can be hard. Don't be discouraged - if you enjoy it, the hard parts will be worth the reward.

### Is it normal for a beginner to have some trouble on problems and some exercises?

Is it normal for a beginner to fall off a bike a couple times? Is it normal for a beginner to sink a couple times when learning to swim? Is it normal for a beginner to miss notes or play the wrong notes when learning an instrument? Is it normal for a beginner to burn some meals?

**Absolutely yes!**

Seriously, this is one of the dumbest, most frequently asked questions in relation to programming. Of course, it is natural to struggle and fail. After all you are just a _beginner_. You're supposed to struggle and fail.

_Failure_ is an important part of learning. It is very important to know how _not to do things_. Failure is just _gained experience_.

If you didn't fail or struggle, you would not be a beginner, you would already be an expert (and even those fail occasionally, just not as often as a beginner and usually they know how to recover).

* * *

## Questions about learning

### What does it mean to "know a language" or to "know how to program"?

To "know a language" for programming is similar to knowing a language for speaking. You can say you know it when you can use it effectively, even if you don't know "everything" about it. To "know how to program" generally means that you understand the concepts related to programming and you can use them effectively in one or more languages. Read some past threads on the topic.

*   [http://redd.it/vhccu](http://redd.it/vhccu)
*   [http://redd.it/iea3f](http://redd.it/iea3f)
*   [http://redd.it/s4n5o](http://redd.it/s4n5o)
*   [http://redd.it/1nf8yd](http://redd.it/1nf8yd)

### I just started learning language X. Should I start learning language Y?

Especially when you're starting to learn how to program, it's best to learn one language and stick with it for a while. Even if a particular problem domain uses a specific language that you don't know yet, first learn _how to program_. Once you understand the fundamentals (flow control, error handling, I/O, implementation of algorithms, data structures, etc.), then you can start worrying about picking up different languages.

### Should I learn more than one programming language at once?

If you are just starting out we recommend that you select _one_ language (as the previous answer says, it doesn't really matter which), and stick with it for at least a month. Experienced programmers can learn bits of several languages at the same time, but beginners are more likely simply to confuse themselves by doing so. Combining a _programming language_ (C, C++, C#, Java, Python, JavaScript, Ruby, etc.) with _markup languages_ (HTML and CSS) is fine, however as they are not comparable at all.

### How can I get/stay motivated to learn programming?

Check out [/r/GetMotivated/](/r/GetMotivated/) and [/r/GetDisciplined](/r/GetDisciplined).

Often we think "if I were motivated enough... then I could...," however; it is action that drives motivation. First comes action, then motivation. Find small, specific programs to create. Get rid of the distractions. Get browser plugins to block websites such as Reddit, Facebook, and Twitter. Take a minute to visualize how great it will feel when you have become a more knowledgeable programmer.

Here are some past threads on this topic:

*   [http://redd.it/uzt31](http://redd.it/uzt31)
*   [http://redd.it/1c1bnj](http://redd.it/1c1bnj)
*   [http://redd.it/2j6b7i](http://redd.it/2j6b7i)
*   [http://redd.it/1s347g](http://redd.it/1s347g)
*   [http://redd.it/javfv](http://redd.it/javfv)
*   [http://redd.it/gy0xa](http://redd.it/gy0xa)
*   [http://redd.it/1xvdte](http://redd.it/1xvdte)
*   [http://redd.it/1hh76b](http://redd.it/1hh76b)

## How do I get started in X?

### How can I get started making video games?

Modern video games are made using [game engines](https://en.wikipedia.org/wiki/Game_engine): software libraries that handle complex tasks like graphics, sound, physics and networking. There are many [options available](https://www.reddit.com/r/gamedev/wiki/engine_faq) - However, the following engines are strongly recommended for beginners as they are free to develop with and have the best documentation for learning:

*   [Unity](https://unity3d.com/learn/tutorials) (C#): Suitable for 2D & 3D mobile, desktop, browser/online & console games
*   [Construct2](https://www.scirra.com/tutorials/37/beginners-guide-to-construct-2) (JavaScript): for 2D mobile, desktop, browser/online
*   [Pygame](http://inventwithpython.com/pygame/chapters) (Python): engine for 2D desktop games
*   [LÖVE](https://love2d.org/wiki/Category:Tutorials) (LUA): Suitable for 2D desktop games

Always remember that [your goal is to develop games, not engines](https://en.wikipedia.org/wiki/Reinventing_the_wheel)!

Engines will help you get started with graphics and user controls for your games, but you will still need to thoroughly learn a programming language to write your [game logic](https://unity3d.com/learn/tutorials/topics/scripting) - so pick a good [Book](https://www.reddit.com/r/learnprogramming/wiki/books) or [Online Resource](https://www.reddit.com/r/learnprogramming/wiki/online).

Most importantly: **Start simple**. You will want to dive right in and create your dream game straight away, but remember that [the only way to climb a mountain is by taking many small steps](https://www.reddit.com/r/gamedev/comments/stg2o/how_i_went_from_knowing_nothing_about_programming/). Here is a list of simple practice games listed in ascending order of difficulty - consider trying a few of these before jumping right to your end goal:

*   [Guess the number game](http://www.funbrain.com/cgi-bin/gn.cgi?A1=s&A2=100&A3=1)
*   [Blackjack](https://en.wikipedia.org/wiki/Blackjack) or [Tic-tac-toe](https://en.wikipedia.org/wiki/Tic-tac-toe)
*   [Hunt the wumpus](http://www.ifiction.org/games/playz.php?cat=&game=249&mode=html) ([Rules](https://en.wikipedia.org/wiki/Hunt_the_Wumpus))
*   Your own choose-your-own adventure or [Zork](https://en.wikipedia.org/wiki/Zork) clone
*   [Pong](http://noobtuts.com/unity/2d-pong-game), [Tetris](http://gamedevelopment.tutsplus.com/series/implementing-tetris--gamedev-12717) or Minesweeper clone
*   Horizontal/Vertical scrolling [Space Shooter](https://unity3d.com/learn/tutorials/projects/space-shooter-tutorial)
*   Simple DOOM, Mario or Legend of Zelda clone

Be sure to check out the [/r/gamedev](/r/gamedev) FAQ, read the [/r/gamedev](/r/gamedev) "How to Get Started" guide, and perform some searches for past threads on [/r/gamedev](/r/gamedev) and [/r/learnprogramming](/r/learnprogramming).

### How do I get started making websites/making webapps/doing web development?

There are many different ways to learn about web development, but in general, the core skills that you need are usually divided into _frontend_ skills (code that runs on a user's web browser), and _backend_ skills (code that runs on your server).

In general, most people will recommend that you start by learning HTML, CSS, and Javascript (in that order), which are the core three languages that run on every web browser and makes up every website.

You can find more information on the [/r/webdev FAQ](http://www.reddit.com/r/webdev/wiki/faq). Here's another [list of online courses, tutorials, and resources](https://github.com/Michael0x2a/curated-programming-resources/blob/master/resources.md#html-css-and-javascript) for beginners.

### How do I get starting making mobile apps/Android apps/iOS apps/Windows phone apps?

You will need to learn a different programming language for each type of smartphone.

*   Android apps are coded primarily in Java -- see [/r/androiddev's FAQ](http://www.reddit.com/r/androiddev/wiki/index) for more info.
*   iOS apps are coded in either Objective-C or Swift -- see the sidebar of [/r/iosprogramming](/r/iosprogramming) and their wiki ([hosted on Github](https://github.com/programmingthomas/FAQ)) for more info.
*   Windows Phone apps are coded in either C#, Visual Basic, or Javascript -- see the sidebar of [/r/WPDev](/r/WPDev) for more info.

You can also make apps that can run on all three major smartphones using technologies such as [Phonegap](http://phonegap.com/) and [Titanium](http://www.appcelerator.com/titanium/) -- they allow you to write your app once using HTML, CSS, and Javascript, and run your app on any platform.

See the [list of mobile app development resources](https://www.reddit.com/r/learnprogramming/wiki/online#wiki_mobile_app_development) for more information. Here is a past thread on the topic: [http://redd.it/352f09](http://redd.it/352f09)

However, do keep in mind that many, if not all, of the above sources are geared towards people who already have some prior experience with programming. If you've never programmed before, you _may_ want to start with learning a language which has more resources geared towards beginners. Once you've acquired some experience, and learned about the underlying concepts behind programming, you'll often find that it's _much_ easier to learn a new language and begin learning about mobile development. The [Getting Started](http://www.reddit.com/r/learnprogramming/wiki/faq#wiki_how_do_i_get_started_with_programming.3F) section in our FAQ has some more info on where to begin.

### How do I automate things?

For _Windows_ there are a couple dedicated programming languages, such as [Autohotkey](https://autohotkey.com/) and [AutoIt](https://www.autoitscript.com/site/autoit/).

Another viable, cross platform alternative is [Python](http://python.org). [Automate the Boring Stuff with Python](http://automatetheboringstuff.com) is a great learning resource.

If you want to automate _MS-Office_, use the built-in programming language _Visual Basic for Applications_ (VBA). [/r/vba](/r/vba) is dedicated for VBA programming.

* * *

## What are the best...

[/u/thekodols](/u/thekodols) compiled a list of more than 150 "what are the best" questions and answers in [this post](https://www.reddit.com/r/learnprogramming/comments/3r7lhp/a_collection_of_150_what_are_the_best_dev/) covering various languages, tools, and topics.

* * *

## Terminology and Vocab

### What is the difference between computer science, computer engineering, software engineering, programming, and coding?

**CS/CE/SE vs Programming/Coding**

Computer science (CS), computer engineering (CE), software engineering (SE), programming, and coding are all terms that are interrelated yet subtly different from each other, often making it difficult for beginners to tell them apart.

The first distinction you should make is to distinguish between CS/CE/SE and programming/coding. CS, CE, and SE are all **fields of study**. Saying "I'm studying computer science" would be similar to saying "I'm studying chemistry" or "I'm studying literature". In contrast, programming and coding are **activities** -- they're things you do. To use a metaphor, studying CS/CE/SE would be like studying musical theory, while learning programming/coding would be like learning how to play a particular instrument.

Theoretically, you could learn one and not learn the other, but your experience will be much more enriched if you learn both.

Another difference is that while CS/CE/SE are things that you can study, learning to program is something that only comes through practice. And in fact, what most universities and schools will do is formally teach one language to teach the basics of coding, then will focus on teaching CS, CE, and SE and leave you to learn how to program through practicing and completing homework.

**CS vs CE vs SE**

The next distinction you should make is between CS, CE, and SE. In a nutshell, though there's a lot of overlap, "computer science" has little to do with either computers or science and is more of a field of applied maths that studies the concept of computability. Computer engineering is similar to CS, but tends to focus more on lower-level hardware -- it's like a cross between computer science and electrical engineering. And finally, software engineering is more about how to build large and complex programs while preventing them from collapsing under their own weight -- it's like CS and CE, but with less theory.

You can find a more detailed overview here: [http://www.reddit.com/r/learnprogramming/comments/2k569h/eli5_computer_science_vs_software_engineering_vs/](http://www.reddit.com/r/learnprogramming/comments/2k569h/eli5_computer_science_vs_software_engineering_vs/)

**Programming vs Coding**

And finally, you have programming vs coding. The difference between these two terms are very small -- many people use them interchangeably. In general, the term "programming" seems to have slightly more positive connotations then "coding". If you say "I'm a programmer", it implies a certain level of professionalism -- it indicates that you can not only write code, but also have a firm grasp on the fundamentals and theory, know how to communicate with clients and work with others, etc.

In contrast, if you say "I'm a coder", it usually implies that your focus is exclusively on writing code, and less so on the other things.

However, again, the different connotations are very small here -- you can use the two terms interchangeably in the vast majority of cases.

### What is the difference between C, C++, Objective-C, and C#?

TL;DR - C, C++, Objective-C, and C# are **not** different flavours of the same language.

C is the smallest and the oldest of these languages. It was originally created as a systems programming language for the Unix operating system, and is still widely used today for applications programming.

C++ is a very popular, general-purpose programming language, originally based on C. With some tweaking, most C code can be made to compile as C++ code. However C++ adds a large set of language features which change the way the language is used significantly from the way C is used. It is generally considered a bad practice to write C-style code in C++.

Objective-C is a strict superset of C, meaning that all valid C code is also valid Objective-C code. Objective-C is not nearly as popular as C or C++, and is mainly used today in development for Apple's OS X and iOS platforms.

C# is _not_ based on C in any technical sense. C# is a general purpose language designed by Microsoft and is similar in many ways to Java. It compiles down to an intermediate form which runs in a virtual machine (CLR), unlike the previous three languages which are all compiled to native machine code. While C# borrows syntactic elements from C and C++ (as does Java), it has no real technical relation to those languages.

### What is the difference between Java and JavaScript?

Java is related to JavaScript in the same way that a grape is related to a grapefruit.

Similarly to the previous question, Java and JavaScript are not related in any technical sense. They share a bit of syntax as they are both influenced by C, but that's about it. Wikipedia has a good explanation of why the name similarity exists: [Wikipedia: JavaScript and Java](http://en.wikipedia.org/wiki/Javascript#JavaScript_and_Java)

### Classes versus Interfaces

This is a question that appears frequently and often confuses beginners since on the outside both seem to do similar things.

[/u/donsagiv](/u/donsagiv) wrote a great and simple ELI5 (link to [original comment](https://www.reddit.com/r/learnprogramming/comments/d56gnb/eli5_interface_vs_class/f0k5ism/)):

A boy scout has badges that merits them to do certain things, such as cooking, swimming, starting a campfire, canoeing, etc. The boy scout troop doesn't care how they were able to do these things (i.e. swimming with the breast-stroke, back-stroke, etc.) as long that they meet the specification for it (being able to move in the water by a certain, controlled movement of the body while staying afloat). Each boy scout can have zero or many badges, meaning they are certified to do each of the things merited by the badge.

Despite that, they are still boy scouts. Every boy scout is allowed to attend their periodic meetings, wear their uniform, etc... A boy scout doesn't need a badge to swim. However, they can't go river-rafting unless they have a swim badge. **Edit: a swim badge can't swim by itself. It is merely an indicator that the boy scout it's attached to can swim.**

**The boy scout is the class, and the swim badge is an interface it implements**.

Every object that of the class that is instantiated have the same functions (i.e. attending periodic meetings, uniforms, etc). If the class implements an interface, the class MUST have be able to perform the functions specified in the interface (i.e swimming, canoeing). Some classes can't be used in certain parts of your code unless they implement that interface (i.e. going river rafting requires swim badges). **Edit: An interface is an abstraction, so it can't be instantiated. (A badge by itself can't swim.) To sum up, an interface is a contract a class must follow in order for a class to implement it.**

Interfaces and classes behave differently in different languages (My example is from what I know in C# with generics). I suggest you read the documentation to your language carefully.

Interfaces can also be used to collect objects from different classes (they act like a data type).

You could collect all boy scouts who can swim, regardless of their nationality, gender, age, etc. and go river rafting. You don't need to know anything about the individual boy scouts, but you know that each of them is able to swim.

## Tools and version control

### What is Source/Version/Revision Control? Should I be using it?

A Version Control System (VCS) is a tool which keeps track of the changes to your code, and allows you do handy things like undo coding errors and see what has changed in the code over time. Modern Distributed Version Control Systems (DVCS) also allow you to work easily with other programmers on the same code. And yes, you should definitely be using a version control system!

The two most popular DVCSs are git and Mercurial; which you use mostly comes down to personal preference, but we _strongly_ advise you to use one of them.

### So how do I get started with revision control?

You can start with git by reading [a git primer](http://cgordini.blogspot.com/2013/05/git-101.html), written by a redditor, and also [the free git book](http://git-scm.com/book).

A good, brief tutorial on Mercurial is [here](http://hginit.com/01.html).

We have links to download sites for both pieces of software on [our tools page](http://www.reddit.com/r/learnprogramming/wiki/tools#wiki_version_control_systems).

### What is an IDE? Should I be using one?

An IDE is an Integrated Development Environment, which is a GUI application that generally includes a text editor with code completion and syntax highlighting, some project management features, a compiler or interpreter (either configurable or included), and many other fancy features to make writing, running, and testing code easier. The alternative to using an IDE is to do what the IDE is doing for you automatically on your own. This method requires the programmer to use separate tools and to have a more in-depth knowledge of the development process.

For beginners, there are arguments for both of these development methods:

*   Using an IDE means that you don't have to know as much about the development process, don't have to use a command-line interface, and don't have to configure those tools to work together correctly; an IDE offers a quick way to get your code building, and may even write some of the code for you!
*   On the other hand, working from the command-line means that you don't have to fit in with the mindset of the IDE's designer, and since less of the development process is hidden from you, you get a better understanding of the software build process.

Use of an IDE versus separate tools generally comes down to a matter of personal preference (unless of course your employer/school requires the use of a specific development environment). If you've never used an IDE before, download one of the popular ones and tinker around with it. And if you've never used vim or compiled code from the command-line, try it out and see if you like it. A list of common IDEs and lightweight text editors can be found in [Programming Tools](http://www.reddit.com/r/learnprogramming/wiki/tools).

* * *

## Computers and Operating Systems

### What kind of operating system should I use?

A common question many beginners have is what sort of operating system they should use -- Windows, Mac, or Linux.

It honestly doesn't matter -- in this day and age, the quality and maturity of the tools available to you are going to be about the same on all platforms, and any decent programming language will be useable on all operating systems.

That being said, you should eventually gain some level of familiarity with all three operating systems so that you're not completely lost when you encounter a new kind of OS (for example, when remoting in to another machine or when you arrive at a new job).

There are two main exceptions to this rule:

*   If you want to do Windows-specific development, get a Windows computer.
*   If you want to do Mac or iOS-specific development, get a Mac.

There are a number of good options for running [C# code on other platforms](http://timjones.tw/blog/archive/2015/09/19/cross-platform-csharp-and-fsharp-in-2015), but some Microsoft and .NET tools are still primarily targeted towards Windows.

While you can develop Mac and iOS apps on any computer, you must use Xcode on a Mac machine to compile and submit your app to the app store.

Finally, it's also worth noting that you're not "locked in" once you've picked an operating system -- it's always possible to run a virtual machine (VM) with another operating system installed. For example, if I own a Windows computer, it would be very easy to set up a Linux virtual machine that I can use without fear of it interfering with my existing Windows OS.

### What kind of computer/laptop should I get?

Again, it doesn't really matter -- any mid-range laptop or computer should do. If you already own a computer or laptop, you should just use that instead of purchasing a new computer. Basically, you can learn to program and can write complex and interesting programs on pretty much any computer in existence.

If you're basically destitute and without any usable computer, you can always check places like Craigslist for a used computer, or ask around. You can get very far with an old computer if it's just for learning.

However, if you happen to need to buy a new computer and want to use it for programming, you should prioritize CPU, RAM, and hard drive space. If possible, try and obtain a computer with the following specs or better:

*   Intel i5 CPU (3.0+ GHz)
*   4+ GB RAM
*   200+ GB Hard drive
*   (Optional) A solid-state drive

If you can upgrade, it's probably safe to prioritize getting a better CPU and more RAM over getting a larger hard drive -- a beefier CPU will always help. In contrast, most kinds of programming don't require you to have a lot of disk space: the only exceptions would be if you're trying to do something with images or videos, or if you want to download and analyze large data sets while learning about machine learning and similar things (and you can typically store those things in the cloud, if it comes down to it).

If you want to purchase a desktop, these specs are really the only relevant ones. If you want portability, you should purchase a laptop and make sure that it comes with a big enough screen and keyboard to be comfortable programming with. However, there's a fine balance between usability and portability in a laptop:

*   The larger the screen, the shorter the battery life (but the dimmer you're willing to set the screen's brightness, the longer the batter life)
*   The smaller the screen, the less you can fit on it and the more flipping between windows/desktops you'll have to do.
    *   Ideally, you should be able to comfortably fit 2 windows side by side
*   The larger the laptop, the heavier it is, and the heavier it is to carry around

It's also worth asking yourself how you plan on using your laptop. Do you plan on just having it sit on your desk all day, or on carrying it all around campus, or on going hiking in the Yukon with it?

If possible, try testing the laptops you're considering in person. If you find typing on particular laptop's keyboard to be unpleasant and not something you can get used to, for example, you may want to give that laptop a pass no matter how good it looks on paper.

If you are also trying to buy a laptop to prepare for classes in university or college, you may want to try checking their website/the website of their computer science or software engineering departments to see if they have any more specific suggestions and recommendations.

For more information, and for more detailed help, visit the following subreddits to get more personalized recommendations:

*   [/r/suggestalaptop](/r/suggestalaptop)
*   [/r/suggestapc](/r/suggestapc)

You may also want to be cautious about buying Chromebooks -- they'll require either some degree of customization or will require you to work using online editors and IDEs and require constant internet access. For more information, see the following links:

*   [http://www.howtogeek.com/162120/how-to-install-ubuntu-linux-on-your-chromebook-with-crouton/](http://www.howtogeek.com/162120/how-to-install-ubuntu-linux-on-your-chromebook-with-crouton/)
*   [http://blog.codestarter.org/post/93985346780/how-we-turn-199-chromebooks-into-ubuntu-based](http://blog.codestarter.org/post/93985346780/how-we-turn-199-chromebooks-into-ubuntu-based)
*   [http://www.reddit.com/r/learnprogramming/comments/1ba1gd/programming_on_a_chromebook/](http://www.reddit.com/r/learnprogramming/comments/1ba1gd/programming_on_a_chromebook/)
*   [http://www.chromebookhq.com/five-best-online-ides-making-the-switch-to-a-chromebook/](http://www.chromebookhq.com/five-best-online-ides-making-the-switch-to-a-chromebook/)

You should be even more cautious about trying to use tablets or phones as your primary programming device. While it's possible to program using a tablet or phone with some effort, nearly all software development is done using desktops or laptops using a keyboard.

If you need advice on picking a specific brand, just keep in mind that programming doesn't require anything special from your computer. This means that a good general-purpose computer will, in all likelihood, be a good programming computer. (This makes searching for a good laptop easier, since you don't need to try and search for one specifically marketed towards programmers.)

One final optional constraint: If you're specifically interested in doing machine learning, natural language processing, or graphics (including game development), you may want to consider purchasing a machine with a GPU. While you don't need a GPU to do any of these things, you can often speed up your code by carefully writing it so that it takes advantage of GPUs (when possible).

If you're interested more in machine learning or NLP, do note that you can rent machines with GPUs in the cloud via services like Amazon Web Services (AWS) or Google Compute Engine (GCE) for relatively cheap prices.

* * *

## Careers and jobs

### Can I earn lots of money programming?

Maybe, but only if you are good at it. But you can also earn lots of money as a plumber, or in any other number of businesses. You can also fail horribly. Programming is not a guaranteed, safe job.

### Can I get a programming job without a Computer Science degree? Or without any degree at all?

Yes and yes.

It is possible to get a job without a CS degree, and without a degree in general, though with decreased probability. Quitting school is definitely not recommended. If programming isn't for you, switch majors. If it is for you, staying in school will give you the best chance at a job once you are finished.

You may get more informed responses to these and other career-oriented questions if you post them in [/r/cscareerquestions](/r/cscareerquestions) or [/r/cscareerquestionsEU](/r/cscareerquestionsEU).

### How do I break into the industry and get an entry-level job?

This question is again mostly out-of-scope for this subreddit -- career-related questions are better asked on [/r/cscareerquestions](/r/cscareerquestions) and by consulting their [comprehensive wiki](https://www.reddit.com/r/cscareerquestions/wiki/index). Also see [/r/cscareerquestionsEU](/r/cscareerquestionsEU) if you are living in the EU.

But in general, there are two main phases to getting an entry level job, assuming you already know how to code:

1.  Build a CV that stands out enough that people start inviting you to interview
2.  Pass the interview

The two stages require somewhat different strategies.

**Phase 1: Build a CV that stands out**

In phase 1, your goal is to steadily start adding items to your CV that help you stand out (or at least help make you comparable to) any other applicants that are applying.

One particularly helpful strategy for doing this is to start building a portfolio of non-trivial projects you can show off to prospective employers. Your portfolio could contain anything ranging from:

*   Independent side projects
*   Volunteer work -- e.g. maybe making a website for some non-profit
*   Class projects
*   Work you did at your job where you found a way to incorporate programming
*   Technical work you do for a club at school -- maybe some club wants a new website, or maybe you can find a club with a technological focus
*   A research project -- either an independent one, or research you did as a part of a lab at your school
*   Projects from past jobs or internships

Having a strong portfolio shows employers that can successfully apply programming languages, libraries, and technologies to solve problems and gives them a way to more accurately gauge your skill level. (And, as it turns out, working on non-trivial projects is also one of the better ways to improve your skill level in general!)

To put it another way, you want to establish that you have a track record of successfully building relatively complex things. If you don't have any prior job history in this field, working on projects is one of the better ways of doing that.

Some additional notes:

*   Your projects don't necessarily need to be visually flashy. Most recruiters will focus on your CV (and often will read _only_ your CV!), and recruiters with a technical background will understand that not all interesting projects have or need a slick interface. What's probably more important that you can honestly describe your project on your CV in a way that showcases the complexity of the work you did.

    Perhaps the main exception is if you're applying to a role that requires some visual flair. For example, if you're applying to a frontend web designer role, it would help to have projects that show you can make a polished and usable website.

*   Of course, working on projects aren't the only things you can do. Doing things like getting a degree (preferably in a subject related to computer science) will also definitely help. Just keep in mind that many job applicants will also have a tech-related degree, so just having one might not be sufficient to help you stand out -- you'll also want to take full advantage of any extracurricular opportunities your school has to offer. Good schools will have many potential side projects you can get involved in if you dig a little. Having access to those potential side projects is one of the biggest benefits to paying tuition.

*   Some people also attend bootcamps in part to expedite the process of building a relevant CV/portfolio. Just be sure to do your research before committing to a bootcamp: some are great, and some are outright scams. Before committing to any one bootcamp, try reaching out to alumni of that bootcamp on sites like Linkedin to see how they feel, try checking to see if the bootcamp reports stats on [CIRR](https://cirr.org/), try asking people in a variety of different communities (not just reddit)... Also see [/r/cscareerquestion's FAQ section on bootcamps](https://www.reddit.com/r/cscareerquestions/wiki/index#wiki_bootcamps).

*   If your CV is not getting a lot of attention, try posting it for review on [/r/cscareerquestions](/r/cscareerquestions)' or [/r/cscareerquestionsEU](/r/cscareerquestionsEU)'s weekly CV review thread.

**Phase 2: Pass the interview**

What exactly happens in phase 2 (pass the interview) can vary from region to region. For example, many silicon-valley-esque companies prefer asking data structures and algorithms questions, so if you plan on applying to those types of companies having a strong foundation in that topic is a must. This may not necessarily be the case in other parts of the world or for other kinds of companies.

Some common interview archetypes you may run into include:

*   Giving you a coding challenge of some kind, usually about data structures and algorithms -- especially at the entry level. To learn more about what these types of interviews look like and how to prepare for them, consider purchasing or borrowing a copy of "Cracking the Coding Interview".
*   Asking you questions related to the specific role you're interviewing for -- e.g. frontend web design, security, data science...
*   Asking you to pair program together with your interviewer where you collaboratively build or debug a small program
*   Asking you to complete a take-home challenge of some kind
*   Asking you to try designing the high-level architecture of some larger program
*   Asking you about items you have listed on your CV (sometimes in general, sometimes focusing on a single project in-depth)
*   Just having a discussion about technology in general

Note: this is not an exhaustive list. You should also keep in mind that different employers will look for different things and interviewing practices that are common in one area may be almost completely unheard of in another. So, we strongly recommend you network with developers in your local area and ask them for advice.

Also see [/r/cscareerquestions' wiki](https://www.reddit.com/r/cscareerquestions/wiki/index) -- and perhaps [/r/cscareerquestionsEU](/r/cscareerquestionsEU) if you're living in the EU.

* * *

## Now what do I do?

### No longer a beginner:

There comes a time when every programmer grows up, and they face a problem, they are plunged into the real world. In the real world, there is no hand holding or major guidance. Instead, you need to learn how to make your way. If you've come this far, you should have a field of interest, may it just be general programming, web development, algorithms, or anything of that sort. Maybe, you want to learn of other, different fields involving programming, or maybe, you just want to know what to do next.

### Programming is just a tool

When you started programming, you might have wondered on when you would learn to create the next Reddit, or when you would learn about being able to make those fancy graphics, or how to perform different algorithms. Well, if you consider yourself to no longer be a beginner, then you have programming under your tool-belt. Now you need to learn how to apply it, and how to strengthen in it. Very soon you will be able to do these things, and be learning all about them.

### Enhancing your programming skills

Many people face the fear that they are not competent enough while programming. And thus, many want to improve their programming skills. But, at this stage, there is only one way to do that, and this is with practice. There are many sites and locations dedicated to practicing, things like [/r/dailyprogrammer](/r/dailyprogrammer), [CodeWars](http://www.codewars.com/dashboard), [HackerRank](https://www.hackerrank.com/), [Project Euler](https://projecteuler.net/), and many others.

## Misc

### How can I contribute to open source projects?

Participate in one of the projects in the [/r/learnprogramming github group](https://github.com/LearnProgramming)! This group was [created by jfredett](http://www.reddit.com/r/learnprogramming/comments/tl1qy/learnprogramming_on_github_a_place_for_you_to/) with the express purpose of providing projects for new programmers to learn how to contribute to open source by interacting with more experienced programmers as mentors.

The group is still in its infancy but several people are working to get it up and running.

Here are some websites that contain links to projects thare are actively looking for contributors of all levels of experience, and will often link to open bugs or issues that are very approachable for beginners.

*   [OpenHatch](https://openhatch.org/)
*   [24PullRequests](https://24pullrequests.com/)
*   [CodeTriage](https://www.codetriage.com/)
*   [Up For Grabs](http://up-for-grabs.net/#/)

Here are some past threads about working on open source projects.

*   [https://www.reddit.com/r/programming/comments/5bab3n/how_to_contribute_to_an_open_source_project_on/](https://www.reddit.com/r/programming/comments/5bab3n/how_to_contribute_to_an_open_source_project_on/)
*   [http://www.reddit.com/r/learnprogramming/comments/t0fk4/how_do_i_actually_contribute_to_open_source/](http://www.reddit.com/r/learnprogramming/comments/t0fk4/how_do_i_actually_contribute_to_open_source/)
*   [http://www.reddit.com/r/learnprogramming/comments/swwbd/how_to_contribute_to_an_opensource_project/](http://www.reddit.com/r/learnprogramming/comments/swwbd/how_to_contribute_to_an_opensource_project/)
*   [http://www.reddit.com/r/learnprogramming/comments/sw209/question_about_contributing_to_open_source](http://www.reddit.com/r/learnprogramming/comments/sw209/question_about_contributing_to_open_source)
*   [http://www.reddit.com/r/learnprogramming/comments/ee6fq/opensource_projects_for_beginners/](http://www.reddit.com/r/learnprogramming/comments/ee6fq/opensource_projects_for_beginners/)
*   [http://www.reddit.com/r/learnprogramming/comments/cm8be/reddit_how_do_i_get_involved_in_open_source/](http://www.reddit.com/r/learnprogramming/comments/cm8be/reddit_how_do_i_get_involved_in_open_source/)

### I have a question about C/Python/some specific language

Try consulting some language-specific wikis to see if your question is listed there:

*   [C FAQ](http://www.reddit.com/r/learnprogramming/wiki/faq_c)
*   [C++ FAQ](http://www.reddit.com/r/learnprogramming/wiki/faq_cpp)
*   [Java FAQ](http://www.reddit.com/r/learnprogramming/wiki/faq_java)
*   [PHP FAQ](http://www.reddit.com/r/learnprogramming/wiki/faq_php)
*   [Python FAQ](http://www.reddit.com/r/learnprogramming/wiki/faq_python)

### My question wasn't one of these; what now?

Check the [quick troubleshooting guide for beginners](http://www.reddit.com/r/learnprogramming/wiki/qtsgfb) and the FAQ page for the language you're using to see if it's answered in either location. If not, post on [r/learnprogramming](http://www.reddit.com/r/learnprogramming/).

*   [C FAQ](http://www.reddit.com/r/learnprogramming/wiki/faq_c)
*   [C++ FAQ](http://www.reddit.com/r/learnprogramming/wiki/faq_cpp)
*   [Java FAQ](http://www.reddit.com/r/learnprogramming/wiki/faq_java)
*   [PHP FAQ](http://www.reddit.com/r/learnprogramming/wiki/faq_php)
*   [Python FAQ](http://www.reddit.com/r/learnprogramming/wiki/faq_python)

Try also checking the [list of related communities](https://www.reddit.com/r/learnprogramming/wiki/index#wiki_related_communities).
