# The Awesome Teachable Machine List 

A curated list of awesome machine learning projects built with Google's Teachable Machine.

We've also enriched the list with fantastic learning and inspiration resources, detailed tutorials and articles that will help you bring your creative ideas to life, as well as useful open-source tools and libs - all full with awesomeness.

You can use this carefully selected list for your personal inspiration, as a guidance on how to introduce Machine Learning concepts to others, finding ways for building physical sorting machines from scratch or as a cookbook of how to spin up a cool MVP in no time!

## Contents

<ul>
<li><a href="#gettingstarted">🏁 Getting Started</a></li>
<li><a href="#starterprojects">👶 Starter Projects</a></li>
<li><a href="#tutorials">📖 Tutorials</a></li>
<li><a href="#videos"> ▶️ Videos</a></li>
<li><a href="#libs">📚 Libs</a></li>
 <li><a href="#tools">🛠️ Tools</a></li>
 <li><a href="#projects">🦄 Awesome Projects</a></li>
<li><a href="#related">🔍 Related</a></li>
<li><a href="#community">💬 Community</a></li>
<li><a href="#contribute">⚙️ Contribute</a></li>
</ul>
 
## 🏁 Getting Started <span id="gettingstarted"></span>

We'll start with the basics, so in this section, you can find the resources for complete beginners.

 <ul>
 <li><a href="https://teachablemachine.withgoogle.com"> Teachable Machine 2</a> - The official website </li>
 <li><a href="https://www.youtube.com/watch?v=T2qQGqZxkD0&feature=emb_title">Teachable Machine 2.0: Making AI easier for everyone</a> - Short YouTube video explaining the tool. Start creating and see where your ideas take you!</li>
 <li><a href="https://medium.com/analytics-vidhya/teachable-machine-with-google-baaed5104d08">Teachable Machines With Google</a> - An article offering a simple explanation of Teachable Machine tool.</li>
 <li><a href="https://www.youtube.com/playlist?list=PLJfHZtseuscuTQfodmFnbZ3rBgCWsRT9t">Google’s Gather, Train, Export playlist of video tutorial</a> -  The must-watch series of three videos on how to create your first TM model.</li>
 <li><a href="https://github.com/googlecreativelab/teachablemachine-community/">Example code snippets and machine learning code for Teachable Machine</a></li>
  <li><a href="https://blog.etereo.io/an-introduction-to-teachable-machine-ai-for-dummies-61d1f97f5cf">An introduction to Teachable Machine — AI for dummies</a> -  Another awesome detailed explanation on training your first model. Uses pose model option for the example. </li>
 <li><a href="https://design.google/library/designing-and-learning-teachable-machine/">Designing (and Learning From) a Teachable Machine</a> - Great article by <a href="https://barronwebster.com/#/0/0">Barron Webster</a> giving UX insights on designing simple, accessible interfaces for teaching computers</li>
  <li><a href="https://www.youtube.com/watch?v=PBK5moNYQS8&ab_channel=KrishNaik">Teachable Machine By Google - Train Your Model With Ease</a> - A complete video tutorial explaining the basics of Teachable Machine and showing how a model is created from end to end.</li>
</ul>


## 👶 Starter Projects <span id="starterprojects"></span>

The following resources contain thorough step-by-step instructions on how to create and use an Image, Audio or Pose Model.

<ul>
 <li><a href="https://medium.com/@warronbebster/teachable-machine-tutorial-bananameter-4bfffa765866"> Image - Teachable Machine Tutorial: Bananameter</a> - Learn how to create a model that can tell if a banana is ripe or not.</li>
   <li><a href="https://medium.com/@warronbebster/teachable-machine-tutorial-head-tilt-f4f6116f491"> Pose - Teachable Machine Tutorial: Head Tilt</a> - Learn how to create a model that recognizes which way you’re tilting your head.</li>
   <li><a href="https://medium.com/@warronbebster/teachable-machine-tutorial-snap-clap-whistle-4212fd7f3555">Sound - Teachable Machine Tutorial: Snap, Clap, Whistle</a> - Learn how to create a model that detects simple sounds you make.</li>
  <li><a href="https://www.youtube.com/watch?v=kwcillcWOg0">Teachable Machine 1: Image Classification</a> - A simple video on how to import a machine learning model into a p5.js sketch with the ml5.js library.</li>
   <li><a href="https://www.youtube.com/watch?v=UPgxnGC8oBU"> Teachable Machine 2: Snake Game</a> - A video demonstration on how to control an interaction with an image classification machine learning model to play the snake game.</li>
   <li><a href="https://www.youtube.com/watch?v=TOrVsLklltM">Teachable Machine 3: Sound Classification</a>- A short video on how to train a sound classifier and import the machine learning model into a p5.js sketch with the ml5.js library.</li>
  </ul>


## 📖 Tutorials <span id="tutorials"></span>

<ul>
 <li><a href="https://blog.sashido.io/how-to-load-a-teachable-machine-image-model-in-a-node-js-project/">How to load a Teachable Machine image model in a Node.Js project</a> -  A short tutorial on how to easily train and load a Teachable Machine's Image classification model to any Node.js application in less than 10 minutes.</li>
 <li><a href="https://towardsdev.com/how-to-build-and-deploy-a-machine-learning-model-for-mask-detection-in-minutes-5bbb0b65523d/">How to Build and Deploy a Machine Learning Model for Mask Detection in Minutes</a> -  This is a step by step beginner tutorial on how to create a mask detection model with Teachable Machine and deploy it with wwww.TeachableHub.com in minutes.</li>
 <li><a href="https://dev.to/vaishnavi5183/how-to-make-a-simple-hand-gesture-app-with-sashido-and-android-studio-7dj">How to make a Simple, Android Hand Gesture App with SashiDo and Teachable Machine</a> - A simple tutorial on how to easily develop an app that recognizes hand gestures used in ASL (American Sign Language) and teaches users how to sign in ASL.</li>
  <li><a href="https://dev.to/carolinebaillie/fish-classification-ios-app-with-sashido-and-teachable-machine-417i">Fish Classification IOS App with SashiDo and Teachable Machine</a> - A fun tutorial on how you can create a fish classification app using Xcode, Teachable Machine to identify the type of fish, and SashiDo to manage all the data and backend code</li>
 <li><a href="https://dev.to/nishkakotian/fruit-quality-detection-web-app-using-sashido-and-teachable-machine-2799?signin=true">Fruit quality detection web app using SashiDo and Teachable Machine</a> - An useful web application that can be used to check if an orange, apple or banana is rotten, so basically it is a fruit quality detection tool.Users can either use their webcam to get live predictions or upload an image and get results.</li>
 <li><a href="https://dev.to/marcostx7/learning-languages-through-a-web-application-with-sashido-and-teachable-machine-53dh">Learning Languages through a web application with SashiDo and Teachable Machine</a> - A cool project that aims to help children in learning other languages dynamically using a Teachable Machine's image model.</li>
 <li><a href="https://dev.to/sam_chu/sashido-coral-reef-project-4f8o">How to make a Coral Reef Health classification app with SashiDo and Teachable Machine</a> - An awesome web app that facilitates the process of mapping and understanding our ocean's coral reefs. It allows users to take pictures of coral reefs and enter the location of the coral. Then, the machine learning model classifies the coral as either healthy or unhealthy.</li>
 <li><a href="https://dev.to/ygarg704/flora-3b44">How to Build a Flower Recognition App with Teachable Machine and SashiDo</a> - An interesting machine learning based web application that can identify a flower (daisy, dandelion, sunflower, rose and tulip for now) using Google's Teachable Machine image model.</li>
 <li><a href="https://dev.to/penguinprogramer/creating-a-workout-tracker-using-teachable-machine-and-sashido-j3e">Creating a workout tracker using Teachable Machine and SashiDo</a> - An awesome tutorial on how to get started with machine learning by creating a simple web app to count your push-ups and squats.</li>
 <li><a href="https://coral.ai/projects/teachable-machine/#project-intro">Embedded Teachable Machine</a> -  This project is a direct re-implementation of Creative Lab's original Teachable Machine and teaches you how to build a computer vision kit that can learn to recognize different objects in mere minutes.</li>
  <li><a href="https://towardsdatascience.com/have-you-taught-your-machine-yet-45540b7e646b">How Teachable Machine Learns in the Browser</a> - An awesome guidance on how Google’s Teachable Machine transfers learning right inside your little browser.</li>
  <li><a href="https://dev.to/devdevcharlie/acoustic-activity-recognition-in-javascript-2go4">Acoustic activity recognition in JavaScript</a> - A prototype of a browser-based acoustic activity recognition system, classifying speaking, coughing, typing, brushing teeth, and my phone ringing</li>
  <li><a href="https://www.instructables.com/id/Easy-Machine-Learning-Object-Detection-With-Teacha/">Easy Machine Learning & Object Detection With Teachable Machine</a> - A step-by-step guide for setting up an OpenCV/TensorFlow Python development environment and a Python script framework to easily incorporate Teachable Machine image models into your projects.</li>
 <li><a href="https://towardsdatascience.com/easily-create-an-ai-app-for-your-phone-zero-coding-experience-2d38afd4db14">Easily create an AI app for your phone — zero coding experience</a> - An experimental visual manual of the Royal Enfield motorbike made with p5js and teachable machine for the mobile phone. </li>
 <li><a href="https://learn.adafruit.com/teachable-machine-raspberry-pi-tensorflow-camera?view=all">Raspberry Pi + Teachable Machine = Teachable Pi</a> - Train Raspberry Pi to recognize custom models, without a lot of work.</li>
 <li><a href="https://www.hackster.io/alankrantas/use-teachable-machine-ai-to-control-anything-2ad1ee">Use Teachable Machine AI to Control Anything</a> - Check out how to easily employ AI image/sound recognition for your microcontrollers, even if you know nothing about machine learning.</li>
 <li><a href="https://observablehq.com/@nsthorat/how-to-build-a-teachable-machine-with-tensorflow-js">[Advanced] How to build a Teachable Machine with TensorFlow.js</a> - Feeling ready to build your own Teachable Machine?</li>
 <li><a href="https://experiments.withgoogle.com/tiny-sorter/view">[Advanced] Tiny Sorter: A DIY experiment connecting with Arduino + Teachable Machine</a> - How to build a fun starter project that teaches you about machine learning and physical computing — together, in a hands-on DIY way.</li>
  <li><a href="https://coral.ai/projects/teachable-sorter/#project-intro">[Advanced] Sorting Marshmallows with AI: Using Coral + Teachable Machine</a> - How to build a machine that you can teach to rapidly recognize and sort objects using your own custom machine learning models.</li>
  <li><a href="https://medium.com/@michellecarney/using-teachable-machine-in-the-d-school-classroom-96be1ba6a4f9">Using Teachable Machine in the d.school classroom</a> - How a tool like Teachable Machine can apply to teacher's work.</li>
 <li><a href="https://medium.com/analytics-vidhya/a-fun-project-pose-detector-with-googles-teachable-machine-6c7c8d650be1">Sleepy One</a> - How to build a real-time detector using your computer’s webcam which plays an alarm when you get sleepy & tilt your head beyond certain degrees on either side.</li>
 <li><a href="https://data-driven.com/2019/11/visual-machine-learning-with-teachable-machine-not-happy-baby/">Happy vs Unhappy Baby</a> - A full-stack Data Architect Dad uses Teachable Machine to teach a model to recognize if his teething son is happy or unhappy</li>
 <li><a href="https://helloworld.co.in/article/teachable-machine-gesture-controlled-robot-using-machine-learning-model">Earth Rover</a> - How to train a teachable Machine Model on Raspberry Pi robot and control it through gestures.</li>
 <li><a href="https://towardsdatascience.com/from-training-to-deployment-stop-biting-your-nails-with-machine-learning-ffed31a59040">From training to deployment: Stop biting your nails with machine learning</a> - Learn how to train a machine learning model with only a few clicks, put it into practice in a simple web application, and deploy it to the cloud to share it with others.</li>
</ul>

## ▶️ Videos <span id="videos"></span>
<ul>
 <li><a href="https://www.youtube.com/watch?v=i9tjzr1KME0&feature=youtu.be">Machine learning without code in the browser</a> - How to train a pose model with Teachable Machine in under 10 minutes .</li>
 <li><a href="https://www.youtube.com/watch?v=Et6UqGHoR5Y&ab_channel=ialimustufa">Detecting Mask with Zero Coding and ML Knowledge using Teachable Machine
</a> - Couldn't skip this one in the midst of COVID-19</li>
 <li><a href="https://www.youtube.com/watch?v=HLpw0JFY4-E&feature=youtu.be&ab_channel=TheMuratorium">Using React (Hooks) with D3 – [07] Gauge Chart (+ Machine Learning)</a> - How to create a gauge/pie chart, which is combined with Teachable Machine and ML5.</li>
 <li><a href="https://www.youtube.com/watch?v=1NoM72IZoqY&feature=youtu.be&ab_channel=CodeDecoders">How to Integrate TensorFlow Machine Learning Model in a Flutter App</a> - Step by step video tutorial</li>
 <li><a href="https://www.youtube.com/watch?v=P7YkdRfhuRo&ab_channel=Imtiaz">Teachable Machine: Teach computer to recognize Italian hand gestures</a> - Cool idea offering machine learning explanation for beginners.</li>
</ul>


## 📚 Libs <span id="libs"></span>
<ul>
  <li><a href="https://github.com/SashiDo/teachablemachine-node">Teachable Machine on NodeJS</a> - A package that empowers you to load any image classification model trained with the Teachable Machine tool in a Node.Js project. </li>
  <li><a href="https://github.com/traumverloren/teachable-machine-image-nodejs-starter">Teachable Machine image prediction in Node.js & Tensorflow.js</a> - Another starter template for setting up a teachable machine image model in Node.js. </li>
<li><a href="https://www.npmjs.com/package/node-red-contrib-teachable-machine">Teachable Machine in Node-RED</a> - A Node-RED node based in tensorflow.js that enables you to run custom image classification trained models using the Teachable Machine tool.</li>
 <li><a href="https://github.com/kre8mymedia/Express-Teachable-Machine">Express Teachable Machine</a> - Quick express installation combined with Teachable Machine.</li>
 <li><a href="https://github.com/pourabk-hexaware/insights-teachable-machine-wrapper">Python Wrapper for Google Teachable Machine</a>A python based backend for hosting ML models from Google's Teachable Machine and Running demos on webcam.</li>
<li><a href="https://github.com/Harikrishnan6336/Image_Classifier">A Python Image Classification Template</a> - Real-time detection with OpenCV for any Teachable Machine model.</li>
<li><a href="https://github.com/googlecreativelab/teachablemachine-community/tree/master/libraries/image">Teachable Machine Library - Image</a> - Library for using image models created with Teachable Machine in JavaScript.</li>
<li><a href="https://github.com/rafyzg/teachable-machine">Teachable Machine Node.JS</a>- A demonstartion of using Teachable Machine as an API with NodeJS </li>
</ul>

## 🛠️ Tools <span id="tools"></span>
<ul>
<li><a href="https://www.mblock.cc/doc/en/use-extensions/teachable-machine.html">Teachable Machine extension of mBlock 5.</a>With this awesome extension, you can create a training model, instead of programming, to enable your computer to learn.</li>
<li><a href="https://github.com/lukaskirner/teachable-pi-websocket"> Pi camera websocket for Teachable Machine</a> - A websocket that allows you to add images to a Teachable Machine class from a Raspberry Pi camera module.</li>
<li><a href="https://github.com/kevinrobinson/warping-machine"> Warping Machine</a> - Test how well does your Teachable Machine model perform on a generalization data set.</li>
 <li><a href="https://github.com/kevinrobinson/conceptual-machine">Conceptual Machine</a> - Test how could concepts trained on top of your Teachable Machine model help you explore bias within your model.</li>
 <li><a href="https://github.com/kevinrobinson/agreeable-pisces">Agreeable Pisces</a> - Test how well does your Teachable Machine model generalize to new image searches.</li>
 <li><a href="https://github.com/kevinrobinson/greenscreen-machine">Greenscreen Machine</a> - Test what do Teachable Machine models see when people are composited into different backgrounds.</li>
</ul>

## 🦄 Awesome Projects <span id="projects"></span>

#### Java 

<ul>
 <li><a href="https://github.com/mstale007/Teachable_Machine_Mobile">Teachable Machine Mobile</a> - Cool мobile version of Teachable machine</li>
  <li><a href="https://github.com/immu0001/Android-Custom-Image-Classification-App">Android-Custom-Image-Classification-App</a> -  Simply great TensorFlow Lite image classification Android example application built with TensorFlow Lite.</li>
 <li><a href="https://github.com/alexisjwu/object-detection-android-app">Object Detection Android App</a> - Using Google's Teachable Machine 2.0 and Tensorflow Lite. It also comes with a simple tutorial that provides a step-by-step instructions. Cool, right?!</li>
 </ul>

#### Javascript

 <ul>
 <li><a href="https://github.com/jeferson-sb/dogAI">Dog AI</a> - Dog breed image recognition with Teachable Machine & Tensorflow.js. Woof!🐕</li>
 <li><a href="https://github.com/atharvapatil/teachable-browser">Sit Straight</a> - A quite useful posture classifier that blurs out Youtube videos if you don't sit straight</li>
 <li><a href="https://github.com/usacs/instagram-gesture">Gesture-Based Instagram Liker</a> - Heart Instagram photos using Teachable Machine and Google Chrome extension content scripts. Thumbs up for this project!</li>
   <li><a href="https://github.com/vince19972/TeachableSnake">Teachable Snake</a> - The eternal classic - snake game, just this time controlled by webcam image using pre-trained neural network models.</li>
    <li><a href="https://github.com/rainbarrel/byotm">Bring Your Own Teachable Machine</a> - Send text messages to family & friends using your personalized Teachable Machine speech recognizer. Exhibits the power of anyone's voice used to accomplish a meaningful task.</li>
 <li><a href="https://github.com/shaystrong/floss-dab-hairwhip">Floss! Dab! Hair whip!</a> - This groovy app uses a Teachable Machine Tensorflow model in the browser to predict, using your pose in the webcam, whether you are doing the floss, dab, or hair whip. </li>
<li><a href="https://github.com/charliegerard/washOS">WashOS</a> - A cool app that’s using a Teachable Machine Sound Model for automatic detection of water running to trigger a countdown to wash your hands in the browser. What’s even better - it’s eco-friendly too!</li>
 <li><a href="https://github.com/charlielito/teachable-machines-audio-demo">Using Audio to toggle a WiFi connected device</a> - An amazing audio model for recognizing a whistle pattern trained with Teachable Machine to toggle a Sonoff/Ewelink socket device connected to a room light. You just whistle and the light turns on/off!</li>
 <li><a href="https://github.com/seftimie/TeachableMachine4YoutubeNetflix">Teachable Machine 4 Youtube, Netflix or HBO</a> - ML model to play/pause videos from distance on Youtube, Netflix, or HBO in a hacky way. No argument here. We love it!</li>
 
  <li><a href="https://github.com/seftimie/Rock-Paper-Scissors-with-Google-Teachable-Machine">Rock Paper Scissors with Google Teachable Machine</a> - A visual machine learning model trained with Google Teachable Machine and turned into a classic game for kids: Rock Paper Scissors ( <a href="https://silviueftimiedev.web.app/">Play it</a> | <a href="https://www.youtube.com/watch?v=6poEnjJL0jI">Video Demo</a> )</li>
 
<li><a href="https://github.com/klousell/Speculative-UI">Hands On Head Detection</a> - This witty project yells when you place your hands on your head.</li>
 <li><a href="https://github.com/starakaj/teachable-machine-starter">Starter project scaffold for working with Teachable Machine</a> - Small and useful scaffold that offers image, sound or drawing recognition examples</li>
 <li><a href="https://github.com/tomwieck/tensor-dj">Tensor DJ</a> - Using Teachable Machine to identify records. Although we don't possess the same set of records, we like the idea. ;)</li>
 <li><a href="https://github.com/dylandawk/ml4pcomp-final">Teachable Machine + Harry Potter</a> - For all Hogwarts fans, this project combines Teachable Machine Image and Sound Classifiers with a microcontroller to create a magical wizarding experience.</li>
 <li><a href="https://github.com/mikahayk/ml4w-homework3-3">Detect a Cup</a> - LED there be light! Using a Teachable Machine trained model with ml5 and Arduino to detect a Cup and toggle LED light.</li>
</ul>

#### Python
<ul>
<li><a href="https://github.com/KimaruThagna/Picture-lytics">Picture-lytics</a> - A meaningful project, using Google's teachable machine to generate an image classification model and serving the model via streamlit. The classification tasks will be brain MRI tumor classification and Plant disease classification.</li>
  <li><a href="https://github.com/Hack-To-The-Future/scanner">Item Scanner</a> - Great mini machine learning project using Google's Teachable Machine, Django, and a Raspberry Pi to identify and "scan" items as they are passed in front of the camera.</li>
  <li><a href="https://github.com/Theob0t/Gesture-Controlled-Snake-Game">Gesture Controlled Snake-Game</a> - Another awesome classic snake game built with Pygame, OpenCV and Google's Teachable machine V2.0</li>
  <li><a href="https://github.com/sushantPatrikar/teachable-dinosaur">Teachable Dinosaur</a> - Have fun with this Chrome dinosaur game controlled with hand gestures.</li>
</ul> 
  
## 🔍 Related <span id="related"></span>

Although the resources here do not use Google’s Teachable Machine directly, they offer useful tools that could benefit your next projects or meaningful ideas you could use for inspiration.

<ul>
 <li><a href="https://runwayml.com/"> Runway</a> - A tool for creators that lets you use machine learning models made by experts (like style transfer models, or GAN’s) in native creative software like Photoshop, Ableton, and others.</li>
 <li><a href="http://www.wekinator.org/">Wekinator</a> - A free Mac app that allows anyone to use machine learning to build new musical instruments, gestural game controllers, computer vision or computer listening systems, and more.</li>
 <li><a href="https://github.com/RajParikh7/Teachable_Machines_for_Blind">Teachable Machines for Blind</a> - The application is used to help blind people learn how machine learning works by recognizing images and returning sound as output.</li>
 <li><a href="https://github.com/zeajose/first-teachable-machine">My First Teachable Machine</a> - A simple Teachable Machine spinoff using tensorflow.js to do custom 3-class object classifiers using a webcam on the fly.</li>
<li><a href="https://blog.jzhong.today/computationaltypo/Asemic-Writing-Teachable-Machine/">Asemic Writing Teachable Machine</a> - An asemic writing generator that responds to user-set gestures.</li>
</ul>


## 💬 Community <span id="community"></span>

<ul>
 <li><a href="https://github.com/googlecreativelab/teachablemachine-community/">Teachable Machine Community repo on GitHub</a></li>
  <li><a href="https://twitter.com/hashtag/teachablemachine">Projects made with #teachablemachine on Twitter</a></li>
 <li><a href="https://glitch.com/@teachablemachine">Projects made with #teachablemachine on Glitch</a></li>
</ul>

## ⚙️ Contribute <span id="contribute"></span>

Awesome contributors are most welcomed! Want to share with the world your amazing project or  the astonishing resource you stumbled upon, check the [CONTRIBUTING.md](https://github.com/SashiDo/awesome-teachable-machine/blob/master/CONTRIBUTING.md).

## 📜 License

Copyright © 2020, CloudStrap AD. See [LICENSE](https://github.com/SashiDo/awesome-teachable-machine/blob/master/LICENSE) for further details.

