#include "../../src/bignum/bigint.h"
#include "../../src/crypto/asymmetric/rsa.h"
#include "../../src/crypto/crypto.h"

#include <cassert>
#include <cstddef>
#include <cstdint>
#include <cstdio>

int test_rsa_decrypt() {
  uint8_t n[256] = {
      0x9e, 0xc0, 0x8c, 0xa3, 0x66, 0xef, 0x7b, 0x58, 0x24, 0xe9, 0xfd, 0x3a, 0xb0, 0x4f, 0x87, 0x19, 0x5f, 0x53, 0x8b,
      0x61, 0x4c, 0x11, 0xc8, 0xf2, 0x85, 0x1e, 0x59, 0x87, 0x80, 0x38, 0xc2, 0x53, 0x76, 0x41, 0x7f, 0x62, 0x8a, 0xd7,
      0x9e, 0x71, 0xa2, 0x99, 0x25, 0xf9, 0x39, 0xde, 0x8c, 0xab, 0x1b, 0x96, 0xea, 0x40, 0x38, 0x8d, 0xba, 0x7f, 0x5f,
      0x47, 0xeb, 0xf1, 0x55, 0xfa, 0xa3, 0xcc, 0x3b, 0x98, 0xbd, 0xb3, 0x7a, 0x11, 0x16, 0x5e, 0xbe, 0x74, 0x84, 0x0a,
      0x31, 0x53, 0xeb, 0xdd, 0x51, 0xf4, 0x71, 0x09, 0x8e, 0x15, 0x66, 0x18, 0x11, 0x31, 0xeb, 0x67, 0x01, 0x5b, 0x08,
      0x76, 0xe4, 0xb9, 0x61, 0x2c, 0x56, 0xae, 0x00, 0xac, 0x1a, 0xe6, 0xc0, 0x54, 0x62, 0x9c, 0x4f, 0x41, 0xc8, 0x6c,
      0x7f, 0x60, 0x17, 0xd9, 0x95, 0x5c, 0xb4, 0x6b, 0x56, 0x55, 0x0b, 0xf6, 0x41, 0x54, 0x39, 0x80, 0x0f, 0x64, 0xc9,
      0x4a, 0x13, 0xdd, 0xd1, 0x27, 0x86, 0x97, 0xf6, 0x25, 0x44, 0x9f, 0x05, 0xa3, 0x9e, 0x01, 0xa1, 0x95, 0x8e, 0x64,
      0xfd, 0x3a, 0xc9, 0x67, 0xad, 0x7c, 0xad, 0x10, 0xb4, 0xf7, 0xa1, 0x3a, 0xbf, 0x76, 0xdf, 0x58, 0x0d, 0x3f, 0x7b,
      0x74, 0x97, 0x11, 0x19, 0x7a, 0xe9, 0xbb, 0xe9, 0xce, 0xf7, 0x0d, 0xfb, 0x39, 0xe4, 0x86, 0xe3, 0x48, 0x48, 0x3f,
      0x02, 0xad, 0x4d, 0x2d, 0x3f, 0x11, 0xf4, 0x91, 0x41, 0x78, 0x73, 0x9a, 0xa3, 0xf0, 0x7d, 0xe0, 0xdf, 0xed, 0xae,
      0xfb, 0x3b, 0x40, 0xb7, 0x37, 0x44, 0xf0, 0x96, 0x5f, 0xbc, 0x91, 0xeb, 0x5a, 0xe6, 0xa6, 0x8d, 0xa7, 0xc3, 0xed,
      0x51, 0x61, 0x6e, 0xb0, 0x03, 0xf5, 0x32, 0xfd, 0x93, 0x03, 0xc7, 0x7b, 0x17, 0x41, 0xa3, 0x01, 0xd6, 0xc3, 0x60,
      0x07, 0x7c, 0x2e, 0x41, 0x51, 0x41, 0x52, 0x0a, 0x6d};
  uint8_t e[3] = {0x01, 0x00, 0x01};
  uint8_t d[256] = {
      0x35, 0x9a, 0x8c, 0xa2, 0x6c, 0x12, 0x77, 0x12, 0x97, 0x3c, 0x4f, 0x1e, 0x2f, 0x04, 0x5b, 0x78, 0xcc, 0xc0, 0x57,
      0xf2, 0xdd, 0x8d, 0xaf, 0xcd, 0x7b, 0xf7, 0x78, 0x81, 0x91, 0x61, 0x18, 0xf4, 0xb7, 0x9c, 0x7c, 0x17, 0xd9, 0x0b,
      0xdf, 0x5b, 0x3d, 0x6c, 0xfa, 0xee, 0x81, 0x84, 0xcc, 0xf8, 0xc5, 0xd3, 0x1a, 0x7b, 0xde, 0xdc, 0xb4, 0x59, 0x67,
      0xe1, 0xd0, 0x20, 0x68, 0x48, 0xbe, 0x60, 0x2a, 0xcb, 0x73, 0x5a, 0x93, 0xe0, 0x0b, 0x2e, 0xa8, 0x9e, 0x8d, 0x2b,
      0x27, 0xe6, 0xcf, 0x60, 0xa6, 0xd8, 0xa4, 0x06, 0x76, 0xec, 0x70, 0xd1, 0xb5, 0x94, 0xa6, 0x88, 0xdc, 0x63, 0x51,
      0xa3, 0x5b, 0xad, 0xe0, 0xca, 0xe8, 0xe5, 0xce, 0x22, 0x4e, 0xdf, 0x15, 0x98, 0x28, 0xc7, 0xe0, 0xd7, 0x34, 0x86,
      0xb6, 0x27, 0xcb, 0x45, 0xd3, 0xf2, 0x3e, 0x95, 0x73, 0xcc, 0x39, 0xc2, 0xc7, 0xe1, 0xd1, 0x72, 0x3f, 0x5e, 0x4e,
      0x83, 0x61, 0x44, 0x84, 0x17, 0xcc, 0xfc, 0x8e, 0x27, 0x7d, 0x86, 0x09, 0xb3, 0x5a, 0xb7, 0x25, 0x7e, 0x9e, 0xa0,
      0xc2, 0xc7, 0x8a, 0x10, 0x5c, 0xef, 0x15, 0x71, 0x77, 0x01, 0x76, 0x51, 0xdd, 0x65, 0x92, 0x2c, 0x94, 0xdc, 0x44,
      0xf8, 0x9a, 0x3c, 0xa3, 0x1c, 0x26, 0xbb, 0xff, 0x63, 0x5f, 0xb5, 0xa8, 0x89, 0x4d, 0x48, 0x24, 0xdd, 0xc9, 0xe4,
      0x26, 0x6b, 0xe4, 0xe9, 0x86, 0x77, 0x32, 0x81, 0x45, 0xfb, 0xa3, 0xc8, 0x81, 0x87, 0x75, 0x37, 0x92, 0xa4, 0xd8,
      0x06, 0x92, 0x43, 0x6e, 0x80, 0x0d, 0x4c, 0x75, 0x29, 0x28, 0x6b, 0xc2, 0xc2, 0x9d, 0xe4, 0x84, 0x02, 0x8a, 0x09,
      0x38, 0xe7, 0x84, 0x73, 0x97, 0x51, 0x57, 0x4b, 0x72, 0x81, 0x5b, 0x1a, 0x20, 0xac, 0x2c, 0x0d, 0xd6, 0xb0, 0xde,
      0xb0, 0x5d, 0x5f, 0x81, 0xc8, 0xd7, 0x1e, 0xd3, 0x3d};

  uint8_t m_raw[256] = {
      0x80, 0x1e, 0x54, 0x34, 0xc8, 0xa4, 0xbb, 0x40, 0x4a, 0x9f, 0x86, 0x5e, 0x1c, 0xd4, 0xe7, 0x86, 0x78, 0xd4, 0x66,
      0x47, 0xb9, 0x8f, 0x1f, 0x47, 0x67, 0x13, 0xe0, 0x5b, 0x1d, 0xb7, 0xbd, 0xbd, 0xf0, 0xb3, 0x37, 0x0d, 0xf9, 0x10,
      0xa5, 0x51, 0x7a, 0xc6, 0xb4, 0x7f, 0x17, 0x51, 0x5b, 0x03, 0x94, 0xc6, 0xa7, 0x1d, 0x7e, 0xc0, 0xf0, 0x78, 0xd9,
      0xcd, 0x41, 0xd9, 0x85, 0xd5, 0x5c, 0xf2, 0xff, 0x04, 0xda, 0x84, 0x26, 0x53, 0x33, 0x79, 0x4b, 0xf4, 0x2e, 0xd3,
      0xaa, 0x8e, 0x24, 0x20, 0x7b, 0xf9, 0x64, 0x0f, 0x96, 0xf4, 0x12, 0x77, 0x10, 0x43, 0x41, 0xca, 0x9a, 0x68, 0xb4,
      0x4b, 0xf8, 0x2f, 0xb5, 0x57, 0x2e, 0xf5, 0xfa, 0x9e, 0x38, 0x74, 0x7d, 0xf9, 0x2c, 0x31, 0x53, 0x1e, 0x20, 0x55,
      0x72, 0x92, 0x38, 0x3d, 0x96, 0x4b, 0x3a, 0x20, 0x32, 0x94, 0xfa, 0xcd, 0x68, 0x86, 0xe2, 0xfb, 0xac, 0x5e, 0xfe,
      0xae, 0x11, 0x0c, 0xa7, 0x6a, 0xb0, 0xfd, 0xd0, 0x59, 0x25, 0x95, 0x5d, 0x62, 0xb9, 0x6f, 0x13, 0x90, 0x7c, 0x5f,
      0x4a, 0x76, 0xa2, 0x1d, 0x88, 0xb9, 0x24, 0x06, 0x98, 0x24, 0x15, 0xff, 0xd6, 0x48, 0x21, 0x76, 0x31, 0x98, 0xaa,
      0xb0, 0x19, 0x76, 0xa2, 0xe9, 0x40, 0x90, 0x70, 0x0a, 0x48, 0xce, 0xa7, 0x30, 0x13, 0x52, 0x6b, 0xc0, 0x59, 0x94,
      0xcf, 0xcd, 0x3a, 0x18, 0xbe, 0xcb, 0xa7, 0x72, 0x80, 0x99, 0x4e, 0x59, 0x54, 0xb4, 0x38, 0x0d, 0xd9, 0x33, 0x43,
      0x16, 0x7c, 0xfe, 0x92, 0xcc, 0xed, 0x7e, 0x7b, 0x13, 0x11, 0x34, 0xac, 0x5b, 0xa0, 0x55, 0x18, 0x6c, 0x70, 0xf5,
      0xf4, 0x22, 0xfa, 0x1b, 0xd2, 0x78, 0xc4, 0x7a, 0x73, 0xf6, 0x1b, 0x35, 0xbe, 0xd6, 0xe5, 0x92, 0x08, 0xf2, 0x27,
      0xdb, 0x83, 0x56, 0xf7, 0x62, 0xea, 0x6f, 0x5e, 0xfa};

  mpz_t key_n;
  mpz_init(key_n);
  mpz_import(key_n, 256, 1, sizeof(uint8_t), 0, 0, n);
  mpz_t key_e;
  mpz_init(key_e);
  mpz_import(key_e, 3, 1, sizeof(uint8_t), 0, 0, e);
  mpz_t key_d;
  mpz_init(key_d);
  mpz_import(key_d, 256, 1, sizeof(uint8_t), 0, 0, d);
  mpz_t m;
  mpz_init(m);
  mpz_import(m, 256, 1, sizeof(uint8_t), 0, 0, m_raw);
  mpz_t output;
  mpz_init(output);

  rsa key;
  key.exponent(key_e);
  key.priv(key_d);
  key.modulus(key_n);

  key.decrypt(output, m);

  return 0;
}
