#include "../../src/crypto/symmetric/rc4.h"
#include <cassert>
#include <cstddef>
#include <cstdint>
#include <cstdio>

int test_rc4_stream_one() {
  uint8_t key[5] = {0x01, 0x02, 0x03, 0x04, 0x05};
  uint8_t keystream[32];
  uint8_t expected[32] = {0xb2, 0x39, 0x63, 0x05, 0xf0, 0x3d, 0xc0, 0x27, 0xcc, 0xc3, 0x52,
                          0x4a, 0x0a, 0x11, 0x18, 0xa8, 0x69, 0x82, 0x94, 0x4f, 0x18, 0xfc,
                          0x82, 0xd5, 0x89, 0xc4, 0x03, 0xa4, 0x7a, 0x0d, 0x09, 0x19};

  rc4 *a = new rc4(key, 5);

  a->stream(keystream, 32);

  for (size_t i = 0; i < 32; i++) {
    assert(keystream[i] == expected[i]);
  }

  delete a;

  return 0;
}

int test_rc4_stream_two() {
  uint8_t key[7] = {0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07};
  uint8_t keystream[32];
  uint8_t expected[32] = {0x29, 0x3f, 0x02, 0xd4, 0x7f, 0x37, 0xc9, 0xb6, 0x33, 0xf2, 0xaf,
                          0x52, 0x85, 0xfe, 0xb4, 0x6b, 0xe6, 0x20, 0xf1, 0x39, 0x0d, 0x19,
                          0xbd, 0x84, 0xe2, 0xe0, 0xfd, 0x75, 0x20, 0x31, 0xaf, 0xc1};

  rc4 *a = new rc4(key, 7);

  a->stream(keystream, 32);

  for (size_t i = 0; i < 32; i++) {
    assert(keystream[i] == expected[i]);
  }

  delete a;

  return 0;
}
