#include "../../src/crypto/hash/hmac.h"
#include "../../src/crypto/hash/md5.h"
#include "../../src/crypto/hash/sha2-256.h"

#include <cassert>
#include <cstddef>
#include <cstdint>
#include <cstdio>

int test_hmac_md5_vector_one() {
  hmac *m;
  md5 *h = new md5();

  h->init();

  uint8_t expected[16] = {0x92, 0x94, 0x72, 0x7a, 0x36, 0x38, 0xbb, 0x1c,
                          0x13, 0xf4, 0x8e, 0xf8, 0x15, 0x8b, 0xfc, 0x9d};
  uint8_t actual[16] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
  uint8_t key[16] = {0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b};

  m = new hmac(h, key, 16);

  m->sum(actual, (uint8_t *)"Hi There", 8);

  delete m;

  for (int i = 0; i < 16; i++) {
    assert(actual[i] == expected[i]);
  }

  return 0;
}

int test_hmac_md5_vector_two() {
  hmac *m;
  md5 *h = new md5();

  h->init();

  uint8_t expected[16] = {0x75, 0x0c, 0x78, 0x3e, 0x6a, 0xb0, 0xb5, 0x03,
                          0xea, 0xa8, 0x6e, 0x31, 0x0a, 0x5d, 0xb7, 0x38};
  uint8_t actual[16] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

  m = new hmac(h, (uint8_t *)"Jefe", 4);

  m->sum(actual, (uint8_t *)"what do ya want for nothing?", 28);

  delete m;

  for (int i = 0; i < 16; i++) {
    assert(actual[i] == expected[i]);
  }

  return 0;
}

int test_hmac_md5_vector_three() {
  hmac *m;
  md5 *h = new md5();

  h->init();

  uint8_t expected[16] = {0x56, 0xbe, 0x34, 0x52, 0x1d, 0x14, 0x4c, 0x88,
                          0xdb, 0xb8, 0xc7, 0x33, 0xf0, 0xe8, 0xb3, 0xf6};
  uint8_t actual[16] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
  uint8_t data[50] = {0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD,
                      0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD,
                      0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD,
                      0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD};
  uint8_t key[16] = {0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA};

  m = new hmac(h, key, 16);

  m->sum(actual, data, 50);

  delete m;

  for (int i = 0; i < 16; i++) {
    assert(actual[i] == expected[i]);
  }

  return 0;
}

int test_hmac_sha256() {
  hmac *m;
  sha2_256 *h = new sha2_256();

  h->init();

  uint8_t key[32] = {0x3c, 0x33, 0x59, 0xe2, 0xd5, 0x0f, 0x4d, 0x69, 0x93, 0x99, 0x42, 0xfb, 0x13, 0x3c, 0x71, 0xd9,
                     0x41, 0x1f, 0xd9, 0xa7, 0x53, 0x69, 0xa3, 0x05, 0xdf, 0xa3, 0x2e, 0x3a, 0x4c, 0x4a, 0x71, 0xf0};
  uint8_t data[29] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x03, 0x03, 0x00, 0x10, 0x14, 0x00,
                      0x00, 0x0c, 0x80, 0x73, 0x36, 0x7e, 0x7b, 0x57, 0xd9, 0x26, 0xc0, 0x7e, 0x41, 0x4b};
  uint8_t expected[32] = {0xf2, 0x1f, 0x99, 0x3a, 0x8b, 0x96, 0x4d, 0x96, 0x54, 0xc1, 0x60,
                          0x45, 0x48, 0xbe, 0x05, 0x06, 0x9b, 0x10, 0xd7, 0xa6, 0xb0, 0x58,
                          0x8d, 0xbe, 0x23, 0xae, 0xcb, 0x3e, 0x0d, 0x81, 0xbd, 0xc1};
  uint8_t actual[32] = {0x00};

  m = new hmac(h, key, 32);

  m->sum(actual, data, 29);

  delete m;

  for (int i = 0; i < 32; i++) {
    assert(actual[i] == expected[i]);
  }

  return 0;
}
