#include "../../src/encoding/ber/octetstring.h"
#include <cassert>
#include <cstddef>
#include <cstdint>
#include <cstdio>

int test_ber_octetstring_short_encode() {
  uint8_t octetstring[3] = {0x42, 0x21, 0x45};
  uint8_t encoded[5] = {0x00, 0x00, 0x00, 0x00, 0x00};

  assert(encode_octetstring_length(3) == 5);
  encode_octetstring(encoded, octetstring, 3);

  assert(encoded[0] == 0x04);
  assert(encoded[1] == 0x03);
  assert(encoded[2] == 0x42);
  assert(encoded[3] == 0x21);
  assert(encoded[4] == 0x45);

  return 0;
}

int test_ber_octetstring_short_decode() {
  uint8_t encoded[5] = {0x04, 0x03, 0x42, 0x21, 0x45};
  uint8_t octetstring[3] = {0x00, 0x00, 0x00};

  assert(decode_octetstring_length(encoded) == 3);
  decode_octetstring(octetstring, encoded, 5);

  assert(octetstring[0] == 0x42);
  assert(octetstring[1] == 0x21);
  assert(octetstring[2] == 0x45);

  return 0;
}

int test_ber_octetstring_long_encode() {
  uint8_t octetstring[256] = {
      0x42, 0x21, 0x45, 0x42, 0x21, 0x45, 0x51, 0x65, 0x42, 0x21, 0x45, 0x42, 0x21, 0x45, 0x51, 0x65, 0x42, 0x21, 0x45,
      0x42, 0x21, 0x45, 0x51, 0x65, 0x42, 0x21, 0x45, 0x42, 0x21, 0x45, 0x51, 0x65, 0x42, 0x21, 0x45, 0x42, 0x21, 0x45,
      0x51, 0x65, 0x42, 0x21, 0x45, 0x42, 0x21, 0x45, 0x51, 0x65, 0x42, 0x21, 0x45, 0x42, 0x21, 0x45, 0x51, 0x65, 0x42,
      0x21, 0x45, 0x42, 0x21, 0x45, 0x51, 0x65, 0x42, 0x21, 0x45, 0x42, 0x21, 0x45, 0x51, 0x65, 0x42, 0x21, 0x45, 0x42,
      0x21, 0x45, 0x51, 0x65, 0x42, 0x21, 0x45, 0x42, 0x21, 0x45, 0x51, 0x65, 0x42, 0x21, 0x45, 0x42, 0x21, 0x45, 0x51,
      0x65, 0x42, 0x21, 0x45, 0x42, 0x21, 0x45, 0x51, 0x65, 0x42, 0x21, 0x45, 0x42, 0x21, 0x45, 0x51, 0x65, 0x42, 0x21,
      0x45, 0x42, 0x21, 0x45, 0x51, 0x65, 0x42, 0x21, 0x45, 0x42, 0x21, 0x45, 0x51, 0x65, 0x42, 0x21, 0x45, 0x42, 0x21,
      0x45, 0x51, 0x65, 0x42, 0x21, 0x45, 0x42, 0x21, 0x45, 0x51, 0x65, 0x42, 0x21, 0x45, 0x42, 0x21, 0x45, 0x51, 0x65,
      0x42, 0x21, 0x45, 0x42, 0x21, 0x45, 0x51, 0x65, 0x42, 0x21, 0x45, 0x42, 0x21, 0x45, 0x51, 0x65, 0x42, 0x21, 0x45,
      0x42, 0x21, 0x45, 0x51, 0x65, 0x42, 0x21, 0x45, 0x42, 0x21, 0x45, 0x51, 0x65, 0x42, 0x21, 0x45, 0x42, 0x21, 0x45,
      0x51, 0x65, 0x42, 0x21, 0x45, 0x42, 0x21, 0x45, 0x51, 0x65, 0x42, 0x21, 0x45, 0x42, 0x21, 0x45, 0x51, 0x65, 0x42,
      0x21, 0x45, 0x42, 0x21, 0x45, 0x51, 0x65, 0x42, 0x21, 0x45, 0x42, 0x21, 0x45, 0x51, 0x65, 0x42, 0x21, 0x45, 0x42,
      0x21, 0x45, 0x51, 0x65, 0x42, 0x21, 0x45, 0x42, 0x21, 0x45, 0x51, 0x65, 0x42, 0x21, 0x45, 0x42, 0x21, 0x45, 0x51,
      0x65, 0x42, 0x21, 0x45, 0x42, 0x21, 0x45, 0x51, 0x65};
  uint8_t encoded[260] = {
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

  assert(encode_octetstring_length(256) == 260);
  encode_octetstring(encoded, octetstring, 256);

  assert(encoded[0] == 0x04);
  assert(encoded[1] == 0x82);
  assert(encoded[2] == 0x01);
  assert(encoded[3] == 0x00);
  for (size_t i = 0; i < 256; i++) {
    assert(encoded[i + 4] == octetstring[i]);
  }

  return 0;
}

int test_ber_octetstring_long_decode() {
  uint8_t octetstring[256] = {
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
  uint8_t encoded[260] = {
      0x04, 0x82, 0x01, 0x00, 0x42, 0x21, 0x45, 0x42, 0x21, 0x45, 0x51, 0x65, 0x42, 0x21, 0x45, 0x42, 0x21, 0x45, 0x51,
      0x65, 0x42, 0x21, 0x45, 0x42, 0x21, 0x45, 0x51, 0x65, 0x42, 0x21, 0x45, 0x42, 0x21, 0x45, 0x51, 0x65, 0x42, 0x21,
      0x45, 0x42, 0x21, 0x45, 0x51, 0x65, 0x42, 0x21, 0x45, 0x42, 0x21, 0x45, 0x51, 0x65, 0x42, 0x21, 0x45, 0x42, 0x21,
      0x45, 0x51, 0x65, 0x42, 0x21, 0x45, 0x42, 0x21, 0x45, 0x51, 0x65, 0x42, 0x21, 0x45, 0x42, 0x21, 0x45, 0x51, 0x65,
      0x42, 0x21, 0x45, 0x42, 0x21, 0x45, 0x51, 0x65, 0x42, 0x21, 0x45, 0x42, 0x21, 0x45, 0x51, 0x65, 0x42, 0x21, 0x45,
      0x42, 0x21, 0x45, 0x51, 0x65, 0x42, 0x21, 0x45, 0x42, 0x21, 0x45, 0x51, 0x65, 0x42, 0x21, 0x45, 0x42, 0x21, 0x45,
      0x51, 0x65, 0x42, 0x21, 0x45, 0x42, 0x21, 0x45, 0x51, 0x65, 0x42, 0x21, 0x45, 0x42, 0x21, 0x45, 0x51, 0x65, 0x42,
      0x21, 0x45, 0x42, 0x21, 0x45, 0x51, 0x65, 0x42, 0x21, 0x45, 0x42, 0x21, 0x45, 0x51, 0x65, 0x42, 0x21, 0x45, 0x42,
      0x21, 0x45, 0x51, 0x65, 0x42, 0x21, 0x45, 0x42, 0x21, 0x45, 0x51, 0x65, 0x42, 0x21, 0x45, 0x42, 0x21, 0x45, 0x51,
      0x65, 0x42, 0x21, 0x45, 0x42, 0x21, 0x45, 0x51, 0x65, 0x42, 0x21, 0x45, 0x42, 0x21, 0x45, 0x51, 0x65, 0x42, 0x21,
      0x45, 0x42, 0x21, 0x45, 0x51, 0x65, 0x42, 0x21, 0x45, 0x42, 0x21, 0x45, 0x51, 0x65, 0x42, 0x21, 0x45, 0x42, 0x21,
      0x45, 0x51, 0x65, 0x42, 0x21, 0x45, 0x42, 0x21, 0x45, 0x51, 0x65, 0x42, 0x21, 0x45, 0x42, 0x21, 0x45, 0x51, 0x65,
      0x42, 0x21, 0x45, 0x42, 0x21, 0x45, 0x51, 0x65, 0x42, 0x21, 0x45, 0x42, 0x21, 0x45, 0x51, 0x65, 0x42, 0x21, 0x45,
      0x42, 0x21, 0x45, 0x51, 0x65, 0x42, 0x21, 0x45, 0x42, 0x21, 0x45, 0x51, 0x65};

  assert(decode_octetstring_length(encoded) == 256);
  decode_octetstring(octetstring, encoded, 260);

  for (size_t i = 0; i < 256; i++) {
    assert(encoded[i + 4] == octetstring[i]);
  }

  return 0;
}
