#include "../../src/crypto/crypto.h"
#include <cassert>
#include <cstddef>
#include <cstdint>
#include <cstdio>

int test_aes256_cbc() {
  aes *a;
  cbc *block_mode;

  uint8_t plaintext[48] = {0x12, 0x34, 0x56, 0x78, 0x90, 0x12, 0x34, 0x56, 0x12, 0x34, 0x56, 0x78,
                           0x90, 0x12, 0x34, 0x56, 0x12, 0x34, 0x56, 0x78, 0x90, 0x12, 0x34, 0x56,
                           0x12, 0x34, 0x56, 0x78, 0x90, 0x12, 0x34, 0x56, 0x12, 0x34, 0x56, 0x78,
                           0x90, 0x12, 0x34, 0x56, 0x12, 0x34, 0x56, 0x78, 0x90, 0x12, 0x34, 0x56};
  uint8_t ciphertext[48] = {0x3a, 0x3f, 0xee, 0xb1, 0x50, 0x4b, 0xc3, 0x10, 0xfe, 0x75, 0xca, 0x54,
                            0x07, 0x80, 0xb1, 0xad, 0x0f, 0x13, 0xeb, 0x57, 0xad, 0xc0, 0x4c, 0x2d,
                            0x13, 0xa6, 0x8b, 0x94, 0x33, 0x34, 0x67, 0x24, 0xe2, 0xb2, 0x04, 0x57,
                            0x76, 0xa6, 0xeb, 0x38, 0x83, 0xce, 0xc5, 0xbf, 0x92, 0xfd, 0xc4, 0xc6};
  uint8_t output[48] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
  uint8_t iv[16] = {0x57, 0x2c, 0x0e, 0x22, 0x44, 0x7c, 0x7b, 0x67, 0x41, 0xa1, 0x3b, 0xdb, 0xbb, 0x99, 0xa0, 0x9f};
  uint8_t key[32] = {0x65, 0x51, 0xf5, 0xd0, 0xef, 0x7b, 0x4b, 0x80, 0x7e, 0x03, 0xbc, 0xfc, 0xd3, 0xc7, 0x08, 0xed,
                     0x44, 0xbb, 0x05, 0xc5, 0xea, 0x7f, 0x54, 0x8c, 0x97, 0x70, 0xe0, 0x7a, 0x42, 0x20, 0x75, 0xb3};

  a = aes::aes_256(key);
  block_mode = new cbc(a, iv);

  block_mode->decrypt(output, ciphertext, 48);

  for (size_t i = 0; i < 48; i++) {
    assert(output[i] == plaintext[i]);
  }

  delete a;

  return 0;
}
