#include "../../src/crypto/symmetric/aes.h"
#include <cassert>
#include <cstddef>
#include <cstdint>
#include <cstdio>

int test_aes256_key_expansion() {
  aes *a;
  uint8_t key[32] = {0x60, 0x3d, 0xeb, 0x10, 0x15, 0xca, 0x71, 0xbe, 0x2b, 0x73, 0xae, 0xf0, 0x85, 0x7d, 0x77, 0x81,
                     0x1f, 0x35, 0x2c, 0x07, 0x3b, 0x61, 0x08, 0xd7, 0x2d, 0x98, 0x10, 0xa3, 0x09, 0x14, 0xdf, 0xf4};
  uint32_t expected[60] = {
      0x603deb10, 0x15ca71be, 0x2b73aef0, 0x857d7781, 0x1f352c07, 0x3b6108d7, 0x2d9810a3, 0x914dff4,  0x9ba35411,
      0x8e6925af, 0xa51a8b5f, 0x2067fcde, 0xa8b09c1a, 0x93d194cd, 0xbe49846e, 0xb75d5b9a, 0xd59aecb8, 0x5bf3c917,
      0xfee94248, 0xde8ebe96, 0xb5a9328a, 0x2678a647, 0x98312229, 0x2f6c79b3, 0x812c81ad, 0xdadf48ba, 0x24360af2,
      0xfab8b464, 0x98c5bfc9, 0xbebd198e, 0x268c3ba7, 0x9e04214,  0x68007bac, 0xb2df3316, 0x96e939e4, 0x6c518d80,
      0xc814e204, 0x76a9fb8a, 0x5025c02d, 0x59c58239, 0xde136967, 0x6ccc5a71, 0xfa256395, 0x9674ee15, 0x5886ca5d,
      0x2e2f31d7, 0x7e0af1fa, 0x27cf73c3, 0x749c47ab, 0x18501dda, 0xe2757e4f, 0x7401905a, 0xcafaaae3, 0xe4d59b34,
      0x9adf6ace, 0xbd10190d, 0xfe4890d1, 0xe6188d0b, 0x46df344,  0x706c631e};

  a = aes::aes_256(key);
  uint32_t *actual = a->__testing_copy_key();

  for (size_t i = 0; i < 60; i++) {
    assert(actual[i] == expected[i]);
  }

  delete[] actual;
  delete a;

  return 0;
}

int test_aes256_encrypt() {
  aes *a;
  uint8_t plaintext[16] = {0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77,
                           0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff};
  uint8_t ciphertext[16] = {0x8e, 0xa2, 0xb7, 0xca, 0x51, 0x67, 0x45, 0xbf,
                            0xea, 0xfc, 0x49, 0x90, 0x4b, 0x49, 0x60, 0x89};
  uint8_t output[16] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
  uint8_t key[32] = {0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
                     0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f};

  a = aes::aes_256(key);

  a->encrypt(output, plaintext, 16);

  for (size_t i = 0; i < 16; i++) {
    assert(output[i] == ciphertext[i]);
  }

  delete a;

  return 0;
}

int test_aes256_decrypt() {
  aes *a;
  uint8_t plaintext[16] = {0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77,
                           0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff};
  uint8_t ciphertext[16] = {0x8e, 0xa2, 0xb7, 0xca, 0x51, 0x67, 0x45, 0xbf,
                            0xea, 0xfc, 0x49, 0x90, 0x4b, 0x49, 0x60, 0x89};
  uint8_t output[16] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
  uint8_t key[32] = {0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
                     0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f};

  a = aes::aes_256(key);

  a->decrypt(output, ciphertext, 16);

  for (size_t i = 0; i < 16; i++) {
    assert(output[i] == plaintext[i]);
  }

  delete a;

  return 0;
}

int test_aes256_avs_gfsbox() {
  aes *a;

  uint8_t plaintext[5][16] = {
      {0x01, 0x47, 0x30, 0xf8, 0x0a, 0xc6, 0x25, 0xfe, 0x84, 0xf0, 0x26, 0xc6, 0x0b, 0xfd, 0x54, 0x7d},
      {0x0b, 0x24, 0xaf, 0x36, 0x19, 0x3c, 0xe4, 0x66, 0x5f, 0x28, 0x25, 0xd7, 0xb4, 0x74, 0x9c, 0x98},
      {0x76, 0x1c, 0x1f, 0xe4, 0x1a, 0x18, 0xac, 0xf2, 0x0d, 0x24, 0x16, 0x50, 0x61, 0x1d, 0x90, 0xf1},
      {0x8a, 0x56, 0x07, 0x69, 0xd6, 0x05, 0x86, 0x8a, 0xd8, 0x0d, 0x81, 0x9b, 0xdb, 0xa0, 0x37, 0x71},
      {0x91, 0xfb, 0xef, 0x2d, 0x15, 0xa9, 0x78, 0x16, 0x06, 0x0b, 0xee, 0x1f, 0xea, 0xa4, 0x9a, 0xfe}};
  uint8_t ciphertext[5][16] = {
      {0x5c, 0x9d, 0x84, 0x4e, 0xd4, 0x6f, 0x98, 0x85, 0x08, 0x5e, 0x5d, 0x6a, 0x4f, 0x94, 0xc7, 0xd7},
      {0xa9, 0xff, 0x75, 0xbd, 0x7c, 0xf6, 0x61, 0x3d, 0x37, 0x31, 0xc7, 0x7c, 0x3b, 0x6d, 0x0c, 0x04},
      {0x62, 0x3a, 0x52, 0xfc, 0xea, 0x5d, 0x44, 0x3e, 0x48, 0xd9, 0x18, 0x1a, 0xb3, 0x2c, 0x74, 0x21},
      {0x38, 0xf2, 0xc7, 0xae, 0x10, 0x61, 0x24, 0x15, 0xd2, 0x7c, 0xa1, 0x90, 0xd2, 0x7d, 0xa8, 0xb4},
      {0x1b, 0xc7, 0x04, 0xf1, 0xbc, 0xe1, 0x35, 0xce, 0xb8, 0x10, 0x34, 0x1b, 0x21, 0x6d, 0x7a, 0xbe}};
  uint8_t output[16] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
  uint8_t key[32] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

  a = aes::aes_256(key);

  for (size_t j = 0; j < 5; j++) {
    a->encrypt(output, plaintext[j], 16);

    for (size_t i = 0; i < 16; i++) {
      assert(output[i] == ciphertext[j][i]);
    }

    a->decrypt(output, ciphertext[j], 16);

    for (size_t i = 0; i < 16; i++) {
      assert(output[i] == plaintext[j][i]);
    }
  }

  delete a;

  return 0;
}
