//===-- EduTLS/src/encoding/constants/ber.h               -------*- C++ -*-===//
//
//                     EduTLS - Transport Layer Security
//
// This file is distributed under the MIT License. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//
///
/// \file
/// This file contains constants for the BER encoding specification according to
/// ITU-T X.690.
///
//===----------------------------------------------------------------------===//

#pragma once

#define BER_BIT8 0x80
#define BER_BIT7 0x40
#define BER_BIT6 0x20
#define BER_BIT5 0x10
#define BER_BIT4 0x08
#define BER_BIT3 0x04
#define BER_BIT2 0x02
#define BER_BIT1 0x01

#define BER_IDENTIFIER_CLASS_MASK (BER_BIT8 + BER_BIT7)
#define BER_IDENTIFIER_CLASS_UNIVERSAL 0x00
#define BER_IDENTIFIER_CLASS_APPLICATION BER_BIT7
#define BER_IDENTIFIER_CLASS_CONTEXT BER_BIT8
#define BER_IDENTIFIER_CLASS_PRIVATE (BER_BIT8 + BER_BIT7)

#define BER_IDENTIFIER_TYPE_MASK BER_BIT6
#define BER_IDENTIFIER_TYPE_PRIMITIVE 0x00
#define BER_IDENTIFIER_TYPE_CONSTRUCTED BER_BIT6

#define BER_IDENTIFIER_FIRST_TAG_VALUE_MASK (BER_BIT5 + BER_BIT4 + BER_BIT3 + BER_BIT2 + BER_BIT1)
#define BER_IDENTIFIER_FIRST_TAG_CONTINUED (BER_BIT5 + BER_BIT4 + BER_BIT3 + BER_BIT2 + BER_BIT1)
#define BER_IDENTIFIER_SUCCESSIVE_TAG_CONTINUED_MASK BER_BIT8
#define BER_IDENTIFIER_SUCCESSIVE_TAG_CONTINUED BER_BIT8
#define BER_IDENTIFIER_SUCCESSIVE_TAG_VALUE_MASK                                                                       \
  (BER_BIT7 + BER_BIT6 + BER_BIT5 + BER_BIT4 + BER_BIT3 + BER_BIT2 + BER_BIT1)

#define BER_LENGTH_TYPE_MASK BER_BIT8
#define BER_LENGTH_DEFINITE_TYPE_SHORT 0x00
#define BER_LENGTH_DEFINITE_TYPE_LONG BER_BIT8
#define BER_LENGTH_INDEFINITE_TYPE BER_BIT8
#define BER_LENGTH_INDEFINITE_LENGTH 0x00

#define BER_LENGTH_DEFINITE_SHORT_VALUE_MASK                                                                           \
  (BER_BIT7 + BER_BIT6 + BER_BIT5 + BER_BIT4 + BER_BIT3 + BER_BIT2 + BER_BIT1)
#define BER_LENGTH_DEFINITE_LONG_COUNT_MASK (BER_BIT7 + BER_BIT6 + BER_BIT5 + BER_BIT4 + BER_BIT3 + BER_BIT2 + BER_BIT1)

#define BER_LENGTH_INDEFINITE_END_OF_CONTENTS_HALF 0x00

#define BER_VALUE_BOOLEAN_LENGTH 0x01
#define BER_VALUE_BOOLEAN_VALUE_FALSE 0x00
#define BER_VALUE_BOOLEAN_VALUE_TRUE 0xFF

#define BER_VALUE_BITSTRING_UNUSED_MASK (BER_BIT7 + BER_BIT6 + BER_BIT5 + BER_BIT4 + BER_BIT3 + BER_BIT2 + BER_BIT1)

#define BER_VALUE_NULL_LENGTH 0x00

#define BER_VALUE_REAL_SPECIAL_CHECK_MASK (BER_BIT8 + BER_BIT7)
#define BER_VALUE_REAL_SPECIAL_CHECK_VALUE BER_BIT7
#define BER_VALUE_REAL_SPECIAL_VALUE_MASK (BER_BIT6 + BER_BIT5 + BER_BIT4 + BER_BIT3 + BER_BIT2 + BER_BIT1)
#define BER_VALUE_REAL_SPECIAL_VALUE_PLUS_INIFINITY 0x00
#define BER_VALUE_REAL_SPECIAL_VALUE_MINUS_INIFINITY BER_BIT1
#define BER_VALUE_REAL_SPECIAL_VALUE_NOT_A_NUMBER BER_BIT2
#define BER_VALUE_REAL_SPECIAL_VALUE_MINUS_ZERO (BER_BIT2 + BER_BIT1)
