# Augment Your SAP BTP Use Cases With AI Foundation on SAP BTP
[![License: Apache2](https://img.shields.io/badge/License-Apache2-green.svg)](https://opensource.org/licenses/Apache-2.0)
[![REUSE status](https://api.reuse.software/badge/github.com/SAP-samples/btp-generative-ai-hub-use-cases)](https://api.reuse.software/info/github.com/SAP-samples/btp-generative-ai-hub-use-cases)

## Description
This repository includes a list of sample code about various use cases with SAP BTP, which are presented during the [SAP BTP AI Foundation Use Cases series](https://partneredge.sap.com/en/library/education/products/btp/build/e_ep_use-cases_ai-foundation.html). Each numbered folder you see in the structure is comprised by the code presented on an individual session. And each folder represents a completed runnable project about an use case with SAP BTP. To run a specific project, please kindly follow the README.md within its folder. <br/>
Use Case | Description | SAP BTP Services | Blog Post
---------|----------|----------|----------
[`01-Social Media Citizen Reporting`](01-social-media-citizen-reporting-genai-hub) | In this session we will do an in-depth exploration of the new Generative AI Hub and its industry solution. Learn how to quickly develop generative AI for SAP BTP apps securely, with access to a variety of large language models. The Generative AI Hub is the central cockpit in SAP BTP, allowing you to create, operate, monitor, and orchestrate your generative AI scenarios. It provides tools for efficient prompt engineering and prompt management, experimentation through the playground, and access to code libraries and SDKs. | Generative AI Hub, SAP AI Core, SAP S/4HANA Cloud, SAP HANA Cloud, CAP, SAP Build Apps | [Blog Post](https://community.sap.com/t5/sap-business-technology-platform-blog-posts/augmenting-sap-btp-use-cases-with-ai-foundation-a-deep-dive-into-the/ba-p/13645665)
[`02-Embedding business context with the SAP HANA Cloud, Vector Engine`](02-embedding-business-context-vector-engine) | In this session we will do an in-depth exploration of the new Vector Engine in SAP HANA Cloud and show how it can help ground/embed your models to put its responses into the right business context for better and more relevant outcomes and eliminate “hallucinations”. | Generative AI Hub, SAP HANA Cloud, Vector Engine, SAP AI Core | [Blog Post](https://community.sap.com/t5/technology-blogs-by-sap/embedding-business-context-with-the-sap-hana-cloud-vector-engine/ba-p/13693738)
[03-Generative AI-based code development with Joule in SAP Build Code](03-develop-with-joule-in-sap-build-code) | In this session we will do an in-depth exploration of ”capGPT” and show how it can help increase development productivity by using generative AI for automatic code generation based on Cloud Platform Application Programming (CAP) model. | SAP Build Code, Joule, CAP | [Blog Post](https://community.sap.com/t5/technology-blogs-by-sap/develop-with-joule-in-sap-build-code/ba-p/13695326)
[`10-Bring Open-Source LLMs into SAP AI Core`](10-byom-oss-llm-ai-core) | This repository serves as a guide on how to bring the popular and commercially viable open-source Large Language Models (such as Phi 3, LLaMa 3, Mistral, Mixtral, Gemma, LlaVA, etc.) and open-source Text Embedding into SAP AI Core using widely adopted open-source LLM tools or backends, which complements SAP Generative AI Hub with self-hosted open-source LLMs with benefits:<br/>-To avoid sending enterprise data to external proprietary LLM vendors.<br/>-To foster the innovations of the open-source LLM community with the enterprise-grade security and scalability of SAP AI Core.<br/>-To enjoy the flexibility of choices from various open-source LLMs and LLM back-ends, tailored to your specific business needs and requirements. | Open-Source LLMs, Open-Source Text Embedding Models, Ollama, LocalAI, llama.cpp, vLLM, Transformers, Infinity, SAP Generative AI Hub, SAP Generative AI Hub SDK, SAP AI Core | [Blog Post](https://community.sap.com/t5/artificial-intelligence-and-machine-learning-blogs/bring-open-source-llms-into-sap-ai-core/ba-p/13655167)

Please note that the table above reflects the current state of planning, and that actual topics and timelines may change completely. Additional sessions will be added throughout the year.

## Known Issues
No known issues.

## How to obtain support
[Create an issue](https://github.com/SAP-samples/<repository-name>/issues) in this repository if you find a bug or have questions about the content.
 
For additional support, [ask a question in SAP Community](https://answers.sap.com/questions/ask.html).

## Contributing
If you wish to contribute code, offer fixes or improvements, please send a pull request. Due to legal reasons, contributors will be asked to accept a DCO when they create the first pull request to this project. This happens in an automated fashion during the submission process. SAP uses [the standard DCO text of the Linux Foundation](https://developercertificate.org/).

## License
Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved. This project is licensed under the Apache Software License, version 2.0 except as noted otherwise in the [LICENSE](LICENSE) file.
