# ESM Support

## Status

decided

## Context

The JavaScript ecosystem is changing.
Node.js projects have to decide whether to use the legacy CommonJS modules (CJS, `require`) or ECMAScript Modules (ESM, `import`).
As ESM is not compatible with CJS, this is an important decision.
This [article](https://blog.stackademic.com/commonjs-vs-ecmascript-modules-esm-choosing-the-right-module-system-for-your-javascript-project-ef4efa856554) describes the most relevant differences.
Although ESM has been on the market since 2016, CJS is still widely used (I couldn't find any concrete numbers).

Due to the incompatibility between both module systems library developers hesitate switching to ESM, because this would be a breaking change and might be a deal breaker for legacy applications that use CJS.

## Decision

- Use "secret hybrid mode":
  - Syntax is ESM
  - Dependencies are only CJS or hybrid
  - We add a check that we could switch to a hybrid mode at any time
- If users strongly disagree to adapting ESM, switch to hybrid mode
- After a grace period (GA + 1 year) make a final decision to switch to pure ESM, if not already switched to hybrid mode

### Pros

We can check the community's opinion by communicating ESM compatibility only and be a pull factor as long as there are no hard blocks for either bigger projects or a large number of projects.
If it becomes a blocker, we can react without breaking changes.
We can benefit from the performance improvements in ESM.

## Cons

We still cannot use ESM dependencies, which might pose a security risk in the long term.

# Discussion

## Notes/Questions

- What projects do the users who asked for an SDK have as of today.
- Hybrid mode: Can we work around ESM dependency issue, e.g. with dynamic imports?
- Ask CAP colleagues?
- New "topic" might attract rather new projects - increases chances of them using ESM.
- SAP Cloud SDK generator does not support ESM at the moment

## ESM

Contra:

- CJS applications cannot use ESM libs

Pro:

- we can use all dependencies (CJS + ESM), even if they switch to ESM in the future (security relevant)
- no future switch needed
- become a pull factor to help the ecosystem move forward
- better performance through features like tree shaking and async loading

## CJS

Contra:

- we can only use CJS, when libraries switch to ESM we need to replace them or keep an old version that will not receive security patches
- at some point in the future we probably will have to switch anyways
- worse performance

Pro:

- all applications can use CJS

## Hybrid Mode

[Node.js docs on hybrid mode](https://nodejs.org/api/packages.html#dual-commonjses-module-packages)

Contra:

- we still can only use CJS, because our dependencies cannot use ESM dependencies, still not receiving security patches those
- we would have to transpile packages twice and publish packages with a duplicate (transpiled) codebase

Pro:

- works for all users (same as CJS)
- ESM users can benefit from performance features like tree shaking and async loading

### Evaluation from PoC

Hybrid mode is in fact CJS.
Generally it is possible to find workarounds to use ESM in CJS, but it gets ugly quickly and has limitations:

- The lib cannot use top level awaits.
- Typings get lost.
- ESM imports need to be wrapped in functions.
