#
# This file was automatically generated by s2e-env at {{ creation_time }}
#
# This script is used to launch the test.
#

on_exit() {
    local CODE=$?

    if [ $CODE -ne 0 ]; then
        echo FAILURE > $S2E_LAST/status
        echo FAILURE
    else
        echo SUCCESS > $S2E_LAST/status
        echo SUCCESS
    fi
}

if [ ! -d "$S2EDIR" ]; then
    echo "S2EDIR does not exist or is not set. Please set it to the root of your S2E environment"
    exit 1
fi

trap "on_exit" EXIT

set -xe

ulimit -c unlimited

DIR_NAME="$(cd $(dirname $0) && pwd)"
S2E_LAST="$DIR_NAME/s2e-last"

# Make sure we don't have left overs from a previous run,
# otherwise, if S2E fails to start, the script will mistakenly look at old results.
rm -f "$S2E_LAST"

check_coverage() {
    local PROJECT_NAME="$1"
    local EXPECTED_COVERAGE="$2"
    local SYMPATH="$3"

    if [ -d "$SYMPATH" ]; then
        local EXTRA_PARAMS="--sympath $SYMPATH"
    fi

    echo === Computing code coverage
    s2e coverage $EXTRA_PARAMS lcov --html {{ project_name }} | tee $S2E_LAST/cov.log

    echo === Checking code coverage

    COV_PC=$(grep "lines......" $S2E_LAST/cov.log | cut -d : -f 2 | cut -d '%' -f 1)
    if [ "x$COV_PC" = "x" ]; then
        echo Could not get coverage
        exit 1
    fi

    if (( $(bc <<< "$COV_PC < $EXPECTED_COVERAGE") )); then
        echo Bad coverage: $COV_PC
        exit 1
    fi
}

{% include 'helpers.sh' %}
