///
/// Copyright (C) 2016, Dependable Systems Laboratory, EPFL
/// Copyright (C) 2016, Cyberhaven
///
/// Permission is hereby granted, free of charge, to any person obtaining a copy
/// of this software and associated documentation files (the "Software"), to deal
/// in the Software without restriction, including without limitation the rights
/// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
/// copies of the Software, and to permit persons to whom the Software is
/// furnished to do so, subject to the following conditions:
///
/// The above copyright notice and this permission notice shall be included in all
/// copies or substantial portions of the Software.
///
/// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
/// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
/// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
/// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
/// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
/// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
/// SOFTWARE.
///

#include "Register.h"

namespace s2e {
namespace plugins {
namespace recipe {

const char *Register::s_regs32[10] = {"EAX", "ECX", "EDX", "EBX", "ESP", "EBP", "ESI", "EDI", "EIP", nullptr};
const char *Register::s_regs64[18] = {"RAX", "RCX", "RDX", "RBX", "RSP", "RBP", "RSI", "RDI", "R8",
                                      "R9",  "R10", "R11", "R12", "R13", "R14", "R15", "RIP", nullptr};

std::string Register::name() const {
    if (m_bits == 32) {
        return s_regs32[m_reg];
    } else {
        return s_regs64[m_reg];
    }
}

klee::ref<Register> Register::fromName(const std::string &name, unsigned byteIdx) {

    for (unsigned i = 0; s_regs32[i]; ++i) {
        if (s_regs32[i] == name) {
            return klee::ref<Register>(new Register(i, 32, byteIdx));
        }
    }

    for (unsigned i = 0; s_regs64[i]; ++i) {
        if (s_regs64[i] == name) {
            return klee::ref<Register>(new Register(i, 64, byteIdx));
        }
    }

    return nullptr;
}

klee::ref<Register> Register::fromIndex(Reg reg, uint8_t bits) {
    return new Register(reg, bits, 0);
}

bool Register::isPc() const {
    if (m_bits == 32) {
        return m_reg == 8;
    } else if (m_bits == 64) {
        return m_reg == 16;
    }
    return false;
}
} // namespace recipe
} // namespace plugins
} // namespace s2e
