///
/// Copyright (C) 2016, Dependable Systems Laboratory, EPFL
/// Copyright (C) 2015-2016, Cyberhaven
///
/// Permission is hereby granted, free of charge, to any person obtaining a copy
/// of this software and associated documentation files (the "Software"), to deal
/// in the Software without restriction, including without limitation the rights
/// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
/// copies of the Software, and to permit persons to whom the Software is
/// furnished to do so, subject to the following conditions:
///
/// The above copyright notice and this permission notice shall be included in all
/// copies or substantial portions of the Software.
///
/// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
/// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
/// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
/// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
/// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
/// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
/// SOFTWARE.
///

#ifndef S2E_PLUGINS_PovGenerationPolicy_H
#define S2E_PLUGINS_PovGenerationPolicy_H

#include <s2e/CorePlugin.h>
#include <s2e/Plugin.h>
#include <s2e/Plugins/ExecutionTracers/TestCaseGenerator.h>
#include <s2e/Plugins/OSMonitors/Linux/LinuxMonitor.h>
#include <s2e/Plugins/OSMonitors/Support/ProcessExecutionDetector.h>
#include <s2e/Plugins/OSMonitors/Windows/WindowsCrashMonitor.h>
#include <s2e/Plugins/VulnerabilityAnalysis/DecreePovGenerator.h>
#include <s2e/S2EExecutionState.h>

namespace s2e {
namespace plugins {

namespace recipe {
class Recipe;
}

class DecreeMonitor;

class PovGenerationPolicy : public Plugin {
    S2E_PLUGIN

private:
    LinuxMonitor *m_linuxMonitor;
    WindowsCrashMonitor *m_windowsCrashMonitor;

    recipe::Recipe *m_recipe;
    pov::PovGenerator *m_povGenerator;
    ProcessExecutionDetector *m_process;

    uint64_t m_maxCrashCount;
    uint64_t m_crashCount;

    typedef pov::PovOptions PovOptions;
    typedef pov::PovType PovType;

    typedef std::tuple<uint64_t /* faultAddr */, unsigned /* povType */, std::string /* recipeName */> UniquePovKey;
    typedef std::map<UniquePovKey, unsigned /* count */> UniquePovMap;

    // TODO: implement proper sharing between multiple s2e processes (e.g., through KeyValueStore plugin)
    UniquePovMap m_uniquePovMap;
    unsigned m_maxPovCount;

    void onPovReadyHandler(S2EExecutionState *state, const PovOptions &opt, const std::string &recipeName,
                           bool isCrash);
    void onSegFault(S2EExecutionState *state, uint64_t pid, const S2E_LINUXMON_COMMAND_SEG_FAULT &data);

    void onSegFaultWinUser(S2EExecutionState *state, const WindowsUserModeCrash &crash);

    void onSegFaultWinKernel(S2EExecutionState *state, const vmi::windows::BugCheckDescription &crash);

    void onSymbolicAddress(S2EExecutionState *state, ref<Expr> virtualAddress, uint64_t concreteAddress,
                           bool &concretize, CorePlugin::symbolicAddressReason reason);

public:
    enum TestCaseType { POV, CRASH, END_OF_PATH, PARTIAL_PATH };

    void initialize();
    PovGenerationPolicy(S2E *s2e) : Plugin(s2e) {
    }

    sigc::signal<void, S2EExecutionState *, const PovOptions &, const std::string & /* recipeName */,
                 const std::vector<std::string> & /* filePaths */, TestCaseType /* tcType */>
        onPovReady;
};

} // namespace plugins
} // namespace s2e

#endif // S2E_PLUGINS_PovGenerationPolicy_H
