///
/// Copyright (C) 2018, Cyberhaven
///
/// Permission is hereby granted, free of charge, to any person obtaining a copy
/// of this software and associated documentation files (the "Software"), to deal
/// in the Software without restriction, including without limitation the rights
/// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
/// copies of the Software, and to permit persons to whom the Software is
/// furnished to do so, subject to the following conditions:
///
/// The above copyright notice and this permission notice shall be included in all
/// copies or substantial portions of the Software.
///
/// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
/// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
/// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
/// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
/// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
/// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
/// SOFTWARE.
///

#ifndef S2E_PLUGINS_FilePovGenerator_H
#define S2E_PLUGINS_FilePovGenerator_H

#include <s2e/CorePlugin.h>
#include <s2e/Plugin.h>
#include <s2e/S2EExecutionState.h>

#include <s2e/Plugins/ExecutionTracers/TestCaseGenerator.h>

#include "PovGenerator.h"

namespace s2e {
namespace plugins {
namespace pov {

class FilePovGenerator : public PovGenerator {
    S2E_PLUGIN
public:
    FilePovGenerator(S2E *s2e) : PovGenerator(s2e) {
    }

    void initialize();

    virtual bool generatePoV(S2EExecutionState *state, const PovOptions &opt, const std::string &filePrefix,
                             std::vector<std::string> &filePaths);

private:
    testcases::TestCaseGenerator *m_tc;

    uint64_t m_gp;
    uint64_t m_pc;

    void assignNegotiatedVariables(std::unordered_map<std::string, uint8_t> &varAssignment, const PovOptions &opt);

    void constrainNegotiatedVariables(S2EExecutionState *state, std::unordered_map<std::string, uint8_t> &varAssignment,
                                      PovOptions &opt);
};

} // namespace pov
} // namespace plugins
} // namespace s2e

#endif // S2E_PLUGINS_FilePovGenerator_H
