/// S2E Selective Symbolic Execution Platform
///
/// Copyright (c) 2013 Dependable Systems Laboratory, EPFL
///
/// Permission is hereby granted, free of charge, to any person obtaining a copy
/// of this software and associated documentation files (the "Software"), to deal
/// in the Software without restriction, including without limitation the rights
/// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
/// copies of the Software, and to permit persons to whom the Software is
/// furnished to do so, subject to the following conditions:
///
/// The above copyright notice and this permission notice shall be included in all
/// copies or substantial portions of the Software.
///
/// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
/// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
/// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
/// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
/// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
/// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
/// SOFTWARE.

#ifndef __PORT_H__

#define __PORT_H__

#include <inttypes.h>

static inline void outb(uint16_t port, uint8_t byte) {
    __asm__ __volatile__("out %%al, %%dx" : : "a"(byte), "d"(port));
}

static inline void outw(uint16_t port, uint16_t word) {
    __asm__ __volatile__("out %%ax, %%dx" : : "a"(word), "d"(port));
}

static inline void outl(uint16_t port, uint32_t dword) {
    __asm__ __volatile__("out %%eax, %%dx" : : "a"(dword), "d"(port));
}

static inline uint8_t inb(uint16_t port) {
    uint8_t ret;
    __asm__ __volatile__("in %%dx, %%al" : "=a"(ret) : "d"(port));
    return ret;
}

static inline uint16_t inw(uint16_t port) {
    uint16_t ret;
    __asm__ __volatile__("in %%dx, %%ax" : "=a"(ret) : "d"(port));
    return ret;
}

static inline uint32_t inl(uint16_t port) {
    uint32_t ret;
    __asm__ __volatile__("in %%dx, %%eax" : "=a"(ret) : "d"(port));
    return ret;
}

static inline void mmio_writel(uintptr_t addr, uint32_t val) {
    *(volatile uint32_t *) addr = val;
}

static inline uint32_t mmio_readl(uintptr_t addr) {
    return *(volatile uint32_t *) addr;
}

#endif
