#ifndef KERNEL_IDT_DEF
#define KERNEL_IDT_DEF

#include "../cpu/cpu.h"
#include <stdint.h>

extern void idt_init(void);

execution_context* isr_handler(execution_context* frame);

execution_context* irq_handler(execution_context* frame);

void irq_install_handler(
    uint8_t offset, execution_context* (*handler)(execution_context* frame));

void irq_uninstall_handler(uint8_t offset);

void set_interrupt_descriptor(uint8_t vector, void* handler, uint8_t dpl);

// CPU exceptions
extern void isr0(void);
extern void isr1(void);
extern void isr2(void);
extern void isr3(void);
extern void isr4(void);
extern void isr5(void);
extern void isr6(void);
extern void isr7(void);
extern void isr_err8(void);
extern void isr9(void);
extern void isr_err10(void);
extern void isr_err11(void);
extern void isr_err12(void);
extern void isr_err13(void);
extern void isr_err14(void);
extern void isr15(void);
extern void isr16(void);
extern void isr17(void);
extern void isr18(void);
extern void isr19(void);
extern void isr20(void);
extern void isr21(void);
extern void isr22(void);
extern void isr23(void);
extern void isr24(void);
extern void isr25(void);
extern void isr26(void);
extern void isr27(void);
extern void isr28(void);
extern void isr29(void);
extern void isr30(void);
extern void isr31(void);
extern void isr128(void);
// extern void isr177(void);

// IRQs
extern void irq0();
extern void irq1();
extern void irq2();
extern void irq3();
extern void irq4();
extern void irq5();
extern void irq6();
extern void irq7();
extern void irq8();
extern void irq9();
extern void irq10();
extern void irq11();
extern void irq12();
extern void irq13();
extern void irq14();
extern void irq15();

// // HW interrupts
// extern void isr32(void);
// extern void isr33(void);
// extern void isr34(void);
// extern void isr35(void);
// extern void isr36(void);
// extern void isr37(void);
// extern void isr38(void);
// extern void isr39(void);
// extern void isr40(void);
// extern void isr41(void);
// extern void isr42(void);
// extern void isr43(void);
// extern void isr44(void);
// extern void isr45(void);
// extern void isr46(void);
// extern void isr47(void);
//
// extern void isr48(void);
// extern void isr49(void);
// extern void isr50(void);
// extern void isr51(void);
// extern void isr52(void);
// extern void isr53(void);
// extern void isr54(void);
// extern void isr55(void);
// extern void isr56(void);
// extern void isr57(void);
// extern void isr58(void);
// extern void isr59(void);
// extern void isr60(void);
// extern void isr61(void);
// extern void isr62(void);
// extern void isr63(void);
// extern void isr64(void);
// extern void isr65(void);
// extern void isr66(void);
// extern void isr67(void);
// extern void isr68(void);
// extern void isr69(void);
// extern void isr70(void);
// extern void isr71(void);
// extern void isr72(void);
// extern void isr73(void);
// extern void isr74(void);
// extern void isr75(void);
// extern void isr76(void);
// extern void isr77(void);
// extern void isr78(void);
// extern void isr79(void);
// extern void isr80(void);
// extern void isr81(void);
// extern void isr82(void);
// extern void isr83(void);
// extern void isr84(void);
// extern void isr85(void);
// extern void isr86(void);
// extern void isr87(void);
// extern void isr88(void);
// extern void isr89(void);
// extern void isr90(void);
// extern void isr91(void);
// extern void isr92(void);
// extern void isr93(void);
// extern void isr94(void);
// extern void isr95(void);
// extern void isr96(void);
// extern void isr97(void);
// extern void isr98(void);
// extern void isr99(void);
// extern void isr100(void);
// extern void isr101(void);
// extern void isr102(void);
// extern void isr103(void);
// extern void isr104(void);
// extern void isr105(void);
// extern void isr106(void);
// extern void isr107(void);
// extern void isr108(void);
// extern void isr109(void);
// extern void isr110(void);
// extern void isr111(void);
// extern void isr112(void);
// extern void isr113(void);
// extern void isr114(void);
// extern void isr115(void);
// extern void isr116(void);
// extern void isr117(void);
// extern void isr118(void);
// extern void isr119(void);
// extern void isr120(void);
// extern void isr121(void);
// extern void isr122(void);
// extern void isr123(void);
// extern void isr124(void);
// extern void isr125(void);
// extern void isr126(void);
// extern void isr127(void);
// extern void isr128(void);
// extern void isr129(void);
// extern void isr130(void);
// extern void isr131(void);
// extern void isr132(void);
// extern void isr133(void);
// extern void isr134(void);
// extern void isr135(void);
// extern void isr136(void);
// extern void isr137(void);
// extern void isr138(void);
// extern void isr139(void);
// extern void isr140(void);
// extern void isr141(void);
// extern void isr142(void);
// extern void isr143(void);
// extern void isr144(void);
// extern void isr145(void);
// extern void isr146(void);
// extern void isr147(void);
// extern void isr148(void);
// extern void isr149(void);
// extern void isr150(void);
// extern void isr151(void);
// extern void isr152(void);
// extern void isr153(void);
// extern void isr154(void);
// extern void isr155(void);
// extern void isr156(void);
// extern void isr157(void);
// extern void isr158(void);
// extern void isr159(void);
// extern void isr160(void);
// extern void isr161(void);
// extern void isr162(void);
// extern void isr163(void);
// extern void isr164(void);
// extern void isr165(void);
// extern void isr166(void);
// extern void isr167(void);
// extern void isr168(void);
// extern void isr169(void);
// extern void isr170(void);
// extern void isr171(void);
// extern void isr172(void);
// extern void isr173(void);
// extern void isr174(void);
// extern void isr175(void);
// extern void isr176(void);
// extern void isr177(void);
// extern void isr178(void);
// extern void isr179(void);
// extern void isr180(void);
// extern void isr181(void);
// extern void isr182(void);
// extern void isr183(void);
// extern void isr184(void);
// extern void isr185(void);
// extern void isr186(void);
// extern void isr187(void);
// extern void isr188(void);
// extern void isr189(void);
// extern void isr190(void);
// extern void isr191(void);
// extern void isr192(void);
// extern void isr193(void);
// extern void isr194(void);
// extern void isr195(void);
// extern void isr196(void);
// extern void isr197(void);
// extern void isr198(void);
// extern void isr199(void);
// extern void isr200(void);
// extern void isr201(void);
// extern void isr202(void);
// extern void isr203(void);
// extern void isr204(void);
// extern void isr205(void);
// extern void isr206(void);
// extern void isr207(void);
// extern void isr208(void);
// extern void isr209(void);
// extern void isr210(void);
// extern void isr211(void);
// extern void isr212(void);
// extern void isr213(void);
// extern void isr214(void);
// extern void isr215(void);
// extern void isr216(void);
// extern void isr217(void);
// extern void isr218(void);
// extern void isr219(void);
// extern void isr220(void);
// extern void isr221(void);
// extern void isr222(void);
// extern void isr223(void);
// extern void isr224(void);
// extern void isr225(void);
// extern void isr226(void);
// extern void isr227(void);
// extern void isr228(void);
// extern void isr229(void);
// extern void isr230(void);
// extern void isr231(void);
// extern void isr232(void);
// extern void isr233(void);
// extern void isr234(void);
// extern void isr235(void);
// extern void isr236(void);
// extern void isr237(void);
// extern void isr238(void);
// extern void isr239(void);
// extern void isr240(void);
// extern void isr241(void);
// extern void isr242(void);
// extern void isr243(void);
// extern void isr244(void);
// extern void isr245(void);
// extern void isr246(void);
// extern void isr247(void);
// extern void isr248(void);
// extern void isr249(void);
// extern void isr250(void);
// extern void isr251(void);
// extern void isr252(void);
// extern void isr253(void);
// extern void isr254(void);
// extern void isr255(void);
#endif
