<?php

namespace Riimu\Kit\SecureRandom\Generator;

use Riimu\Kit\SecureRandom\GeneratorException;

/**
 * Generates bytes using OpenSSL extension.
 *
 * OpenSSL generator uses openssl_random_pseudo_bytes to generate bytes. Note
 * that whether bytes generated by this function are secure or not is up to
 * debate.
 *
 * @author Riikka Kalliomäki <riikka.kalliomaki@gmail.com>
 * @copyright Copyright (c) 2014-2017 Riikka Kalliomäki
 * @license http://opensource.org/licenses/mit-license.php MIT License
 */
class OpenSSL extends AbstractGenerator
{
    public function isSupported()
    {
        return function_exists('openssl_random_pseudo_bytes');
    }

    protected function readBytes($count)
    {
        $bytes = openssl_random_pseudo_bytes($count, $strong);

        if ($strong !== true) {
            throw new GeneratorException('OpenSSL failed to generate strong bytes');
        }

        return $bytes;
    }
}
