<?php

namespace Riimu\Kit\SecureRandom\Generator;

use Riimu\Kit\SecureRandom\GeneratorException;

/**
 * Secure random byte generator interface.
 * @author Riikka Kalliomäki <riikka.kalliomaki@gmail.com>
 * @copyright Copyright (c) 2014-2017 Riikka Kalliomäki
 * @license http://opensource.org/licenses/mit-license.php MIT License
 */
interface Generator
{
    /**
     * Tells if the generator is supported by the operating system.
     * @return bool True if the generator is supported, false if not
     */
    public function isSupported();

    /**
     * Returns securely generated random bytes.
     *
     * This method will always return the correct number of bytes that have been
     * securely generated. If the bytes cannot be securely generated or if the
     * correct number of bytes cannot be generated, the method MUST throw an
     * exception.
     *
     * @param int $count Number of bytes to return
     * @return string Bytes generated by the secure random byte generator
     * @throws GeneratorException If any error occurs
     */
    public function getBytes($count);
}
