﻿// Copyright (c) Rodel. All rights reserved.
// <auto-generated />

using Markdig.Extensions.Tables;
using Microsoft.UI.Xaml.Documents;
using Microsoft.UI.Xaml.Media;

namespace RodelAgent.UI.Controls.Markdown.TextElements;

internal class MyTable : IAddChild
{
    private readonly Table _table;
    private Paragraph _paragraph;
    private readonly MyTableUIElement _tableElement;

    public TextElement TextElement => _paragraph;

    public MyTable(Table table)
    {
        _table = table;
        _paragraph = new Paragraph();
        var row = table.FirstOrDefault() as TableRow;
        var column = row == null ? 0 : row.Count;

        _tableElement = new MyTableUIElement(
            column,
            table.Count,
            1,
            new SolidColorBrush(Colors.Gray));

        _tableElement.HorizontalAlignment = HorizontalAlignment.Stretch;
        _tableElement.Margin = new(0,6,0,6);
        var inlineUIContainer = new InlineUIContainer
        {
            Child = _tableElement,
        };
        _paragraph.Inlines.Add(inlineUIContainer);
    }

    public void AddChild(IAddChild child)
    {
        if (child is MyTableCell cellChild)
        {
            var cell = cellChild.Container;

            Grid.SetColumn(cell, cellChild.ColumnIndex);
            Grid.SetRow(cell, cellChild.RowIndex);
            Grid.SetColumnSpan(cell, cellChild.ColumnSpan);
            Grid.SetRowSpan(cell, cellChild.RowSpan);

            _tableElement.Children.Add(cell);
        }
    }
}
