﻿// Copyright (c) Rodel. All rights reserved.
// <auto-generated />

using Markdig.Syntax;
using Microsoft.UI.Xaml.Documents;

namespace RodelAgent.UI.Controls.Markdown.TextElements;

internal class MyParagraph : IAddChild
{
    private readonly ParagraphBlock _paragraphBlock;
    private Paragraph _paragraph;

    public TextElement TextElement => _paragraph;

    public MyParagraph(ParagraphBlock paragraphBlock)
    {
        _paragraphBlock = paragraphBlock;
        _paragraph = new Paragraph();
        _paragraph.LineHeight = 1.3 * _paragraph.FontSize;
        _paragraph.Margin = new Thickness(0, 0, 0, _paragraph.FontSize / 2);
    }

    public void AddChild(IAddChild child)
    {
        if (child.TextElement is Inline inlineChild)
        {
            _paragraph.Inlines.Add(inlineChild);
        }
        else if (child.TextElement is Microsoft.UI.Xaml.Documents.Block blockChild)
        {
            var inlineUIContainer = new InlineUIContainer();
            var richTextBlock = new RichTextBlock
            {
                TextWrapping = TextWrapping.Wrap,
            };
            richTextBlock.Blocks.Add(blockChild);
            inlineUIContainer.Child = richTextBlock;
            _paragraph.Inlines.Add(inlineUIContainer);
        }
    }
}
