﻿// Copyright (c) Rodel. All rights reserved.
// <auto-generated />

using Markdig.Syntax.Inlines;
using Microsoft.UI.Xaml.Documents;
using Microsoft.UI.Xaml.Media.Media3D;

namespace RodelAgent.UI.Controls.Markdown.TextElements;

internal class MyInlineCode : IAddChild
{
    private readonly CodeInline _codeInline;
    private Run _inlineContainer;
    private readonly MarkdownConfig _config;

    public TextElement TextElement => _inlineContainer;

    public MyInlineCode(CodeInline codeInline, MarkdownConfig config)
    {
        _codeInline = codeInline;
        _config = config;
        _inlineContainer = new Run();
        _inlineContainer.Text=codeInline.Content.ToString();
        _inlineContainer.FontStyle = Windows.UI.Text.FontStyle.Italic;
        _inlineContainer.FontFamily = new Microsoft.UI.Xaml.Media.FontFamily("Cascadia Code");
        _inlineContainer.FontSize = config.Themes.InlineCodeFontSize;
        _inlineContainer.FontWeight = config.Themes.InlineCodeFontWeight;
    }

    public void AddChild(IAddChild child)
    {
    }
}
