﻿// Copyright (c) Rodel. All rights reserved.
// <auto-generated />

using Markdig.Syntax.Inlines;
using Microsoft.UI.Text;
using Microsoft.UI.Xaml.Documents;
using Windows.UI.Text;

namespace RodelAgent.UI.Controls.Markdown.TextElements;

internal class MyEmphasisInline : IAddChild
{
    private Span _span;
    private readonly EmphasisInline _markdownObject;

    private bool _isBold;
    private bool _isItalic;
    private bool _isStrikeThrough;

    public TextElement TextElement => _span;

    public MyEmphasisInline(EmphasisInline emphasisInline)
    {
        _span = new Span();
        _markdownObject = emphasisInline;
    }

    public void AddChild(IAddChild child)
    {
        try
        {
            if (child is MyInlineText inlineText)
            {
                _span.Inlines.Add((Run)inlineText.TextElement);
            }
            else if (child is MyEmphasisInline emphasisInline)
            {
                if (emphasisInline._isBold)
                {
                    SetBold();
                }

                if (emphasisInline._isItalic)
                {
                    SetItalic();
                }

                if (emphasisInline._isStrikeThrough)
                {
                    SetStrikeThrough();
                }

                _span.Inlines.Add(emphasisInline._span);
            }
        }
        catch (Exception ex)
        {
            throw new Exception($"Error in {nameof(MyEmphasisInline)}.{nameof(AddChild)}: {ex.Message}");
        }
    }

    public void SetBold()
    {
        _span.FontWeight = FontWeights.Bold;
        _isBold = true;
    }

    public void SetItalic()
    {
        _span.FontStyle = FontStyle.Italic;
        _isItalic = true;
    }

    public void SetStrikeThrough()
    {
        _span.TextDecorations = TextDecorations.Strikethrough;
        _isStrikeThrough = true;
    }

    public void SetSubscript() => _span.SetValue(Typography.VariantsProperty, FontVariants.Subscript);

    public void SetSuperscript() => _span.SetValue(Typography.VariantsProperty, FontVariants.Superscript);
}
