﻿// Copyright (c) Rodel. All rights reserved.
// <auto-generated />

using HtmlAgilityPack;
using Microsoft.UI.Xaml.Documents;

namespace RodelAgent.UI.Controls.Markdown.TextElements.Html;

// block
internal class MyDetails : IAddChild
{
    private HtmlNode _htmlNode;
    private InlineUIContainer _inlineUIContainer;
    private readonly Expander _expander;
    private readonly MyFlowDocument _flowDocument;
    private Paragraph _paragraph;

    public TextElement TextElement => _paragraph;

    public MyDetails(HtmlNode details)
    {
        _htmlNode = details;

        var header = _htmlNode.ChildNodes
            .FirstOrDefault(
                x => x.Name is "summary" or "header");

        _inlineUIContainer = new InlineUIContainer();
        _expander = new Expander
        {
            HorizontalAlignment = HorizontalAlignment.Stretch,
        };
        _flowDocument = new MyFlowDocument(details);
        _flowDocument.RichTextBlock.HorizontalAlignment = HorizontalAlignment.Stretch;
        _expander.Content = _flowDocument.RichTextBlock;
        var headerBlock = new TextBlock
        {
            Text = header?.InnerText,
            HorizontalAlignment = HorizontalAlignment.Stretch,
        };
        _expander.Header = headerBlock;
        _inlineUIContainer.Child = _expander;
        _paragraph = new Paragraph();
        _paragraph.Inlines.Add(_inlineUIContainer);
    }

    public void AddChild(IAddChild child) => _flowDocument.AddChild(child);
}
