﻿// Copyright (c) Rodel. All rights reserved.
// <auto-generated />

using Markdig.Syntax.Inlines;
using RodelAgent.UI.Controls.Markdown.TextElements;

namespace RodelAgent.UI.Controls.Markdown.Renderers.ObjectRenderers.Inlines;

internal class EmphasisInlineRenderer : WinUIObjectRenderer<EmphasisInline>
{
    protected override void Write(WinUIRenderer renderer, EmphasisInline obj)
    {
        if (renderer == null)
        {
            throw new ArgumentNullException(nameof(renderer));
        }

        if (obj == null)
        {
            throw new ArgumentNullException(nameof(obj));
        }

        MyEmphasisInline span = null;

        switch (obj.DelimiterChar)
        {
            case '*':
            case '_':
                span = new MyEmphasisInline(obj);
                if (obj.DelimiterCount == 2)
                {
                    span.SetBold();
                }
                else
                {
                    span.SetItalic();
                }

                break;
            case '~':
                span = new MyEmphasisInline(obj);
                if (obj.DelimiterCount == 2)
                {
                    span.SetStrikeThrough();
                }
                else
                {
                    span.SetSubscript();
                }

                break;
            case '^':
                span = new MyEmphasisInline(obj);
                span.SetSuperscript();
                break;
        }

        if (span != null)
        {
            renderer.Push(span);
            renderer.WriteChildren(obj);
            renderer.Pop();
        }
        else
        {
            renderer.WriteChildren(obj);
        }
    }
}
