﻿// Copyright (c) Rodel. All rights reserved.

using RodelTranslate.Models.Client;

namespace RodelTranslate.Core;

/// <summary>
/// 预定义的语言.
/// </summary>
internal static partial class PredefinedLanguages
{
    internal static List<Language> VolcanoLanguages { get; } = new List<Language>
    {
        new ("zh", "zh-Hans"),
        new ("zh-Hant", "zh-Hant"),
        new ("zh-Hant-hk", "zh-HK"),
        new ("zh-Hant-tw", "zh-TW"),
        new ("tn", "tn"),
        new ("vi", "vi"),
        new ("iu", "iu"),
        new ("it", "it"),
        new ("id", "id"),
        new ("hi", "hi"),
        new ("en", "en"),
        new ("ho", "ho"),
        new ("he", "he"),
        new ("es", "es"),
        new ("el", "el"),
        new ("uk", "uk"),
        new ("ur", "ur"),
        new ("tk", "tk"),
        new ("tr", "tr"),
        new ("ti", "ti"),
        new ("ty", "ty"),
        new ("tl", "tl"),
        new ("to", "to"),
        new ("th", "th"),
        new ("ta", "ta"),
        new ("te", "te"),
        new ("sl", "sl"),
        new ("sk", "sk"),
        new ("ss", "ss"),
        new ("eo", "eo"),
        new ("sm", "sm"),
        new ("sg", "sg"),
        new ("st", "st"),
        new ("sv", "sv"),
        new ("ja", "ja"),
        new ("tw", "tw"),
        new ("qu", "qu"),
        new ("pt", "pt"),
        new ("pa", "pa"),
        new ("no", "no"),
        new ("nb", "nb"),
        new ("nr", "nr"),
        new ("my", "my"),
        new ("bn", "bn"),
        new ("mn", "mn"),
        new ("mh", "mh"),
        new ("mk", "mk"),
        new ("ml", "ml"),
        new ("mr", "mr"),
        new ("ms", "ms"),
        new ("lu", "lu"),
        new ("ro", "ro"),
        new ("lt", "lt"),
        new ("lv", "lv"),
        new ("lo", "lo"),
        new ("kj", "kj"),
        new ("hr", "hr"),
        new ("kn", "kn"),
        new ("ki", "ki"),
        new ("cs", "cs"),
        new ("ca", "ca"),
        new ("nl", "nl"),
        new ("ko", "ko"),
        new ("ht", "ht"),
        new ("gu", "gu"),
        new ("ka", "ka"),
        new ("kl", "kl"),
        new ("km", "km"),
        new ("lg", "lg"),
        new ("kg", "kg"),
        new ("fi", "fi"),
        new ("fj", "fj"),
        new ("fr", "fr"),
        new ("ru", "ru"),
        new ("ng", "ng"),
        new ("de", "de"),
        new ("tt", "tt"),
        new ("da", "da"),
        new ("ts", "ts"),
        new ("cv", "cv"),
        new ("fa", "fa"),
        new ("bs", "bs"),
        new ("pl", "pl"),
        new ("bi", "bi"),
        new ("nd", "nd"),
        new ("ba", "ba"),
        new ("bg", "bg"),
        new ("az", "az"),
        new ("ar", "ar"),
        new ("af", "af"),
        new ("sq", "sq"),
        new ("ab", "ab"),
        new ("os", "os"),
        new ("ee", "ee"),
        new ("et", "et"),
        new ("ay", "ay"),
        new ("lzh", "lzh"),
        new ("am", "am"),
        new ("ckb", "ckb"),
        new ("cy", "cy"),
        new ("gl", "gl"),
        new ("ha", "ha"),
        new ("hy", "hy"),
        new ("ig", "ig"),
        new ("kmr", "kmr"),
        new ("ln", "ln"),
        new ("nso", "nso"),
        new ("ny", "ny"),
        new ("om", "om"),
        new ("sn", "sn"),
        new ("so", "so"),
        new ("sr", "sr"),
        new ("sw", "sw"),
        new ("xh", "xh"),
        new ("yo", "yo"),
        new ("zu", "zu"),
        new ("bo", "bo"),
        new ("nan", "nan"),
        new ("wuu", "wuu"),
        new ("yue", "yue"),
        new ("cmn", "cmn"),
        new ("ug", "ug"),
        new ("fuv", "fuv"),
        new ("hu", "hu"),
        new ("kam", "kam"),
        new ("luo", "luo"),
        new ("rw", "rw"),
        new ("umb", "umb"),
        new ("wo", "wo"),
    };
}
